/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.entity.Aggregation;
import org.anyline.entity.AggregationConfig;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultGroupStore;
import org.anyline.entity.GroupStore;
import org.anyline.metadata.Table;
import org.anyline.service.AnylineService;

public class AggregationBuilder {
    private AnylineService service;
    private Table table;
    private RunPrepare prepare;
    private ConfigStore configs;
    private List<AggregationConfig> aggregations = new ArrayList<AggregationConfig>();
    private GroupStore groups = new DefaultGroupStore();

    public AggregationBuilder(AnylineService service) {
        this.service = service;
    }

    public AggregationBuilder group(String ... columns) {
        for (String column : columns) {
            this.groups.group(column);
        }
        return this;
    }

    public GroupStore groups() {
        return this.groups;
    }

    public List<AggregationConfig> aggregations() {
        return this.aggregations;
    }

    public AggregationBuilder aggregation(Aggregation aggregation, String column, String result) {
        AggregationConfig config = new AggregationConfig(aggregation, column, result);
        this.aggregations.add(config);
        return this;
    }

    public AggregationBuilder table(Table table) {
        this.table = table;
        return this;
    }

    public AggregationBuilder table(RunPrepare prepare) {
        this.prepare = prepare;
        return this;
    }

    public AggregationBuilder configs(ConfigStore configs) {
        this.configs = configs;
        return this;
    }

    public DataSet querys() {
        this.configs.setGroups(this.groups);
        this.configs.aggregations(this.aggregations);
        if (null != this.prepare) {
            return this.service.querys(this.prepare, this.configs, new String[0]);
        }
        if (null != this.table) {
            return this.service.querys(this.table, this.configs, new String[0]);
        }
        throw new RuntimeException("\u672a\u63d0\u4f9bTable\u6216RunPrepare");
    }

    public DataRow query() {
        this.configs.setGroups(this.groups);
        this.configs.aggregations(this.aggregations);
        if (null != this.prepare) {
            return this.service.query(this.prepare, this.configs, new String[0]);
        }
        if (null != this.table) {
            return this.service.query(this.table, this.configs, new String[0]);
        }
        throw new RuntimeException("\u672a\u63d0\u4f9bTable\u6216RunPrepare");
    }
}

