/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter.init;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.entity.Join;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.TypeMetadataAlias;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.auto.init.VirtualTablePrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.CommandParser;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.VariableValue;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.Role;
import org.anyline.entity.authorize.User;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.AnylineException;
import org.anyline.exception.CommandException;
import org.anyline.exception.CommandQueryException;
import org.anyline.exception.CommandUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.CMD;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.TableComment;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.ConvertProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public abstract class AbstractDriverAdapter
implements DriverAdapter {
    protected DMListener dmListener;
    protected DDListener ddListener;
    protected PrimaryGenerator primaryGenerator;
    protected DriverActuator actuator;
    protected String delimiterFr = "";
    protected String delimiterTo = "";
    protected static Map<String, String> spells = new HashMap<String, String>();
    protected Map<Class<?>, MetadataFieldRefer> refers = new HashMap();
    protected LinkedHashMap<String, TypeMetadata> alias = new LinkedHashMap();

    protected DMListener getListener() {
        return this.dmListener;
    }

    @Override
    public void setListener(DMListener listener) {
        this.dmListener = listener;
    }

    @Override
    public DMListener getDMListener() {
        return this.dmListener;
    }

    @Override
    public void setListener(DDListener listener) {
        this.ddListener = listener;
    }

    @Override
    public DDListener getDDListener() {
        return this.ddListener;
    }

    @Override
    public void setGenerator(PrimaryGenerator generator) {
        this.primaryGenerator = generator;
    }

    public PrimaryGenerator getPrimaryGenerator() {
        return this.primaryGenerator;
    }

    @Override
    public void setActuator(DriverActuator actuator) {
        this.actuator = actuator;
    }

    @Override
    public DriverActuator getActuator() {
        return this.actuator;
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    @Override
    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public DatabaseType compatible() {
        return null;
    }

    public AbstractDriverAdapter() {
        block0: for (StandardTypeMetadata type : StandardTypeMetadata.values()) {
            this.reg((TypeMetadata)type, type.config());
            List dbs = type.databaseTypes();
            for (DatabaseType db : dbs) {
                if (db != this.type()) continue;
                this.alias(type.getName(), (TypeMetadata)type);
                this.alias(type.name(), (TypeMetadata)type);
                continue block0;
            }
        }
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Refer)new TypeMetadata.Refer(0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Refer)new TypeMetadata.Refer(0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 0, 0));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Refer)new TypeMetadata.Refer(1, 1, 1));
        this.reg(this.initDatabaseFieldRefer());
        this.reg(this.initCatalogFieldRefer());
        this.reg(this.initSchemaFieldRefer());
        this.reg(this.initTableFieldRefer());
        this.reg(this.initTableCommentFieldRefer());
        this.reg(this.initMasterTableFieldRefer());
        this.reg(this.initTablePartitionFieldRefer());
        this.reg(this.initTablePartitionSliceFieldRefer());
        this.reg(this.initPartitionTableFieldRefer());
        this.reg(this.initEdgeFieldRefer());
        this.reg(this.initVertexFieldRefer());
        this.reg(this.initColumnFieldRefer());
        this.reg(this.initTagFieldRefer());
        this.reg(this.initViewFieldRefer());
        this.reg(this.initPrimaryKeyFieldRefer());
        this.reg(this.initForeignKeyFieldRefer());
        this.reg(this.initConstraintFieldRefer());
        this.reg(this.initIndexFieldRefer());
        this.reg(this.initTriggerFieldRefer());
        this.reg(this.initProcedureFieldRefer());
        this.reg(this.initFunctionFieldRefer());
        this.reg(this.initSequenceFieldRefer());
        this.reg(this.initUserFieldRefer());
        this.reg(this.initRoleFieldRefer());
        this.reg(this.initPrivilegeFieldRefer());
    }

    @Override
    public MetadataFieldRefer refer(DataRuntime runtime, Class<?> type) {
        MetadataFieldRefer refer = this.refers.get(type);
        if (null == refer) {
            refer = new MetadataFieldRefer(type);
        }
        return refer;
    }

    @Override
    public void reg(MetadataFieldRefer refer) {
        Class metadata = refer.metadata();
        MetadataFieldRefer cur = this.refers.get(metadata);
        if (null != cur) {
            cur.copy(refer);
        } else {
            this.refers.put(metadata, refer);
        }
    }

    @Override
    public LinkedHashMap<String, TypeMetadata> alias() {
        return this.alias;
    }

    @Override
    public TypeMetadata.Refer reg(TypeMetadataAlias alias) {
        TypeMetadata standard = alias.standard();
        if (standard == StandardTypeMetadata.NONE) {
            return null;
        }
        this.alias(alias.input(), standard);
        this.alias(standard.getName(), standard);
        TypeMetadata.Refer refer = alias.refer();
        this.reg(alias.input(), refer);
        this.reg(alias.standard(), refer);
        return refer;
    }

    protected void alias(String key, TypeMetadata value) {
        if (null != key && null != value && TypeMetadata.NONE != value) {
            this.alias.put(key, value);
            this.alias.put(key.replace("_", " "), value);
            this.alias.put(key.replace(" ", "_"), value);
        }
    }

    @Override
    public TypeMetadata.Refer reg(TypeMetadata type, TypeMetadata.Refer config) {
        return MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata)type, (TypeMetadata.Refer)config);
    }

    @Override
    public TypeMetadata.Refer reg(String type, TypeMetadata.Refer config) {
        return MetadataReferHolder.reg((DatabaseType)this.type(), (String)type, (TypeMetadata.Refer)config);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        DataSet set;
        Map tags;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        swt = InterceptorProxy.prepareInsert(runtime, random, batch, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareInsert(runtime, random, batch, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && !tags.isEmpty()) {
            LinkedHashMap partitions = this.partitions(runtime, random, false, new MasterTable(dest), tags, null);
            if (partitions.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(partitions.keySet());
                if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    throw new CommandUpdateException(msg);
                }
                log.error(msg);
                return -1L;
            }
            dest = (Table)partitions.values().iterator().next();
        }
        Run run = this.buildInsertRun(runtime, batch, dest, data, configs, columns);
        if (ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            dest.setColumns(this.columns(runtime, random, false, dest, false));
        }
        if (null == run) {
            return 0L;
        }
        long cnt = 0L;
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeInsert(runtime, random, run, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeInsert(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        cnt = this.insert(runtime, random, data, configs, run, null);
        if (null != this.dmListener) {
            this.dmListener.afterInsert(runtime, random, run, cnt, dest, data, columns, cmd_success, cnt, millis);
        }
        InterceptorProxy.afterInsert(runtime, random, run, dest, data, configs, columns, cmd_success, cnt, System.currentTimeMillis() - fr);
        return cnt;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions)"), (int)37));
        }
        return 0L;
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (null != list && !list.isEmpty()) {
                run = this.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
            }
        } else {
            run = this.createInsertRun(runtime, dest, obj, configs, columns);
        }
        this.convert(runtime, configs, run);
        return run;
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String... conditions)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public void fillInsertCreateTemplate(DataRuntime runtime, Run run, PartitionTable dest, ConfigStore configs) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertCreateTemplate(DataRuntime runtime, Run run, PartitionTable dest, ConfigStore configs)"), (int)37));
        }
    }

    @Override
    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        LinkedHashMap cols = new LinkedHashMap<String, Column>();
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow(KeyAdapter.KEY_CASE.SRC, (Map)obj);
        }
        LinkedHashMap<String, Column> mastKeys = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        boolean each = true;
        if (null != columns && !columns.isEmpty()) {
            each = false;
            cols = new LinkedHashMap();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = ConfigStore.IS_INSERT_NULL_FIELD(configs);
                isInsertEmptyColumn = ConfigStore.IS_INSERT_EMPTY_FIELD(configs);
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.INSERT));
                } else {
                    cols = new LinkedHashMap();
                    List fields = ClassUtil.getFields(obj.getClass(), (boolean)false, (boolean)false);
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        Field field = (Field)iterator.next();
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        cols.put(field.getName().toUpperCase(), new Column(field.getName()));
                    }
                }
            }
            if (batch) {
                isInsertNullColumn = true;
                isInsertEmptyColumn = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][columns:{}]", (Object)cols);
            }
            BeanUtil.removeAll(ignores, columns);
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][ignores:{}]", ignores);
            }
            List keys = Column.names((LinkedHashMap)cols);
            for (String key : keys) {
                if (mastKeys.containsKey(key.toUpperCase())) continue;
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    cols.remove(key);
                    continue;
                }
                if (!BasicUtil.isEmpty((boolean)true, (Object)value)) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                cols.remove(key);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[confirm insert columns][result:{}]", cols);
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.setPrimaryValue(value);
        } else {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), (Column)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run createInsertRun(DataRuntime runtime, Table dest, Object obj, List<String> columns)"), (int)37));
        }
        return null;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setBatch(batch);
        if (null == list || list.isEmpty()) {
            throw new CommandException("\u7a7a\u6570\u636e");
        }
        Object first = list.iterator().next();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Object item : list) {
            cols.putAll(this.confirmInsertColumns(runtime, dest, item, configs, columns, true));
            if (ConfigStore.IS_CHECK_ALL_INSERT_COLUMN(configs)) continue;
            break;
        }
        if (null == cols || cols.isEmpty()) {
            throw new CommandException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json(first) + "]");
        }
        run.setInsertColumns(cols);
        run.setVol(cols.size());
        this.fillInsertContent(runtime, (Run)run, dest, list, configs, cols);
        return run;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt;
        block18: {
            cnt = 0L;
            int batch = run.getBatch();
            String action = "insert";
            if (batch > 1) {
                action = "batch insert";
            }
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][action:{}][table:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)action, (Object)run.getTableName());
                }
                return -1L;
            }
            String cmd = run.getFinalInsert();
            if (run.isEmpty()) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:{}][table:{}]", (Object)action, (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][table:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, run.getTable(), cmd, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            long millis = -1L;
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            try {
                cnt = this.actuator.insert(this, runtime, random, data, configs, run, this.generatedKey(), pks);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, cmd, values, null, true, cnt, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = LogUtil.format((long)cnt, (int)34);
                    if (batch > 1) {
                        qty = LogUtil.format((String)("\u7ea6" + cnt), (int)34);
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), qty});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("insert \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}][table:{}]{}", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, action, run.getTable(), run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block18;
                CommandUpdateException ex = new CommandUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(cmd);
                ex.setValues(values);
                throw ex;
            }
        }
        return cnt;
    }

    @Override
    public boolean supportKeyHolder(DataRuntime runtime, ConfigStore configs) {
        return null == configs || configs.supportKeyHolder();
    }

    @Override
    public List<String> keyHolders(DataRuntime runtime, ConfigStore configs) {
        if (null != configs) {
            return configs.keyHolders();
        }
        return new ArrayList<String>();
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, batch, dest, data, configs, columns)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareUpdate(runtime, random, batch, dest, data, configs, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null == data) {
            if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new CommandUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        long result = 0L;
        if (data instanceof Collection && batch <= 1) {
            Collection list = (Collection)data;
            for (Object item : list) {
                DefaultConfigStore cfg = new DefaultConfigStore(new String[0]);
                cfg.copyProperty(configs);
                cfg.and(configs);
                result += this.update(runtime, random, 0, dest, item, (ConfigStore)cfg, columns);
            }
            return result;
        }
        Run run = this.buildUpdateRun(runtime, batch, dest, data, configs, columns);
        if (run.isEmptyCondition()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u6ca1\u6709\u66f4\u65b0\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        if (ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            dest.setColumns(this.columns(runtime, null, false, dest, false));
        }
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeUpdate(runtime, random, run, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeUpdate(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.update(runtime, random, dest, data, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterUpdate(runtime, random, run, result, dest, data, columns, cmd_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, dest, data, configs, columns, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public long update(DataRuntime runtime, String random, RunPrepare prepare, DataRow data, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, prepare, data, configs)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareUpdate(runtime, random, prepare, data, configs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null == data || data.isEmpty()) {
            throw new CommandUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        long result = -1L;
        Run run = this.buildUpdateRun(runtime, prepare, data, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeUpdate(runtime, random, run, prepare, data, configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeUpdate(runtime, random, run, prepare, data, configs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.update(runtime, random, "", (Object)data, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterUpdate(runtime, random, run, result, prepare, data, configs, cmd_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, prepare, data, configs, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public Run buildUpdateRun(DataRuntime runtime, RunPrepare prepare, DataRow data, ConfigStore configs, String ... conditions) {
        Run run = this.initQueryRun(runtime, prepare);
        this.init(runtime, run, configs, conditions);
        if (run.checkValid()) {
            this.fillUpdateContent(runtime, (TableRun)run, data, configs);
        }
        return run;
    }

    @Override
    public void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs)"), (int)37));
        }
    }

    @Override
    public Run buildUpdateRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (!(obj instanceof DataRow) && obj instanceof Map) {
            obj = new DataRow((Map)obj);
        }
        run = obj instanceof Collection ? this.buildUpdateRunFromCollection(runtime, batch, dest, (Collection)obj, configs, cols) : (obj instanceof DataRow ? this.buildUpdateRunFromDataRow(runtime, dest, (DataRow)obj, configs, cols) : this.buildUpdateRunFromEntity(runtime, dest, obj, configs, cols));
        this.convert(runtime, configs, run);
        this.buildUpdateRunLimit(runtime, run);
        return run;
    }

    @Override
    public Run buildUpdateRunLimit(DataRuntime runtime, Run run) {
        return run;
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        List<String> primaryKeys;
        TableRun run = new TableRun(runtime, dest);
        run.setOriginType(2);
        StringBuilder builder = run.getBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, obj, configs, list);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if ((primaryKeys = configs.keys()).isEmpty()) {
            if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
            } else {
                primaryKeys = new ArrayList<String>();
                primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
            }
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk = pk.toUpperCase()) || columns.containsKey("+" + pk) || configColumns.containsKey(pk)) continue;
            cols.remove(pk.toUpperCase());
        }
        String defaultPk = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(defaultPk) || columns.containsKey("+" + defaultPk) || configColumns.containsKey(defaultPk))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean isReplaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL(configs);
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
                }
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    if (!first) {
                        builder.append(", ");
                    }
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    first = false;
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if ("".equals(value) && !ConfigStore.IS_UPDATE_EMPTY_FIELD(configs)) {
                    chk = false;
                }
                if (!chk) continue;
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                if (this.isMultipleValue(runtime, run, key)) {
                    compare = Compare.IN;
                }
                this.addRunValue(runtime, run, compare, column, value);
            }
            builder.append("\n");
            if (configs.isEmptyCondition()) {
                for (String pk : primaryKeys) {
                    if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)pk);
                        configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, pk, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, pk, BeanUtil.getFieldValue((Object)obj, (String)pk, (boolean)true));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        List<String> primaryKeys;
        TableRun run = new TableRun(runtime, dest);
        run.setOriginType(1);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)Column.names(columns));
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if ((primaryKeys = configs.keys()).isEmpty()) {
            primaryKeys.addAll(row.getPrimaryKeys());
        }
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        if (configs.isEmptyCondition()) {
            for (String string : primaryKeys) {
                Object pv = row.get(string);
                pv = this.convert(runtime, cols.get(string.toUpperCase()), pv);
                if (null == pv) continue;
                configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, string, pv);
            }
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk = pk.toUpperCase()) || columns.containsKey("+" + pk) || configColumns.containsKey(pk)) continue;
            cols.remove(pk.toUpperCase());
        }
        String string = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(string) || columns.containsKey("+" + string) || configColumns.containsKey(string))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    continue;
                }
                this.delimiter(builder, key).append(" = ");
                this.convert(runtime, builder, value, col, true, false, configs);
                builder.append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                this.addRunValue(runtime, run, compare, col, value);
            }
            builder.append("\n");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setOriginType(1);
        if (null == list || list.isEmpty()) {
            return run;
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        List<Object> primaryKeys = new ArrayList();
        boolean replaceEmptyNull = false;
        for (Object item : list) {
            if (item instanceof DataRow) {
                DataRow row = (DataRow)item;
                primaryKeys = row.getPrimaryKeys();
                cols.putAll(this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)Column.names(columns)));
                replaceEmptyNull = row.isReplaceEmptyNull();
            } else {
                ArrayList<String> ll = new ArrayList<String>();
                for (Column column : columns.values()) {
                    ll.add(column.getName());
                }
                cols.putAll(this.confirmUpdateColumns(runtime, dest, item, configs, ll));
                if (EntityAdapterProxy.hasAdapter(item.getClass())) {
                    primaryKeys.addAll(EntityAdapterProxy.primaryKeys(item.getClass()).keySet());
                } else {
                    primaryKeys = new ArrayList();
                    primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
                }
                replaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL(configs);
            }
            if (ConfigStore.IS_CHECK_ALL_UPDATE_COLUMN(configs)) continue;
            break;
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        StringBuilder builder = run.getBuilder();
        List<String> keys = configs.keys();
        if (!keys.isEmpty()) {
            primaryKeys = keys;
        }
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String string : primaryKeys) {
            String string2 = string.toUpperCase();
            if (columns.containsKey(string2) || columns.containsKey("+" + string2) || configColumns.containsKey(string2)) continue;
            cols.remove(string2.toUpperCase());
        }
        String defaultPk = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(defaultPk) || columns.containsKey("+" + defaultPk) || configColumns.containsKey(defaultPk))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET ");
            boolean start = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                if (!start) {
                    builder.append(", ");
                }
                start = false;
                builder.append(key);
                builder.append(" = ");
                this.convert(runtime, builder, null, column, true, false, configs);
            }
            start = true;
            for (String string : primaryKeys) {
                if (start) {
                    builder.append(" WHERE ");
                } else {
                    builder.append(" AND ");
                }
                this.delimiter(builder, string).append(" = ?");
                start = false;
            }
        }
        run.setUpdateColumns(arrayList);
        ArrayList<RunValue> values = new ArrayList<RunValue>();
        for (Object e : list) {
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = BeanUtil.getFieldValue(e, (String)key, (boolean)true);
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                values.add(new RunValue(key, value));
            }
            for (String string : primaryKeys) {
                values.add(new RunValue(string, BeanUtil.getFieldValue(e, (String)string, (boolean)true)));
            }
        }
        run.setBatch(batch);
        run.setVol(cols.size() + primaryKeys.size());
        run.setRunValues(values);
        return run;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Column> cols = null;
        if (null == row) {
            return new LinkedHashMap<String, Column>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        if ((null == columns || columns.isEmpty()) && null != configs) {
            columns = configs.columns();
        }
        LinkedHashMap masters = row.getUpdateColumns(true);
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != configs) {
            BeanUtil.removeAll(configs.excludes(), columns);
        }
        if (null != columns && !columns.isEmpty()) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && !masters.isEmpty()) {
            each = false;
            cols = masters;
        }
        if (each) {
            cols = row.getUpdateColumns(true);
            cols.putAll(masters);
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            List keys = Column.names(cols);
            for (String key : keys) {
                if (masters.containsKey(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key.toUpperCase());
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                cols.remove(key.toUpperCase());
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Object> cols = null;
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow(KeyAdapter.KEY_CASE.SRC, (Map)obj);
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        LinkedHashMap<String, Column> masters = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll(ignores, columns);
        if (null != columns && !columns.isEmpty()) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && !masters.isEmpty()) {
            each = false;
            cols = masters;
        }
        if (each) {
            boolean isUpdateNullColumn = ConfigStore.IS_UPDATE_NULL_FIELD(configs);
            boolean isUpdateEmptyColumn = ConfigStore.IS_UPDATE_EMPTY_FIELD(configs);
            cols = new LinkedHashMap();
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                masters.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isUpdateNullColumn = row.isUpdateNullColumn();
                isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            } else {
                cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
            }
            cols.putAll(masters);
            List keys = Column.names(cols);
            for (String key : keys) {
                if (masters.containsKey(key)) continue;
                Object value = BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key.toUpperCase());
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                cols.remove(key.toUpperCase());
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) {
        long result;
        block17: {
            result = 0L;
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
                }
                return -1L;
            }
            if (run.isEmpty()) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:{}]", (Object)dest);
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List<Object> values = run.getValues();
            int batch = run.getBatch();
            String action = null;
            if (null != run.action()) {
                action = run.action().toString();
            }
            if (batch > 1) {
                action = "batch " + action;
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                result = this.actuator.update(this, runtime, random, dest, data, configs, run);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][{}][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, run.getFinalUpdate(), values, null, true, result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = result + "";
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("update \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    CommandUpdateException ex = new CommandUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) break block17;
                log.error("{}[{}][action:][{}]{}", new Object[]{random, action, run.getTable(), LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
            }
        }
        return result;
    }

    @Override
    public long save(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == data) {
            if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new CommandUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1L;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            long cnt = 0L;
            for (Object item : items) {
                cnt += this.save(runtime, random, dest, item, configs, columns);
            }
            return cnt;
        }
        return this.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        long cnt = 0L;
        return cnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        boolean isNew = BeanUtil.checkIsNew((Object)data);
        if (isNew) {
            return this.insert(runtime, random, 0, dest, data, configs, columns);
        }
        Boolean override = this.checkOverride(data, configs);
        Boolean overrideSync = this.checkOverrideSync(data, configs);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == override) return this.update(runtime, random, dest, data, configs, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        DataSet exists = this.querys(runtime, random, prepare, stores, new String[0]);
        if (exists.isEmpty()) return this.insert(runtime, random, 0, dest, data, configs, columns);
        if (override.booleanValue()) {
            long result = this.update(runtime, random, dest, data, configs, columns);
            if (null == overrideSync || !overrideSync.booleanValue()) return result;
            if (data instanceof DataRow) {
                DataRow row = (DataRow)data;
                row.copyIfEmpty(exists.getRow(0), new String[0]);
                return result;
            } else {
                BeanUtil.copyFieldValueEvl((Object)data, (DataRow)exists.getRow(0));
            }
            return result;
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0L;
    }

    protected Boolean checkOverride(Object obj, ConfigStore configs) {
        Boolean result = null;
        if (obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        if (null == result && null != configs) {
            result = configs.override();
        }
        return result;
    }

    protected Boolean checkOverrideSync(Object obj, ConfigStore configs) {
        Boolean result = null;
        if (obj instanceof DataRow) {
            result = ((DataRow)obj).getOverrideSync();
        }
        if (null == result && null != configs) {
            result = configs.override();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        LinkedHashMap columns;
        Table table = run.getTable();
        if (null != table && null != (columns = this.columns(runtime, null, false, table, false))) {
            Column column = (Column)columns.get(key.toUpperCase());
            return this.isMultipleValue(column);
        }
        return false;
    }

    protected boolean isMultipleValue(Column column) {
        String type;
        return null != column && ((type = column.getTypeName().toUpperCase()).contains("POINT") || type.contains("GEOMETRY") || type.contains("POLYGON"));
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (!ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            return columns;
        }
        if (null == table || table.isEmpty()) {
            return columns;
        }
        LinkedHashMap<String, Column> result = new LinkedHashMap<String, Column>();
        LinkedHashMap metadatas = this.columns(runtime, null, false, table, false);
        try {
            LinkedHashMap tags = this.tags(runtime, null, false, table);
            metadatas.putAll(tags);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!metadatas.isEmpty()) {
            for (String key : columns.keySet()) {
                if (metadatas.containsKey(key)) {
                    result.put(key, (Column)metadatas.get(key));
                    continue;
                }
                if (!ConfigStore.IS_LOG_SQL_WARN(configs)) continue;
                log.warn("[{}][column:{}.{}][insert/update\u5ffd\u7565\u5f53\u524d\u5217\u540d]", new Object[]{LogUtil.format((String)"\u5217\u540d\u68c0\u6d4b\u4e0d\u5b58\u5728", (int)33), table, key});
            }
        } else if (ConfigStore.IS_LOG_SQL_WARN(configs)) {
            log.warn("[{}][table:{}][\u5ffd\u7565\u5217\u540d\u68c0\u6d4b]", (Object)LogUtil.format((String)"\u8868\u7ed3\u6784\u68c0\u6d4b\u5931\u8d25(\u68c0\u67e5\u8868\u540d\u662f\u5426\u5b58\u5728)", (int)33), (Object)table);
        }
        if (ConfigStore.IS_LOG_SQL_WARN(configs)) {
            log.info("[check column metadata][origin:{}][result:{}]", (Object)columns.size(), (Object)result.size());
        }
        return result;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Table table = null;
        DataSet set = null;
        Long fr = 0L;
        boolean cmd_success = false;
        Run run = null;
        PageNavi navi = null;
        if (null == prepare.getJoins() || prepare.getJoins().isEmpty()) {
            table = prepare.getTable();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet().setTable(table);
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet().setTable(table);
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTableName() : prepare.getText();
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        if (null == (navi = run.getPageNavi()) && null != configs) {
            navi = configs.getPageNavi();
        }
        long total = 0L;
        Boolean autoCount = false;
        if (run.isValid() && null != navi) {
            autoCount = navi.autoCount();
            if (null == autoCount) {
                autoCount = true;
            }
            if (autoCount.booleanValue()) {
                if (null != this.dmListener) {
                    this.dmListener.beforeTotal(runtime, random, run);
                }
                fr = System.currentTimeMillis();
                if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                    total = 1L;
                } else if (navi.getTotalRow() == 0L) {
                    total = this.count(runtime, random, run);
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != this.dmListener) {
                    this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                }
                if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || total > 0L || !autoCount.booleanValue()) {
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                if ((swt = InterceptorProxy.beforeQuery(runtime, random, run, navi)) == ACTION.SWITCH.BREAK) {
                    return new DataSet().setTable(table);
                }
                set = this.select(runtime, random, false, table, configs, run);
                cmd_success = true;
            } else {
                if (null != configs) {
                    configs.add(run);
                }
                set = new DataSet().setTable(table);
                if (ConfigStore.IS_CHECK_EMPTY_SET_METADATA(configs)) {
                    set.setMetadata(this.metadata(runtime, prepare, false));
                }
            }
        } else {
            set = new DataSet().setTable(table);
        }
        set.setDest(prepare.getDest());
        set.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            navi.setDataSize(set.size());
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, set, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, set, navi, System.currentTimeMillis() - fr);
        return set;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi)"), (int)37));
        }
        return new DataSet();
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == prepare) {
            prepare = new DefaultTablePrepare();
        }
        EntitySet<T> list = null;
        Long fr = System.currentTimeMillis();
        Run run = null;
        boolean cmd_success = false;
        PageNavi navi = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        if (BasicUtil.isEmpty((Object)prepare.getDest()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare)) {
            prepare.setDest(EntityAdapterProxy.table(clazz, (boolean)true));
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        navi = run.getPageNavi();
        long total = 0L;
        Boolean autoCount = false;
        if (run.isValid()) {
            if (null != navi) {
                autoCount = navi.autoCount();
                if (null == autoCount) {
                    autoCount = true;
                }
                if (autoCount.booleanValue()) {
                    if (null != this.dmListener) {
                        this.dmListener.beforeTotal(runtime, random, run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                        total = 1L;
                    } else if (navi.getTotalRow() == 0L) {
                        total = this.count(runtime, random, run);
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.dmListener) {
                        this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                    }
                }
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || !autoCount.booleanValue() || total > 0L) {
                swt = InterceptorProxy.beforeQuery(runtime, random, run, navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new EntitySet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                fr = System.currentTimeMillis();
                list = this.select(runtime, random, clazz, run.getTable(), configs, run);
                cmd_success = false;
            } else {
                list = new EntitySet();
            }
        } else {
            list = new EntitySet<T>();
        }
        list.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, list, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, list, navi, System.currentTimeMillis() - fr);
        return list;
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        EntitySet set = new EntitySet();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null != configs) {
            configs.entityClass(clazz);
        }
        DataSet rows = this.select(runtime, random, false, table, configs, run);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter(clazz) ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        return set;
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        List<Map<String, Object>> maps = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        Long fr = System.currentTimeMillis();
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTableName() : prepare.getText();
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        if (run.isValid()) {
            Boolean autoCount;
            PageNavi navi;
            swt = InterceptorProxy.beforeQuery(runtime, random, run, null);
            if (swt == ACTION.SWITCH.BREAK) {
                return new ArrayList<Map<String, Object>>();
            }
            if (null != this.dmListener) {
                this.dmListener.beforeQuery(runtime, random, run, -1L);
            }
            if (null != configs && null != (navi = configs.getPageNavi()) && null != (autoCount = navi.autoCount()) && autoCount.booleanValue()) {
                long total = this.count(runtime, random, run);
                navi.setTotalRow(total);
            }
            maps = this.maps(runtime, random, configs, run);
            cmd_success = true;
        } else {
            maps = new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, maps, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, maps, null, System.currentTimeMillis() - fr);
        return maps;
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Run run = this.initQueryRun(runtime, prepare);
        this.init(runtime, run, configs, conditions);
        List<Run> unions = run.getUnions();
        if (null != unions) {
            for (Run union : unions) {
                this.init(runtime, union, configs, conditions);
            }
        }
        if (run.checkValid()) {
            run = this.fillQueryContent(runtime, run);
        }
        return run;
    }

    public void init(DataRuntime runtime, Run run, ConfigStore configs, String ... conditions) {
        if (null != run) {
            RunPrepare prepare = run.getPrepare();
            if (prepare instanceof TablePrepare) {
                this.likes(runtime, prepare.getTable(), configs);
            }
            run.addConfigStore(configs);
            if (run instanceof TextRun) {
                this.parseText(runtime, (TextRun)run);
            }
            if (null != (configs = run.getConfigs())) {
                List<Object> statics = configs.getStaticValues();
                for (Object item : statics) {
                    run.addValue(new RunValue("none", item));
                }
            }
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                if (ConfigStore.IS_AUTO_CHECK_METADATA(configs) && null != prepare) {
                    List<RunPrepare> joins = prepare.getJoins();
                    Table table = run.getTable();
                    if (null != table && (null == joins || joins.isEmpty())) {
                        ConditionChain chain;
                        LinkedHashMap<String, Column> metadatas = this.columns(runtime, null, false, table, false);
                        OrderStore orders = run.getOrderStore();
                        if (null != orders) {
                            orders.filter(metadatas);
                        }
                        if (null != prepare) {
                            prepare.filter(metadatas);
                        }
                        if (null != (chain = run.getConditionChain())) {
                            chain.filter(metadatas);
                        }
                        if (null != configs) {
                            configs.filter(metadatas);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void parseText(DataRuntime runtime, TextRun run) {
        RunPrepare prepare = run.getPrepare();
        if (null == prepare) {
            return;
        }
        String text = prepare.getText();
        if (null == text) {
            return;
        }
        CommandParser.parseText(runtime, run, text);
    }

    private void likes(DataRuntime runtime, Table table, ConfigStore configs) {
        if (null == table || null == configs) {
            return;
        }
        List<Config> list = configs.getConfigChain().getConfigs();
        for (Config config : list) {
            if (config.getCompare() != Compare.LIKES) continue;
            LinkedHashMap colums = this.columns(runtime, null, false, table, false);
            list.remove(config);
            DefaultConfigStore ors = new DefaultConfigStore(new String[0]);
            List<Object> values = config.getValues();
            Object value = null;
            if (null != values && !values.isEmpty()) {
                value = values.get(0);
            }
            for (Column column : colums.values()) {
                TypeMetadata tm = column.getTypeMetadata();
                if (null == tm || tm.getCategoryGroup() != TypeMetadata.CATEGORY_GROUP.STRING) continue;
                ors.or(Compare.LIKE, column.getName(), value);
            }
            configs.and(ors);
            break;
        }
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, Run run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, StringBuilder builder, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                run = this.fillQueryContent(runtime, builder, (TableRun)run);
            } else if (run instanceof XMLRun) {
                run = this.fillQueryContent(runtime, builder, (XMLRun)run);
            } else if (run instanceof TextRun) {
                run = this.fillQueryContent(runtime, builder, (TextRun)run);
            }
            this.convert(runtime, run.getConfigs(), run);
        }
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, XMLRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, XMLRun run) {
        String text = CommandParser.replaceVariable(runtime, run, run.getVariableBlocks(), run.getVariables(), run.getText());
        run.getBuilder().append(text);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, TextRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, TextRun run) {
        String text = CommandParser.replaceVariable(runtime, run, run.getVariableBlocks(), run.getVariables(), run.getText());
        run.getBuilder().append(text);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, TableRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, TableRun run) {
        ConfigStore configs;
        TablePrepare prepare = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != prepare.getDistinct()) {
            builder.append(prepare.getDistinct());
        }
        builder.append("\n\t");
        LinkedHashMap<String, Object> columns = prepare.getColumns();
        if ((null == columns || columns.isEmpty()) && null != (configs = run.getConfigs())) {
            List<String> cols = configs.columns();
            columns = new LinkedHashMap();
            for (String col : cols) {
                columns.put(col.toUpperCase(), new Column(col));
            }
        }
        if (null != columns && !columns.isEmpty()) {
            boolean first = true;
            for (Column column : columns.values()) {
                if (BasicUtil.isEmpty((Object)column) || BasicUtil.isEmpty((Object)column.getName())) continue;
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                String name = column.getName();
                if (BasicUtil.checkEl((String)name)) {
                    name = name.substring(2, name.length() - 1);
                    builder.append(name);
                    continue;
                }
                if (name.contains("(") || name.contains(",")) {
                    builder.append(name);
                    continue;
                }
                if (name.toUpperCase().contains(" AS ")) {
                    int split = name.toUpperCase().indexOf(" AS ");
                    String tmp = name.substring(0, split).trim();
                    this.delimiter(builder, tmp);
                    builder.append(this.columnAliasGuidd());
                    tmp = name.substring(split + 4).trim();
                    this.delimiter(builder, tmp);
                    continue;
                }
                if ("*".equals(name)) {
                    builder.append("*");
                    continue;
                }
                this.delimiter(builder, name);
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        builder.append("FROM ");
        this.fillMasterTableContent(runtime, builder, run, prepare);
        builder.append("\n");
        List<RunPrepare> joins = prepare.getJoins();
        if (null != joins) {
            for (RunPrepare join : joins) {
                this.fillJoinTableContent(runtime, builder, run, join);
            }
        }
        run.appendCondition(builder, this, true, true);
        run.appendGroup(builder);
        return run;
    }

    public Run fillMasterTableContent(DataRuntime runtime, StringBuilder builder, TableRun run, RunPrepare prepare) {
        if (prepare instanceof VirtualTablePrepare) {
            Run fromRun = this.buildQueryRun(runtime, ((VirtualTablePrepare)prepare).getPrepare(), new DefaultConfigStore(new String[0]), new String[0]);
            run.getRunValues().addAll(fromRun.getRunValues());
            String inner = fromRun.getFinalQuery(true);
            inner = BasicUtil.tab((String)inner);
            builder.append("(\n").append(inner).append("\n)");
        } else {
            Table table = prepare.getTable();
            this.name(runtime, builder, (Metadata)table);
        }
        String alias = prepare.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(this.tableAliasGuidd());
            this.delimiter(builder, alias);
        }
        return run;
    }

    public Run fillJoinTableContent(DataRuntime runtime, StringBuilder builder, TableRun run, RunPrepare prepare) {
        builder.append("\n");
        Join join = prepare.getJoin();
        if (prepare instanceof VirtualTablePrepare) {
            join = ((VirtualTablePrepare)prepare).getPrepare().getJoin();
            builder.append(join.getType().getCode()).append(" ");
            Run joinRun = this.buildQueryRun(runtime, ((VirtualTablePrepare)prepare).getPrepare(), new DefaultConfigStore(new String[0]), new String[0]);
            run.getRunValues().addAll(joinRun.getRunValues());
            String inner = joinRun.getFinalQuery(true);
            inner = BasicUtil.tab((String)inner);
            builder.append("(").append("\n").append(inner).append("\n").append(")");
        } else {
            builder.append(join.getType().getCode()).append(" ");
            this.name(runtime, builder, (Metadata)prepare.getTable());
        }
        String alias = prepare.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(this.tableAliasGuidd());
            this.delimiter(builder, alias);
        }
        String on = join.getConditions().getRunText(runtime, false);
        on = SQLUtil.trim((String)on);
        builder.append(" ON ").append(on).append("\n");
        return run;
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return run.getBaseQuery();
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder, boolean unicode) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder, boolean unicode)"), (int)37));
        }
        return null;
    }

    @Override
    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder, boolean unicode) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder, boolean unicode)"), (int)37));
        }
        return null;
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run)"), (int)37));
        }
        return new DataSet().setTable(table);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        List<Map<String, Object>> maps;
        block11: {
            maps = null;
            if (null == random) {
                random = this.random(runtime);
            }
            if (null != configs) {
                configs.add(run);
            }
            String sql = run.getFinalQuery();
            List<Object> values = run.getValues();
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new CommandQueryException("\u672a\u6307\u5b9a\u547d\u4ee4");
                }
                log.error("\u672a\u6307\u5b9a\u547d\u4ee4");
                return new ArrayList<Map<String, Object>>();
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new ArrayList<Map<String, Object>>();
            }
            try {
                maps = this.actuator.maps(this, runtime, random, configs, run);
                maps = this.process(runtime, maps);
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("maps \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) break block11;
                CommandQueryException ex = new CommandQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return maps;
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long fr;
        List<Object> values;
        String sql;
        Map<String, Object> map;
        block11: {
            map = null;
            sql = run.getFinalExists();
            values = run.getValues();
            if (null != configs) {
                configs.add(run);
            }
            fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.EXISTS, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new HashMap<String, Object>();
            }
            try {
                map = this.actuator.map(this, runtime, random, configs, run);
            }
            catch (Exception e) {
                if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new CommandQueryException("\u67e5\u8be2\u5f02\u5e38", e);
                }
                if (!ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) break block11;
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                log.error("{}[{}][action:select][cmd:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e, sql, LogUtil.param(values)});
            }
        }
        Long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
        if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:exists][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n]\n[param:{}]", new Object[]{random, DateUtil.format((Long)millis), sql, LogUtil.param(values)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, sql, values, null, true, map, millis);
            }
        }
        if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
            log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((Long)millis), LogUtil.format((int)(map == null ? 0 : 1), (int)34)});
        }
        return map;
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return list;
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long count = -1L;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        boolean cmd_success = false;
        ACTION.SWITCH swt = InterceptorProxy.prepareCount(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTableName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeCount(runtime, random, run);
        }
        if ((swt = InterceptorProxy.beforeCount(runtime, random, run, configs)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        fr = System.currentTimeMillis();
        count = this.count(runtime, random, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterCount(runtime, random, run, configs, cmd_success, count, System.currentTimeMillis() - fr);
        return count;
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalTotal(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long count(DataRuntime runtime, String random, Run run)"), (int)37));
        }
        return -1L;
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0  exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions)"), (int)37));
        }
        return false;
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalExists(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareExecute(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildExecuteRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTableName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeExecute(runtime, random, run, configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeExecute(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterExecute(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterExecute(runtime, random, run, configs, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        if (null == random) {
            random = this.random(runtime);
        }
        prepare.setBatch(batch);
        Run run = this.buildExecuteRun(runtime, prepare, configs, new String[0]);
        if (null != values && !values.isEmpty()) {
            Object first = values.iterator().next();
            if (first instanceof Collection) {
                ArrayList<Object> list = new ArrayList<Object>();
                int vol = 0;
                for (Object item : values) {
                    Collection col = (Collection)item;
                    list.addAll(col);
                    vol = col.size();
                }
                run.setValues(null, list);
                run.setVol(vol);
            } else if (first.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                boolean vol = false;
                int len = Array.getLength(first);
                for (Object item : values) {
                    for (int i = 0; i < len; ++i) {
                        Object value = Array.get(item, i);
                        list.add(value);
                    }
                }
                run.setValues(null, list);
                run.setVol(len);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                List<Variable> vars = run.getVariables();
                ArrayList<String> keys = new ArrayList<String>();
                run.setVol(vars.size());
                for (Variable var : vars) {
                    keys.add(var.getKey());
                }
                for (Object item : values) {
                    for (String key : keys) {
                        Object value = BeanUtil.getFieldValue((Object)item, (String)key, (boolean)true);
                        list.add(value);
                    }
                }
                run.setValues(null, list);
            }
        }
        return this.execute(runtime, random, configs, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, int vol, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        if (null == random) {
            random = this.random(runtime);
        }
        prepare.setBatch(batch);
        Run run = this.buildExecuteRun(runtime, prepare, configs, new String[0]);
        run.setVol(vol);
        run.setValues(null, values);
        return this.execute(runtime, random, configs, run);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Procedure procedure)"), (int)37));
        }
        return false;
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        TextRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setConfigStore(configs);
            run.setBatch(prepare.getBatch());
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            if (run instanceof TextRun) {
                this.parseText(runtime, run);
            }
            run.addCondition(conditions);
            run.init();
            this.fillExecuteContent(runtime, (Run)run);
        }
        return run;
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        String text = CommandParser.replaceVariable(runtime, run, run.getVariableBlocks(), run.getVariables(), run.getText());
        run.getBuilder().append(text);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillExecuteContent(runtime, r);
            }
        }
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result;
        block16: {
            result = -1L;
            if (null == random) {
                random = this.random(runtime);
            }
            String sql = run.getFinalExecute();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            int batch = run.getBatch();
            String action = "execute";
            if (batch > 1) {
                action = "batch execute";
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, sql, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            if (null != configs) {
                configs.add(run);
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                result = this.actuator.execute(this, runtime, random, configs, run);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n]\n[param:{}]", new Object[]{random, action, DateUtil.format((long)millis), sql, LogUtil.param(values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, sql, values, null, true, result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = "" + result;
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, DateUtil.format((long)millis), LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("execute exception:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}]{}", new Object[]{random, LogUtil.format((String)"\u547d\u4ee4\u6267\u884c\u5f02\u5e38:", (int)33) + e, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block16;
                throw new CommandUpdateException("\u547d\u4ee4\u6267\u884c\u5f02\u5e38", e);
            }
        }
        return result;
    }

    @Override
    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String key, Collection<T> values) {
        ACTION.SWITCH swt;
        long result = -1L;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareDelete(runtime, random, batch, table, configs, key, values)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, batch, table, key, values);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        List<Run> runs = this.buildDeleteRun(runtime, batch, table, configs, key, values);
        for (Run run : runs) {
            if (!run.isValid()) {
                if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                continue;
            }
            if (result == -1L) {
                result = 1L;
            }
            result += this.delete(runtime, random, configs, run);
        }
        return result;
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long size = -1L;
        if (null != obj) {
            swt = InterceptorProxy.prepareDelete(runtime, random, 0, dest, obj, configs, columns);
            if (swt == ACTION.SWITCH.BREAK) {
                return -1L;
            }
            if (null != this.dmListener) {
                swt = this.dmListener.prepareDelete(runtime, random, 0, dest, obj, columns);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                return -1L;
            }
            List<Run> runs = this.buildDeleteRun(runtime, dest, configs, obj, columns);
            for (Run run : runs) {
                if (!run.isValid()) {
                    if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                    continue;
                }
                if (size == -1L) {
                    size = 0L;
                }
                size += this.delete(runtime, random, configs, run);
            }
        }
        return size;
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        swt = InterceptorProxy.prepareDelete(runtime, random, 0, table, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, 0, table, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        List<Run> runs = this.buildDeleteRun(runtime, table, configs, (Object)conditions, new String[0]);
        for (Run run : runs) {
            if (!run.isValid()) {
                if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                continue;
            }
            if (result == -1L) {
                result = 0L;
            }
            result += this.delete(runtime, random, configs, run);
        }
        return result;
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        List<Run> runs = this.buildTruncateRun(runtime, table);
        if (null != runs && !runs.isEmpty()) {
            DefaultTextPrepare prepare = new DefaultTextPrepare(runs.get(0).getFinalUpdate());
            return (int)this.execute(runtime, random, prepare, null, new String[0]);
        }
        return -1L;
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        List<Run> runs = new ArrayList<Run>();
        if (null == obj && (null == configs || configs.isEmptyCondition())) {
            return null;
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                runs.addAll(this.buildDeleteRun(runtime, dest, configs, item, columns));
            }
            return runs;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table;
            }
        }
        if (null == dest || BasicUtil.isEmpty((Object)dest.getName())) {
            runs = this.buildDeleteRunFromConfig(runtime, configs);
        } else if (obj instanceof ConfigStore) {
            TableRun run = new TableRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDest(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, run);
            runs.add(run);
        } else {
            runs = this.buildDeleteRunFromEntity(runtime, dest, configs, obj, columns);
        }
        this.convert(runtime, (ConfigStore)new DefaultConfigStore(new String[0]), runs);
        return runs;
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, String key, Object values) {
        List<Run> runs = this.buildDeleteRunFromTable(runtime, batch, table, configs, key, values);
        this.convert(runtime, (ConfigStore)new DefaultConfigStore(new String[0]), runs);
        return runs;
    }

    @Override
    public List<Run> buildTruncateRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    @Override
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs,String column, Object values)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, String ... columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDeleteRunFromEntity(DataRuntime runtime, String table, ConfigStore configs, Object obj, String... columns)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillDeleteRunContent(DataRuntime runtime, Run run)"), (int)37));
        }
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result = -1L;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete(runtime, random, run, configs);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        long millis = -1L;
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete(runtime, random, run, configs, cmd_success, result, millis);
        return result;
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, String random)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        String product = null;
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryProductRun(runtime);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            product = this.product(runtime, idx++, true, product, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[product][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (null == product) {
                product = this.product(runtime, false, product);
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[product][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, product, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[product][result:fail][msg:{}]", (Object)e.toString());
        }
        return product;
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        String version = null;
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryProductRun(runtime);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            version = this.version(runtime, idx++, true, version, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[version][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (null == version) {
                version = this.version(runtime, false, version);
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[version][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, version, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[version][result:fail][msg:{}]", (Object)e.toString());
        }
        return version;
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, Database query) {
        String name = query.getName();
        if (null == random) {
            random = this.random(runtime);
        }
        List<Object> databases = new ArrayList();
        try {
            long fr;
            block12: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryDatabasesRun(runtime, greedy, name))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            databases = this.databases(runtime, idx++, true, databases, query, set);
                        }
                    }
                    if (databases.isEmpty()) {
                        databases = this.getActuator().databases(this, runtime, query);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block12;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, databases.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, Database query) {
        String name = query.getName();
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Object> databases = new LinkedHashMap<String, Database>();
        try {
            long fr;
            block12: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryDatabasesRun(runtime, false, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            databases = this.databases(runtime, idx++, true, databases, query, set);
                        }
                    }
                    if (databases.isEmpty()) {
                        List list = this.getActuator().databases(this, runtime, query);
                        for (Database item : list) {
                            databases.put(item.getName().toUpperCase(), item);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block12;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, databases.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryProductRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVersionRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initDatabaseFieldRefer() {
        return new MetadataFieldRefer(Database.class);
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Database query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, int index, boolean create, List<T> previous, Database query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, boolean create, Database meta)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String product(DataRuntime runtime, int index, boolean create, String product, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String product(DataRuntime runtime, boolean create, String product)"), (int)37));
        }
        return null;
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String version(DataRuntime runtime, int index, boolean create, String version, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String version(DataRuntime runtime, boolean create, String version)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Database> T init(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        if (null == meta) {
            meta = new Database();
        }
        MetadataFieldRefer refer = this.refer(runtime, Database.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        return meta;
    }

    @Override
    public <T extends Database> T detail(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        MetadataFieldRefer refer = this.refer(runtime, Database.class);
        meta.setUser(this.getString(row, refer, "USER"));
        meta.setEngine(this.getString(row, refer, "ENGINE"));
        return meta;
    }

    @Override
    public Catalog catalog(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        Catalog catalog = null;
        try {
            long fr;
            block14: {
                block13: {
                    fr = System.currentTimeMillis();
                    try {
                        List<Run> runs = this.buildQueryCatalogRun(runtime, random);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.selectMetadata(runtime, random, run);
                                catalog = this.catalog(runtime, idx++, true, catalog, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block13;
                        log.warn("{}[catalog][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                    }
                }
                try {
                    catalog = this.catalog(runtime, true, catalog);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[catalog][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636eJDBC\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalog][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalog][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalog;
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, Catalog query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap catalogs = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryCatalogsRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalogs.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, Catalog query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List catalogs = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryCatalogsRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalogs.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public List<Run> buildQueryCatalogRun(DataRuntime runtime, String random) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryCatalogRun(DataRuntime runtime, String random)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initCatalogFieldRefer() {
        return new MetadataFieldRefer(Catalog.class);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Catalog catalog(DataRuntime runtime, boolean create, Catalog meta)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Catalog> T init(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        if (null == meta) {
            meta = new Catalog();
        }
        MetadataFieldRefer refer = this.refer(runtime, Catalog.class);
        String name = row.getString(refer.maps("NAME"));
        meta.setMetadata(row);
        meta.setName(name);
        return meta;
    }

    @Override
    public <T extends Catalog> T detail(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return meta;
    }

    @Override
    public Schema schema(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        Schema schema = null;
        try {
            long fr;
            block14: {
                block13: {
                    fr = System.currentTimeMillis();
                    try {
                        List<Run> runs = this.buildQuerySchemaRun(runtime, random);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.selectMetadata(runtime, random, run);
                                schema = this.schema(runtime, idx++, true, schema, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block13;
                        log.warn("{}[schema][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                    }
                }
                try {
                    schema = this.schema(runtime, true, schema);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[schema][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636eJDBC\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schema][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schema, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schema][result:fail][msg:{}]", (Object)e.toString());
        }
        return schema;
    }

    public DataSet selectMetadata(DataRuntime runtime, String random, Run run) {
        ConfigStore configs = run.getConfigs();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
            run.setConfigStore(configs);
        }
        configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER);
        configs.IS_ENABLE_PLACEHOLDER_REGEX_EXT(false);
        if (run instanceof SimpleRun) {
            String text = run.getBuilder().toString();
            DefaultTextPrepare prepare = new DefaultTextPrepare(text);
            run = this.buildQueryRun(runtime, prepare, configs, new String[0]);
        }
        DataSet set = this.select(runtime, random, true, (Table)null, configs, run);
        return set;
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Schema query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap schemas = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySchemasRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            schemas = this.schemas(runtime, idx++, true, schemas, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schemas.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Schema query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List schemas = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQuerySchemasRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            schemas = this.schemas(runtime, idx++, true, schemas, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schemas.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public List<Run> buildQuerySchemaRun(DataRuntime runtime, String random) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySchemaRun(DataRuntime runtime, String random)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initSchemaFieldRefer() {
        return new MetadataFieldRefer(Schema.class);
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Schema query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Schema query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Schema query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Schema query)"), (int)37));
        }
        return previous;
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, boolean create, List<T> previous, Schema query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Schema> List<T> schemas(DataRuntime runtime, boolean create, List<T> previous, Schema query)"), (int)37));
        }
        return previous;
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Schema schema(DataRuntime runtime, boolean create, Schema meta)"), (int)37));
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, Column> metadata(DataRuntime runtime, RunPrepare prepare, boolean comment) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String,Column> metadata(DataRuntime runtime, RunPrepare prepare, boolean comment)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Metadata> T checkName(DataRuntime runtime, String random, T meta) throws RuntimeException {
        if (null == meta) {
            return null;
        }
        String name = meta.getName();
        if (null != name && name.contains(".")) {
            String[] ks = name.split("\\.");
            if (ks.length == 3) {
                meta.setCatalog(ks[0]);
                meta.setSchema(ks[1]);
                meta.setName(ks[2]);
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5b9e\u522bschema\u6216catalog(\u5b50\u7c7b\u672a" + this.getClass().getSimpleName() + "\u5b9e\u73b0)");
            }
        }
        return meta;
    }

    @Override
    public <T extends Schema> T init(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        MetadataFieldRefer refer;
        String _catalog;
        Catalog catalog = query.getCatalog();
        if (null == meta) {
            meta = new Schema();
        }
        if (null == (_catalog = row.getString((refer = this.refer(runtime, Schema.class)).maps("CATALOG"))) && null != catalog) {
            _catalog = catalog.getName();
        }
        String name = row.getString(refer.maps("NAME"));
        if (null != _catalog) {
            _catalog = _catalog.trim();
        }
        meta.setUser(row.getString(refer.maps("USER")));
        meta.setMetadata(row);
        meta.setCatalog(_catalog);
        meta.setName(name);
        return meta;
    }

    @Override
    public <T extends Schema> T detail(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return meta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        List<Object> list;
        block36: {
            list = new ArrayList();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                String pattern;
                Schema schema;
                Catalog catalog;
                String caches_key;
                long fr = System.currentTimeMillis();
                if (!greedy) {
                    this.checkSchema(runtime, query);
                }
                if (null == (list = CacheProxy.tables(caches_key = CacheProxy.key(runtime, "tables", greedy, catalog = query.getCatalog(), schema = query.getSchema(), pattern = query.getName(), types, configs))) || list.isEmpty()) {
                    void var16_20;
                    block35: {
                        PageNavi navi;
                        block34: {
                            void var16_18;
                            String cache_key = CacheProxy.key(runtime, "table_name_map", greedy, catalog, schema, pattern);
                            String string = CacheProxy.name(cache_key);
                            if (null == string && ConfigTable.IS_METADATA_IGNORE_CASE) {
                                this.tableMap(runtime, random, greedy, query, new DefaultConfigStore(new String[0]));
                                String string2 = CacheProxy.name(cache_key);
                            }
                            if (null != var16_18) {
                                query.setName((String)var16_18);
                            } else {
                                String string3 = query.getName();
                            }
                            navi = null;
                            if (null == configs) {
                                configs = new DefaultConfigStore(new String[0]);
                            }
                            navi = configs.getPageNavi();
                            try {
                                List<Run> runs = this.buildQueryTablesRun(runtime, greedy, query, types, configs);
                                if (null == runs) break block34;
                                int idx = 0;
                                for (Run run : runs) {
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                        this.mergeFinalQuery(runtime, run);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.tables(runtime, idx++, true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block34;
                                log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        if (null == list || list.isEmpty()) {
                            try {
                                list = this.tables(runtime, true, list, catalog, schema, (String)var16_20, types);
                                if (!greedy) {
                                    int size = list.size();
                                    for (int i = size - 1; i >= 0; --i) {
                                        Table table = (Table)list.get(i);
                                        if (this.equals(catalog, table.getCatalog()) && this.equals(schema, table.getSchema())) continue;
                                        list.remove(i);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("{}[tables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        boolean comment = false;
                        for (Table table : list) {
                            if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                            comment = true;
                            break;
                        }
                        if (!comment) {
                            try {
                                List<Run> runs = this.buildQueryTablesCommentRun(runtime, catalog, schema, (String)var16_20, types);
                                if (null == runs) break block35;
                                boolean bl = false;
                                for (Run run : runs) {
                                    void var20_42;
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.comments(runtime, (int)(++var20_42), true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                                log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                    }
                    if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                        log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, var16_20, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                    }
                    if (BasicUtil.isNotEmpty((Object)var16_20)) {
                        String string = var16_20.replace("%", ".*");
                        ArrayList<Table> tmp = new ArrayList<Table>();
                        for (Table table : list) {
                            String name = table.getName(greedy) + "";
                            if (!RegularUtil.match((String)name.toUpperCase(), (String)string.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !BasicUtil.isEmpty((Object)catalog) && !this.equals(catalog, table.getCatalog()) || !BasicUtil.isEmpty((Object)schema) && !this.equals(schema, table.getSchema())) continue;
                            tmp.add(table);
                        }
                        list = tmp;
                    }
                    CacheProxy.tables(caches_key, list);
                }
                if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                    for (Table table : list) {
                        if (null != table.getColumns() && !table.getColumns().isEmpty()) continue;
                        Column column_query = new Column();
                        column_query.setCatalog(catalog);
                        column_query.setSchema(schema);
                        this.columns(runtime, random, greedy, list, column_query);
                        break;
                    }
                }
                if (!Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) break block36;
                for (Table table : list) {
                    if (null != table.getIndexes() && !table.getIndexes().isEmpty()) continue;
                    Index index_qeury = new Index();
                    index_qeury.setCatalog(catalog);
                    index_qeury.setSchema(schema);
                    this.indexes(runtime, random, greedy, list, index_qeury);
                    break;
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return list;
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Table query, ConfigStore configs) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List tables = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryTablesRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, new DefaultConfigStore(new String[0]));
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    tables = this.tables(runtime, idx++, true, tables, catalog, schema, set);
                    for (Table table : tables) {
                        String cache_key = CacheProxy.key(runtime, "table_name_map", greedy, catalog, schema, table.getName());
                        CacheProxy.name(cache_key, table.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                tables = this.tables(runtime, true, tables, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (Table table : tables) {
                    String cache_key = CacheProxy.key(runtime, "table_name_map", greedy, catalog, schema, table.getName());
                    CacheProxy.name(cache_key, table.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        List<T> list = this.tables(runtime, random, false, query, types, struct, configs);
        for (Table table : list) {
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTablesRun(DataRuntime runtime, Table query, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initTableFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.class);
        refer.map("NAME", "TABLE_NAME,NAME,TABNAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA,TABSCHEMA,SCHEMA_NAME");
        refer.map("COMMENT", "TABLE_COMMENT,COMMENTS,COMMENT");
        return refer;
    }

    @Override
    public MetadataFieldRefer initTableCommentFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(TableComment.class);
        refer.map("VALUE", "TABLE_COMMENT");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        return refer;
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, meta, catalog, schema, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, catalog, schema, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T meta = null;
            if (null == (meta = this.init(runtime, index, meta, query, row)) || meta.isEmpty()) continue;
            if (null == this.search(previous, meta.getCatalog(), meta.getSchema(), meta.getName())) {
                previous.add(meta);
            }
            this.detail(runtime, index, meta, query, row);
        }
        return previous;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Table query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Table query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public <T extends Table> T init(DataRuntime runtime, int index, T meta, Table query, DataRow row) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        MetadataFieldRefer refer = this.refer(runtime, Table.class);
        String _catalog = this.getString(row, refer, "CATALOG");
        String _schema = this.getString(row, refer, "SCHEMA");
        if (null == _catalog && null != catalog) {
            _catalog = catalog.getName();
        }
        if (null == _schema && null != schema) {
            _schema = schema.getName();
        }
        String name = this.getString(row, refer, "NAME");
        if (null == meta) {
            String[] vals;
            String[] chks;
            Boolean bol;
            meta = "VIEW".equals(this.getString(row, refer, "TYPE")) ? new View() : (null != (bol = this.matchBoolean(row, chks = refer.maps("_MASTER_CHECK"), vals = refer.maps("MASTER_CHECK_VALUE"))) && bol != false ? new MasterTable() : new Table());
        }
        if (null != _catalog) {
            _catalog = _catalog.trim();
        }
        if (null != _schema) {
            _schema = _schema.trim();
        }
        meta.setMetadata(row);
        meta.setCatalog(_catalog);
        meta.setSchema(_schema);
        meta.setName(name);
        return meta;
    }

    @Override
    public <T extends Table> T detail(DataRuntime runtime, int index, T meta, Table query, DataRow row) {
        MetadataFieldRefer refer = this.refer(runtime, Table.class);
        meta.setObjectId(this.getLong(row, refer, "OBJECT_ID"));
        meta.setComment(this.getString(row, refer, "COMMENT"));
        meta.setDataRows(this.getLong(row, refer, "DATA_ROWS"));
        meta.setCollate(this.getString(row, refer, "COLLATE"));
        meta.setDataLength(this.getLong(row, refer, "DATA_LENGTH"));
        meta.setDataFree(this.getLong(row, refer, "DATA_FREE"));
        meta.setIncrement(this.getLong(row, refer, "INCREMENT"));
        meta.setIndexLength(this.getLong(row, refer, "INDEX_LENGTH"));
        meta.setCreateTime(this.getDate(row, refer, "CREATE_TIME"));
        meta.setUpdateTime(this.getDate(row, refer, "UPDATE_TIME"));
        meta.setType(this.getString(row, refer, "TYPE"));
        meta.setEngine(this.getString(row, refer, "ENGINE"));
        meta.setTemporary(this.getBoolean(row, refer, "TEMPORARY", false).booleanValue());
        return meta;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        MetadataFieldRefer refer = new MetadataFieldRefer(TableComment.class);
        for (DataRow row : set) {
            Table table;
            String tab = this.getString(row, refer, "TABLE");
            if (null == tab) continue;
            String comment = this.getString(row, refer, "VALUE");
            if (null == tab || null == comment || null == (table = (Table)previous.get(tab.toUpperCase()))) continue;
            table.setComment(comment);
        }
        return previous;
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        MetadataFieldRefer refer = new MetadataFieldRefer(TableComment.class);
        for (DataRow row : set) {
            String tab = this.getString(row, refer, "TABLE");
            if (null == tab) continue;
            String comment = this.getString(row, refer, "VALUE");
            String catlog_ = this.getString(row, refer, "CATALOG");
            String schema_ = this.getString(row, refer, "SCHEMA");
            if (null == catalog && BasicUtil.isNotEmpty((Object)catlog_)) {
                catalog = new Catalog(catlog_);
            }
            if (null == schema && BasicUtil.isNotEmpty((Object)schema_)) {
                schema = new Schema(schema_);
            }
            boolean contains = true;
            Table table = (Table)this.search(previous, catalog, schema, tab);
            if (null == table) {
                if (!create) continue;
                table = new Table(catalog, schema, tab);
                contains = false;
            }
            table.setComment(comment);
            if (contains) continue;
            previous.add(table);
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, table);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = table.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, table, true);
                        table.setColumns(columns);
                        table.setTags(this.tags(runtime, random, false, table));
                    }
                    if (null == (pk = table.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, table);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    table.setPrimaryKey(pk);
                    LinkedHashMap indexes = table.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        table.setIndexes(this.indexes(runtime, random, table, null));
                    }
                    runs = this.buildCreateRun(runtime, table);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        table.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, VertexTable query, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String pattern;
            Schema schema;
            Catalog catalog;
            String caches_key;
            long fr = System.currentTimeMillis();
            if (!greedy) {
                this.checkSchema(runtime, query);
            }
            if (null == (list = CacheProxy.vertexs(caches_key = CacheProxy.key(runtime, "vertexs", greedy, catalog = query.getCatalog(), schema = query.getSchema(), pattern = query.getName(), types, configs))) || list.isEmpty()) {
                void var16_20;
                block36: {
                    PageNavi navi;
                    block35: {
                        void var16_18;
                        String cache_key = CacheProxy.key(runtime, "vertex_name_map", greedy, catalog, schema, pattern);
                        String string = CacheProxy.name(cache_key);
                        if (null == string && ConfigTable.IS_METADATA_IGNORE_CASE) {
                            this.vertexMap(runtime, random, greedy, query, new DefaultConfigStore(new String[0]));
                            String string2 = CacheProxy.name(cache_key);
                        }
                        if (null != var16_18) {
                            query.setName((String)var16_18);
                        } else {
                            String string3 = query.getName();
                        }
                        navi = null;
                        if (null == configs) {
                            configs = new DefaultConfigStore(new String[0]);
                        }
                        navi = configs.getPageNavi();
                        try {
                            List<Run> runs = this.buildQueryTablesRun(runtime, greedy, (Table)query, types, configs);
                            if (null == runs) break block35;
                            int idx = 0;
                            for (Run run : runs) {
                                if (null != navi) {
                                    run.setPageNavi(navi);
                                    this.mergeFinalQuery(runtime, run);
                                }
                                DataSet set = this.selectMetadata(runtime, random, run);
                                list = this.vertexs(runtime, idx++, true, list, catalog, schema, set);
                                if (null == navi) continue;
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                            log.warn("{}[vertexs][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                        }
                    }
                    if (null == list || list.isEmpty()) {
                        try {
                            list = this.vertexs(runtime, true, list, catalog, schema, (String)var16_20, types);
                            if (!greedy) {
                                int size = list.size();
                                for (int i = size - 1; i >= 0; --i) {
                                    Table table = (Table)list.get(i);
                                    if (this.equals(catalog, table.getCatalog()) && this.equals(schema, table.getSchema())) continue;
                                    list.remove(i);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            log.warn("{}[vertexs][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                        }
                    }
                    boolean comment = false;
                    for (Table table : list) {
                        if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                        comment = true;
                        break;
                    }
                    if (!comment) {
                        try {
                            List<Run> runs = this.buildQueryTablesCommentRun(runtime, catalog, schema, (String)var16_20, types);
                            if (null == runs) break block36;
                            boolean bl = false;
                            for (Run run : runs) {
                                void var20_42;
                                if (null != navi) {
                                    run.setPageNavi(navi);
                                }
                                DataSet set = this.selectMetadata(runtime, random, run);
                                list = this.comments(runtime, (int)(++var20_42), true, list, catalog, schema, set);
                                if (null == navi) continue;
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                e.printStackTrace();
                            }
                            if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                            log.info("{}[vertexs][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                        }
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[vertexs][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, var16_20, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
                if (BasicUtil.isNotEmpty((Object)var16_20)) {
                    String string = var16_20.replace("%", ".*");
                    ArrayList<VertexTable> tmp = new ArrayList<VertexTable>();
                    for (VertexTable vertexTable : list) {
                        String name = vertexTable.getName(greedy) + "";
                        if (!RegularUtil.match((String)name.toUpperCase(), (String)string.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, vertexTable.getCatalog()) || !this.equals(schema, vertexTable.getSchema())) continue;
                        tmp.add(vertexTable);
                    }
                    list = tmp;
                }
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                for (VertexTable vertexTable : list) {
                    if (null != vertexTable.getColumns() && !vertexTable.getColumns().isEmpty()) continue;
                    Column column_query = new Column();
                    column_query.setCatalog(catalog);
                    column_query.setSchema(schema);
                    this.columns(runtime, random, greedy, list, column_query);
                    break;
                }
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                for (VertexTable vertexTable : list) {
                    if (null != vertexTable.getIndexes() && !vertexTable.getIndexes().isEmpty()) continue;
                    Index index_qeury = new Index();
                    index_qeury.setCatalog(catalog);
                    index_qeury.setSchema(schema);
                    this.indexes(runtime, random, greedy, list, index_qeury);
                    break;
                }
            }
            CacheProxy.vertexs(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[vertexs][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void vertexMap(DataRuntime runtime, String random, boolean greedy, VertexTable query, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List vertexs = null;
        boolean sys = false;
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryVertexsRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, new DefaultConfigStore(new String[0]));
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    vertexs = this.vertexs(runtime, idx++, true, vertexs, catalog, schema, set);
                    for (VertexTable vertex : vertexs) {
                        String cache_key = CacheProxy.key(runtime, "vertex", greedy, catalog, schema, vertex.getName());
                        CacheProxy.name(cache_key, vertex.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                vertexs = this.vertexs(runtime, true, vertexs, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (VertexTable vertex : vertexs) {
                    String cache_key = CacheProxy.key(runtime, "vertex", greedy, catalog, schema, vertex.getName());
                    CacheProxy.name(cache_key, vertex.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, VertexTable query, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, VertexTable> vertexs = new LinkedHashMap<String, VertexTable>();
        List<T> list = this.vertexs(runtime, random, false, query, types, struct, configs);
        for (VertexTable vertex : list) {
            vertexs.put(vertex.getName().toUpperCase(), vertex);
        }
        return vertexs;
    }

    @Override
    public List<Run> buildQueryVertexsRun(DataRuntime runtime, boolean greedy, VertexTable query, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVertexsRun(DataRuntime runtime, VertexTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initVertexFieldRefer() {
        return new MetadataFieldRefer(VertexTable.class);
    }

    @Override
    public List<Run> buildQueryVertexsCommentRun(DataRuntime runtime, VertexTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVertexsCommentRun(DataRuntime runtime, VertexTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, VertexTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, int index, boolean create, List<T> previous, VertexTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, VertexTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> vertexs, VertexTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, boolean create, List<T> previous, VertexTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> List<T> vertexs(DataRuntime runtime, boolean create, List<T> vertexs, VertexTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, VertexTable vertex, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, vertex);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, vertex, list, set);
                    }
                    vertex.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = vertex.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)vertex, true);
                        vertex.setColumns(columns);
                        vertex.setTags(this.tags(runtime, random, false, (Table)vertex));
                    }
                    if (null == (pk = vertex.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)vertex);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    vertex.setPrimaryKey(pk);
                    LinkedHashMap indexes = vertex.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        vertex.setIndexes(this.indexes(runtime, random, (Table)vertex, null));
                    }
                    runs = this.buildCreateRun(runtime, (Table)vertex);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        vertex.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[vertex ddl][vertex:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, vertex.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[vertex ddl][{}][vertex:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), vertex.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, VertexTable vertex) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, VertexTable vertex)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, VertexTable vertex, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, VertexTable vertex, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends VertexTable> T init(DataRuntime runtime, int index, T meta, VertexTable query, DataRow row) {
        if (null == meta) {
            meta = new VertexTable();
        }
        MetadataFieldRefer refer = this.refer(runtime, VertexTable.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        return meta;
    }

    @Override
    public <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, VertexTable query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, VertexTable query, DataRow row)"), (int)37));
        }
        return meta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, EdgeTable query, int types, int struct, ConfigStore configs) {
        List<Object> list;
        block36: {
            list = new ArrayList();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                String pattern;
                Schema schema;
                Catalog catalog;
                String caches_key;
                long fr = System.currentTimeMillis();
                if (!greedy) {
                    this.checkSchema(runtime, query);
                }
                if (null == (list = CacheProxy.edges(caches_key = CacheProxy.key(runtime, "edges", greedy, catalog = query.getCatalog(), schema = query.getSchema(), pattern = query.getName(), types, configs))) || list.isEmpty()) {
                    void var16_20;
                    block35: {
                        PageNavi navi;
                        block34: {
                            void var16_18;
                            String cache_key = CacheProxy.key(runtime, "edge_name_map", greedy, catalog, schema, pattern);
                            String string = CacheProxy.name(cache_key);
                            if (null == string && ConfigTable.IS_METADATA_IGNORE_CASE) {
                                this.edgeMap(runtime, random, greedy, query, new DefaultConfigStore(new String[0]));
                                String string2 = CacheProxy.name(cache_key);
                            }
                            if (null != var16_18) {
                                query.setName((String)var16_18);
                            } else {
                                String string3 = query.getName();
                            }
                            navi = null;
                            if (null == configs) {
                                configs = new DefaultConfigStore(new String[0]);
                            }
                            navi = configs.getPageNavi();
                            try {
                                List<Run> runs = this.buildQueryTablesRun(runtime, greedy, (Table)query, types, configs);
                                if (null == runs) break block34;
                                int idx = 0;
                                for (Run run : runs) {
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                        this.mergeFinalQuery(runtime, run);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.edges(runtime, idx++, true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block34;
                                log.warn("{}[edges][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        if (null == list || list.isEmpty()) {
                            try {
                                list = this.edges(runtime, true, list, catalog, schema, (String)var16_20, types);
                                if (!greedy) {
                                    int size = list.size();
                                    for (int i = size - 1; i >= 0; --i) {
                                        Table table = (Table)list.get(i);
                                        if (this.equals(catalog, table.getCatalog()) && this.equals(schema, table.getSchema())) continue;
                                        list.remove(i);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("{}[edges][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        boolean comment = false;
                        for (Table table : list) {
                            if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                            comment = true;
                            break;
                        }
                        if (!comment) {
                            try {
                                List<Run> runs = this.buildQueryTablesCommentRun(runtime, catalog, schema, (String)var16_20, types);
                                if (null == runs) break block35;
                                boolean bl = false;
                                for (Run run : runs) {
                                    void var20_42;
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.comments(runtime, (int)(++var20_42), true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                                log.info("{}[edges][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                    }
                    if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                        log.info("{}[edges][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, var16_20, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                    }
                    if (BasicUtil.isNotEmpty((Object)var16_20)) {
                        String string = var16_20.replace("%", ".*");
                        ArrayList<EdgeTable> tmp = new ArrayList<EdgeTable>();
                        for (EdgeTable edgeTable : list) {
                            String name = edgeTable.getName(greedy) + "";
                            if (!RegularUtil.match((String)name.toUpperCase(), (String)string.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, edgeTable.getCatalog()) || !this.equals(schema, edgeTable.getSchema())) continue;
                            tmp.add(edgeTable);
                        }
                        list = tmp;
                    }
                    CacheProxy.edges(caches_key, list);
                }
                if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                    for (EdgeTable edgeTable : list) {
                        if (null != edgeTable.getColumns() && !edgeTable.getColumns().isEmpty()) continue;
                        Column column_query = new Column();
                        column_query.setCatalog(catalog);
                        column_query.setSchema(schema);
                        this.columns(runtime, random, greedy, list, column_query);
                        break;
                    }
                }
                if (!Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) break block36;
                for (EdgeTable edgeTable : list) {
                    if (null != edgeTable.getIndexes() && !edgeTable.getIndexes().isEmpty()) continue;
                    Index index_qeury = new Index();
                    index_qeury.setCatalog(catalog);
                    index_qeury.setSchema(schema);
                    this.indexes(runtime, random, greedy, list, index_qeury);
                    break;
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                log.error("[edges][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return list;
    }

    protected void edgeMap(DataRuntime runtime, String random, boolean greedy, EdgeTable query, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List edges = null;
        boolean sys = false;
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryEdgesRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, new DefaultConfigStore(new String[0]));
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    edges = this.edges(runtime, idx++, true, edges, catalog, schema, set);
                    for (EdgeTable item : edges) {
                        String cache_key = CacheProxy.key(runtime, "edge", greedy, catalog, schema, item.getName());
                        CacheProxy.name(cache_key, item.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                edges = this.edges(runtime, true, edges, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (EdgeTable item : edges) {
                    String cache_key = CacheProxy.key(runtime, "edge", greedy, catalog, schema, item.getName());
                    CacheProxy.name(cache_key, item.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, EdgeTable query, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, EdgeTable> edges = new LinkedHashMap<String, EdgeTable>();
        List<T> list = this.edges(runtime, random, false, query, types, struct, configs);
        for (EdgeTable edge : list) {
            edges.put(edge.getName().toUpperCase(), edge);
        }
        return edges;
    }

    @Override
    public List<Run> buildQueryEdgesRun(DataRuntime runtime, boolean greedy, EdgeTable query, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryEdgesRun(DataRuntime runtime, EdgeTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initEdgeFieldRefer() {
        return new MetadataFieldRefer(EdgeTable.class);
    }

    @Override
    public List<Run> buildQueryEdgesCommentRun(DataRuntime runtime, EdgeTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryEdgesCommentRun(DataRuntime runtime, EdgeTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, EdgeTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends EdgeTable> List<T> edges(DataRuntime runtime, int index, boolean create, List<T> previous, EdgeTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, EdgeTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, boolean create, LinkedHashMap<String, T> edges, EdgeTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public <T extends EdgeTable> List<T> edges(DataRuntime runtime, boolean create, List<T> previous, EdgeTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> List<T> edges(DataRuntime runtime, boolean create, List<T> edges, EdgeTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public <T extends EdgeTable> T init(DataRuntime runtime, int index, T meta, EdgeTable query, DataRow row) {
        if (null == meta) {
            meta = new EdgeTable();
        }
        MetadataFieldRefer refer = this.refer(runtime, EdgeTable.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        return meta;
    }

    @Override
    public <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, EdgeTable query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, EdgeTable query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, EdgeTable meta, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, meta);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    meta.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = meta.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)meta, true);
                        meta.setColumns(columns);
                        meta.setTags(this.tags(runtime, random, false, (Table)meta));
                    }
                    if (null == (pk = meta.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)meta);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    meta.setPrimaryKey(pk);
                    LinkedHashMap indexes = meta.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        meta.setIndexes(this.indexes(runtime, random, (Table)meta, null));
                    }
                    runs = this.buildCreateRun(runtime, (Table)meta);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[edge ddl][edge:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[edge ddl][{}][edge:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, EdgeTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, EdgeTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, EdgeTable meta, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, EdgeTable meta, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, View query, int types, int struct, ConfigStore configs) {
        List<Object> list;
        block36: {
            list = new ArrayList();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                String pattern;
                Schema schema;
                Catalog catalog;
                String caches_key;
                long fr = System.currentTimeMillis();
                if (!greedy) {
                    this.checkSchema(runtime, query);
                }
                if (null == (list = CacheProxy.views(caches_key = CacheProxy.key(runtime, "views", greedy, catalog = query.getCatalog(), schema = query.getSchema(), pattern = query.getName(), types, configs))) || list.isEmpty()) {
                    void var16_20;
                    block35: {
                        PageNavi navi;
                        block34: {
                            void var16_18;
                            String cache_key = CacheProxy.key(runtime, "view_name_map", greedy, catalog, schema, pattern);
                            String string = CacheProxy.name(cache_key);
                            if (null == string && ConfigTable.IS_METADATA_IGNORE_CASE) {
                                this.viewMap(runtime, random, greedy, query, new DefaultConfigStore(new String[0]));
                                String string2 = CacheProxy.name(cache_key);
                            }
                            if (null != var16_18) {
                                query.setName((String)var16_18);
                            } else {
                                String string3 = query.getName();
                            }
                            navi = null;
                            if (null == configs) {
                                configs = new DefaultConfigStore(new String[0]);
                            }
                            navi = configs.getPageNavi();
                            try {
                                List<Run> runs = this.buildQueryTablesRun(runtime, greedy, (Table)query, types, configs);
                                if (null == runs) break block34;
                                int idx = 0;
                                for (Run run : runs) {
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                        this.mergeFinalQuery(runtime, run);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.views(runtime, idx++, true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block34;
                                log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        if (null == list || list.isEmpty()) {
                            try {
                                list = this.views(runtime, true, list, catalog, schema, (String)var16_20, types);
                                if (!greedy) {
                                    int size = list.size();
                                    for (int i = size - 1; i >= 0; --i) {
                                        Table table = (Table)list.get(i);
                                        if (this.equals(catalog, table.getCatalog()) && this.equals(schema, table.getSchema())) continue;
                                        list.remove(i);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("{}[views][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                        boolean comment = false;
                        for (Table table : list) {
                            if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                            comment = true;
                            break;
                        }
                        if (!comment) {
                            try {
                                List<Run> runs = this.buildQueryTablesCommentRun(runtime, catalog, schema, (String)var16_20, types);
                                if (null == runs) break block35;
                                boolean bl = false;
                                for (Run run : runs) {
                                    void var20_42;
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.comments(runtime, (int)(++var20_42), true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                                log.info("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var16_20, e.toString()});
                            }
                        }
                    }
                    if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                        log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, var16_20, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                    }
                    if (BasicUtil.isNotEmpty((Object)var16_20)) {
                        String string = var16_20.replace("%", ".*");
                        ArrayList<View> tmp = new ArrayList<View>();
                        for (View view : list) {
                            String name = view.getName(greedy) + "";
                            if (!RegularUtil.match((String)name.toUpperCase(), (String)string.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, view.getCatalog()) || !this.equals(schema, view.getSchema())) continue;
                            tmp.add(view);
                        }
                        list = tmp;
                    }
                    CacheProxy.views(caches_key, list);
                }
                if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                    for (View view : list) {
                        if (null != view.getColumns() && !view.getColumns().isEmpty()) continue;
                        Column column_query = new Column();
                        column_query.setCatalog(catalog);
                        column_query.setSchema(schema);
                        this.columns(runtime, random, greedy, list, column_query);
                        break;
                    }
                }
                if (!Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) break block36;
                for (View view : list) {
                    if (null != view.getIndexes() && !view.getIndexes().isEmpty()) continue;
                    Index index_qeury = new Index();
                    index_qeury.setCatalog(catalog);
                    index_qeury.setSchema(schema);
                    this.indexes(runtime, random, greedy, list, index_qeury);
                    break;
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                log.error("[views][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return list;
    }

    protected void viewMap(DataRuntime runtime, String random, boolean greedy, View query, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List views = null;
        boolean sys = false;
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryViewsRun(runtime, greedy, catalog, schema, null, View.TYPE.NORMAL.value, new DefaultConfigStore(new String[0]));
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    views = this.views(runtime, idx++, true, views, catalog, schema, set);
                    for (View view : views) {
                        String cache_key = CacheProxy.key(runtime, "view_name_map", greedy, catalog, schema, view.getName());
                        CacheProxy.name(cache_key, view.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                views = this.views(runtime, true, views, catalog, schema, null, View.TYPE.NORMAL.value);
                for (View view : views) {
                    String cache_key = CacheProxy.key(runtime, "view_name_map", greedy, catalog, schema, view.getName());
                    CacheProxy.name(cache_key, view.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, View> views = new LinkedHashMap<String, View>();
        List<T> list = this.views(runtime, random, false, query, types, struct, configs);
        for (View view : list) {
            String name;
            if (!(view instanceof View) || null == (name = view.getName())) continue;
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, View query, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewsRun(DataRuntime runtime, View query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initViewFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(View.class);
        refer.map("NAME", "VIEW_NAME,TABLE_NAME,NAME,TABNAME");
        refer.map("CATALOG", "VIEW_CATALOG,TABLE_CATALOG");
        refer.map("SCHEMA", "VIEW_SCHEMA,TABLE_SCHEMA,TABSCHEMA,SCHEMA_NAME");
        return refer;
    }

    @Override
    public List<Run> buildQueryViewsCommentRun(DataRuntime runtime, View query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewsCommentRun(DataRuntime runtime, View query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, View query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends View> List<T> views(DataRuntime runtime, int index, boolean create, List<T> previous, View query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, View query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> previous, View query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> views, View query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public <T extends View> T init(DataRuntime runtime, int index, T meta, View query, DataRow row) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == meta) {
            meta = new View();
        }
        MetadataFieldRefer refer = this.refer(runtime, View.class);
        String _catalog = this.getString(row, refer, "CATALOG");
        String _schema = this.getString(row, refer, "SCHEMA");
        if (null == _catalog && null != catalog) {
            _catalog = catalog.getName();
        }
        if (null == _schema && null != schema) {
            _schema = schema.getName();
        }
        String name = this.getString(row, refer, "NAME");
        if (null == meta) {
            meta = new View();
        }
        if (null != _catalog) {
            _catalog = _catalog.trim();
        }
        if (null != _schema) {
            _schema = _schema.trim();
        }
        meta.setMetadata(row);
        meta.setCatalog(_catalog);
        meta.setSchema(_schema);
        meta.setName(name);
        meta.setDefinition(this.getString(row, refer, "DEFINITION"));
        return meta;
    }

    @Override
    public <T extends View> T detail(DataRuntime runtime, int index, T meta, View query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> T detail(DataRuntime runtime, int index, T meta, View query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, view);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, view, list, set);
                    }
                    view.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = view.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)view, true);
                        view.setColumns(columns);
                        view.setTags(this.tags(runtime, random, false, (Table)view));
                    }
                    if (null == (pk = view.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)view);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    view.setPrimaryKey(pk);
                    LinkedHashMap indexes = view.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        view.setIndexes(this.indexes(runtime, random, (Table)view, null));
                    }
                    runs = this.buildCreateRun(runtime, view);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        view.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[view ddl][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, view.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[view ddl][{}][view:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u89c6\u56fe\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), view.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        List<Object> list;
        block39: {
            list = new ArrayList();
            if (null == random) {
                random = this.random(runtime);
            }
            Catalog catalog = query.getCatalog();
            Schema schema = query.getSchema();
            String pattern = query.getName();
            try {
                String caches_key;
                long fr = System.currentTimeMillis();
                MasterTable search = new MasterTable();
                if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                    MasterTable tmp = new MasterTable();
                    if (!greedy) {
                        this.checkSchema(runtime, tmp);
                    }
                    if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                        catalog = tmp.getCatalog();
                    }
                    if (this.supportSchema() && this.empty((Metadata)schema)) {
                        schema = tmp.getSchema();
                    }
                }
                if (null == (list = CacheProxy.masters(caches_key = CacheProxy.key(runtime, "masters", greedy, catalog, schema, pattern, types, configs))) || list.isEmpty()) {
                    void var17_21;
                    block38: {
                        PageNavi navi;
                        block37: {
                            void var17_19;
                            String cache_key = CacheProxy.key(runtime, "master", greedy, catalog, schema, pattern);
                            String string = CacheProxy.name(cache_key);
                            if (null == string && ConfigTable.IS_METADATA_IGNORE_CASE) {
                                this.masterMap(runtime, random, greedy, query, configs);
                                String string2 = CacheProxy.name(cache_key);
                            }
                            if (null != var17_19) {
                                query.setName((String)var17_19);
                            } else {
                                String string3 = query.getName();
                            }
                            search.setName((String)var17_21);
                            search.setCatalog(catalog);
                            search.setSchema(schema);
                            navi = null;
                            if (null == configs) {
                                configs = new DefaultConfigStore(new String[0]);
                            }
                            navi = configs.getPageNavi();
                            try {
                                List<Run> runs = this.buildQueryMasterTablesRun(runtime, greedy, catalog, schema, (String)var17_21, types, configs);
                                if (null == runs) break block37;
                                int idx = 0;
                                for (Run run : runs) {
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                        this.mergeFinalQuery(runtime, run);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.masters(runtime, idx++, true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block37;
                                log.warn("{}[masters][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var17_21, e.toString()});
                            }
                        }
                        if (null == list || list.isEmpty()) {
                            try {
                                list = this.masters(runtime, true, list, catalog, schema, (String)var17_21, types);
                                if (!greedy) {
                                    int size = list.size();
                                    for (int i = size - 1; i >= 0; --i) {
                                        MasterTable masterTable = (MasterTable)list.get(i);
                                        if (this.equals(catalog, masterTable.getCatalog()) && this.equals(schema, masterTable.getSchema())) continue;
                                        list.remove(i);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                log.warn("{}[masters][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, var17_21, e.toString()});
                            }
                        }
                        boolean comment = false;
                        for (MasterTable masterTable : list) {
                            if (!BasicUtil.isNotEmpty((Object)masterTable.getComment())) continue;
                            comment = true;
                            break;
                        }
                        if (!comment) {
                            try {
                                List<Run> runs = this.buildQueryMasterTablesCommentRun(runtime, catalog, schema, (String)var17_21, types);
                                if (null == runs) break block38;
                                boolean bl = false;
                                for (Run run : runs) {
                                    void var21_43;
                                    if (null != navi) {
                                        run.setPageNavi(navi);
                                    }
                                    DataSet set = this.selectMetadata(runtime, random, run);
                                    list = this.comments(runtime, (int)(++var21_43), true, list, catalog, schema, set);
                                    if (null == navi) continue;
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                                    e.printStackTrace();
                                }
                                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block38;
                                log.info("{}[masters][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, var17_21, e.toString()});
                            }
                        }
                    }
                    if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                        log.info("{}[masters][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, var17_21, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                    }
                    if (BasicUtil.isNotEmpty((Object)var17_21)) {
                        String string = var17_21.replace("%", ".*");
                        ArrayList<MasterTable> tmp = new ArrayList<MasterTable>();
                        for (MasterTable masterTable : list) {
                            String name = masterTable.getName(greedy) + "";
                            if (!RegularUtil.match((String)name.toUpperCase(), (String)string.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, masterTable.getCatalog()) || !this.equals(schema, masterTable.getSchema())) continue;
                            tmp.add(masterTable);
                        }
                        list = tmp;
                    }
                    CacheProxy.masters(caches_key, list);
                }
                if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                    for (MasterTable masterTable : list) {
                        if (null != masterTable.getColumns() && !masterTable.getColumns().isEmpty()) continue;
                        Column column_query = new Column();
                        column_query.setCatalog(catalog);
                        column_query.setSchema(schema);
                        this.columns(runtime, random, greedy, list, column_query);
                        break;
                    }
                }
                if (!Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) break block39;
                for (MasterTable masterTable : list) {
                    if (null != masterTable.getIndexes() && !masterTable.getIndexes().isEmpty()) continue;
                    Index index_qeury = new Index();
                    index_qeury.setCatalog(catalog);
                    index_qeury.setSchema(schema);
                    this.indexes(runtime, random, greedy, list, index_qeury);
                    break;
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                log.error("[masters][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return list;
    }

    protected void masterMap(DataRuntime runtime, String random, boolean greedy, MasterTable query, ConfigStore configs) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List masters = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryMasterTablesRun(runtime, greedy, catalog, schema, null, MasterTable.TYPE.NORMAL.value, new DefaultConfigStore(new String[0]));
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    masters = this.masters(runtime, idx++, true, masters, catalog, schema, set);
                    for (MasterTable master : masters) {
                        String cache_key = CacheProxy.key(runtime, "master", greedy, catalog, schema, master.getName());
                        CacheProxy.name(cache_key, master.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                masters = this.masters(runtime, true, masters, catalog, schema, null, MasterTable.TYPE.NORMAL.value);
                for (MasterTable master : masters) {
                    String cache_key = CacheProxy.key(runtime, "master", greedy, catalog, schema, master.getName());
                    CacheProxy.name(cache_key, master.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, MasterTable query, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, MasterTable> masters = new LinkedHashMap<String, MasterTable>();
        List<T> list = this.masters(runtime, random, false, query, types, struct, configs);
        for (MasterTable master : list) {
            masters.put(master.getName().toUpperCase(), master);
        }
        return masters;
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, MasterTable query, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTablesRun(DataRuntime runtime, MasterTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initMasterTableFieldRefer() {
        return new MetadataFieldRefer(MasterTable.class);
    }

    @Override
    public List<Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, MasterTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, MasterTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, MasterTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, int index, boolean create, List<T> previous, MasterTable query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T master = null;
            if (null == this.search(previous, (master = this.init(runtime, index, master, catalog, schema, row)).getCatalog(), master.getSchema(), master.getName())) {
                previous.add(master);
            }
            this.detail(runtime, index, master, catalog, schema, row);
        }
        return previous;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, MasterTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> masters, MasterTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, boolean create, List<T> previous, MasterTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> List<T> masters(DataRuntime runtime, boolean create, List<T> masters, MasterTable query, int types)"), (int)37));
        }
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public <T extends MasterTable> T init(DataRuntime runtime, int index, T meta, MasterTable query, DataRow row) {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == meta) {
            meta = new MasterTable();
        }
        MetadataFieldRefer refer = this.refer(runtime, MasterTable.class);
        String _catalog = this.getString(row, refer, "CATALOG");
        String _schema = this.getString(row, refer, "SCHEMA");
        if (null == _catalog && null != catalog) {
            _catalog = catalog.getName();
        }
        if (null == _schema && null != schema) {
            _schema = schema.getName();
        }
        String name = this.getString(row, refer, "NAME");
        if (null == meta) {
            meta = new MasterTable();
        }
        if (null != _catalog) {
            _catalog = _catalog.trim();
        }
        if (null != _schema) {
            _schema = _schema.trim();
        }
        meta.setMetadata(row);
        meta.setCatalog(_catalog);
        meta.setSchema(_schema);
        meta.setName(name);
        return meta;
    }

    @Override
    public <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta, MasterTable query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta,  MasterTable query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, meta);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    meta.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = meta.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)meta, true);
                        meta.setColumns(columns);
                        meta.setTags(this.tags(runtime, random, false, (Table)meta));
                    }
                    if (null == (pk = meta.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)meta);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    meta.setPrimaryKey(pk);
                    LinkedHashMap indexes = meta.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        meta.setIndexes(this.indexes(runtime, random, (Table)meta, null));
                    }
                    runs = this.buildCreateRun(runtime, meta);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[master ddl][master:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[master ddl][{}][master:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, MasterTable master) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, MasterTable master)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable master, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, MasterTable master, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public Table.Partition partition(DataRuntime runtime, String random, Table table) {
        if (null == random) {
            random = this.random(runtime);
        }
        Table.Partition partition = null;
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryTablePartitionRun(runtime, table);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            partition = this.partition(runtime, idx++, true, partition, table, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        log.error("[partition][result:fail]", (Throwable)e);
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[partition][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), table.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[partition][table:{}][result:true][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table.getName(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                log.error("[partition][result:fail]", (Throwable)e);
            }
            log.error("[partition][result:fail][msg:{}]", (Object)e.toString());
        }
        return partition;
    }

    @Override
    public List<Run> buildQueryTablePartitionRun(DataRuntime runtime, Table table) {
        return new ArrayList<Run>();
    }

    @Override
    public Table.Partition partition(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataSet set) throws Exception {
        for (DataRow row : set) {
            if (null == meta) {
                meta = this.init(runtime, index, create, meta, table, row);
            }
            if (null == meta) continue;
            meta = this.detail(runtime, index, create, meta, table, row);
        }
        return meta;
    }

    @Override
    public Table.Partition init(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        MetadataFieldRefer refer = this.refer(runtime, Table.Partition.class);
        try {
            String type = this.getString(row, refer, "NAME");
            if (BasicUtil.isNotEmpty((Object)type)) {
                meta.setType(Table.Partition.TYPE.valueOf((String)type));
                meta.setMetadata(row);
                String columns = this.getString(row, refer, "COLUMN");
                if (null != columns) {
                    String[] cols;
                    for (String col : cols = columns.split(",")) {
                        col = col.replace(this.getDelimiterFr(), "");
                        col = col.replace(this.getDelimiterTo(), "");
                        meta.addColumn(col);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return meta;
    }

    @Override
    public Table.Partition detail(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        MetadataFieldRefer refer = this.refer(runtime, Table.Partition.Slice.class);
        Table.Partition.Slice slice = new Table.Partition.Slice();
        slice.setName(this.getString(row, refer, "NAME"));
        meta.addSlice(slice);
        return meta;
    }

    @Override
    public MetadataFieldRefer initTablePartitionFieldRefer() {
        return new MetadataFieldRefer(Table.Partition.class);
    }

    @Override
    public MetadataFieldRefer initTablePartitionSliceFieldRefer() {
        return new MetadataFieldRefer(Table.Partition.Slice.class);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        if (!greedy) {
            this.checkSchema(runtime, query);
        }
        MasterTable master = (MasterTable)query.getMaster();
        LinkedHashMap tags = query.getTags();
        String pattern = query.getName();
        LinkedHashMap tables = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryPartitionTablesRun(runtime, greedy, query);
                    if (null != runs) {
                        int idx = 0;
                        int total = runs.size();
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            tables = this.partitions(runtime, total, idx++, true, master, tables, master.getCatalog(), master.getSchema(), set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, master.getName(), tables.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[partitions][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy,  PartitionTable query, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initPartitionTableFieldRefer() {
        return new MetadataFieldRefer(PartitionTable.class);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, LinkedHashMap<String, T> previous, PartitionTable query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query)"), (int)37));
        }
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[partition table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[partition table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b50\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends PartitionTable> T init(DataRuntime runtime, int index, T meta, PartitionTable query, DataRow row) {
        if (null == meta) {
            meta = new PartitionTable();
        }
        MetadataFieldRefer refer = this.refer(runtime, PartitionTable.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        meta.setCatalog(this.getString(row, refer, "CATALOG"));
        meta.setSchema(this.getString(row, refer, "SCHEMA"));
        meta.setType(this.getString(row, refer, "TYPE"));
        meta.setComment(this.getString(row, refer, "COMMENT"));
        meta.setMaster(this.getString(row, refer, "MASTER"));
        return meta;
    }

    @Override
    public <T extends PartitionTable> T detail(DataRuntime runtime, int index, T meta, PartitionTable query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PartitionTable> T detail(DataRuntime runtime, int index, T meta, PartitionTable query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, Column query, boolean primary, ConfigStore configs) {
        if (null != table) {
            query.setTable(table);
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (!greedy) {
            this.checkSchema(runtime, query);
        }
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        String key = CacheProxy.key(runtime, "table_columns", greedy, table);
        LinkedHashMap<String, Object> columns = CacheProxy.columns(key);
        if (null != columns && !columns.isEmpty()) {
            return columns;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            int n;
            List<Run> runs;
            int qty_jdbc;
            int qty_dialect;
            int qty_total;
            block35: {
                qty_total = 0;
                qty_dialect = 0;
                boolean bl = false;
                qty_jdbc = 0;
                try {
                    runs = this.buildQueryColumnsRun(runtime, false, query, configs);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            columns = this.columns(runtime, idx, true, columns, table, query, set);
                            ++idx;
                        }
                    }
                    if (null != columns) {
                        qty_dialect = columns.size();
                        qty_total = columns.size();
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (primary) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            if (null == columns || columns.isEmpty()) {
                block36: {
                    try {
                        runs = this.buildQueryColumnsRun(runtime, true, query, configs);
                        if (null != runs) {
                            for (Run run : runs) {
                                String sql = run.getFinalQuery();
                                if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                columns = this.actuator.columns(this, runtime, true, columns, table, sql);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            log.error("columns exception:", (Throwable)e);
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                if (null != columns) {
                    n = columns.size() - qty_dialect;
                    qty_total = columns.size();
                }
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, n, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if ((null == columns || columns.isEmpty()) && null != (columns = this.actuator.metadata((DriverAdapter)this, runtime, true, columns, query))) {
                qty_total = columns.size();
                qty_jdbc = columns.size() - n - qty_dialect;
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, n, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (ConfigTable.IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY && (null != columns || !columns.isEmpty())) {
                LinkedHashMap linkedHashMap;
                PrimaryKey pk;
                boolean exists = false;
                for (Column column : columns.values()) {
                    if (column.isPrimaryKey() == -1) continue;
                    exists = true;
                    break;
                }
                if (!exists && null != (pk = this.primary(runtime, random, false, table)) && null != (linkedHashMap = pk.getColumns())) {
                    for (String k : linkedHashMap.keySet()) {
                        Column column = (Column)columns.get(k);
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                log.error("columns exception:", (Throwable)e);
            }
            log.error("{}[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != columns) {
            CacheProxy.cache(key, columns);
        } else {
            columns = new LinkedHashMap();
        }
        int index = 0;
        for (Column column : columns.values()) {
            if (null == column.getPosition() || -1 == column.getPosition()) {
                column.setPosition(Integer.valueOf(index++));
            }
            if (column.isAutoIncrement() != 1) {
                column.autoIncrement(Boolean.valueOf(false));
            }
            if (column.isPrimaryKey() != 1) {
                column.setPrimary(Boolean.valueOf(false));
            }
            if (null != column.getTable() || greedy) continue;
            column.setTable(table);
        }
        return columns;
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Column query, ConfigStore configs) {
        if (!greedy) {
            this.checkSchema(runtime, query);
        }
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        List columns = new ArrayList();
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        Table tab = null;
        if (null != tables && !tables.isEmpty()) {
            tab = tables.iterator().next();
        }
        if (null != tab) {
            tab.setCatalog(catalog);
            tab.setSchema(schema);
            if (BasicUtil.isEmpty((Object)catalog) && BasicUtil.isEmpty((Object)schema) && !greedy) {
                this.checkSchema(runtime, tab);
            }
        }
        try {
            List<Run> runs = this.buildQueryColumnsRun(runtime, false, tables, query, configs);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    columns = this.columns(runtime, idx, true, columns, query, set);
                    ++idx;
                }
            }
            for (Table table : tables) {
                Long tObjectId = table.getObjectId();
                LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
                table.setColumns(cols);
                for (Column column : columns) {
                    if (!table.equals(column.getTable())) continue;
                    Catalog cCatalog = column.getCatalog();
                    Schema cSchema = column.getSchema();
                    Long cObjectId = column.getObjectId();
                    if (null != tObjectId && null != cObjectId && tObjectId == cObjectId) {
                        cols.put(column.getName().toUpperCase(), column);
                        continue;
                    }
                    if (!this.equals(cCatalog, column.getCatalog()) || !this.equals(cSchema, column.getSchema()) || !BasicUtil.equals((Object)table.getName(), (Object)column.getTableName(), (boolean)true)) continue;
                    cols.put(column.getName().toUpperCase(), column);
                }
                table.setColumns(cols);
                columns.removeAll(cols.values());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Column query, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Collection<? extends Table> tables, Column query, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnsRun(DataRuntime runtime, Catalog catalog, Schema schema, Collection<? extends Table> tables, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initColumnFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Column.class);
        refer.map("NAME", "COLUMN_NAME,COLNAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA,TABSCHEMA,SCHEMA_NAME,OWNER");
        refer.map("TABLE", "TABLE_NAME,TABNAME");
        refer.map("NULLABLE", "IS_NULLABLE,NULLABLE,NULLS");
        refer.map("CHARSET", "CHARACTER_SET_NAME");
        refer.map("COLLATE", "COLLATION_NAME");
        refer.map("TYPE", "FULL_TYPE,DATA_TYPE,TYPE_NAME,TYPENAME,DATA_TYPE_NAME,UDT_NAME,DATA_TYPE,TYPENAME,DATA_TYPE_NAME");
        refer.map("POSITION", "ORDINAL_POSITION,COLNO,POSITION");
        refer.map("COMMENT", "COLUMN_COMMENT,COMMENTS,REMARKS");
        refer.map("DEFAULT_VALUE", "COLUMN_DEFAULT,DATA_DEFAULT,DEFAULT,DEFAULT_VALUE,DEFAULT_DEFINITION");
        return refer;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table table, Column query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object column = null;
            query.setTable(table);
            if (null == (column = this.init(runtime, index, (T)column, query, row))) continue;
            column = this.detail(runtime, index, (T)column, query, row);
            previous.put(column.getName().toUpperCase(), column);
        }
        return previous;
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Column query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T column = null;
            if (null == Metadata.match(column = this.init(runtime, index, column, query, row), previous)) {
                previous.add(column);
            }
            this.detail(runtime, index, column, query, row);
        }
        return previous;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Column query) throws Exception {
        return previous;
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Collection<? extends Table> tables, Column query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        HashMap<String, Table> tbls = new HashMap<String, Table>();
        for (Table table : tables) {
            tbls.put(table.getName().toUpperCase(), table);
        }
        for (DataRow dataRow : set) {
            Table table;
            Column meta = null;
            if (null == Metadata.match(meta = this.init(runtime, index, meta, query, dataRow), previous)) {
                previous.add(meta);
            }
            this.detail(runtime, index, meta, query, dataRow);
            String tableName = meta.getTableName();
            if (null == tableName || null == (table = (Table)tbls.get(tableName.toUpperCase()))) continue;
            table.addColumn(meta);
        }
        return previous;
    }

    @Override
    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public String columnFieldLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getLengthRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getLengthRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getLengthRefer();
        }
        if (null == result && null != config) {
            result = config.getLengthRefer();
        }
        return result;
    }

    @Override
    public String columnFieldPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != config) {
            result = config.getPrecisionRefer();
        }
        return result;
    }

    @Override
    public String columnFieldScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getScaleRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getScaleRefer();
        }
        if (null == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getScaleRefer();
        }
        if (null == result && null != config) {
            result = config.getScaleRefer();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnoreLength(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignoreLength();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignoreLength();
        }
        if (-1 == result) {
            result = meta.ignoreLength();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignoreLength();
        }
        if (-1 == result && null != config) {
            result = config.ignoreLength();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnorePrecision(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignorePrecision();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignorePrecision();
        }
        if (-1 == result) {
            result = meta.ignorePrecision();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignorePrecision();
        }
        if (-1 == result && null != config) {
            result = config.ignorePrecision();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnoreScale(DataRuntime runtime, TypeMetadata meta) {
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Refer config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignoreScale();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignoreScale();
        }
        if (-1 == result) {
            result = meta.ignoreScale();
        }
        if (-1 == result && null != (config = MetadataReferHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignoreScale();
        }
        if (-1 == result && null != config) {
            result = config.ignoreScale();
        }
        return result;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initTagFieldRefer() {
        return new MetadataFieldRefer(Tag.class);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Tag query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Tag meta = null;
            if (null == (meta = (Tag)this.init(runtime, index, meta, (Column)query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, meta, (Column)query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Tag query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) {
        if (null == meta) {
            meta = new Tag();
        }
        MetadataFieldRefer refer = this.refer(runtime, Tag.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        return meta;
    }

    @Override
    public <T extends Tag> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, PrimaryKey query) {
        Object primary;
        block7: {
            primary = null;
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                List<Run> runs;
                if (!greedy) {
                    this.checkSchema(runtime, query);
                }
                if (null != (runs = this.buildQueryPrimaryRun(runtime, greedy, query))) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        primary = this.init(runtime, idx, primary, query, set);
                        primary = this.detail(runtime, idx, primary, query, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.warn("{}[primary][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), query.getTable(), e.toString()});
            }
        }
        return primary;
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, PrimaryKey query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy,  Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initPrimaryKeyFieldRefer() {
        return new MetadataFieldRefer(PrimaryKey.class);
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T meta, PrimaryKey query, DataSet set) throws Exception {
        Table table = query.getTable();
        MetadataFieldRefer refer = this.refer(runtime, PrimaryKey.class);
        for (DataRow row : set) {
            String col;
            if (null == meta) {
                meta = new PrimaryKey();
                meta.setName(this.getString(row, refer, "NAME"));
                if (null == table) {
                    table = new Table(this.getString(row, refer, "CATALOG"), this.getString(row, refer, "SCHEMA"), this.getString(row, refer, "TABLE"));
                }
                meta.setTable(table);
                meta.setMetadata(row);
            }
            if (BasicUtil.isEmpty((Object)(col = this.getString(row, refer, "COLUMN")))) {
                throw new Exception("\u4e3b\u952e\u76f8\u5173\u5217\u540d\u5f02\u5e38,\u8bf7\u68c0\u67e5buildQueryPrimaryRun\u4e0eprimaryMetadataColumn");
            }
            Column column = meta.getColumn(col);
            if (null == column) {
                column = new Column(col);
            }
            column.setTable(table);
            String position = this.getString(row, refer, "POSITION");
            meta.setPosition(column, BasicUtil.parseInt((Object)position, (Integer)0));
            String order = this.getString(row, refer, "ORDER");
            if (BasicUtil.isNotEmpty((Object)order)) {
                column.setOrder(order);
            }
            meta.addColumn(column);
        }
        return meta;
    }

    @Override
    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, PrimaryKey query, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, PrimaryKey query, DataSet set)"), (int)37));
        }
        return meta;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, PrimaryKey query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 PrimaryKey primary(DataRuntime runtime, PrimaryKey query)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, ForeignKey query) {
        LinkedHashMap foreigns;
        block6: {
            Table table = query.getTable();
            foreigns = new LinkedHashMap();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                List<Run> runs;
                if (!greedy) {
                    this.checkSchema(runtime, query);
                }
                if (null != (runs = this.buildQueryForeignsRun(runtime, greedy, query))) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        foreigns = this.foreigns(runtime, idx, table, foreigns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, ForeignKey query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy,  ForeignKey query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initForeignKeyFieldRefer() {
        return new MetadataFieldRefer(ForeignKey.class);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, LinkedHashMap<String, T> previous, ForeignKey query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        if (null == meta) {
            meta = new ForeignKey();
        }
        MetadataFieldRefer refer = this.refer(runtime, ForeignKey.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        String name = this.getString(row, refer, "NAME");
        meta.setName(name);
        meta.setTable(this.getString(row, refer, "TABLE"));
        meta.setReference(this.getString(row, refer, "REFERENCE_TABLE"));
        Table refTable = new Table(this.getString(row, refer, "REFERENCE_CATALOG"), this.getString(row, refer, "REFERENCE_SCHEMA"), this.getString(row, refer, "REFERENCE_TABLE"));
        Column reference = new Column(this.getString(row, refer, "REFERENCE_COLUMN"));
        reference.setTable(refTable);
        meta.addColumn(new Column(this.getString(row, refer, "COLUMN")).setReference(reference).setPosition(this.getInt(row, refer, "POSITION", 0)));
        return meta;
    }

    @Override
    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Index query) {
        List list = null;
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            List<Run> runs = this.buildQueryIndexesRun(runtime, greedy, tables);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    list = this.indexes(runtime, idx, true, tables, list, new Index(), set);
                    ++idx;
                }
            }
            if (null != list) {
                for (Table table : tables) {
                    Long tObjectId = table.getObjectId();
                    LinkedHashMap<String, Index> idxs = new LinkedHashMap<String, Index>();
                    table.setIndexes(idxs);
                    for (Index index : list) {
                        if (!table.equals(index.getTable())) continue;
                        Catalog cCatalog = index.getCatalog();
                        Schema cSchema = index.getSchema();
                        Long cObjectId = index.getObjectId();
                        if (null != tObjectId && null != cObjectId && tObjectId == cObjectId) {
                            idxs.put(index.getName().toUpperCase(), index);
                            continue;
                        }
                        if (!this.equals(cCatalog, index.getCatalog()) || !this.equals(cSchema, index.getSchema()) || !BasicUtil.equals((Object)table.getName(), (Object)index.getTableName(), (boolean)true)) continue;
                        idxs.put(index.getName().toUpperCase(), index);
                    }
                    list.removeAll(idxs.values());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == list) {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Index query) {
        List list;
        block12: {
            List<Run> runs;
            Table table = query.getTable();
            list = null;
            if (null == table) {
                table = new Table();
            }
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, query);
            }
            if (null != (runs = this.buildQueryIndexesRun(runtime, greedy, query))) {
                int idx = 0;
                for (Run run : runs) {
                    block11: {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        try {
                            list = this.indexes(runtime, idx, true, table, list, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block11;
                            e.printStackTrace();
                        }
                    }
                    ++idx;
                }
            }
            if ((null == list || list.isEmpty()) && null != table.getName()) {
                try {
                    LinkedHashMap maps = this.indexes(runtime, true, new LinkedHashMap(), table, false, false);
                    table.setIndexes(maps);
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block12;
                    e.printStackTrace();
                }
            }
        }
        if (null == list) {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Index query) {
        Table table = query.getTable();
        String pattern = query.getName();
        LinkedHashMap<String, Object> map = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        this.checkSchema(runtime, query);
        List<Run> runs = this.buildQueryIndexesRun(runtime, false, query);
        if (null != runs) {
            int idx = 0;
            for (Run run : runs) {
                block19: {
                    DataSet set = this.selectMetadata(runtime, random, run);
                    try {
                        map = this.indexes(runtime, idx, true, table, map, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block19;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        if ((null == map || map.isEmpty()) && null != table.getName()) {
            try {
                map = this.indexes(runtime, true, map, table, false, false);
                table.setIndexes(map);
            }
            catch (Exception e) {
                log.info("{}[{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"JDBC\u65b9\u5f0f\u83b7\u53d6\u7d22\u5f15\u5931\u8d25", (int)33), table, e.toString()});
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                map = new LinkedHashMap();
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                Index index = (Index)map.get(pattern.toUpperCase());
                map = new LinkedHashMap();
                map.put(pattern.toUpperCase(), index);
            }
        }
        PrimaryKey pk = null;
        if (null != map) {
            for (Index index : map.values()) {
                if (!index.isPrimary()) continue;
                pk = index;
                break;
            }
        }
        if (null == pk) {
            pk = table.getPrimaryKey();
            if (null == pk) {
                pk = this.primary(runtime, random, false, table);
            }
            if (null != pk && !pk.isEmpty()) {
                Index index = (Index)map.get(pk.getName().toUpperCase());
                if (null != index) {
                    index.setPrimary(true);
                } else {
                    map.put(pk.getName().toUpperCase(), pk);
                }
            }
        }
        if (null == map) {
            map = new LinkedHashMap();
        }
        return map;
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Index query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy,  Index query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Collection<? extends Table> tables) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy,  Collection<? extends Table> tables)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initIndexFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Index.class);
        refer.map("NAME", "INDEX_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("ORDER", "COLLATION");
        refer.map("POSITION", "SEQ_IN_INDEX");
        return refer;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Index query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        for (DataRow row : set) {
            String name = this.getString(row, refer, "NAME");
            if (null == name) continue;
            Index meta = (Index)previous.get(name.toUpperCase());
            if (null == meta) {
                meta = this.init(runtime, index, meta, query, row);
            }
            if (null == meta || meta.isEmpty() || null != table && !table.getName().equalsIgnoreCase(meta.getTableName()) || null == (meta = this.detail(runtime, index, meta, query, row)) || meta.isEmpty()) continue;
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, List<T> previous, Index query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        for (DataRow row : set) {
            String name = this.getString(row, refer, "NAME");
            if (null == name) continue;
            Index meta = (Index)this.search(previous, name);
            if (null == meta) {
                meta = this.init(runtime, index, meta, table, row);
            }
            if (null == meta || meta.isEmpty() || null != table && !table.getName().equalsIgnoreCase(meta.getTableName()) || null == (meta = this.detail(runtime, index, meta, table, row)) || meta.isEmpty()) continue;
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, Collection<? extends Table> tables, List<T> previous, Index query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        HashMap<String, Table> tbls = new HashMap<String, Table>();
        for (Table table : tables) {
            tbls.put(table.getName().toUpperCase(), table);
        }
        for (DataRow dataRow : set) {
            Table table;
            String name = this.getString(dataRow, refer, "NAME");
            if (null == name) continue;
            Index meta = (Index)this.search(previous, name);
            if (null == meta) {
                meta = this.init(runtime, index, meta, query, dataRow);
            }
            if (null == meta || meta.isEmpty()) continue;
            if (null == Metadata.match((Metadata)meta, previous)) {
                previous.add(meta);
            }
            this.detail(runtime, index, meta, query, dataRow);
            String tableName = meta.getTableName();
            if (null == tableName || null == (table = (Table)tbls.get(tableName.toUpperCase()))) continue;
            table.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> indexes, Index query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, List<T> indexes, Index query)"), (int)37));
        }
        if (null == indexes) {
            indexes = new ArrayList<T>();
        }
        return indexes;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Index query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Index query)"), (int)37));
        }
        if (null == indexes) {
            indexes = new LinkedHashMap();
        }
        return indexes;
    }

    @Override
    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        Table table = query.getTable();
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        String name = this.getString(row, refer, "NAME");
        if (null == meta) {
            meta = new Index();
            meta.setName(name);
            Catalog catalog = null;
            Schema schema = null;
            String catalogName = this.getString(row, refer, "CATALOG");
            if (BasicUtil.isNotEmpty((Object)catalogName)) {
                catalog = new Catalog(catalogName);
            } else if (null != table) {
                catalog = table.getCatalog();
            }
            String schemaName = this.getString(row, refer, "SCHEMA");
            if (BasicUtil.isNotEmpty((Object)schemaName)) {
                schema = new Schema(schemaName);
            } else if (null != table) {
                schema = table.getSchema();
            }
            if (null == table) {
                String tableName = this.getString(row, refer, "TABLE");
                table = new Table(catalog, schema, tableName);
            }
            meta.setCatalog(catalog);
            meta.setSchema(schema);
            meta.setTable(table);
            meta.setMetadata(row);
            String[] chks = refer.maps("PRIMARY_CHECK");
            String[] vals = refer.maps("PRIMARY_CHECK_VALUE");
            Boolean bol = this.matchBoolean(row, chks, vals);
            if (null != bol) {
                meta.setPrimary(bol.booleanValue());
            }
            if (null != (bol = this.matchBoolean(row, chks = refer.maps("UNIQUE_CHECK"), vals = refer.maps("UNIQUE_CHECK_VALUE")))) {
                meta.setUnique(bol.booleanValue());
            }
        }
        return meta;
    }

    @Override
    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        MetadataFieldRefer refer = this.refer(runtime, Index.class);
        String columnName = row.getStringWithoutEmpty(refer.maps("COLUMN"));
        if (null == columnName) {
            return meta;
        }
        Column column = meta.getColumn((columnName = columnName.replace("\"", "")).toUpperCase());
        if (null == column) {
            column = new Column();
        }
        column.setName(columnName);
        meta.addColumn(column);
        Integer position = this.getInt(row, refer, "POSITION");
        if (null == position) {
            position = 0;
        }
        column.setPosition(position);
        meta.setPosition(column, position);
        String order = this.getString(row, refer, "ORDER");
        if (null != order) {
            order = order.toUpperCase();
            Order.TYPE type = Order.TYPE.ASC;
            if (order.contains("DESC")) {
                type = Order.TYPE.DESC;
            }
            meta.setOrder(column, type);
        }
        return meta;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Constraint query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryConstraintsRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.constraints(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[constraints][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[constraints][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[constraints][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Constraint query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap map = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryConstraintsRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            map = this.constraints(runtime, idx++, true, map, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[constraints][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[constraints][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, map.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[constraints][result:fail][msg:{}]", (Object)e.toString());
        }
        return map;
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initConstraintFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Constraint.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("SCHEMA", "CONSTRAINT_CATALOG");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("TYPE", "CONSTRAINT_TYPE");
        return refer;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, List<T> previous, Constraint query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        MetadataFieldRefer refer = this.refer(runtime, Constraint.class);
        Table table = query.getTable();
        for (DataRow row : set) {
            String name = this.getString(row, refer, "NAME");
            if (null == name) continue;
            Constraint meta = (Constraint)this.search(previous, name);
            if (null == meta) {
                meta = this.init(runtime, index, meta, query, row);
            }
            if (null == meta || meta.isEmpty() || null != table && !table.getName().equalsIgnoreCase(meta.getTableName())) continue;
            if (null == Metadata.match((Metadata)meta, previous)) {
                previous.add(meta);
            }
            this.detail(runtime, index, meta, query, row);
        }
        return previous;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Constraint query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        MetadataFieldRefer refer = this.refer(runtime, Constraint.class);
        for (DataRow row : set) {
            String name = this.getString(row, refer, "NAME");
            if (null == name) continue;
            Constraint meta = (Constraint)previous.get(name.toUpperCase());
            if (null == meta) {
                meta = this.init(runtime, index, meta, query, row);
            }
            if (null == meta || meta.isEmpty() || null != table && !table.getName().equalsIgnoreCase(meta.getTableName()) || null == (meta = this.detail(runtime, index, meta, query, row)) || meta.isEmpty()) continue;
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Constraint> T init(DataRuntime runtime, int index, T meta, Constraint query, DataRow row) {
        MetadataFieldRefer refer;
        String name;
        if (null == meta) {
            meta = new Constraint();
        }
        if (null == (name = this.getString(row, refer = this.refer(runtime, Constraint.class), "NAME"))) {
            return meta;
        }
        String catalog = this.getString(row, refer, "CATALOG");
        String schema = this.getString(row, refer, "SCHEMA");
        meta.setCatalog(catalog);
        meta.setSchema(schema);
        Table table = query.getTable();
        if (null == table) {
            table = new Table(catalog, schema, this.getString(row, refer, "TABLE"));
        }
        meta.setTable(table);
        meta.setName(name);
        meta.setType(this.getString(row, refer, "TYPE"));
        return meta;
    }

    @Override
    public <T extends Constraint> T detail(DataRuntime runtime, int index, T meta, Constraint query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> T detail(DataRuntime runtime, int index, T meta, Constraint query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Trigger query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap map = new LinkedHashMap();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryTriggersRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            map = this.triggers(runtime, idx++, true, map, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[triggers][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[triggers][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, map.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[triggers][result:fail][msg:{}]", (Object)e.toString());
        }
        return map;
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initTriggerFieldRefer() {
        return new MetadataFieldRefer(Trigger.class);
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Trigger query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (null == meta) {
            meta = new Trigger();
        }
        MetadataFieldRefer refer = this.refer(runtime, Trigger.class);
        meta.setName(this.getString(row, refer, "NAME"));
        Table table = null;
        String tableName = this.getString(row, refer, "TABLE");
        table = BasicUtil.isNotEmpty((Object)tableName) ? new Table(this.getString(row, refer, "CATALOG"), this.getString(row, refer, "SCHEMA"), tableName) : query.getTable();
        meta.setTable(table);
        meta.setMetadata(row);
        meta.setDefinition(this.getString(row, refer, "DEFINITION"));
        return meta;
    }

    @Override
    public <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Procedure query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryProceduresRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.procedures(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[procedures][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[procedures][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[procedures][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Procedure query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap map = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryProceduresRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            map = this.procedures(runtime, idx++, true, map, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[procedures][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[procedures][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, map.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[procedures][result:fail][msg:{}]", (Object)e.toString());
        }
        return map;
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initProcedureFieldRefer() {
        return new MetadataFieldRefer(Procedure.class);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> previous, Procedure query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Procedure query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> previous, Procedure query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set)"), (int)37));
        }
        return previous;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Procedure query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set)"), (int)37));
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, procedure);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, procedure, list, set);
                    }
                    if (null != list && !list.isEmpty()) {
                        procedure.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[procedure ddl][procedure:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, procedure.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[procedure ddl][{}][procedure:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b58\u50a8\u8fc7\u7a0b\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), procedure.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return new ArrayList<String>();
    }

    @Override
    public <T extends Procedure> T init(DataRuntime runtime, int index, T meta, Procedure query, DataRow row) {
        if (null == meta) {
            meta = new Procedure();
        }
        MetadataFieldRefer refer = this.refer(runtime, Procedure.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        meta.setCatalog(this.getString(row, refer, "CATALOG"));
        meta.setSchema(this.getString(row, refer, "SCHEMA"));
        meta.setDefinition(this.getString(row, refer, "DEFINITION"));
        return meta;
    }

    @Override
    public <T extends Procedure> T detail(DataRuntime runtime, int index, T meta, Procedure query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 detail(DataRuntime runtime, int index, T meta, Procedure query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Function query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryFunctionsRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.functions(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[functions][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[functions][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[functions][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Function query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap map = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryFunctionsRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            map = this.functions(runtime, idx++, true, map, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[functions][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[functions][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, map.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[functions][result:fail][msg:{}]", (Object)e.toString());
        }
        return map;
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initFunctionFieldRefer() {
        return new MetadataFieldRefer(Function.class);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Function query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Function query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> previous, Function query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, Catalog catalog, Schema previous)"), (int)37));
        }
        return previous;
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Function query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> functions)"), (int)37));
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, meta);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    if (null != list && !list.isEmpty()) {
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[function ddl][function:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[function ddl][{}][function:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u51fd\u6570\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends Function> T init(DataRuntime runtime, int index, T meta, Function query, DataRow row) {
        MetadataFieldRefer refer = this.refer(runtime, Function.class);
        if (null == meta) {
            meta = new Function();
        }
        if (null != refer) {
            meta.setName(this.getString(row, refer, "NAME"));
            meta.setCatalog(this.getString(row, refer, "CATALOG"));
            meta.setSchema(this.getString(row, refer, "SCHEMA"));
            meta.setComment(this.getString(row, refer, "COMMENT"));
            meta.setDefinition(this.getString(row, refer, "DEFINITION"));
        }
        return meta;
    }

    @Override
    public <T extends Function> T detail(DataRuntime runtime, int index, T meta, Function query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> T detail(DataRuntime runtime, int index, T meta, Function query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Sequence query) {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQuerySequencesRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.sequences(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[sequences][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[sequences][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[sequences][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Sequence query) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap maps = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySequencesRun(runtime, false, query);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            maps = this.sequences(runtime, idx++, true, maps, new Sequence(), set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[sequences][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[sequences][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, maps.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[sequences][result:fail][msg:{}]", (Object)e.toString());
        }
        return maps;
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initSequenceFieldRefer() {
        return new MetadataFieldRefer(Sequence.class);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Sequence query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.put(meta.getName().toUpperCase(), meta);
        }
        return previous;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> previous, Sequence query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query)"), (int)37));
        }
        return previous;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Sequence query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Sequence query)"), (int)37));
        }
        return previous;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlRun(runtime, meta);
                if (null != runs && !runs.isEmpty()) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.selectMetadata(runtime, random, run);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    if (null != list && !list.isEmpty()) {
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[sequence ddl][sequence:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[sequence ddl][{}][sequence:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5e8f\u5217\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends Sequence> T init(DataRuntime runtime, int index, T meta, Sequence query, DataRow row) {
        if (null == meta) {
            meta = new Sequence();
        }
        MetadataFieldRefer refer = this.refer(runtime, Database.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        meta.setCatalog(this.getString(row, refer, "CATALOG"));
        meta.setSchema(this.getString(row, refer, "SCHEMA"));
        meta.setLast(this.getLong(row, refer, "LAST", null));
        meta.setMin(this.getLong(row, refer, "MIN", null));
        meta.setMax(this.getLong(row, refer, "MAX", null));
        meta.setIncrement(this.getInt(row, refer, "INCREMENT", 1).intValue());
        meta.setCache(this.getInt(row, refer, "CACHE", null).intValue());
        meta.setCycle(this.getBoolean(row, refer, "CYCLE_CHECK", null));
        return meta;
    }

    @Override
    public <T extends Sequence> T detail(DataRuntime runtime, int index, T meta, Sequence query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> T detail(DataRuntime runtime, int index, T meta, Sequence query, DataRow row)"), (int)37));
        }
        return meta;
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        if (null != schemas) {
            for (Schema schema : schemas) {
                if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)schema.getCatalog()) || !schema.getName().equalsIgnoreCase(name)) continue;
                return (T)schema;
            }
        }
        return null;
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        if (null != catalogs) {
            for (Catalog catalog : catalogs) {
                if (!catalog.getName().equalsIgnoreCase(name)) continue;
                return (T)catalog;
            }
        }
        return null;
    }

    public <T extends Database> T database(List<T> databases, String name) {
        if (null != databases) {
            for (Database database : databases) {
                if (!database.getName().equalsIgnoreCase(name)) continue;
                return (T)database;
            }
        }
        return null;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run)"), (int)37));
        }
        return false;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        long frs = System.currentTimeMillis();
        ACTION.SWITCH swt = meta.swt();
        if (swt == ACTION.SWITCH.CONTINUE && (swt = InterceptorProxy.before(runtime, random, action, meta, runs)) == ACTION.SWITCH.CONTINUE) {
            for (Run run : runs) {
                swt = InterceptorProxy.before(runtime, random, action, meta, run, runs);
                long fr = System.currentTimeMillis();
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.execute(runtime, random + "[index:" + idx++ + "]", meta, action, run) && result;
                } else {
                    if (swt == ACTION.SWITCH.SKIP) continue;
                    if (swt == ACTION.SWITCH.BREAK) break;
                }
                if ((swt = InterceptorProxy.after(runtime, random, action, meta, run, runs, result, System.currentTimeMillis() - fr)) != ACTION.SWITCH.BREAK) continue;
                break;
            }
            long millis = System.currentTimeMillis() - frs;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][meta:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, action, meta.getName(), runs.size(), result, DateUtil.format((long)millis)});
            }
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public <T extends Metadata> T parse(DataRuntime runtime, Class<T> type, String ddl, ConfigStore configs) {
        return null;
    }

    @Override
    public boolean create(DataRuntime runtime, Catalog meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CATALOG_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Catalog meta) throws Exception {
        return false;
    }

    @Override
    public boolean drop(DataRuntime runtime, Catalog meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CATALOG_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Catalog origin, String name) throws Exception {
        return false;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return this.buildChangeCommentRun(runtime, catalog);
    }

    @Override
    public StringBuilder checkCatalogExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Schema meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.SCHEMA_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Schema meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.SCHEMA_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Schema meta) throws Exception {
        return false;
    }

    @Override
    public boolean rename(DataRuntime runtime, Schema origin, String name) throws Exception {
        return false;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return this.buildChangeCommentRun(runtime, schema);
    }

    @Override
    public StringBuilder checkSchemaExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Database meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.DATABASE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Database meta) throws Exception {
        return false;
    }

    @Override
    public boolean drop(DataRuntime runtime, Database meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.DATABASE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Database origin, String name) throws Exception {
        return false;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Database meta) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Database database) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddCommentRun(DataRuntime runtime, Database database) throws Exception {
        return this.buildChangeCommentRun(runtime, database);
    }

    @Override
    public StringBuilder checkDatabaseExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Database meta) {
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Database meta) {
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Database meta) {
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Database meta) {
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        this.checkPrimary(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    protected LinkedHashMap<String, Column> checkColumnAction(DataRuntime runtime, Table meta) {
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        for (Object col : columns.values()) {
            this.typeMetadata(runtime, (Column)col);
        }
        for (Object col : ucolumns.values()) {
            this.typeMetadata(runtime, (Column)col);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = (Column)ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals(ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                column.setAction(ACTION.DDL.COLUMN_ALTER);
                ucolumn.setAction(ACTION.DDL.COLUMN_ALTER);
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction(ACTION.DDL.COLUMN_ADD);
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction(ACTION.DDL.COLUMN_DROP);
            cols.put(column.getName().toUpperCase(), column);
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || ACTION.DDL.COLUMN_DROP == column.getAction() || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction(ACTION.DDL.COLUMN_DROP);
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        for (Column column : cols.values()) {
            if (columns.containsKey(column.getName().toUpperCase()) || column.getAction() != ACTION.DDL.COLUMN_DROP) continue;
            column.setAction(ACTION.DDL.IGNORE);
        }
        return cols;
    }

    protected List<Run> checkAutoIncrement(DataRuntime runtime, String random, Table table, boolean slice) throws Exception {
        List<Run> runs = new ArrayList<Run>();
        Table update = (Table)table.getUpdate();
        if (!table.primaryEquals(update)) {
            LinkedHashMap pks = table.getPrimaryKeyColumns();
            LinkedHashMap npks = update.getPrimaryKeyColumns();
            LinkedHashMap columns = table.getColumns();
            if (null != pks) {
                for (String k : pks.keySet()) {
                    Column auto = (Column)columns.get(k.toUpperCase());
                    if (null == auto || auto.isAutoIncrement() != 1 || null == npks || npks.containsKey(auto.getName().toUpperCase())) continue;
                    auto.primary(Boolean.valueOf(false));
                    runs = this.buildDropAutoIncrement(runtime, auto, slice);
                }
            }
        }
        return runs;
    }

    @Override
    public List<Run> merge(DataRuntime runtime, Table meta, List<Run> slices) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun merge = null;
        if (null != slices && !slices.isEmpty()) {
            StringBuilder builder = null;
            boolean first = true;
            for (Run item : slices) {
                String line;
                if (!BasicUtil.isNotEmpty((Object)item) || BasicUtil.isEmpty((Object)(line = item.getFinalUpdate().trim()))) continue;
                if (!item.slice()) {
                    runs.add(item);
                    continue;
                }
                if (null == merge) {
                    merge = new SimpleRun(runtime);
                    builder = merge.getBuilder();
                    builder.append("ALTER ").append(this.keyword((Metadata)meta)).append(" ");
                    this.name(runtime, builder, (Metadata)meta);
                    runs.add(merge);
                }
                builder.append("\n");
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                builder.append(line);
            }
        }
        return runs;
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        List<Run> merges;
        boolean change_pk;
        boolean result = true;
        ArrayList<Run> runs = new ArrayList<Run>();
        Table update = (Table)meta.getUpdate();
        this.checkPrimary(runtime, update);
        String name = meta.getName();
        String uname = update.getName();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        this.checkSchema(runtime, update);
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
            meta.setName(uname);
        }
        if (!result) {
            return result;
        }
        String ucomment = update.getComment();
        String comment = meta.getComment();
        if (!(BasicUtil.isEmpty((Object)ucomment) && BasicUtil.isEmpty((Object)comment) || BasicUtil.equals((Object)comment, (Object)ucomment))) {
            swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_COMMENT, meta);
            if (swt == ACTION.SWITCH.BREAK) {
                return false;
            }
            if (BasicUtil.isNotEmpty((Object)meta.getComment())) {
                runs.addAll(this.buildChangeCommentRun(runtime, update));
            } else {
                runs.addAll(this.buildAddCommentRun(runtime, update));
            }
            boolean bl = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_COMMENT, runs) && result;
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        boolean slice = this.slice();
        ArrayList<Run> slices = new ArrayList<Run>();
        LinkedHashMap<String, Column> cols = this.checkColumnAction(runtime, meta);
        PrimaryKey src_primary = this.primary(runtime, random, false, meta);
        PrimaryKey cur_primary = update.getPrimaryKey();
        boolean bl = change_pk = !meta.primaryEquals(update);
        if (change_pk) {
            meta.setChangePrimary(1);
        }
        if (null != cur_primary && cur_primary.isDrop()) {
            cur_primary.execute(meta.execute());
            if (slice) {
                slices.addAll(this.buildDropRun(runtime, cur_primary, slice));
            } else {
                this.drop(runtime, cur_primary);
            }
            cur_primary = null;
            change_pk = false;
        }
        try {
            List<Run> autos = this.checkAutoIncrement(runtime, null, meta, slice);
            if (slice) {
                slices.addAll(autos);
            } else {
                boolean bl2 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_ALTER, autos) && result;
                if (meta.swt() == ACTION.SWITCH.BREAK) {
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (change_pk && null != src_primary) {
            src_primary.execute(meta.execute());
            if (slice) {
                slices.addAll(this.buildDropRun(runtime, src_primary, slice));
            } else {
                this.drop(runtime, src_primary);
            }
            src_primary = null;
        }
        ArrayList<Index> index_alters = new ArrayList<Index>();
        ArrayList<Index> index_adds = new ArrayList<Index>();
        LinkedHashMap oindexes = this.indexes(runtime, random, meta, null);
        LinkedHashMap indexes = update.getIndexes();
        for (Index index : indexes.values()) {
            if (index.isPrimary()) continue;
            index.execute(meta.execute());
            if (index.isDrop()) {
                this.drop(runtime, index);
                continue;
            }
            if (null != index.getUpdate()) {
                index_alters.add(index);
                continue;
            }
            Index oindex = (Index)oindexes.get(index.getName().toUpperCase());
            if (null == oindex) {
                index_adds.add(index);
                continue;
            }
            if (index.equals(oindex) || oindex.isPrimary()) continue;
            oindex.execute(meta.execute());
            oindex.setUpdate((Metadata)index, false, false);
            index_alters.add(oindex);
        }
        List<Run> alters = this.buildAlterRun(runtime, meta, cols.values(), slice);
        if (slice) {
            slices.addAll(alters);
        } else if (null != alters && !alters.isEmpty()) {
            boolean bl3 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.COLUMN_ALTER, alters) && result;
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        if (null != cur_primary && change_pk) {
            if (slice) {
                slices.addAll(this.buildAddRun(runtime, cur_primary, slice));
            } else {
                this.add(runtime, cur_primary);
            }
        }
        boolean bl4 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_ALTER, merges = this.merge(runtime, meta, slices)) && result;
        if (meta.swt() == ACTION.SWITCH.BREAK) {
            return result;
        }
        for (Index index : index_adds) {
            this.add(runtime, index);
        }
        for (Index index : index_alters) {
            this.alter(runtime, index);
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        if (null != meta && !meta.isEmpty()) {
            return this.buildAlterRun(runtime, meta, meta.columns());
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Column column : columns) {
            ACTION.DDL action = column.getAction();
            CMD cmd = null;
            if (null != action) {
                cmd = action.getCmd();
            }
            if (CMD.IGNORE == cmd) continue;
            if (CMD.CREATE == cmd) {
                runs.addAll(this.buildAddRun(runtime, column, slice));
                continue;
            }
            if (CMD.ALTER == cmd) {
                runs.addAll(this.buildAlterRun(runtime, column, slice));
                continue;
            }
            if (CMD.DROP != cmd) continue;
            runs.addAll(this.buildDropRun(runtime, column, slice));
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        if (null != table) {
            table.checkColumnPrimary();
        }
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table table) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder indexes(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder indexes(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = meta.getTags();
        LinkedHashMap utags = update.getTags();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable(update);
                tag.setUpdate(utag, false, false);
                this.alter(runtime, tag);
                result = true;
                continue;
            }
            utag.setTable(update);
            this.add(runtime, utag);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable(update);
                this.drop(runtime, tag);
                result = true;
            }
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), result, DateUtil.format((long)(System.currentTimeMillis() - fr))});
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), result, DateUtil.format((long)(System.currentTimeMillis() - fr))});
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.COLUMN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta, false);
        try {
            result = this.execute(runtime, random, (Metadata)meta, action, runs);
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)((Column)meta.getUpdate()).getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == -1) {
                    throw e;
                }
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    swt = this.ddListener.afterAlterColumnException(runtime, random, table, meta, e);
                }
                log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.alter(runtime, table, meta, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(runtime, null, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.COLUMN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin, false);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return "";
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        String define = meta.getDefinition();
        if (BasicUtil.isNotEmpty((Object)define)) {
            builder.append(" ").append(define);
            return builder;
        }
        this.type(runtime, builder, meta);
        this.aggregation(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.defaultValue(runtime, builder, meta);
        this.nullable(runtime, builder, meta, action);
        this.primary(runtime, builder, meta);
        this.unique(runtime, builder, meta);
        this.increment(runtime, builder, meta);
        this.onupdate(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        this.position(runtime, builder, meta);
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        String finalType;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (BasicUtil.isNotEmpty((Object)(finalType = meta.getFinalType()))) {
            builder.append(finalType);
            return builder;
        }
        meta.ignoreLength(ignoreLength);
        meta.ignorePrecision(ignorePrecision);
        meta.ignoreScale(ignoreScale);
        meta.parseType(2);
        builder.append(meta.getFullType(this.type()));
        return builder;
    }

    @Override
    public int ignoreLength(DataRuntime runtime, TypeMetadata type) {
        return MetadataReferHolder.ignoreLength((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public int ignorePrecision(DataRuntime runtime, TypeMetadata type) {
        return MetadataReferHolder.ignorePrecision((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public int ignoreScale(DataRuntime runtime, TypeMetadata type) {
        return MetadataReferHolder.ignoreScale((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        int nullable;
        if (meta.isPrimaryKey() == 1) {
            builder.append(" NOT NULL");
            return builder;
        }
        if (null == meta.getDefaultValue() && (nullable = meta.isNullable()) != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        void var4_12;
        void var4_10;
        void var4_7;
        Object var4_4 = null;
        boolean defaultCurrentDateTime = false;
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            if (update.isAutoIncrement() == 1) {
                return builder;
            }
            Object object = update.getDefaultValue();
            defaultCurrentDateTime = update.isDefaultCurrentDateTime();
        } else {
            if (meta.isAutoIncrement() == 1) {
                return builder;
            }
            Object object = meta.getDefaultValue();
            defaultCurrentDateTime = meta.isDefaultCurrentDateTime();
        }
        if (null == var4_7 && defaultCurrentDateTime) {
            String type = meta.getFullType(this.type()).toLowerCase();
            if (type.contains("timestamp")) {
                DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIMESTAMP;
            } else {
                DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
            }
        }
        if (null == var4_10) return builder;
        String str = var4_10.toString().trim();
        builder.append(" DEFAULT ");
        DriverAdapter.SQL_BUILD_IN_VALUE val = this.checkDefaultBuildInValue(runtime, var4_10);
        if (null != val) {
            DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = val;
        }
        if (var4_12 instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
            String value = this.value(runtime, meta, (DriverAdapter.SQL_BUILD_IN_VALUE)var4_12);
            if (null == value) throw new RuntimeException("\u5f53\u524dadapter\u6ca1\u6709\u89e3\u6790" + var4_12 + ",\u53ef\u4ee5\u7528${\u539f\u751fSQL}\u4ee3\u66ff,\u5982column.setDefaultValue(\"${now()}\");");
            builder.append(value);
            return builder;
        } else if (str.startsWith("${") && str.endsWith("}")) {
            builder.append(str.substring(2, str.length() - 1));
            return builder;
        } else {
            void var4_17;
            void var4_14;
            Object object;
            if (null != var4_12 && var4_12.toString().contains("::")) {
                String string = var4_12.toString().split("::")[0];
            }
            if (null == (object = this.write(runtime, meta, var4_14, false, false))) {
                Object object2 = meta.getDefaultValue();
            }
            builder.append(var4_17);
        }
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (Metadata)meta, action, runs);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    swt = this.ddListener.afterAlterColumnException(runtime, random, table, (Column)meta, e);
                }
                log.warn("{}[\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.alter(runtime, table, meta, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), 1);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin, this.slice());
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, origin, meta);
        return this.execute(runtime, random, (Metadata)table, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        ACTION.SWITCH swt;
        ACTION.DDL action = ACTION.DDL.INDEX_ADD;
        String random = this.random(runtime);
        Index update = (Index)meta.getUpdate();
        if (null != update) {
            meta = update;
        }
        if ((swt = InterceptorProxy.prepare(runtime, random, action, meta)) == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        LinkedHashMap indexes;
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta && !meta.isEmpty() && null != (indexes = meta.getIndexes())) {
            for (Index index : indexes.values()) {
                if (index.isPrimary()) continue;
                runs.addAll(this.buildAddRun(runtime, index));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Index meta) {
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FUNCTION_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.FUNCTION_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.FUNCTION_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.FUNCTION_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.SEQUENCE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.SEQUENCE_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action;
        boolean result = false;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.SEQUENCE_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.SEQUENCE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, Run run)"), (int)37));
        }
        return false;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        long frs = System.currentTimeMillis();
        for (Run run : runs) {
            result = this.execute(runtime, random + "[index:" + idx++ + "]", meta, action, run) && result;
        }
        long millis = System.currentTimeMillis() - frs;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][meta:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, action, meta.getName(), runs.size(), result, DateUtil.format((long)millis)});
        }
        return result;
    }

    @Override
    public boolean create(DataRuntime runtime, Role role) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.ROLE_CREATE;
        List<Run> runs = this.buildCreateRun(runtime, role);
        return this.execute(runtime, random, (Metadata)role, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Role origin, Role update) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.ROLE_RENAME;
        List<Run> runs = this.buildRenameRun(runtime, origin, update);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Role role) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.ROLE_DROP;
        List<Run> runs = this.buildDropRun(runtime, role);
        return this.execute(runtime, random, (Metadata)role, action, runs);
    }

    @Override
    public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy, Role query) throws Exception {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryRolesRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.roles(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[roles][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[roles][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[roles][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Role role) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildCreateRun(DataRuntime runtime, Role role)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Role origin, Role update) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Role origin, Role update)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Role role) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Role role)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryRolesRun(DataRuntime runtime, boolean greedy, Role query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryRolesRun(DataRuntime runtime, boolean greedy, Role query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initRoleFieldRefer() {
        return new MetadataFieldRefer(Role.class);
    }

    @Override
    public <T extends Role> List<T> roles(DataRuntime runtime, int index, boolean create, List<T> previous, Role query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            if (null == (meta = this.init(runtime, index, (T)meta, query, row)) || meta.isEmpty()) continue;
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Role> T init(DataRuntime runtime, int index, T meta, Role query, DataRow row) {
        if (null == meta) {
            meta = new Role();
        }
        MetadataFieldRefer refer = this.refer(runtime, Role.class);
        meta.setMetadata(row);
        meta.setName(this.getString(row, refer, "NAME"));
        return meta;
    }

    @Override
    public <T extends Role> T detail(DataRuntime runtime, int index, T meta, Role query, DataRow row) {
        return meta;
    }

    @Override
    public boolean create(DataRuntime runtime, User user) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.USER_CREATE;
        List<Run> runs = this.buildCreateRun(runtime, user);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, User origin, User update) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.USER_RENAME;
        List<Run> runs = this.buildRenameRun(runtime, origin, update);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, User user) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.USER_DROP;
        List<Run> runs = this.buildDropRun(runtime, user);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public <T extends User> List<T> users(DataRuntime runtime, String random, boolean greedy, User query) throws Exception {
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryUsersRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.users(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[users][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[users][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[users][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, User user) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, User user)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, User origin, User update) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, User origin, User update)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, User user) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, User user)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryUsersRun(DataRuntime runtime, boolean greedy, User query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryUsersRun(DataRuntime runtime, User query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initUserFieldRefer() {
        return new MetadataFieldRefer(User.class);
    }

    @Override
    public <T extends User> List<T> users(DataRuntime runtime, int index, boolean create, List<T> previous, User query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            meta = this.init(runtime, index, (T)meta, query, row);
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends User> T init(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        if (null == meta) {
            meta = new User();
        }
        MetadataFieldRefer refer = this.refer(runtime, Procedure.class);
        meta.setMetadata(row);
        meta.setName(row.getString(refer.maps("NAME")));
        meta.setHost(row.getString(refer.maps("HOST")));
        return meta;
    }

    @Override
    public <T extends User> T detail(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        return meta;
    }

    @Override
    public <T extends Privilege> List<T> privileges(DataRuntime runtime, String random, boolean greedy, Privilege query) throws Exception {
        User user = query.getUser();
        if (null == random) {
            random = this.random(runtime);
        }
        List list = new ArrayList();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs;
                    if (!greedy) {
                        this.checkSchema(runtime, query);
                    }
                    if (null != (runs = this.buildQueryPrivilegesRun(runtime, greedy, query))) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.selectMetadata(runtime, random, run);
                            list = this.privileges(runtime, idx++, true, list, query, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[privileges][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[privileges][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[privileges][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    @Override
    public List<Run> buildQueryPrivilegesRun(DataRuntime runtime, boolean regreedy, Privilege query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrivilegesRun(DataRuntime runtime, Privilege query)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public MetadataFieldRefer initPrivilegeFieldRefer() {
        return new MetadataFieldRefer(Privilege.class);
    }

    @Override
    public <T extends Privilege> List<T> privileges(DataRuntime runtime, int index, boolean create, List<T> previous, Privilege query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        for (DataRow row : set) {
            Object meta = null;
            meta = this.init(runtime, index, (T)meta, query, row);
            meta = this.detail(runtime, index, (T)meta, query, row);
            previous.add(meta);
        }
        return previous;
    }

    @Override
    public <T extends Privilege> T init(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        if (null == meta) {
            meta = new Privilege();
        }
        MetadataFieldRefer refer = this.refer(runtime, Procedure.class);
        meta.setMetadata(row);
        meta.setName(row.getString(refer.maps("NAME")));
        return meta;
    }

    @Override
    public <T extends Privilege> T detail(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        return meta;
    }

    @Override
    public boolean grant(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.GRANT;
        List<Run> runs = this.buildGrantRun(runtime, user, privileges);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public boolean grant(DataRuntime runtime, User user, Role ... roles) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.GRANT;
        List<Run> runs = this.buildGrantRun(runtime, user, roles);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public boolean grant(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.GRANT;
        List<Run> runs = this.buildGrantRun(runtime, role, privileges);
        return this.execute(runtime, random, (Metadata)role, action, runs);
    }

    @Override
    public List<Run> buildGrantRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildGrantRun(DataRuntime runtime, User user, Privilege ... privileges)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildGrantRun(DataRuntime runtime, User user, Role ... roles) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildGrantRun(DataRuntime runtime, User user, Role ... roles)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildGrantRun(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildGrantRun(DataRuntime runtime, User user, Privilege ... privileges)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean revoke(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.REVOKE;
        List<Run> runs = this.buildRevokeRun(runtime, user, privileges);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public boolean revoke(DataRuntime runtime, User user, Role ... roles) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.REVOKE;
        List<Run> runs = this.buildRevokeRun(runtime, user, roles);
        return this.execute(runtime, random, (Metadata)user, action, runs);
    }

    @Override
    public boolean revoke(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.Authorize action = ACTION.Authorize.REVOKE;
        List<Run> runs = this.buildRevokeRun(runtime, role, privileges);
        return this.execute(runtime, random, (Metadata)role, action, runs);
    }

    @Override
    public List<Run> buildRevokeRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildRevokeRun(DataRuntime runtime, User user, Privilege ... privileges)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRevokeRun(DataRuntime runtime, User user, Role ... roles) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildRevokeRun(DataRuntime runtime, User user, Role ... roles)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRevokeRun(DataRuntime runtime, Role role, Privilege ... privileges) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildRevokeRun(DataRuntime runtime, Role role, Privilege ... privileges)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    protected String getString(DataRow row, MetadataFieldRefer refer, String key, String def) {
        String result = null;
        String[] keys = refer.maps(key);
        if (null != keys && keys.length > 0) {
            result = row.getString(keys);
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    protected String getString(DataRow row, MetadataFieldRefer refer, String key) {
        return this.getString(row, refer, key, null);
    }

    protected Boolean getBoolean(DataRow row, MetadataFieldRefer refer, String key, Boolean def) {
        Boolean result = null;
        try {
            String[] keys = refer.maps(key);
            if (null != keys && keys.length > 0) {
                result = row.getBoolean(keys);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    protected Date getDate(DataRow row, MetadataFieldRefer refer, String key, Date def) {
        Date result = null;
        try {
            String[] keys = refer.maps(key);
            if (null != keys && keys.length > 0) {
                result = row.getDate(keys);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    protected Date getDate(DataRow row, MetadataFieldRefer refer, String key) {
        return this.getDate(row, refer, key, null);
    }

    protected Long getLong(DataRow row, MetadataFieldRefer refer, String key, Long def) {
        Long result = null;
        try {
            String[] keys = refer.maps(key);
            if (null != keys && keys.length > 0) {
                result = row.getLong(keys);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    protected Long getLong(DataRow row, MetadataFieldRefer refer, String key) {
        return this.getLong(row, refer, key, null);
    }

    protected Integer getInt(DataRow row, MetadataFieldRefer refer, String key, Integer def) {
        Integer result = null;
        try {
            String[] keys = refer.maps(key);
            if (null != keys && keys.length > 0) {
                result = row.getInt(keys);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    protected Integer getInt(DataRow row, MetadataFieldRefer refer, String key) {
        return this.getInt(row, refer, key, null);
    }

    protected Boolean matchBoolean(DataRow row, MetadataFieldRefer refer, String key, String value) {
        String[] cols = refer.maps(key);
        String[] vals = refer.maps(value);
        return this.matchBoolean(row, cols, vals);
    }

    protected Boolean matchBoolean(DataRow row, String[] cols, String[] vals) {
        Boolean bol = null;
        if (null != cols) {
            for (String col : cols) {
                Object value = row.get(col);
                if (null == value) continue;
                if (value instanceof Boolean) {
                    bol = (Boolean)value;
                } else if (null != vals) {
                    String str = value.toString();
                    for (String val : vals) {
                        if (!str.matches(val)) continue;
                        bol = true;
                        break;
                    }
                }
                if (null != bol) break;
            }
            if (null == bol) {
                bol = false;
            }
        }
        return bol;
    }

    @Override
    public TypeMetadata typeMetadata(DataRuntime runtime, Column meta) {
        TypeMetadata typeMetadata = meta.getTypeMetadata();
        if (null == typeMetadata || TypeMetadata.NONE == typeMetadata || meta.getParseLvl() < 2 || this.type() != meta.getDatabaseType()) {
            typeMetadata = TypeMetadata.parse((DatabaseType)this.type(), (Column)meta, this.alias, spells);
            meta.setDatabaseType(this.type());
            meta.setParseLvl(2);
        }
        return typeMetadata;
    }

    @Override
    public TypeMetadata typeMetadata(DataRuntime runtime, String type) {
        if (null == type) {
            return null;
        }
        Column tmp = new Column();
        tmp.setTypeName(type, false);
        return this.typeMetadata(runtime, tmp);
    }

    protected PrimaryGenerator checkPrimaryGenerator(DatabaseType type, String table) {
        PrimaryGenerator generator = GeneratorConfig.get((String)(table = table.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "")));
        if (null != generator && generator != PrimaryGenerator.GENERATOR.DISABLE && generator != PrimaryGenerator.GENERATOR.AUTO) {
            return generator;
        }
        if (null == this.primaryGenerator) {
            if (null == this.primaryGenerator) {
                this.primaryGenerator = GeneratorConfig.get();
            }
            if (null == this.primaryGenerator) {
                if (ConfigTable.PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.SNOWFLAKE;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.RANDOM;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.UUID;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIME_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIME;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIMESTAMP_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIMESTAMP;
                }
            }
        }
        if (null != this.primaryGenerator) {
            return this.primaryGenerator;
        }
        return null;
    }

    public TypeMetadata spell(String name) {
        TypeMetadata typeMetadata = this.alias.get(name.toUpperCase());
        if (null == typeMetadata || TypeMetadata.NONE == typeMetadata) {
            typeMetadata = this.alias.get(spells.get(name.toUpperCase()));
        }
        return typeMetadata;
    }

    public String name(Metadata meta) {
        StringBuilder builder = new StringBuilder();
        String catalog = meta.getCatalogName();
        String schema = meta.getSchemaName();
        String name = meta.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append(catalog).append(".");
        }
        if (!this.empty(schema)) {
            builder.append(schema).append(".");
        }
        builder.append(name);
        return builder.toString();
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Metadata meta) {
        this.checkName(runtime, null, meta);
        String catalog = meta.getCatalogName();
        String schema = meta.getSchemaName();
        String name = meta.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.delimiter(builder, catalog).append(".");
        }
        if (!this.empty(schema)) {
            this.delimiter(builder, schema).append(".");
        }
        this.delimiter(builder, name);
        return builder;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (null != meta && !meta.isEmpty()) {
            this.delimiter(builder, meta.getName());
        }
        return builder;
    }

    @Override
    public Object convert(DataRuntime runtime, StringBuilder builder, Object value, Column column, boolean placeholder, Boolean unicode, ConfigStore configs) {
        if (placeholder) {
            builder.append("?");
        } else {
            Object write = this.write(runtime, column, value, false, unicode);
            builder.append(write);
        }
        return value;
    }

    public StringBuilder delimiter(StringBuilder builder, String src, boolean check) {
        return SQLUtil.delimiter((StringBuilder)builder, (String)src, (String)this.getDelimiterFr(), (String)this.getDelimiterTo(), (boolean)check);
    }

    public StringBuilder delimiter(StringBuilder builder, String src) {
        return SQLUtil.delimiter((StringBuilder)builder, (String)src, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
    }

    public StringBuilder delimiter(StringBuilder builder, List<String> list) {
        String fr = this.getDelimiterFr();
        String to = this.getDelimiterTo();
        boolean first = true;
        for (String item : list) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            SQLUtil.delimiter((StringBuilder)builder, (String)item, (String)fr, (String)to);
        }
        return builder;
    }

    @Override
    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).startsWith("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).startsWith("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return !this.isNumberColumn(runtime, column) && !this.isBooleanColumn(runtime, column);
    }

    @Override
    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    @Override
    public Object write(DataRuntime runtime, Column metadata, Object value, boolean placeholder, boolean unicode) {
        Class writeClass;
        if (null == value || "NULL".equals(value)) {
            return null;
        }
        Object result = null;
        TypeMetadata columnType = null;
        DataWriter writer = null;
        boolean isArray = false;
        if (null != metadata) {
            String typeName;
            isArray = metadata.isArray();
            columnType = metadata.getTypeMetadata();
            if (null != columnType) {
                writer = this.writer(columnType);
            }
            if (null == writer && null != (typeName = metadata.getTypeName())) {
                writer = this.writer(typeName);
                if (null != columnType) {
                    writer = this.writer(this.typeMetadata(runtime, metadata));
                }
            }
        }
        if (null == columnType || TypeMetadata.NONE == columnType) {
            columnType = this.typeMetadata(runtime, value.getClass().getSimpleName());
        }
        if (null != columnType && TypeMetadata.NONE != columnType && null != (writeClass = columnType.compatible())) {
            value = ConvertProxy.convert((Object)value, (Class)writeClass, (boolean)isArray);
        }
        if (null != columnType && TypeMetadata.NONE != columnType && null == (writer = this.writer(columnType))) {
            writer = this.writer(columnType.getCategory());
        }
        if (null == writer && null != value) {
            writer = this.writer(value.getClass());
        }
        if (null != writer) {
            result = writer.write(value, placeholder, unicode, columnType);
        }
        if (null != result) {
            return this.write(runtime, result, placeholder, unicode);
        }
        if (null != columnType && TypeMetadata.NONE != columnType) {
            result = columnType.write(value, null, false);
        }
        if (null != result) {
            return this.write(runtime, result, placeholder, unicode);
        }
        return this.write(runtime, value, placeholder, unicode);
    }

    private Object write(DataRuntime runtime, Object value, boolean placeholder, boolean unicode) {
        if (null == value) {
            return null;
        }
        Object result = null;
        if (!placeholder) {
            boolean isOrigin;
            boolean isNumber = BasicUtil.isNumber((Object)value);
            boolean isBoolean = BasicUtil.isBoolean((Object)value);
            boolean isNull = null == value || "NULL".equals(value);
            boolean isFun = false;
            String str = value + "";
            if (!isNumber && (str.contains("(") || str.contains("'"))) {
                isFun = true;
            }
            boolean bl = isOrigin = isNumber || isBoolean || isNull || isFun || value instanceof VariableValue;
            if (value instanceof VariableValue) {
                value = ((VariableValue)value).value();
            }
            result = isOrigin ? value : "'" + value + "'";
            if (unicode && result instanceof String && result.toString().startsWith("'")) {
                result = this.unicodeGuide(runtime) + result;
            }
        } else if (value instanceof VariableValue) {
            result = ((VariableValue)value).value();
        }
        return result;
    }

    @Override
    public Object read(DataRuntime runtime, Column metadata, Object value, Class clazz) {
        Object result = value;
        if (null == value) {
            return null;
        }
        DataReader reader = null;
        TypeMetadata ctype = null;
        if (null != metadata) {
            String typeName;
            ctype = metadata.getTypeMetadata();
            if (null != ctype) {
                reader = this.reader(ctype);
            }
            if (null == reader && null != (typeName = metadata.getTypeName()) && null == (reader = this.reader(typeName))) {
                reader = this.reader(this.typeMetadata(runtime, metadata));
            }
        }
        if (null == reader) {
            reader = this.reader(value.getClass());
        }
        if (null != reader) {
            result = reader.read(value);
        }
        if ((null == reader || null == result) && null != ctype) {
            result = ctype.read(value, null, clazz);
        }
        return result;
    }

    @Override
    public void value(DataRuntime runtime, StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key, (boolean)true);
        }
        if (null != value) {
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                builder.append(this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
            } else {
                TypeMetadata type = this.typeMetadata(runtime, value.getClass().getName());
                if (null != type) {
                    value = type.write(value, null, false);
                }
                builder.append(value);
            }
        } else {
            builder.append("null");
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, Catalog catalog, Schema schema, String table, RunValue value) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap<String, Column> columns = this.columns(runtime, null, false, new Table(catalog, schema, table), false);
            result = this.convert(runtime, columns, value);
        } else {
            result = this.convert(runtime, (Column)null, value);
        }
        return result;
    }

    @Override
    public void addRunValue(DataRuntime runtime, Run run, Compare compare, Column column, Object value) {
        boolean split = ConfigTable.IS_AUTO_SPLIT_ARRAY;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap columns;
            String type = null;
            if (null != column && null == (type = column.getTypeName()) && BasicUtil.isNotEmpty((Object)run.getTable()) && null != (column = (Column)(columns = this.columns(runtime, null, false, run.getTable(), false)).get(column.getName().toUpperCase()))) {
                type = column.getTypeName();
            }
        }
        run.addValues(compare, column, value, split);
        if (null != column) {
            // empty if block
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, ConfigStore configs, Run run) {
        boolean result = false;
        if (null != run) {
            result = this.convert(runtime, run.getTable(), run);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Table table, Run run) {
        boolean result = false;
        if (null != table) {
            List<RunValue> values;
            LinkedHashMap<String, Column> columns = table.getColumns();
            if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                columns = this.columns(runtime, null, false, table, false);
            }
            if (null != (values = run.getRunValues())) {
                for (RunValue value : values) {
                    if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                        result = this.convert(runtime, columns, value);
                        continue;
                    }
                    result = this.convert(runtime, (Column)null, value);
                }
            }
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Map<String, Column> columns, RunValue value) {
        String key;
        boolean result = false;
        if (null != columns && null != value && null != (key = value.getKey())) {
            Column meta = columns.get(key.toUpperCase());
            result = this.convert(runtime, meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Column metadata, RunValue run) {
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            if (null != metadata) {
                value = this.convert(runtime, metadata, value);
            } else {
                String datatype = run.datatype();
                TypeMetadata tm = null;
                if (null != datatype && null == (tm = this.alias.get(datatype.toUpperCase()))) {
                    log.warn("[\u7c7b\u578b\u68c0\u6d4b\u5931\u8d25][datatype:{}]", (Object)datatype);
                }
                if (null != tm) {
                    value = this.convert(runtime, tm, value);
                } else {
                    DataWriter writer = this.writer(value.getClass());
                    if (null != writer) {
                        value = writer.write(value, true, false, null);
                    }
                }
            }
            run.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Object convert(DataRuntime runtime, Column metadata, Object value) {
        if (null == value) {
            return value;
        }
        try {
            if (null != metadata) {
                TypeMetadata columnType = metadata.getTypeMetadata();
                if (null == columnType && null != (columnType = this.typeMetadata(runtime, metadata))) {
                    columnType.setArray(metadata.isArray());
                    metadata.setTypeMetadata(columnType);
                }
                value = this.convert(runtime, columnType, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Object convert(DataRuntime runtime, TypeMetadata meta, Object value) {
        if (null == meta) {
            return value;
        }
        String typeName = meta.getName();
        boolean parseJson = false;
        if (null != typeName && !(value instanceof String)) {
            if (typeName.contains("JSON")) {
                value = BeanUtil.object2json((Object)value);
                parseJson = true;
            } else if (typeName.contains("XML")) {
                value = BeanUtil.object2xml((Object)value);
                parseJson = true;
            }
        }
        if (!parseJson && null != meta) {
            DataWriter writer = this.writer(meta);
            if (null == writer) {
                writer = this.writer(meta.getCategory());
            }
            if (null != writer) {
                value = writer.write(value, true, false, meta);
            } else {
                Class transfer = meta.transfer();
                Class compatible = meta.compatible();
                if (null != transfer) {
                    value = ConvertProxy.convert((Object)value, (Class)transfer, (boolean)meta.isArray());
                }
                if (null != compatible) {
                    value = ConvertProxy.convert((Object)value, (Class)compatible, (boolean)meta.isArray());
                }
            }
        }
        return value;
    }

    @Override
    public String objectName(DataRuntime runtime, String name) {
        KeyAdapter.KEY_CASE keyCase = this.type().nameCase();
        if (null != keyCase) {
            return keyCase.convert(name);
        }
        return name;
    }

    @Override
    public <T extends Metadata> T search(List<T> list, Catalog catalog, Schema schema, String name) {
        if (null != list) {
            for (Metadata meta : list) {
                if (!this.equals(catalog, meta.getCatalog()) || !this.equals(schema, meta.getSchema()) || !BasicUtil.equalsIgnoreCase((Object)meta.getName(), (Object)name)) continue;
                return (T)meta;
            }
        }
        return (T)Metadata.match(list, (Catalog)catalog, (Schema)schema, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String catalog, String schema, String name) {
        return (T)Metadata.match(list, (String)catalog, (String)schema, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String catalog, String name) {
        return (T)Metadata.match(list, (String)catalog, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String name) {
        return (T)Metadata.match(list, (String)name);
    }

    protected String concat(String prefix, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)prefix)) {
            prefix = "";
        } else if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append(prefix);
            this.delimiter(builder, column);
        }
        return builder.toString();
    }

    protected String concatEqual(String master, String data, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)master)) {
            master = "";
        } else if (!master.endsWith(".")) {
            master = master + ".";
        }
        if (BasicUtil.isEmpty((Object)data)) {
            data = "";
        } else if (!data.endsWith(".")) {
            data = data + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append(master).append(column).append(" = ").append(data).append(column);
        }
        return builder.toString();
    }

    protected String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[cmd:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }

    static {
        for (StandardTypeMetadata type : StandardTypeMetadata.values()) {
            String name = type.name().toUpperCase();
            String standard = type.getName().toUpperCase();
            spells.put(name, standard);
            if (name.contains(" ")) {
                spells.put(name.replace(" ", "_"), standard);
            }
            if (name.contains("_")) {
                spells.put(name.replace("_", " "), standard);
            }
            if (standard.contains(" ")) {
                spells.put(standard.replace(" ", "_"), standard);
            }
            if (!standard.contains("_")) continue;
            spells.put(standard.replace("_", " "), standard);
        }
    }
}

