/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.Highlight;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.param.init.DefaultConfigChain;
import org.anyline.data.prepare.Group;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.init.AbstractGroup;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.OriginRow;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.DESUtil;

public class DefaultConfigStore
implements ConfigStore {
    protected Class clazz;
    protected DataHandler handler;
    protected ConfigChain chain = new DefaultConfigChain();
    protected PageNavi navi;
    protected OrderStore orders;
    protected GroupStore groups;
    protected String having;
    protected List<String> columns = new ArrayList<String>();
    protected List<String> excludes = new ArrayList<String>();
    protected List<Object> values;
    protected boolean cascade = false;
    protected boolean supportKeyHolder = true;
    protected List<String> keyHolders = new ArrayList<String>();
    protected Boolean override = null;
    protected List<String> overrideByColumns = null;
    protected Constraint overrideByConstraint = null;
    protected List<String> primaryKeys = new ArrayList<String>();
    protected boolean integrality = true;
    protected List<Run> runs = new ArrayList<Run>();
    protected KeyAdapter.KEY_CASE kc = null;
    protected boolean execute = true;
    protected String datasource = null;
    protected String dest = null;
    protected Catalog catalog = null;
    protected Schema schema = null;
    protected Table table = null;
    protected String join = null;
    protected Highlight highlight;
    List<Object> statics = new ArrayList<Object>();
    protected Hashtable<String, Object> configs = new Hashtable();
    protected long executeTime = -1L;
    protected long lastExecuteTime = -1L;
    protected long packageTime = -1L;
    protected long lastPackageTime = -1L;

    @Override
    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        OriginRow columns = new OriginRow();
        columns.put("query", this.columns);
        columns.put("exclude", this.excludes);
        if (empty || !this.excludes.isEmpty() || !this.columns.isEmpty()) {
            row.put("columns", (Object)columns);
        }
        row.put("conditions", (Object)this.chain.map(empty));
        if (null != this.navi) {
            row.put("navi", (Object)this.navi.map(empty));
        }
        return row;
    }

    @Override
    public String getRunText(DataRuntime runtime, boolean placeholder) {
        return this.getConfigChain().createAutoConditionChain().getRunText(null, runtime, placeholder);
    }

    @Override
    public Table table() {
        return this.table;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Catalog catalog() {
        return this.catalog;
    }

    @Override
    public String tableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return null;
    }

    @Override
    public String schemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }

    @Override
    public String catalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    @Override
    public ConfigStore table(Table table) {
        this.table = table;
        return this;
    }

    @Override
    public ConfigStore schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public ConfigStore catalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
    }

    @Override
    public ConfigStore table(String table) {
        if (BasicUtil.isNotEmpty((Object)table)) {
            this.table = new Table(table);
        }
        return this;
    }

    @Override
    public ConfigStore schema(String schema) {
        if (BasicUtil.isNotEmpty((Object)schema)) {
            this.schema = new Schema(schema);
        }
        return this;
    }

    @Override
    public ConfigStore catalog(String catalog) {
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.catalog = new Catalog(catalog);
        }
        return this;
    }

    @Override
    public ConfigStore datasource(String datasource) {
        this.datasource = datasource;
        return this;
    }

    @Override
    public String datasource() {
        return this.datasource;
    }

    @Override
    public ConfigStore dest(String dest) {
        this.dest = dest;
        if (null != dest && !dest.contains(" ") && !dest.contains(":")) {
            this.table(dest);
        }
        return this;
    }

    @Override
    public ConfigStore setJoin(String type) {
        this.chain.setJoin(type);
        return this;
    }

    @Override
    public String getJoin() {
        return this.chain.getJoin();
    }

    @Override
    public String dest() {
        return this.dest;
    }

    @Override
    public Highlight getHighlight() {
        return this.highlight;
    }

    @Override
    public Highlight getHighlight(String field) {
        if (null != this.highlight) {
            return this.highlight.getHighlight(field);
        }
        return null;
    }

    @Override
    public ConfigStore addHighlight(String ... fields) {
        if (null == this.highlight) {
            this.highlight = new Highlight();
        }
        this.highlight.addField(fields);
        return this;
    }

    @Override
    public ConfigStore setHighlight(Highlight highlight) {
        this.highlight = highlight;
        return this;
    }

    @Override
    public ConfigStore addHighlight(String field, Highlight highlight) {
        if (null == this.highlight) {
            this.highlight = new Highlight();
        }
        this.highlight.addField(field, highlight);
        return this;
    }

    @Override
    public ConfigStore copyProperty(ConfigStore configs) {
        if (null != configs) {
            this.table = configs.table();
            this.handler = configs.handler();
            this.catalog = configs.catalog();
            this.schema = configs.schema();
            this.table = configs.table();
            this.datasource = configs.datasource();
            this.execute = configs.execute();
            this.clazz = configs.getClass();
            this.integrality = configs.integrality();
            this.primaryKeys = configs.getPrimaryKeys();
            this.configs = configs.getConfigs();
        }
        return this;
    }

    @Override
    public ConfigStore keys(String ... keys) {
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        for (String key : keys) {
            this.primaryKeys.add(key);
        }
        return this;
    }

    @Override
    public List<String> keys() {
        if (null == this.primaryKeys) {
            return new ArrayList<String>();
        }
        return this.primaryKeys;
    }

    public DefaultConfigStore init() {
        return new DefaultConfigStore(new String[0]);
    }

    @Override
    public String toString() {
        String str = "";
        if (null != this.chain) {
            str = str + this.chain.toString();
        }
        if (null != this.navi) {
            str = str + "." + this.navi.getFirstRow() + "." + this.navi.getLastRow() + "." + this.navi.getCurPage();
        }
        if (null != this.orders) {
            str = str + "." + this.orders.getRunText("");
        }
        if (null != this.groups) {
            str = str + "." + this.groups.getRunText("");
        }
        return str;
    }

    @Override
    public boolean execute() {
        return this.execute;
    }

    @Override
    public ConfigStore execute(boolean execute) {
        this.execute = execute;
        return this;
    }

    @Override
    public Config parseConfig(String config) {
        if (null == config) {
            return null;
        }
        DefaultConfig conf = null;
        conf = config.contains("|") ? new DefaultConfigChain(config) : new DefaultConfig(config);
        return conf;
    }

    @Override
    public ConfigStore setPageNavi(PageNavi navi) {
        this.navi = navi;
        return this;
    }

    @Override
    public ConfigStore copyPageNavi(PageNavi navi) {
        if (null == this.navi) {
            this.navi = navi;
        } else {
            this.navi.setBaseLink(navi.getBaseLink());
            this.navi.setCalType(navi.getCalType());
            this.navi.setCurPage(navi.getCurPage());
            this.navi.setDisplayPageFirst(navi.getDisplayPageFirst());
            this.navi.setDisplayPageLast(navi.getDisplayPageLast());
            this.navi.setFirstRow(navi.getFirstRow());
            this.navi.setLastRow(navi.getLastRow());
            this.navi.setPageRows(navi.getPageRows());
            this.navi.setTotalPage(navi.getTotalPage());
            this.navi.setTotalRow(navi.getTotalRow());
        }
        return this;
    }

    public DefaultConfigStore(String ... configs) {
        configs = BasicUtil.compress((String[])configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    public DefaultConfigStore(long first, long last) {
        this.chain = new DefaultConfigChain();
        this.scope(first, last);
    }

    public DefaultConfigStore(List<String> configs) {
        configs = BasicUtil.compress(configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    @Override
    public Boolean override() {
        return this.override;
    }

    @Override
    public List<String> overrideByColumns() {
        return this.overrideByColumns;
    }

    @Override
    public Constraint overrideByConstraint() {
        return this.overrideByConstraint;
    }

    @Override
    public ConfigStore override(Boolean override, String ... columns) {
        this.override = override;
        if (null != columns) {
            if (null == this.overrideByColumns) {
                this.overrideByColumns = new ArrayList<String>();
            }
            for (String column : columns) {
                this.overrideByColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore override(Boolean override, Constraint constraint) {
        this.override = override;
        this.overrideByConstraint = constraint;
        return this;
    }

    @Override
    public DataHandler handler() {
        return this.handler;
    }

    @Override
    public ConfigStore handler(DataHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public ConfigStore entityClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public Class entityClass() {
        return this.clazz;
    }

    @Override
    public ConfigStore scope(long first, long last) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
            this.navi.autoCount(false);
        }
        this.navi.scope(first, last);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public ConfigStore limit(long offset, int rows) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
            this.navi.autoCount(false);
        }
        this.navi.limit(offset, rows);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public ConfigStore autoCount(boolean auto) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
        }
        this.navi.autoCount(auto);
        return this;
    }

    @Override
    public Boolean autoCount() {
        if (null != this.navi) {
            return this.navi.autoCount();
        }
        return null;
    }

    @Override
    public boolean integrality() {
        return this.integrality;
    }

    @Override
    public ConfigStore integrality(boolean integrality) {
        this.integrality = integrality;
        if (null != this.chain) {
            this.chain.integrality(integrality);
        }
        return this;
    }

    @Override
    public List<Run> runs() {
        return this.runs;
    }

    @Override
    public ConfigStore runs(List<Run> runs) {
        this.runs = runs;
        return this;
    }

    @Override
    public ConfigStore add(Run run) {
        if (null == this.runs) {
            this.runs = new ArrayList<Run>();
        }
        this.runs.add(run);
        return this;
    }

    @Override
    public ConfigStore page(long page, int rows) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
        }
        this.navi.setCurPage(page);
        this.navi.setPageRows(rows);
        this.navi.setCalType(0);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public ConfigStore addPrimaryKey(Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : pks) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item)) continue;
            this.primaryKeys.add(item);
        }
        return this;
    }

    @Override
    public ConfigStore setPrimaryKey(Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        return this.addPrimaryKey(pks);
    }

    @Override
    public LinkedHashMap<String, Column> getPrimaryColumns() {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        List<String> pks = this.getPrimaryKeys();
        if (null != pks) {
            for (String pk : pks) {
                Column column = new Column(pk);
                columns.put(pk.toUpperCase(), column);
            }
        }
        return columns;
    }

    @Override
    public List<String> getPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return this.primaryKeys;
        }
        return null;
    }

    @Override
    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && !keys.isEmpty()) {
            return keys.get(0);
        }
        return null;
    }

    @Override
    public boolean hasSelfPrimaryKeys() {
        return null != this.primaryKeys && !this.primaryKeys.isEmpty();
    }

    @Override
    public ConfigStore and(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig conf = new DefaultConfig();
        conf.setSwt(swt);
        conf.setText(text);
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore and(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == compare) {
            compare = Compare.AUTO;
        }
        int compareCode = compare.getCode();
        if (null == prefix && null != var && var.contains(".") && !var.contains(">")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        if ((null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) && null != var) {
            if (var.startsWith("++")) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                swt = Compare.EMPTY_VALUE_SWITCH.NULL;
                var = var.substring(1);
            }
        }
        if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
            String column = var;
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                column = prefix + "." + var;
            }
            String txt = column + compare.formula();
            return this.and(swt, txt);
        }
        if (null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) {
            swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        }
        value = this.value(value);
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                boolean first = true;
                for (Object item : list) {
                    if (first) {
                        this.and(swt, compare, prefix, var, item, false, false);
                        first = false;
                        continue;
                    }
                    this.or(compare, var, item);
                }
            } else if (compareCode == 62) {
                for (Object item : list) {
                    this.and(swt, compare, prefix, var, item, false, false);
                }
            }
        } else if (null == conf) {
            conf = new DefaultConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            conf.setPrefix(prefix);
            conf.setVariable(var);
            conf.setSwt(swt);
            conf.setValue(value);
            this.chain.addConfig(conf);
        } else {
            conf.setOverCondition(overCondition);
            conf.setOverValue(overValue);
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        }
        return this;
    }

    @Override
    public ConfigStore and(Config conf) {
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore and(ConfigStore configs, boolean apart) {
        String having;
        GroupStore groups;
        if (null == configs) {
            return this;
        }
        ConfigChain list = null;
        ConfigChain chains = configs.getConfigChain();
        if (apart) {
            list = new DefaultConfigChain();
            list.addConfig(this.chain);
        } else {
            list = this.chain;
        }
        if (chains.integrality()) {
            list.addConfig(chains);
        } else {
            List<Config> items = chains.getConfigs();
            for (Config item : items) {
                list.addConfig(item);
            }
        }
        PageNavi navi = configs.getPageNavi();
        if (null != navi) {
            this.setPageNavi(navi);
        }
        if (null != (groups = configs.getGroups())) {
            this.setGroups(groups);
        }
        if (BasicUtil.isNotEmpty((Object)(having = configs.getHaving()))) {
            this.having(having);
        }
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Config config) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig conf = new DefaultConfig();
        conf.setText(text);
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        list.addConfig(conf);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == compare) {
            compare = Compare.AUTO;
        }
        int compareCode = compare.getCode();
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        if ((null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) && null != var) {
            if (var.startsWith("++")) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                swt = Compare.EMPTY_VALUE_SWITCH.NULL;
                var = var.substring(1);
            }
        }
        if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
            String column = var;
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                column = prefix + "." + var;
            }
            String txt = column + compare.formula();
            return this.ands(swt, txt);
        }
        if (null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) {
            swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        }
        value = this.value(value);
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        DefaultConfigStore newStore = new DefaultConfigStore(new String[0]);
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                boolean first = true;
                for (Object item : list) {
                    if (first) {
                        newStore.and(swt, compare, prefix, var, item, false, false);
                        first = false;
                        continue;
                    }
                    newStore.or(compare, var, item);
                }
            } else if (compareCode == 62) {
                for (Object item : list) {
                    newStore.and(swt, compare, prefix, var, item, false, false);
                }
            }
        } else if (null == conf) {
            conf = new DefaultConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            conf.setPrefix(prefix);
            conf.setVariable(var);
            conf.setSwt(swt);
            conf.setValue(value);
            newStore.and(conf);
        } else {
            conf.setOverCondition(overCondition);
            conf.setOverValue(overValue);
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        }
        this.ands(newStore);
        return this;
    }

    public ConfigChain getChain() {
        return this.chain;
    }

    public void setChain(ConfigChain chain) {
        this.chain = chain;
    }

    @Override
    public ConfigStore params(Object ... values) {
        if (null == this.values) {
            this.values = new ArrayList<Object>();
        }
        if (null != values) {
            this.values.addAll(Arrays.asList(values));
        }
        return this;
    }

    public ConfigStore params(Collection values) {
        if (null == this.values) {
            this.values = new ArrayList<Object>();
        }
        this.values.addAll(values);
        return this;
    }

    @Override
    public List<Object> values() {
        return this.values;
    }

    @Override
    public ConfigStore or(ConfigStore configs, boolean apart) {
        if (null == configs) {
            return this;
        }
        ConfigChain list = null;
        if (apart) {
            list = new DefaultConfigChain();
            list.addConfig(this.chain);
        } else {
            list = this.chain;
        }
        ConfigChain orChain = configs.getConfigChain();
        orChain.setJoin(" OR ");
        list.addConfig(orChain);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore or(Config config) {
        config.setJoin(" OR ");
        this.chain.addConfig(config);
        return this;
    }

    @Override
    public ConfigStore or(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig config = new DefaultConfig();
        config.setText(text);
        config.setJoin(" OR ");
        this.chain.addConfig(config);
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        DefaultConfig config = new DefaultConfig();
        config.setText(text);
        config.setJoin(" OR ");
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, Config config) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        config.setJoin(" OR ");
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore or(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        List<Config> configs = this.chain.getConfigs();
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        if (configs.size() == 0) {
            this.and(swt, compare, prefix, var, value, overCondition, overValue);
        } else {
            int compareCode = compare.getCode();
            if ((value = this.value(value)) instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
                List list = (List)value;
                if (overValue) {
                    this.chain.removeConfig(olds);
                }
                if (compareCode == 60 || compareCode == 61) {
                    for (Object item : list) {
                        this.or(swt, compare, prefix, var, item);
                    }
                } else if (compareCode == 62) {
                    DefaultConfigChain findChain = new DefaultConfigChain();
                    findChain.setJoin(" OR ");
                    for (Object item : list) {
                        conf = new DefaultConfig();
                        conf.setJoin(" AND ");
                        conf.setCompare(compare);
                        conf.setPrefix(prefix);
                        conf.setVariable(var);
                        conf.setValue(item);
                        findChain.addConfig(conf);
                    }
                    this.chain.addConfig(findChain);
                }
            } else if (null != conf) {
                if (overValue) {
                    conf.setValue(value);
                } else {
                    conf.addValue(value);
                }
            } else {
                DefaultConfigChain orChain = new DefaultConfigChain();
                Config last = configs.get(configs.size() - 1);
                configs.remove(last);
                if (last instanceof ConfigChain) {
                    ConfigChain lastChain = (ConfigChain)last;
                    List<Config> lastItems = lastChain.getConfigs();
                    for (Config lastItem : lastItems) {
                        orChain.addConfig(lastItem);
                    }
                } else {
                    orChain.addConfig(last);
                }
                conf = new DefaultConfig();
                conf.setJoin(" OR ");
                if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
                    String column = var;
                    if (BasicUtil.isNotEmpty((Object)prefix)) {
                        column = prefix + "." + var;
                    }
                    String txt = column + compare.formula();
                    conf.setText(txt);
                } else {
                    conf.setCompare(compare);
                    conf.setVariable(var);
                    conf.setPrefix(prefix);
                    conf.setValue(value);
                }
                orChain.addConfig(conf);
                this.chain.addConfig(orChain);
            }
        }
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        int compareCode = compare.getCode();
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        DefaultConfigChain newChain = new DefaultConfigChain();
        newChain.addConfig(this.chain);
        value = this.value(value);
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                for (Object item : list) {
                    conf = new DefaultConfig();
                    conf.setJoin(" OR ");
                    conf.setPrefix(prefix);
                    conf.setCompare(compare);
                    conf.setVariable(var);
                    conf.setValue(item);
                    newChain.addConfig(conf);
                }
            } else if (compareCode == 62) {
                DefaultConfigChain findChain = new DefaultConfigChain();
                findChain.setJoin(" OR ");
                for (Object item : list) {
                    conf = new DefaultConfig();
                    conf.setJoin(" AND ");
                    conf.setCompare(compare);
                    conf.setPrefix(prefix);
                    conf.setVariable(var);
                    conf.setValue(item);
                    findChain.addConfig(conf);
                }
                newChain.addConfig(findChain);
            }
        } else if (null != conf) {
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        } else {
            conf = new DefaultConfig();
            conf.setJoin(" OR ");
            if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
                String column = var;
                if (BasicUtil.isNotEmpty((Object)prefix)) {
                    column = prefix + "." + var;
                }
                String txt = column + compare.formula();
                conf.setText(txt);
            } else {
                conf.setCompare(compare);
                conf.setVariable(var);
                conf.setPrefix(prefix);
                conf.setValue(value);
            }
            newChain.addConfig(conf);
        }
        this.chain = newChain;
        return this;
    }

    private Object value(Object value) {
        if (value instanceof Object[]) {
            value = BeanUtil.array2list((Object[][])new Object[][]{(Object[])value});
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                value = null;
            } else if (list.size() == 1) {
                value = list.get(0);
            }
        }
        return value;
    }

    protected void setNaviParam() {
        if (null == this.chain || null == this.navi) {
            return;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            String key = config.getKey();
            List<Object> values = new ArrayList();
            List<Object> srcValues = config.getValues();
            if (config.isKeyEncrypt()) {
                key = DESUtil.encryptParamKey((String)key);
            }
            if (config.isValueEncrypt() && null != srcValues) {
                for (Object value : srcValues) {
                    if (null == value) continue;
                    value = DESUtil.encryptParamValue((String)value.toString());
                    values.add(value);
                }
            } else {
                values = srcValues;
            }
            this.navi.addParam(key, values);
        }
    }

    @Override
    public ConfigChain getConfigChain() {
        return this.chain;
    }

    @Override
    public boolean isEmptyCondition() {
        if (null != this.chain) {
            return this.chain.isEmpty();
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (null != this.handler) {
            return false;
        }
        if (null != this.chain && !this.chain.isEmpty()) {
            return false;
        }
        if (null != this.navi) {
            return false;
        }
        if (null != this.orders && !this.orders.isEmpty()) {
            return false;
        }
        if (null != this.groups && !this.groups.isEmpty()) {
            return false;
        }
        if (null != this.having) {
            return false;
        }
        if (null != this.columns && !this.columns.isEmpty()) {
            return false;
        }
        if (null != this.excludes && !this.excludes.isEmpty()) {
            return false;
        }
        return null == this.values || this.values.isEmpty();
    }

    @Override
    public ConfigStore order(Order order, boolean override) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order, override);
        if (null != this.navi) {
            this.navi.order(order.getColumn(), order.getType().getCode(), override);
        }
        return this;
    }

    @Override
    public ConfigStore order(Order order) {
        return this.order(order, true);
    }

    @Override
    public ConfigStore order(String column, Order.TYPE type, boolean override) {
        return this.order((Order)new DefaultOrder(column, type), override);
    }

    @Override
    public ConfigStore order(String column, Order.TYPE type) {
        return this.order(column, type, true);
    }

    @Override
    public ConfigStore order(String column, String type, boolean override) {
        return this.order((Order)new DefaultOrder(column, type), override);
    }

    @Override
    public ConfigStore order(String column, String type) {
        return this.order(column, type, true);
    }

    @Override
    public ConfigStore order(String order, boolean override) {
        return this.order((Order)new DefaultOrder(order), override);
    }

    @Override
    public ConfigStore order(String order) {
        return this.order(order, true);
    }

    @Override
    public OrderStore getOrders() {
        if ((null == this.orders || this.orders.getOrders().isEmpty()) && null != this.navi) {
            this.orders = this.navi.getOrders();
        }
        return this.orders;
    }

    @Override
    public ConfigStore setOrders(OrderStore orders) {
        this.orders = orders;
        return this;
    }

    @Override
    public ConfigStore group(Group group) {
        if (null == this.groups) {
            this.groups = new DefaultGroupStore();
        }
        this.groups.group(group);
        return this;
    }

    @Override
    public ConfigStore group(String column) {
        return this.group(new AbstractGroup(column));
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public ConfigStore setGroups(GroupStore groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public ConfigStore having(String having) {
        this.having = having;
        return this;
    }

    @Override
    public String getHaving() {
        return this.having;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public Config getConfig(String var) {
        return this.chain.getConfig(null, var);
    }

    @Override
    public Hashtable<String, Object> getConfigs() {
        return this.configs;
    }

    @Override
    public ConfigStore removeConfig(String var) {
        Config config = this.getConfig(var);
        return this.removeConfig(config);
    }

    @Override
    public ConfigStore removeConfig(Config config) {
        this.chain.removeConfig(config);
        return this;
    }

    @Override
    public List<Object> getConfigValues(String var) {
        Config config = this.chain.getConfig(null, var);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var);
        if (null != config && null != (values = config.getValues()) && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Config getConfig(String var, Compare compare) {
        return this.chain.getConfig(null, var, compare);
    }

    @Override
    public ConfigStore removeConfig(String var, Compare compare) {
        Config config = this.getConfig(var, compare);
        return this.removeConfig(config);
    }

    @Override
    public List<Object> getConfigValues(String var, Compare compare) {
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var, Compare compare) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config && null != (values = config.getValues()) && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public ConfigStore setTotalLazy(long ms) {
        if (null != this.navi) {
            this.navi.setLazy(ms);
        }
        return this;
    }

    @Override
    public ConfigStore setValue(Map<String, Object> values) {
        if (null == this.chain || null == values) {
            return this;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            config.setValue(values);
        }
        this.setNaviParam();
        return this;
    }

    @Override
    public ConfigStore columns(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.columns.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore columns(List<String> columns) {
        if (null != columns) {
            this.columns.addAll(columns);
        }
        return this;
    }

    @Override
    public List<String> columns() {
        return this.columns;
    }

    @Override
    public LinkedHashMap<String, Column> getColumns() {
        LinkedHashMap<String, Column> map = new LinkedHashMap<String, Column>();
        if (null != this.columns) {
            for (String column : this.columns) {
                map.put(column.toUpperCase(), new Column(column));
            }
        }
        return map;
    }

    @Override
    public ConfigStore excludes(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.excludes.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore excludes(List<String> columns) {
        if (null != columns) {
            this.excludes.addAll(columns);
        }
        return this;
    }

    @Override
    public List<String> excludes() {
        return this.excludes;
    }

    @Override
    public ConfigStore cascade(boolean cascade) {
        this.cascade = cascade;
        return this;
    }

    @Override
    public boolean cascade() {
        return this.cascade;
    }

    @Override
    public boolean supportKeyHolder() {
        return this.supportKeyHolder;
    }

    @Override
    public ConfigStore supportKeyHolder(boolean support) {
        this.supportKeyHolder = support;
        return this;
    }

    @Override
    public List<String> keyHolders() {
        return this.keyHolders;
    }

    @Override
    public ConfigStore keyHolders(String ... keys) {
        if (null != keys) {
            for (String key : keys) {
                this.keyHolders.add(key);
            }
        }
        return this;
    }

    @Override
    public boolean isValid() {
        if (null != this.chain) {
            for (Config config : this.chain.getConfigs()) {
                if (config.getSwt() != Compare.EMPTY_VALUE_SWITCH.BREAK || !config.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public ConfigStore condition(String join, Compare compare, String key, Object ... values) {
        if ("or".equalsIgnoreCase(join)) {
            this.or(compare, key, (Object)values);
        } else {
            this.and(compare, key, values);
        }
        return this;
    }

    public ConfigStore condition(String join, String compare, String key, String value) {
        return this.condition(join, this.compare(compare), key, (Object)value);
    }

    public static Compare compare(int code) {
        for (Compare compare : Compare.values()) {
            if (compare.getCode() != code) continue;
            return compare;
        }
        return Compare.EQUAL;
    }

    @Override
    public ConfigStore addStaticValue(Object value) {
        if (value instanceof Collection) {
            this.statics.addAll((Collection)value);
        } else {
            this.statics.add(value);
        }
        return this;
    }

    @Override
    public List<Object> getStaticValues() {
        return this.statics;
    }

    @Override
    public KeyAdapter.KEY_CASE keyCase() {
        return this.kc;
    }

    @Override
    public ConfigStore keyCase(KeyAdapter.KEY_CASE kc) {
        this.kc = kc;
        return this;
    }

    @Override
    public ConfigStore config(String key, Object value) {
        this.configs.put(key.toUpperCase(), value);
        return this;
    }

    @Override
    public Object config(String key) {
        Object value = null;
        value = this.configs.containsKey(key = key.toUpperCase()) ? this.configs.get(key) : ConfigTable.get((String)key);
        return value;
    }

    @Override
    public void setExecuteTime(long time) {
        this.executeTime = time;
    }

    @Override
    public long getExecuteTime() {
        if (this.executeTime == -1L) {
            return this.lastExecuteTime;
        }
        return this.executeTime;
    }

    @Override
    public void setLastExecuteTime(long time) {
        this.lastExecuteTime = time;
    }

    @Override
    public long getLastExecuteTime() {
        return this.lastExecuteTime;
    }

    @Override
    public void setPackageTime(long time) {
        this.packageTime = time;
    }

    @Override
    public long getPackageTime() {
        if (this.packageTime == -1L) {
            return this.lastPackageTime;
        }
        return this.packageTime;
    }

    @Override
    public void setLastPackageTime(long time) {
        this.lastPackageTime = time;
    }

    @Override
    public long getLastPackageTime() {
        return this.lastPackageTime;
    }

    @Override
    public ConfigStore fetch(String ... keys) {
        DefaultConfigStore result = new DefaultConfigStore(new String[0]);
        result.setOrders(this.getOrders());
        result.setGroups(this.getGroups());
        result.setPageNavi(this.getPageNavi());
        DefaultConfigChain chain = new DefaultConfigChain();
        List<Config> configs = this.getConfigChain().getConfigs();
        for (Config config : configs) {
            if (null == config || !BasicUtil.contains((Object[])keys, (Object)config.getPrefix())) continue;
            chain.addConfig(config.clone());
        }
        result.chain = chain;
        return result;
    }

    @Override
    public ConfigStore clone() {
        PageNavi navi;
        GroupStore groups;
        DefaultConfigStore clone = null;
        try {
            clone = (DefaultConfigStore)super.clone();
        }
        catch (Exception ignored) {
            clone = new DefaultConfigStore(new String[0]);
        }
        if (null != this.orders) {
            clone.setOrders(this.orders.clone());
        }
        if (null != (groups = this.getGroups())) {
            clone.setGroups(groups.clone());
        }
        if (null != (navi = this.getPageNavi())) {
            clone.setPageNavi(navi.clone());
        }
        clone.chain = this.chain.clone();
        return clone;
    }
}

