/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.OriginRow;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfig
implements Config {
    protected static final Logger log = LoggerFactory.getLogger(DefaultConfig.class);
    protected String text;
    protected List<Object> values;
    protected List<Object> orValues;
    protected boolean empty;
    protected ParseResult parser;
    protected boolean overCondition = false;
    protected boolean overValue = true;
    protected boolean integrality = true;

    public DefaultConfig() {
        this.parser = new ParseResult();
    }

    public DefaultConfig(ParseResult parser) {
        this.parser = parser;
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("join", this.getJoin());
        map.put("prefix", this.getPrefix());
        map.put("var", this.getVariable());
        map.put("key", this.getKey());
        map.put("compare", this.getCompare().getCode());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    @Override
    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        String join = this.getJoin();
        if (null != join) {
            join = join.trim();
        }
        row.put("join", (Object)join);
        if (empty || BasicUtil.isNotEmpty((Object)this.text)) {
            row.put("text", (Object)this.text);
        }
        String key = this.getKey();
        if (empty || BasicUtil.isNotEmpty((Object)key)) {
            row.put("key", (Object)key);
        }
        String var = this.getVariable();
        if (empty || BasicUtil.isNotEmpty((Object)var)) {
            row.put("var", (Object)var);
        }
        row.put("compare", (Object)this.getCompareCode());
        if ("or".equalsIgnoreCase(join)) {
            if (empty || BasicUtil.isNotEmpty(this.orValues) || BasicUtil.isNotEmpty(this.values)) {
                if (BasicUtil.isEmpty(this.orValues)) {
                    row.put("values", this.values);
                } else {
                    row.put("values", this.orValues);
                }
            }
        } else if (empty || BasicUtil.isNotEmpty(this.values)) {
            row.put("values", this.values);
        }
        row.put("over_condition", (Object)this.overCondition);
        row.put("over_value", (Object)this.overValue);
        row.put("parser", (Object)this.parser.map(empty));
        return row;
    }

    @Override
    public String json() {
        return this.map().json();
    }

    @Override
    public String cacheKey() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prefix", this.getPrefix());
        map.put("compare", this.getCompare().getCode());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    public DefaultConfig(String config) {
        this.parser = ConfigParser.parse(config, true);
    }

    @Override
    public void setValue(Map<String, Object> values) {
        try {
            ConfigParser.parseVar(values, this.parser);
            this.values = ConfigParser.getValues(values, this.parser);
            this.empty = BasicUtil.isEmpty((boolean)true, this.values);
            this.setOrValue(values);
        }
        catch (Exception e) {
            log.error("set file value exception:", (Throwable)e);
        }
    }

    public void setOrValue(Map<String, Object> values) {
        try {
            this.orValues = ConfigParser.getValues(values, this.parser.getOr());
        }
        catch (Exception e) {
            log.error("set or value exception:", (Throwable)e);
        }
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public List<Object> getOrValues() {
        return this.orValues;
    }

    @Override
    public void addValue(Object value) {
        this.values = this.append(this.values, value);
    }

    @Override
    public void setValue(Object value) {
        this.values = new ArrayList<Object>();
        this.addValue(value);
    }

    @Override
    public void setOrValue(Object value) {
        this.orValues = new ArrayList<Object>();
        this.addValue(value);
    }

    @Override
    public void addOrValue(Object value) {
        this.orValues = this.append(this.orValues, value);
    }

    private List<Object> append(List<Object> values, Object value) {
        if (null == values) {
            values = new ArrayList<Object>();
        }
        if (null != value) {
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                for (Object item : list) {
                    this.addValue(item);
                }
            } else if (value instanceof Object[]) {
                Object[] tmps;
                for (Object tmp : tmps = (Object[])value) {
                    this.addValue(tmp);
                }
            } else {
                values.add(value);
            }
        } else {
            values.add(value);
        }
        return values;
    }

    @Override
    public Condition createAutoCondition(ConditionChain chain) {
        Condition condition = null;
        Compare.EMPTY_VALUE_SWITCH swt = this.parser.getSwt();
        if (!this.isEmpty() || swt == Compare.EMPTY_VALUE_SWITCH.NULL || swt == Compare.EMPTY_VALUE_SWITCH.SRC) {
            if (this instanceof ConfigChain) {
                condition = new DefaultAutoConditionChain((ConfigChain)((Object)this));
                condition.setJoin(this.getJoin());
                condition.setContainer(chain);
            } else if (null != this.text) {
                condition = new DefaultAutoCondition(this);
                condition.setRunText(this.text);
                condition.setContainer(chain);
                condition.setActive(true);
                condition.setVariableType(2);
            } else {
                condition = new DefaultAutoCondition(this).setOrCompare(this.getOrCompare()).setJoin(this.parser.getJoin());
                condition.setContainer(chain);
            }
        }
        if (null != condition) {
            condition.setSwt(this.getSwt());
            condition.integrality(this.integrality);
        }
        return condition;
    }

    @Override
    public String getPrefix() {
        return this.parser.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.parser.setPrefix(prefix);
    }

    @Override
    public String getVariable() {
        return this.parser.getVar();
    }

    @Override
    public void setVariable(String variable) {
        this.parser.setVar(variable);
    }

    @Override
    public String getKey() {
        return this.parser.getKey();
    }

    @Override
    public void setKey(String key) {
        this.parser.setKey(key);
    }

    @Override
    public Compare getCompare() {
        return this.parser.getCompare();
    }

    public int getCompareCode() {
        Compare compare = this.parser.getCompare();
        if (null != compare) {
            return compare.getCode();
        }
        return Compare.EQUAL.getCode();
    }

    @Override
    public void setCompare(Compare compare) {
        this.parser.setCompare(compare);
    }

    @Override
    public boolean isEmpty() {
        Compare.EMPTY_VALUE_SWITCH sw = null;
        if (null != this.parser) {
            sw = this.parser.getSwt();
        }
        if (sw == Compare.EMPTY_VALUE_SWITCH.NULL || sw == Compare.EMPTY_VALUE_SWITCH.SRC) {
            return false;
        }
        return BasicUtil.isEmpty((boolean)true, this.values) && BasicUtil.isEmpty((Object)this.text);
    }

    @Override
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public String getJoin() {
        return this.parser.getJoin();
    }

    @Override
    public void setJoin(String join) {
        this.parser.setJoin(join);
    }

    @Override
    public boolean isKeyEncrypt() {
        return this.parser.isKeyEncrypt();
    }

    @Override
    public boolean isValueEncrypt() {
        return this.parser.isValueEncrypt();
    }

    @Override
    public Compare getOrCompare() {
        ParseResult or = this.parser.getOr();
        if (null != or) {
            return or.getCompare();
        }
        return this.parser.getCompare();
    }

    @Override
    public void setOrCompare(Compare compare) {
        ParseResult or = this.parser.getOr();
        if (null != or) {
            or.setCompare(compare);
        }
    }

    public void setTable(String table) {
    }

    public String getTable() {
        return this.parser.getPrefix();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isOverCondition() {
        return this.overCondition;
    }

    @Override
    public void setOverCondition(boolean overCondition) {
        this.overCondition = overCondition;
    }

    @Override
    public boolean isOverValue() {
        return this.overValue;
    }

    @Override
    public void setOverValue(boolean overValue) {
        this.overValue = overValue;
    }

    @Override
    public Compare.EMPTY_VALUE_SWITCH getSwt() {
        return this.parser.getSwt();
    }

    @Override
    public void setSwt(Compare.EMPTY_VALUE_SWITCH swt) {
        this.parser.setSwt(swt);
    }

    @Override
    public boolean integrality() {
        return this.integrality;
    }

    @Override
    public void integrality(boolean integrality) {
        this.integrality = integrality;
    }

    @Override
    public Config clone() {
        DefaultConfig clone = null;
        try {
            clone = (DefaultConfig)super.clone();
        }
        catch (Exception ignored) {
            clone = new DefaultConfig();
        }
        clone.parser = this.parser;
        clone.empty = this.empty;
        ArrayList<Object> values = new ArrayList<Object>();
        if (null != this.values) {
            for (Object value : this.values) {
                values.add(value);
            }
        }
        clone.values = values;
        return clone;
    }
}

