/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.service.init;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.annotation.Autowired;
import org.anyline.annotation.Component;
import org.anyline.cache.CacheElement;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.cache.CacheUtil;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.auto.init.SimplePrepare;
import org.anyline.data.prepare.init.DefaultSQLStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="anyline.service", index=10)
public class DefaultService<E>
implements AnylineService<E> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected AnylineDao dao;
    public AnylineService.MetaDataService metadata = new AnylineService.MetaDataService(){

        @Override
        public DatabaseType type() {
            return DefaultService.this.dao.type();
        }

        @Override
        public String version() {
            return DefaultService.this.dao.version();
        }

        @Override
        public String product() {
            return DefaultService.this.dao.product();
        }

        @Override
        public Database database() {
            return DefaultService.this.dao.database();
        }

        @Override
        public LinkedHashMap<String, Database> databases(String name) {
            return DefaultService.this.dao.databases(name);
        }

        @Override
        public List<Database> databases(boolean greedy, String name) {
            return DefaultService.this.dao.databases(greedy, name);
        }

        @Override
        public Database database(String name) {
            return DefaultService.this.dao.database(name);
        }

        @Override
        public Catalog catalog() {
            return DefaultService.this.dao.catalog();
        }

        @Override
        public LinkedHashMap<String, Catalog> catalogs(String name) {
            return DefaultService.this.dao.catalogs(name);
        }

        @Override
        public List<Catalog> catalogs(boolean greedy, String name) {
            return DefaultService.this.dao.catalogs(greedy, name);
        }

        @Override
        public LinkedHashMap<String, Schema> schemas(Catalog catalog, String name) {
            return DefaultService.this.dao.schemas(catalog, name);
        }

        @Override
        public Schema schema() {
            return DefaultService.this.dao.schema();
        }

        @Override
        public List<Schema> schemas(boolean greedy, Catalog catalog, String name) {
            return DefaultService.this.dao.schemas(greedy, catalog, name);
        }

        @Override
        public boolean exists(boolean greedy, Table table) {
            return null != this.table(greedy, table.getCatalog(), table.getSchema(), table.getName(), false);
        }

        @Override
        public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().tables(greedy, catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.tables(greedy, catalog, schema, name, types, struct, configs);
        }

        @Override
        public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.tables(greedy, catalog, schema, name, types, struct, null);
        }

        @Override
        public <T extends Table> LinkedHashMap<String, T> tables(Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().tables(catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.tables(catalog, schema, name, types, struct, configs);
        }

        private void struct(Table table, int struct) {
            LinkedHashMap constraints;
            LinkedHashMap indexes;
            PrimaryKey pk;
            LinkedHashMap columns = table.getColumns();
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.COLUMN) && (null == columns || columns.isEmpty())) {
                columns = this.columns(table);
                table.setColumns(columns);
                table.setTags(this.tags(table));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.PRIMARY) && null == (pk = table.getPrimaryKey())) {
                pk = this.primary(table);
                if (null != pk) {
                    for (Column col : pk.getColumns().values()) {
                        Column column = (Column)columns.get(col.getName().toUpperCase());
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                        BeanUtil.copyFieldValue((Object)col, (Object)column);
                    }
                }
                table.setPrimaryKey(pk);
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.INDEX) && (null == (indexes = table.getIndexes()) || indexes.isEmpty())) {
                table.setIndexes(this.indexes(table));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.CONSTRAINT) && (null == (constraints = table.getConstraints()) || constraints.isEmpty())) {
                table.setConstraints(this.constraints(table));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.DDL) && null == table.ddl()) {
                this.ddl(table);
            }
        }

        @Override
        public Table table(boolean greedy, Catalog catalog, Schema schema, String name, int struct) {
            Table table = null;
            List tables = this.tables(greedy, catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!tables.isEmpty() && null != (table = (Table)tables.get(0)) && struct > 0) {
                this.struct(table, struct);
            }
            return table;
        }

        @Override
        public Table table(Catalog catalog, Schema schema, String name, int struct) {
            Table table = null;
            LinkedHashMap tables = this.tables(catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!tables.isEmpty() && null != (table = (Table)tables.values().iterator().next()) && struct > 0) {
                this.struct(table, struct);
            }
            return table;
        }

        @Override
        public List<String> ddl(Table table, boolean init) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(table, init);
            }
            return DefaultService.this.dao.ddl(table, init);
        }

        @Override
        public boolean exists(boolean greedy, VertexTable vertexTable) {
            return null != this.vertexTable(greedy, vertexTable.getCatalog(), vertexTable.getSchema(), vertexTable.getName(), false);
        }

        @Override
        public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().vertexTables(greedy, catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.vertexTables(greedy, catalog, schema, name, types, struct, configs);
        }

        @Override
        public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.vertexTables(greedy, catalog, schema, name, types, struct, null);
        }

        @Override
        public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().vertexTables(catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.vertexTables(catalog, schema, name, types, struct, configs);
        }

        private void struct(VertexTable vertexTable, int struct) {
            LinkedHashMap constraints;
            LinkedHashMap indexes;
            PrimaryKey pk;
            LinkedHashMap columns = vertexTable.getColumns();
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.COLUMN) && (null == columns || columns.isEmpty())) {
                columns = this.columns((Table)vertexTable);
                vertexTable.setColumns(columns);
                vertexTable.setTags(this.tags((Table)vertexTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.PRIMARY) && null == (pk = vertexTable.getPrimaryKey())) {
                pk = this.primary((Table)vertexTable);
                if (null != pk) {
                    for (Column col : pk.getColumns().values()) {
                        Column column = (Column)columns.get(col.getName().toUpperCase());
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                        BeanUtil.copyFieldValue((Object)col, (Object)column);
                    }
                }
                vertexTable.setPrimaryKey(pk);
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.INDEX) && (null == (indexes = vertexTable.getIndexes()) || indexes.isEmpty())) {
                vertexTable.setIndexes(this.indexes((Table)vertexTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.CONSTRAINT) && (null == (constraints = vertexTable.getConstraints()) || constraints.isEmpty())) {
                vertexTable.setConstraints(this.constraints((Table)vertexTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.DDL) && null == vertexTable.ddl()) {
                this.ddl(vertexTable);
            }
        }

        @Override
        public VertexTable vertexTable(boolean greedy, Catalog catalog, Schema schema, String name, int struct) {
            VertexTable vertexTable = null;
            List vertexTables = this.vertexTables(greedy, catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!vertexTables.isEmpty() && null != (vertexTable = (VertexTable)vertexTables.get(0)) && struct > 0) {
                this.struct(vertexTable, struct);
            }
            return vertexTable;
        }

        @Override
        public VertexTable vertexTable(Catalog catalog, Schema schema, String name, int struct) {
            VertexTable vertexTable = null;
            LinkedHashMap vertexTables = this.vertexTables(catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!vertexTables.isEmpty() && null != (vertexTable = (VertexTable)vertexTables.values().iterator().next()) && struct > 0) {
                this.struct(vertexTable, struct);
            }
            return vertexTable;
        }

        @Override
        public List<String> ddl(VertexTable vertexTable, boolean init) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)vertexTable);
            if (null != ps[0]) {
                vertexTable.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(vertexTable, init);
            }
            return DefaultService.this.dao.ddl(vertexTable, init);
        }

        @Override
        public boolean exists(boolean greedy, EdgeTable edgeTable) {
            return null != this.edgeTable(greedy, edgeTable.getCatalog(), edgeTable.getSchema(), edgeTable.getName(), false);
        }

        @Override
        public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().edgeTables(greedy, catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.edgeTables(greedy, catalog, schema, name, types, struct, configs);
        }

        @Override
        public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.edgeTables(greedy, catalog, schema, name, types, struct, null);
        }

        @Override
        public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().edgeTables(catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.edgeTables(catalog, schema, name, types, struct, configs);
        }

        private void struct(EdgeTable edgeTable, int struct) {
            LinkedHashMap constraints;
            LinkedHashMap indexes;
            PrimaryKey pk;
            LinkedHashMap columns = edgeTable.getColumns();
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.COLUMN) && (null == columns || columns.isEmpty())) {
                columns = this.columns((Table)edgeTable);
                edgeTable.setColumns(columns);
                edgeTable.setTags(this.tags((Table)edgeTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.PRIMARY) && null == (pk = edgeTable.getPrimaryKey())) {
                pk = this.primary((Table)edgeTable);
                if (null != pk) {
                    for (Column col : pk.getColumns().values()) {
                        Column column = (Column)columns.get(col.getName().toUpperCase());
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                        BeanUtil.copyFieldValue((Object)col, (Object)column);
                    }
                }
                edgeTable.setPrimaryKey(pk);
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.INDEX) && (null == (indexes = edgeTable.getIndexes()) || indexes.isEmpty())) {
                edgeTable.setIndexes(this.indexes((Table)edgeTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.CONSTRAINT) && (null == (constraints = edgeTable.getConstraints()) || constraints.isEmpty())) {
                edgeTable.setConstraints(this.constraints((Table)edgeTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.DDL) && null == edgeTable.ddl()) {
                this.ddl(edgeTable);
            }
        }

        @Override
        public EdgeTable edgeTable(boolean greedy, Catalog catalog, Schema schema, String name, int struct) {
            EdgeTable edgeTable = null;
            List edgeTables = this.edgeTables(greedy, catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!edgeTables.isEmpty() && null != (edgeTable = (EdgeTable)edgeTables.get(0)) && struct > 0) {
                this.struct(edgeTable, struct);
            }
            return edgeTable;
        }

        @Override
        public EdgeTable edgeTable(Catalog catalog, Schema schema, String name, int struct) {
            EdgeTable edgeTable = null;
            LinkedHashMap edgeTables = this.edgeTables(catalog, schema, name, Table.TYPE.NORMAL.value);
            if (!edgeTables.isEmpty() && null != (edgeTable = (EdgeTable)edgeTables.values().iterator().next()) && struct > 0) {
                this.struct(edgeTable, struct);
            }
            return edgeTable;
        }

        @Override
        public List<String> ddl(EdgeTable edgeTable, boolean init) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)edgeTable);
            if (null != ps[0]) {
                edgeTable.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(edgeTable, init);
            }
            return DefaultService.this.dao.ddl(edgeTable, init);
        }

        @Override
        public boolean exists(boolean greedy, View view) {
            return null != this.view(greedy, view.getCatalog(), view.getSchema(), view.getName(), false);
        }

        @Override
        public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().views(greedy, catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.views(greedy, catalog, schema, name, types, struct, configs);
        }

        @Override
        public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.views(greedy, catalog, schema, name, types, struct, null);
        }

        @Override
        public <T extends View> LinkedHashMap<String, T> views(Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().views(catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.views(catalog, schema, name, types, struct, configs);
        }

        private void struct(View view, int struct) {
            LinkedHashMap constraints;
            LinkedHashMap indexes;
            PrimaryKey pk;
            LinkedHashMap columns = view.getColumns();
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.COLUMN) && (null == columns || columns.isEmpty())) {
                columns = this.columns((Table)view);
                view.setColumns(columns);
                view.setTags(this.tags((Table)view));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.PRIMARY) && null == (pk = view.getPrimaryKey())) {
                pk = this.primary((Table)view);
                if (null != pk) {
                    for (Column col : pk.getColumns().values()) {
                        Column column = (Column)columns.get(col.getName().toUpperCase());
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                        BeanUtil.copyFieldValue((Object)col, (Object)column);
                    }
                }
                view.setPrimaryKey(pk);
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.INDEX) && (null == (indexes = view.getIndexes()) || indexes.isEmpty())) {
                view.setIndexes(this.indexes((Table)view));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.CONSTRAINT) && (null == (constraints = view.getConstraints()) || constraints.isEmpty())) {
                view.setConstraints(this.constraints((Table)view));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.DDL) && null == view.ddl()) {
                this.ddl(view);
            }
        }

        @Override
        public View view(boolean greedy, Catalog catalog, Schema schema, String name, int struct) {
            View view = null;
            List views = this.views(greedy, catalog, schema, name, View.TYPE.NORMAL.value);
            if (!views.isEmpty() && null != (view = (View)views.get(0)) && struct > 0) {
                this.struct(view, struct);
            }
            return view;
        }

        @Override
        public View view(Catalog catalog, Schema schema, String name, int struct) {
            View view = null;
            LinkedHashMap views = this.views(catalog, schema, name, View.TYPE.NORMAL.value);
            if (!views.isEmpty() && null != (view = (View)views.values().iterator().next()) && struct > 0) {
                this.struct(view, struct);
            }
            return view;
        }

        @Override
        public List<String> ddl(View view, boolean init) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)view);
            if (null != ps[0]) {
                view.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(view, init);
            }
            return DefaultService.this.dao.ddl(view, init);
        }

        @Override
        public boolean exists(boolean greedy, MasterTable masterTable) {
            return null != this.masterTable(greedy, masterTable.getCatalog(), masterTable.getSchema(), masterTable.getName(), false);
        }

        @Override
        public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().masterTables(greedy, catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.masterTables(greedy, catalog, schema, name, types, struct, configs);
        }

        @Override
        public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.masterTables(greedy, catalog, schema, name, types, struct, null);
        }

        @Override
        public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog catalog, Schema schema, String name, int types, int struct, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().masterTables(catalog, schema, ps[1], types, struct, configs);
            }
            return DefaultService.this.dao.masterTables(catalog, schema, name, types, struct, configs);
        }

        private void struct(MasterTable masterTable, int struct) {
            LinkedHashMap constraints;
            LinkedHashMap indexes;
            PrimaryKey pk;
            LinkedHashMap columns = masterTable.getColumns();
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.COLUMN) && (null == columns || columns.isEmpty())) {
                columns = this.columns((Table)masterTable);
                masterTable.setColumns(columns);
                masterTable.setTags(this.tags((Table)masterTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.PRIMARY) && null == (pk = masterTable.getPrimaryKey())) {
                pk = this.primary((Table)masterTable);
                if (null != pk) {
                    for (Column col : pk.getColumns().values()) {
                        Column column = (Column)columns.get(col.getName().toUpperCase());
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                        BeanUtil.copyFieldValue((Object)col, (Object)column);
                    }
                }
                masterTable.setPrimaryKey(pk);
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.INDEX) && (null == (indexes = masterTable.getIndexes()) || indexes.isEmpty())) {
                masterTable.setIndexes(this.indexes((Table)masterTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.CONSTRAINT) && (null == (constraints = masterTable.getConstraints()) || constraints.isEmpty())) {
                masterTable.setConstraints(this.constraints((Table)masterTable));
            }
            if (Metadata.check((int)struct, (org.anyline.metadata.Type)Metadata.TYPE.DDL) && null == masterTable.ddl()) {
                this.ddl(masterTable);
            }
        }

        @Override
        public MasterTable masterTable(boolean greedy, Catalog catalog, Schema schema, String name, int struct) {
            MasterTable masterTable = null;
            List masterTables = this.masterTables(greedy, catalog, schema, name, MasterTable.TYPE.NORMAL.value);
            if (!masterTables.isEmpty() && null != (masterTable = (MasterTable)masterTables.get(0)) && struct > 0) {
                this.struct(masterTable, struct);
            }
            return masterTable;
        }

        @Override
        public MasterTable masterTable(Catalog catalog, Schema schema, String name, int struct) {
            MasterTable masterTable = null;
            LinkedHashMap masterTables = this.masterTables(catalog, schema, name, MasterTable.TYPE.NORMAL.value);
            if (!masterTables.isEmpty() && null != (masterTable = (MasterTable)masterTables.values().iterator().next()) && struct > 0) {
                this.struct(masterTable, struct);
            }
            return masterTable;
        }

        @Override
        public List<String> ddl(MasterTable masterTable, boolean init) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)masterTable);
            if (null != ps[0]) {
                masterTable.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(masterTable, init);
            }
            return DefaultService.this.dao.ddl((Table)masterTable, init);
        }

        @Override
        public boolean exists(boolean greedy, PartitionTable table) {
            PartitionTable tab = this.partitionTable(greedy, table.getCatalog(), table.getSchema(), table.getMasterName(), table.getName());
            return null != tab;
        }

        @Override
        public boolean exists(PartitionTable table) {
            return this.exists(false, table);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, MasterTable master, Map<String, Object> tags) {
            String[] ps = DataSourceUtil.parseRuntime(master.getName());
            if (null != ps[0]) {
                master.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().partitionTables(greedy, master, tags);
            }
            return DefaultService.this.dao.partitionTables(greedy, master, tags);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
            String[] ps = DataSourceUtil.parseRuntime(master.getName());
            if (null != ps[0]) {
                master.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().partitionTables(greedy, master, tags, name);
            }
            return DefaultService.this.dao.partitionTables(greedy, master, tags, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(Catalog catalog, Schema schema, String master, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().partitionTables(catalog, schema, master, name);
            }
            return DefaultService.this.dao.partitionTables(false, catalog, schema, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(Schema schema, String master, String name) {
            return this.partitionTables(false, null, schema, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(String master, String name) {
            return this.partitionTables(false, null, null, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(String master) {
            return this.partitionTables(false, null, null, master, null);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master) {
            return DefaultService.this.dao.partitionTables(false, master);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master, Map<String, Object> tags) {
            String[] ps = DataSourceUtil.parseRuntime(master.getName());
            if (null != ps[0]) {
                master.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().partitionTables(master, tags);
            }
            return DefaultService.this.dao.partitionTables(false, master, tags);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master, Map<String, Object> tags, String name) {
            String[] ps = DataSourceUtil.parseRuntime(master.getName());
            if (null != ps[0]) {
                master.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().partitionTables(master, tags, name);
            }
            return DefaultService.this.dao.partitionTables(false, master, tags, name);
        }

        @Override
        public PartitionTable partitionTable(boolean greedy, MasterTable master, String name) {
            LinkedHashMap tables = this.partitionTables(greedy, master, name);
            if (tables.isEmpty()) {
                return null;
            }
            PartitionTable table = (PartitionTable)tables.values().iterator().next();
            table.setColumns(this.columns((Table)table));
            table.setTags(this.tags((Table)table));
            table.setIndexes(this.indexes((Table)table));
            return table;
        }

        @Override
        public List<String> ddl(PartitionTable table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(table);
            }
            return DefaultService.this.dao.ddl(table);
        }

        @Override
        public boolean exists(boolean greedy, Table table, Column column) {
            try {
                String name = column.getName().toUpperCase();
                LinkedHashMap columns = null;
                if (null != table) {
                    columns = table.getColumns();
                } else {
                    String tableName;
                    table = column.getTable(true);
                    if (null == table && BasicUtil.isNotEmpty((Object)(tableName = column.getTableName(true)))) {
                        table = new Table(column.getCatalog(), column.getSchema(), tableName);
                    }
                }
                if ((null == columns || columns.isEmpty()) && null != table) {
                    columns = this.columns(greedy, table);
                }
                if (null != columns && columns.containsKey(name)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public <T extends Column> List<T> columns(boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
            return DefaultService.this.dao.columns(greedy, catalog, schema, configs);
        }

        @Override
        public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Table table, ConfigStore configs) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().columns(greedy, table, configs);
            }
            LinkedHashMap columns = DefaultService.this.dao.columns(greedy, table, configs);
            return columns;
        }

        @Override
        public Column column(boolean greedy, Table table, String name) {
            Column column = null;
            LinkedHashMap columns = table.getColumns();
            if (null == columns && columns.isEmpty()) {
                columns = this.columns(greedy, table);
            }
            column = (Column)columns.get(name.toUpperCase());
            return column;
        }

        @Override
        public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().tags(greedy, table);
            }
            return DefaultService.this.dao.tags(greedy, table);
        }

        @Override
        public PrimaryKey primary(boolean greedy, Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().primary(table);
            }
            return DefaultService.this.dao.primary(greedy, table);
        }

        @Override
        public PrimaryKey primary(boolean greedy, String table) {
            return this.primary(greedy, new Table(table));
        }

        @Override
        public PrimaryKey primary(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.primary(greedy, new Table(catalog, schema, table));
        }

        @Override
        public PrimaryKey primary(Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().primary(table);
            }
            return DefaultService.this.dao.primary(false, table);
        }

        @Override
        public PrimaryKey primary(String table) {
            return this.primary(false, new Table(table));
        }

        @Override
        public PrimaryKey primary(Catalog catalog, Schema schema, String table) {
            return this.primary(false, new Table(catalog, schema, table));
        }

        @Override
        public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().foreigns(greedy, table);
            }
            return DefaultService.this.dao.foreigns(greedy, table);
        }

        @Override
        public ForeignKey foreign(boolean greedy, Table table, List<String> columns) {
            if (null == columns || columns.isEmpty()) {
                return null;
            }
            LinkedHashMap foreigns = this.foreigns(greedy, table);
            Collections.sort(columns);
            String id = BeanUtil.concat(columns).toUpperCase();
            for (ForeignKey foreign : foreigns.values()) {
                List fcols = Column.names((LinkedHashMap)foreign.getColumns());
                Collections.sort(fcols);
                if (!id.equals(BeanUtil.concat((Collection)fcols).toUpperCase())) continue;
                return foreign;
            }
            return null;
        }

        @Override
        public <T extends Index> List<T> indexes(boolean greedy, Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().indexes(greedy, table);
            }
            return DefaultService.this.dao.indexes(greedy, table);
        }

        @Override
        public <T extends Index> LinkedHashMap<String, T> indexes(Table table) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().indexes(table);
            }
            return DefaultService.this.dao.indexes(table);
        }

        @Override
        public Index index(boolean greedy, Table table, String name) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().index(greedy, table, name);
            }
            Index index = null;
            List all = DefaultService.this.dao.indexes(greedy, table, name);
            if (null != all && !all.isEmpty()) {
                index = (Index)all.get(0);
            }
            return index;
        }

        @Override
        public <T extends Constraint> List<T> constraints(boolean greedy, Table table, String name) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().constraints(greedy, table, name);
            }
            return DefaultService.this.dao.constraints(greedy, table);
        }

        @Override
        public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table, String name) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().constraints(table, name);
            }
            return DefaultService.this.dao.constraints(table);
        }

        @Override
        public <T extends Constraint> LinkedHashMap<String, T> constraints(Column column, String name) {
            return DefaultService.this.dao.constraints(column, name);
        }

        @Override
        public Constraint constraint(boolean greedy, Table table, String name) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().constraint(greedy, table, name);
            }
            List constraints = this.constraints(greedy, table, name);
            if (null != constraints && !constraints.isEmpty()) {
                return (Constraint)constraints.get(0);
            }
            return null;
        }

        @Override
        public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Table table, List<Trigger.EVENT> events) {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
            if (null != ps[0]) {
                table.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().triggers(greedy, table, events);
            }
            return DefaultService.this.dao.triggers(greedy, table, events);
        }

        @Override
        public Trigger trigger(boolean greedy, Catalog catalog, Schema schema, String name) {
            LinkedHashMap triggers = this.triggers(greedy, new Table(catalog, schema, null), null);
            if (null != triggers) {
                return (Trigger)triggers.get(name.toUpperCase());
            }
            return null;
        }

        @Override
        public <T extends Procedure> List<T> procedures(boolean greedy, Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().procedures(greedy, catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.procedures(greedy, catalog, schema, name);
        }

        @Override
        public <T extends Procedure> LinkedHashMap<String, T> procedures(Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().procedures(catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.procedures(catalog, schema, name);
        }

        @Override
        public Procedure procedure(boolean greedy, Catalog catalog, Schema schema, String name) {
            List procedures = this.procedures(greedy, catalog, schema, name);
            if (null != procedures && !procedures.isEmpty()) {
                return (Procedure)procedures.get(0);
            }
            return null;
        }

        @Override
        public List<String> ddl(Procedure procedure) {
            String[] ps = DataSourceUtil.parseRuntime(procedure.getName());
            if (null != ps[0]) {
                procedure.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(procedure);
            }
            return DefaultService.this.dao.ddl(procedure);
        }

        @Override
        public <T extends Function> List<T> functions(boolean greedy, Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().functions(greedy, catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.functions(greedy, catalog, schema, name);
        }

        @Override
        public <T extends Function> LinkedHashMap<String, T> functions(Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().functions(catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.functions(catalog, schema, name);
        }

        @Override
        public Function function(boolean greedy, Catalog catalog, Schema schema, String name) {
            List functions = this.functions(greedy, catalog, schema, name);
            if (null != functions && !functions.isEmpty()) {
                return (Function)functions.get(0);
            }
            return null;
        }

        @Override
        public List<String> ddl(Function function) {
            String[] ps = DataSourceUtil.parseRuntime(function.getName());
            if (null != ps[0]) {
                function.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(function);
            }
            return DefaultService.this.dao.ddl(function);
        }

        @Override
        public <T extends Sequence> List<T> sequences(boolean greedy, Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().sequences(greedy, catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.sequences(greedy, catalog, schema, name);
        }

        @Override
        public <T extends Sequence> LinkedHashMap<String, T> sequences(Catalog catalog, Schema schema, String name) {
            String[] ps = DataSourceUtil.parseRuntime(name);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).metadata().sequences(catalog, schema, ps[0]);
            }
            return DefaultService.this.dao.sequences(catalog, schema, name);
        }

        @Override
        public Sequence sequence(boolean greedy, Catalog catalog, Schema schema, String name) {
            List sequences = this.sequences(greedy, catalog, schema, name);
            if (null != sequences && !sequences.isEmpty()) {
                return (Sequence)sequences.get(0);
            }
            return null;
        }

        @Override
        public List<String> ddl(Sequence sequence) {
            String[] ps = DataSourceUtil.parseRuntime(sequence.getName());
            if (null != ps[0]) {
                sequence.setName(ps[1]);
                return ServiceProxy.service(ps[0]).metadata().ddl(sequence);
            }
            return DefaultService.this.dao.ddl(sequence);
        }
    };
    public AnylineService.DDLService ddl = new AnylineService.DDLService(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(Table table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                Table otable = DefaultService.this.metadata.table(table.getCatalog(), table.getSchema(), table.getName());
                if (null != otable) {
                    otable.setAutoDropColumn(table.isAutoDropColumn());
                    otable.execute(table.execute());
                    Table update = (Table)table.getUpdate();
                    if (null == update) {
                        update = table;
                    }
                    otable.setUpdate((Metadata)update, false, false);
                    this.sort(table);
                    result = DefaultService.this.dao.alter(otable);
                    table.setDdls(otable.ddls());
                    table.setRuns(otable.runs());
                } else {
                    this.sort(table);
                    result = DefaultService.this.dao.create(table);
                }
            }
            finally {
                CacheProxy.clear();
            }
            return result;
        }

        @Override
        public boolean create(Table table) throws Exception {
            this.sort(table);
            return DefaultService.this.dao.create(table);
        }

        protected void sort(Table table) {
            LinkedHashMap columns = table.getColumns();
            boolean sort = false;
            for (Column column : columns.values()) {
                if (null == column.getPosition()) continue;
                sort = true;
                break;
            }
            if (sort) {
                table.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(Table table) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                Table update = (Table)table.getUpdate();
                if (null == update) {
                    update = table;
                }
                table = DefaultService.this.metadata().table(table.getCatalog(), table.getSchema(), table.getName());
                table.setUpdate((Metadata)update, false, false);
                boolean bl = result = DefaultService.this.dao.alter(table);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean drop(Table table) throws Exception {
            boolean result = DefaultService.this.dao.drop(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Table origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(View view) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                View oview = DefaultService.this.metadata.view(view.getCatalog(), view.getSchema(), view.getName());
                if (null != oview) {
                    oview.setAutoDropColumn(view.isAutoDropColumn());
                    View update = (View)view.getUpdate();
                    if (null == update) {
                        update = view;
                    }
                    oview.setUpdate((Metadata)update, false, false);
                    result = this.alter(oview);
                } else {
                    result = this.create(view);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean create(View view) throws Exception {
            boolean result = DefaultService.this.dao.create(view);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(View view) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.alter(view);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(View view) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(view);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(View origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(MasterTable table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                MasterTable otable = DefaultService.this.metadata.masterTable(table.getCatalog(), table.getSchema(), table.getName());
                if (null != otable) {
                    otable.setUpdate((Metadata)table, false, false);
                    result = this.alter(otable);
                } else {
                    result = this.create(table);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean create(MasterTable table) throws Exception {
            boolean result = DefaultService.this.dao.create(table);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(MasterTable table) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.alter(table);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(MasterTable table) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(table);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(MasterTable origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(PartitionTable table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                PartitionTable otable = DefaultService.this.metadata.partitionTable(table.getCatalog(), table.getSchema(), table.getMasterName(), table.getName());
                if (null != otable) {
                    otable.setUpdate((Metadata)table, false, false);
                    result = this.alter(otable);
                } else {
                    result = this.create(table);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean create(PartitionTable table) throws Exception {
            boolean result = DefaultService.this.dao.create(table);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(PartitionTable table) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.alter(table);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(PartitionTable table) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(table);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(PartitionTable origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(Column column) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName(true));
                if (null == table) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
                }
                LinkedHashMap columns = table.getColumns();
                Column origin = (Column)columns.get(column.getName().toUpperCase());
                result = null == origin ? this.add(columns, column) : this.alter(table, column);
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Column column) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                LinkedHashMap<String, Column> columns = DefaultService.this.metadata.columns(column.getCatalog(), column.getSchema(), column.getTableName(true));
                boolean bl = result = this.add(columns, column);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(Column column) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName(true));
                boolean bl = result = this.alter(table, column);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(Column column) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(column);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean add(LinkedHashMap<String, Column> columns, Column column) throws Exception {
            CacheProxy.clear();
            try {
                boolean result = DefaultService.this.dao.add(column);
                if (result) {
                    columns.put(column.getName().toUpperCase(), column);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean alter(Table table, Column column) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                LinkedHashMap columns = table.getColumns();
                Column origin = (Column)columns.get(column.getName().toUpperCase());
                Column update = (Column)column.getUpdate();
                if (null == update) {
                    update = (Column)column.clone();
                }
                origin.setUpdate((Metadata)update, false, false);
                String name = origin.getName();
                try {
                    result = DefaultService.this.dao.alter(table, origin);
                }
                finally {
                    origin.setName(name);
                }
                if (result) {
                    columns.remove(origin.getName());
                    BeanUtil.copyFieldValueWithoutNull((Object)origin, (Object)update);
                    origin.setUpdate((Metadata)update, false, false);
                    BeanUtil.copyFieldValue((Object)column, (Object)origin);
                    column.setUpdate((Metadata)update, false, false);
                    columns.put(origin.getName().toUpperCase(), origin);
                }
                column.setTable(table);
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Column origin, String name) throws Exception {
            try {
                boolean result;
                origin.setNewName(name);
                boolean bl = result = this.alter(origin);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(Tag tag) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
                if (null == table) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
                }
                LinkedHashMap tags = table.getTags();
                Tag original = (Tag)tags.get(tag.getName().toUpperCase());
                result = null == original ? this.add(tags, tag) : this.alter(table, tag);
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Tag tag) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                LinkedHashMap<String, Tag> tags = DefaultService.this.metadata.tags(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
                boolean bl = result = this.add(tags, tag);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(Tag tag) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
                boolean bl = result = this.alter(table, tag);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(Tag tag) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(tag);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean add(LinkedHashMap<String, Tag> tags, Tag tag) throws Exception {
            CacheProxy.clear();
            try {
                boolean result = DefaultService.this.dao.add(tag);
                if (result) {
                    tags.put(tag.getName(), tag);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean alter(Table table, Tag tag) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            try {
                LinkedHashMap tags = table.getTags();
                Tag origin = (Tag)tags.get(tag.getName().toUpperCase());
                Tag update = tag.getUpdate();
                if (null == update) {
                    update = tag.clone();
                }
                origin.setUpdate(update, false, false);
                result = DefaultService.this.dao.alter(table, origin);
                if (result) {
                    tags.remove(origin.getName());
                    BeanUtil.copyFieldValueWithoutNull((Object)origin, (Object)update);
                    origin.setUpdate(update, false, false);
                    BeanUtil.copyFieldValue((Object)tag, (Object)origin);
                    tags.put(origin.getName(), origin);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Tag origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean add(PrimaryKey primary) throws Exception {
            CacheProxy.clear();
            try {
                boolean bl = DefaultService.this.dao.add(primary);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean alter(PrimaryKey primary) throws Exception {
            CacheProxy.clear();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(PrimaryKey primary) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(primary);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(PrimaryKey origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(ForeignKey foreign) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.add(foreign);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(ForeignKey foreign) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.alter(foreign);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(ForeignKey foreign) throws Exception {
            try {
                boolean result;
                if (BasicUtil.isEmpty((Object)foreign.getName())) {
                    List names = Column.names((LinkedHashMap)foreign.getColumns());
                    foreign = DefaultService.this.metadata.foreign(foreign.getTable(true), (List<String>)names);
                }
                boolean bl = result = DefaultService.this.dao.drop(foreign);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(ForeignKey origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Index index) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.add(index);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean alter(Index index) throws Exception {
            CacheProxy.clear();
            return DefaultService.this.dao.alter(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(Index index) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(index);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Index origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Constraint constraint) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.add(constraint);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean alter(Constraint constraint) throws Exception {
            CacheProxy.clear();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(Constraint constraint) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(constraint);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Constraint origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean create(Trigger trigger) throws Exception {
            boolean result = DefaultService.this.dao.add(trigger);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean alter(Trigger trigger) throws Exception {
            CacheProxy.clear();
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.alter(trigger);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop(Trigger trigger) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.drop(trigger);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Trigger origin, String name) throws Exception {
            try {
                boolean result;
                boolean bl = result = DefaultService.this.dao.rename(origin, name);
                return bl;
            }
            finally {
                CacheProxy.clear();
            }
        }

        @Override
        public boolean create(Procedure procedure) throws Exception {
            return DefaultService.this.dao.create(procedure);
        }

        @Override
        public boolean alter(Procedure procedure) throws Exception {
            boolean result = DefaultService.this.dao.alter(procedure);
            return result;
        }

        @Override
        public boolean drop(Procedure procedure) throws Exception {
            boolean result = DefaultService.this.dao.drop(procedure);
            return result;
        }

        @Override
        public boolean rename(Procedure origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            return result;
        }

        @Override
        public boolean create(Function function) throws Exception {
            boolean result = DefaultService.this.dao.create(function);
            return result;
        }

        @Override
        public boolean alter(Function function) throws Exception {
            boolean result = DefaultService.this.dao.alter(function);
            return result;
        }

        @Override
        public boolean drop(Function function) throws Exception {
            boolean result = DefaultService.this.dao.drop(function);
            return result;
        }

        @Override
        public boolean rename(Function origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            return result;
        }

        @Override
        public boolean create(Sequence sequence) throws Exception {
            boolean result = DefaultService.this.dao.create(sequence);
            return result;
        }

        @Override
        public boolean alter(Sequence sequence) throws Exception {
            boolean result = DefaultService.this.dao.alter(sequence);
            return result;
        }

        @Override
        public boolean drop(Sequence sequence) throws Exception {
            boolean result = DefaultService.this.dao.drop(sequence);
            return result;
        }

        @Override
        public boolean rename(Sequence origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            return result;
        }
    };

    @Override
    public String datasource() {
        return this.dao.runtime().datasource();
    }

    @Override
    public DriverAdapter adapter() {
        return this.dao.adapter();
    }

    @Override
    public DataRuntime runtime() {
        return this.dao.runtime();
    }

    @Override
    public AnylineDao getDao() {
        return this.dao;
    }

    @Override
    public AnylineService setDao(AnylineDao dao) {
        this.dao = dao;
        return this;
    }

    @Override
    public DataSet querys(String dest, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).querys(ps[1], configs, obj, conditions);
        }
        dest = BasicUtil.compress((String)dest);
        conditions = BasicUtil.compress((String[])conditions);
        if (obj instanceof PageNavi) {
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
                configs.setPageNavi((PageNavi)obj);
            }
        } else {
            configs = this.append(configs, obj);
        }
        return this.queryFromDao(dest, configs, conditions);
    }

    @Override
    public DataSet querys(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return this.queryFromDao(new DefaultTablePrepare(dest), configs, conditions);
    }

    @Override
    public List<String> column2param(String table) {
        List<String> columns = this.columns(table);
        return EntityAdapterProxy.column2param(columns);
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        List<Map<String, Object>> maps;
        block2: {
            maps = null;
            conditions = BasicUtil.compress((String[])conditions);
            try {
                configs = this.append(configs, obj);
                maps = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().maps(prepare, configs, conditions) : this.dao.maps(prepare, configs, conditions);
            }
            catch (Exception e) {
                maps = new ArrayList<Map<String, Object>>();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block2;
                throw e;
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(String dest, ConfigStore configs, Object obj, String ... conditions) {
        List<Map<String, Object>> maps;
        block3: {
            String[] ps = DataSourceUtil.parseRuntime(dest);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).maps(ps[1], configs, obj, conditions);
            }
            maps = null;
            dest = BasicUtil.compress((String)dest);
            conditions = BasicUtil.compress((String[])conditions);
            try {
                RunPrepare prepare = this.createRunPrepare(dest);
                configs = this.append(configs, obj);
                maps = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().maps(prepare, configs, conditions) : this.dao.maps(prepare, configs, conditions);
            }
            catch (Exception e) {
                maps = new ArrayList<Map<String, Object>>();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        List<Map<String, Object>> maps;
        block3: {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).maps(ps[1], configs, obj, conditions);
            }
            maps = null;
            conditions = BasicUtil.compress((String[])conditions);
            try {
                RunPrepare prepare = this.createRunPrepare(dest);
                configs = this.append(configs, obj);
                maps = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().maps(prepare, configs, conditions) : this.dao.maps(prepare, configs, conditions);
            }
            catch (Exception e) {
                maps = new ArrayList<Map<String, Object>>();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return maps;
    }

    @Override
    public DataSet caches(String cache, String dest, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).caches(cache, ps[1], configs, obj, conditions);
        }
        DataSet set = null;
        dest = BasicUtil.compress((String)dest);
        conditions = BasicUtil.compress((String[])conditions);
        set = null == cache || ConfigTable.IS_CACHE_DISABLED ? this.querys(dest, this.append(configs, obj), conditions) : (null != CacheProxy.provider ? this.queryFromCache(cache, dest, configs, conditions) : this.querys(dest, configs, conditions));
        return set;
    }

    @Override
    public DataSet caches(String cache, Table dest, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).caches(cache, ps[1], configs, obj, conditions);
        }
        DataSet set = null;
        conditions = BasicUtil.compress((String[])conditions);
        set = null == cache || ConfigTable.IS_CACHE_DISABLED ? this.querys(dest, this.append(configs, obj), conditions) : (null != CacheProxy.provider ? this.queryFromCache(cache, dest, configs, conditions) : this.querys(dest, configs, conditions));
        return set;
    }

    @Override
    public DataRow query(String dest, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(dest, store, obj, conditions);
        if (null != set && !set.isEmpty()) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public DataRow query(Table dest, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(dest, store, obj, conditions);
        if (null != set && !set.isEmpty()) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public BigDecimal sequence(boolean next, String name) {
        DataRow row = this.sequences(next, name);
        if (null != row) {
            return row.getDecimal(name, (BigDecimal)null);
        }
        return null;
    }

    @Override
    public DataRow sequences(boolean next, String ... names) {
        return this.dao.sequence(next, names);
    }

    @Override
    public DataRow cache(String cache, String dest, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache || null == CacheProxy.provider || ConfigTable.IS_CACHE_DISABLED) {
            return this.query(dest, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs = this.append(configs, obj);
        configs.setPageNavi((PageNavi)navi);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
        if (null != CacheProxy.provider && null != (cacheElement = CacheProxy.provider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef, \u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(dest, configs, obj, conditions)) && null != CacheProxy.provider) {
            CacheProxy.provider.put(cache, key, (Object)row);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public DataRow cache(String cache, Table dest, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache || null == CacheProxy.provider || ConfigTable.IS_CACHE_DISABLED) {
            return this.query(dest, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs = this.append(configs, obj);
        configs.setPageNavi((PageNavi)navi);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
        if (null != CacheProxy.provider && null != (cacheElement = CacheProxy.provider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef, \u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(dest, configs, obj, conditions)) && null != CacheProxy.provider) {
            CacheProxy.provider.put(cache, key, (Object)row);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.selectFromDao(clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> T select(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(clazz, configs, entity, conditions);
        if (null != list && !list.isEmpty()) {
            return (T)list.get(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> EntitySet<T> selects(String dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).selects(ps[1], clazz, configs, entity, conditions);
        }
        return this.queryFromDao(dest, clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> EntitySet<T> selects(Table dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).selects(ps[1], clazz, configs, entity, conditions);
        }
        return this.queryFromDao(dest, clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> T select(String dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(dest, clazz, configs, entity, conditions);
        if (null != list && !list.isEmpty()) {
            return (T)list.get(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> T select(Table dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(dest, clazz, configs, entity, conditions);
        if (null != list && !list.isEmpty()) {
            return (T)list.get(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Class<E> parseGenericClass() {
        Type type = null;
        Class clazz = null;
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        return clazz;
    }

    @Override
    public EntitySet<E> gets(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, configs, conditions);
    }

    @Override
    public E get(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.select(clazz, configs, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        conditions = BasicUtil.compress((String[])conditions);
        DataSet set = this.queryFromDao(prepare, this.append(configs, obj), conditions);
        return set;
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        DataSet set = null;
        conditions = BasicUtil.compress((String[])conditions);
        if (null == cache) {
            set = this.querys(table, configs, obj, conditions);
        } else if (null == CacheProxy.provider) {
            set = this.querys(table, configs, obj, conditions);
        }
        return set;
    }

    @Override
    public DataRow query(RunPrepare table, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(table, store, obj, conditions);
        if (null != set && !set.isEmpty()) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache) {
            return this.query(table, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        configs = this.append(configs, obj);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, table.getTable(), configs, conditions);
        if (null != CacheProxy.provider && null != (cacheElement = CacheProxy.provider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef, \u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(table, configs, conditions)) && null != CacheProxy.provider) {
            CacheProxy.provider.put(cache, key, (Object)row);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public boolean removeCache(String channel, String dest, ConfigStore configs, String ... conditions) {
        if (null != CacheProxy.provider) {
            dest = BasicUtil.compress((String)dest);
            conditions = BasicUtil.compress((String[])conditions);
            String key = CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
            CacheProxy.provider.remove(channel, "SET:" + key);
            CacheProxy.provider.remove(channel, "ROW:" + key);
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setFirstRow(0L);
            navi.setLastRow(0L);
            navi.setCalType(1);
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            configs.setPageNavi((PageNavi)navi);
            key = CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
            CacheProxy.provider.remove(channel, "ROW:" + key);
        }
        return true;
    }

    @Override
    public boolean removeCache(String channel, Table dest, ConfigStore configs, String ... conditions) {
        if (null != CacheProxy.provider) {
            conditions = BasicUtil.compress((String[])conditions);
            String key = CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
            CacheProxy.provider.remove(channel, "SET:" + key);
            CacheProxy.provider.remove(channel, "ROW:" + key);
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setFirstRow(0L);
            navi.setLastRow(0L);
            navi.setCalType(1);
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            configs.setPageNavi((PageNavi)navi);
            key = CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
            CacheProxy.provider.remove(channel, "ROW:" + key);
        }
        return true;
    }

    @Override
    public boolean clearCache(String channel) {
        if (null != CacheProxy.provider) {
            return CacheProxy.provider.clear(channel);
        }
        return false;
    }

    @Override
    public boolean clearCaches() {
        if (null != CacheProxy.provider) {
            return CacheProxy.provider.clears();
        }
        return false;
    }

    @Override
    public boolean exists(String dest, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).exists(ps[1], configs, obj, conditions);
        }
        boolean result = false;
        dest = BasicUtil.compress((String)dest);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(dest);
        result = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().exists(prepare, this.append(configs, obj), conditions) : this.dao.exists(prepare, this.append(configs, obj), conditions);
        return result;
    }

    @Override
    public boolean exists(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).exists(ps[1], configs, obj, conditions);
        }
        boolean result = false;
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(dest);
        result = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().exists(prepare, this.append(configs, obj), conditions) : this.dao.exists(prepare, this.append(configs, obj), conditions);
        return result;
    }

    @Override
    public boolean exists(String dest, DataRow row) {
        if (null != row) {
            List keys = row.getPrimaryKeys();
            if (null != keys) {
                String[] conditions = new String[keys.size()];
                int idx = 0;
                for (String key : keys) {
                    conditions[idx++] = key + ":" + row.getString(key);
                }
                return this.exists(dest, (ConfigStore)null, conditions);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean exists(Table dest, DataRow row) {
        if (null != row) {
            List keys = row.getPrimaryKeys();
            if (null != keys) {
                String[] conditions = new String[keys.size()];
                int idx = 0;
                for (String key : keys) {
                    conditions[idx++] = key + ":" + row.getString(key);
                }
                return this.exists(dest, (ConfigStore)null, conditions);
            }
            return false;
        }
        return false;
    }

    @Override
    public long count(String dest, ConfigStore configs, Object obj, String ... conditions) {
        long count;
        block3: {
            String[] ps = DataSourceUtil.parseRuntime(dest);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).count(ps[1], configs, obj, conditions);
            }
            count = -1L;
            try {
                dest = BasicUtil.compress((String)dest);
                conditions = BasicUtil.compress((String[])conditions);
                RunPrepare prepare = this.createRunPrepare(dest);
                count = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().count(prepare, this.append(configs, obj), conditions) : this.dao.count(prepare, this.append(configs, obj), conditions);
            }
            catch (Exception e) {
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return count;
    }

    @Override
    public long count(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        long count;
        block3: {
            String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).count(ps[1], configs, obj, conditions);
            }
            count = -1L;
            try {
                conditions = BasicUtil.compress((String[])conditions);
                RunPrepare prepare = this.createRunPrepare(dest);
                count = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().count(prepare, this.append(configs, obj), conditions) : this.dao.count(prepare, this.append(configs, obj), conditions);
            }
            catch (Exception e) {
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return count;
    }

    @Override
    public long count(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        long count;
        block2: {
            count = -1L;
            try {
                conditions = BasicUtil.compress((String[])conditions);
                count = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().count(prepare, this.append(configs, obj), conditions) : this.dao.count(prepare, this.append(configs, obj), conditions);
            }
            catch (Exception e) {
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block2;
                throw e;
            }
        }
        return count;
    }

    @Override
    public long insert(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).insert(batch, ps[1], data, configs, columns);
        }
        return this.dao.insert(batch, dest, data, configs, columns);
    }

    @Override
    public long insert(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).insert(batch, dest, data, configs, columns);
        }
        return this.dao.insert(batch, dest, data, configs, columns);
    }

    @Override
    public long insert(Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).insert(dest, prepare, configs, conditions);
        }
        return this.dao.insert(dest, prepare, configs, obj, conditions);
    }

    @Override
    public long insert(Table dest, Table origin, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).insert(dest, origin, configs, obj, conditions);
        }
        RunPrepare prepare = this.createRunPrepare(origin);
        return this.dao.insert(dest, prepare, configs, obj, conditions);
    }

    @Override
    public long update(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        if (!this.checkCondition(data, configs, new String[0])) {
            return -1L;
        }
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).update(batch, ps[1], data, configs, columns);
        }
        return this.dao.update(batch, dest, data, configs, columns);
    }

    @Override
    public long update(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (!this.checkCondition(data, configs, new String[0])) {
            return -1L;
        }
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).update(batch, dest, data, configs, columns);
        }
        return this.dao.update(batch, dest, data, configs, columns);
    }

    protected boolean checkCondition(Object data, ConfigStore configs, String ... conditions) {
        if (null != configs && !configs.isEmptyCondition()) {
            return true;
        }
        if (null != conditions && conditions.length > 0) {
            return true;
        }
        if (null != data) {
            if (data instanceof DataRow) {
                DataRow row = (DataRow)data;
                if (BasicUtil.isNotEmpty((Object)row.getPrimaryValue())) {
                    return true;
                }
            } else {
                if (data instanceof Collection) {
                    return true;
                }
                if (!EntityAdapterProxy.primaryValue((Object)data).isEmpty()) {
                    return true;
                }
            }
        }
        this.log.warn("[\u6ca1\u6709update\u6216delete\u8fc7\u6ee4\u6761\u4ef6]");
        return false;
    }

    protected boolean checkCondition(Object data) {
        return this.checkCondition(data, null, new String[0]);
    }

    protected boolean checkCondition(ConfigStore configs, String ... conditions) {
        return this.checkCondition(null, configs, conditions);
    }

    @Override
    public long save(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    @Override
    public long save(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).save(batch, dest, data, configs, columns);
        }
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            long cnt = 0L;
            DataSet inserts = new DataSet();
            DataSet updates = new DataSet();
            for (DataRow row : set) {
                Boolean override = row.getOverride();
                if (null != override) {
                    boolean exists = this.exists(dest, row);
                    if (exists) {
                        if (!override.booleanValue()) continue;
                        updates.add(row);
                        continue;
                    }
                    inserts.add(row);
                    continue;
                }
                if (row.isNew().booleanValue()) {
                    inserts.add(row);
                    continue;
                }
                updates.add(row);
            }
            if (!inserts.isEmpty()) {
                cnt += this.insert(batch, dest, (Object)inserts, configs, columns);
            }
            if (!updates.isEmpty()) {
                cnt += this.update(batch, dest, (Object)updates, configs, columns);
            }
            return cnt;
        }
        if (data instanceof Collection) {
            Collection objs = (Collection)data;
            long cnt = 0L;
            ArrayList inserts = new ArrayList();
            ArrayList updates = new ArrayList();
            for (Object obj : objs) {
                if (BeanUtil.checkIsNew(obj)) {
                    inserts.add(obj);
                    continue;
                }
                updates.add(obj);
            }
            if (!inserts.isEmpty()) {
                cnt += this.insert(batch, dest, inserts, configs, columns);
            }
            if (!updates.isEmpty()) {
                cnt += this.update(batch, dest, updates, configs, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, configs, columns);
    }

    protected long saveObject(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.saveObject(DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    protected long saveObject(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.dao.save(dest, data, configs, columns);
    }

    protected long saveObject(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.saveObject(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    protected long saveObject(Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.saveObject(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public boolean execute(Procedure procedure, String ... inputs) {
        if (null != inputs) {
            for (String input : inputs) {
                procedure.addInput(input);
            }
        }
        return this.dao.execute(procedure);
    }

    @Override
    public DataSet querys(Procedure procedure, PageNavi navi, String ... inputs) {
        DataSet set;
        block4: {
            set = null;
            try {
                if (null != inputs) {
                    for (String input : inputs) {
                        procedure.addInput(input);
                    }
                }
                set = this.dao.querys(procedure, navi);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return set;
    }

    @Override
    public DataRow query(Procedure procedure, String ... inputs) {
        DataSet set = this.querys(procedure, 0L, 0L, inputs);
        if (!set.isEmpty()) {
            return set.getRow(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public long execute(int batch, String sql, Collection<Object> values) {
        RunPrepare prepare = this.createRunPrepare(sql);
        if (null == prepare) {
            return -1L;
        }
        return this.dao.execute(batch, prepare, values);
    }

    @Override
    public long execute(int batch, int vol, String sql, Collection<Object> values) {
        RunPrepare prepare = this.createRunPrepare(sql);
        if (null == prepare) {
            return -1L;
        }
        return this.dao.execute(batch, vol, prepare, values);
    }

    @Override
    public long execute(String src, ConfigStore configs, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).execute(ps[1], configs, conditions);
        }
        long result = -1L;
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        if (null == prepare) {
            return result;
        }
        result = this.dao.execute(prepare, configs, conditions);
        return result;
    }

    @Override
    public long delete(String dest, DataSet set, String ... columns) {
        return this.delete(DataSourceUtil.parseDest(dest, set, null), set, columns);
    }

    @Override
    public long delete(Table dest, DataSet set, String ... columns) {
        long cnt = 0L;
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            cnt += this.delete(dest, set.getRow(i), columns);
        }
        this.log.info("[delete DataSet][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((long)cnt, (int)34));
        return cnt;
    }

    @Override
    public long delete(String dest, DataRow row, String ... columns) {
        return this.delete(DataSourceUtil.parseDest(dest, row, null), row, columns);
    }

    @Override
    public long delete(Table dest, DataRow row, String ... columns) {
        if (!this.checkCondition(row)) {
            return -1L;
        }
        String[] ps = DataSourceUtil.parseRuntime((Metadata)dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], row, columns);
        }
        return this.dao.delete(dest, (Object)row, columns);
    }

    @Override
    public long delete(Object obj, String ... columns) {
        if (null == obj) {
            return 0L;
        }
        if (obj instanceof ConfigStore) {
            return this.delete((ConfigStore)obj, columns);
        }
        if (!this.checkCondition(obj)) {
            return -1L;
        }
        Table dest = null;
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return this.dao.delete(dest, (Object)row, columns);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (!list.isEmpty()) {
                Class<?> clazz = list.iterator().next().getClass();
                dest = EntityAdapterProxy.table(clazz);
            }
        } else {
            dest = EntityAdapterProxy.table(obj.getClass());
        }
        if (null != dest) {
            return this.dao.delete(dest, obj, columns);
        }
        return 0L;
    }

    @Override
    public long delete(String table, String ... kvs) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], kvs);
        }
        DataRow row = DataRow.parseArray((String[])kvs);
        row.setPrimaryKey((Collection)row.keys());
        if (!this.checkCondition(row)) {
            return -1L;
        }
        return this.dao.delete(table, (Object)row, new String[0]);
    }

    @Override
    public long delete(Table table, String ... kvs) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], kvs);
        }
        DataRow row = DataRow.parseArray((String[])kvs);
        row.setPrimaryKey((Collection)row.keys());
        if (!this.checkCondition(row)) {
            return -1L;
        }
        return this.dao.delete(table, (Object)row, new String[0]);
    }

    @Override
    public long delete(Table table, Collection values) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], values);
        }
        return this.dao.delete(table, values);
    }

    @Override
    public long delete(String table, Collection values) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], values);
        }
        return this.dao.delete(table, values);
    }

    @Override
    public <T> long deletes(int batch, String table, String key, Collection<T> values) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        if (batch > 1) {
            long qty = 0L;
            ArrayList<T> list = new ArrayList<T>();
            int vol = 0;
            for (T value : values) {
                list.add(value);
                if (++vol < batch) continue;
                qty += this.dao.deletes(0, table, key, values);
                list.clear();
            }
            if (!list.isEmpty()) {
                qty += this.dao.deletes(0, table, key, values);
            }
            return qty;
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public <T> long deletes(int batch, Table table, String key, Collection<T> values) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        if (batch > 1) {
            long qty = 0L;
            ArrayList<T> list = new ArrayList<T>();
            int vol = 0;
            for (T value : values) {
                list.add(value);
                if (++vol < batch) continue;
                qty += this.dao.deletes(0, table, key, values);
                list.clear();
            }
            if (!list.isEmpty()) {
                qty += this.dao.deletes(0, table, key, values);
            }
            return qty;
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public <T> long deletes(int batch, String table, String key, T ... values) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public <T> long deletes(int batch, Table table, String key, T ... values) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public long delete(String table, ConfigStore configs, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], configs, conditions);
        }
        if (!this.checkCondition(configs, conditions)) {
            return -1L;
        }
        return this.dao.delete(table, configs, conditions);
    }

    @Override
    public long delete(Table table, ConfigStore configs, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], configs, conditions);
        }
        if (!this.checkCondition(configs, conditions)) {
            return -1L;
        }
        return this.dao.delete(table, configs, conditions);
    }

    @Override
    public long truncate(String table) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).truncate(ps[1]);
        }
        return this.dao.truncate(table);
    }

    @Override
    public long truncate(Table table) {
        String[] ps = DataSourceUtil.parseRuntime((Metadata)table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).truncate(ps[1]);
        }
        return this.dao.truncate(table);
    }

    protected PageNavi setPageLazy(String src, ConfigStore configs, String ... conditions) {
        PageNavi navi = null;
        String lazyKey = null;
        if (null != configs && null != (navi = configs.getPageNavi()) && navi.isLazy()) {
            lazyKey = CacheUtil.createCacheElementKey(false, false, src, configs, conditions);
            navi.setLazyKey(lazyKey);
            long total = PageLazyStore.getTotal(lazyKey, navi.getLazyPeriod());
            navi.setTotalRow(total);
        }
        return navi;
    }

    protected PageNavi setPageLazy(Table src, ConfigStore configs, String ... conditions) {
        PageNavi navi = null;
        String lazyKey = null;
        if (null != configs && null != (navi = configs.getPageNavi()) && navi.isLazy()) {
            lazyKey = CacheUtil.createCacheElementKey(false, false, src, configs, conditions);
            navi.setLazyKey(lazyKey);
            long total = PageLazyStore.getTotal(lazyKey, navi.getLazyPeriod());
            navi.setTotalRow(total);
        }
        return navi;
    }

    protected DataSet queryFromDao(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set;
        block3: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][dest:{}]", (Object)prepare.getText());
            }
            try {
                this.setPageLazy(prepare.getText(), configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return set;
    }

    protected DataSet queryFromDao(String dest, ConfigStore configs, String ... conditions) {
        return this.queryFromDao(DataSourceUtil.parseDest(dest, null, configs), configs, conditions);
    }

    protected DataSet queryFromDao(Table dest, ConfigStore configs, String ... conditions) {
        DataSet set;
        block3: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][dest:{}]", (Object)dest);
            }
            try {
                this.setPageLazy(dest, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(dest);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return set;
    }

    protected <T> EntitySet<T> queryFromDao(String dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.queryFromDao(DataSourceUtil.parseDest(dest, clazz, configs), clazz, configs, conditions);
    }

    protected <T> EntitySet<T> queryFromDao(Table dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block3: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][dest:{}]", clazz);
            }
            try {
                this.setPageLazy(dest, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(dest);
                list = this.dao.selects(prepare, clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return list;
    }

    protected <T> EntitySet<T> selectFromDao(Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block3: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][dest:{}]", clazz);
            }
            try {
                this.setPageLazy(clazz.getName(), configs, conditions);
                list = this.dao.selects(null, clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block3;
                throw e;
            }
        }
        return list;
    }

    @Override
    public ConfigStore condition() {
        return new DefaultConfigStore(new String[0]);
    }

    @Override
    public List<Run> ddl(MetadataDiffer differ) {
        return this.dao.ddl(differ);
    }

    @Override
    public List<Run> ddl(List<MetadataDiffer> differs) {
        return this.dao.ddl(differs);
    }

    protected String parsePrimaryKey(String src, List<String> pks) {
        if (src.endsWith(">")) {
            int fr = src.lastIndexOf("<");
            int to = src.lastIndexOf(">");
            if (fr != -1) {
                String[] tmps;
                String pkstr = src.substring(fr + 1, to);
                src = src.substring(0, fr);
                for (String tmp : tmps = pkstr.split(",")) {
                    pks.add(tmp);
                    if (!ConfigTable.isSQLDebug()) continue;
                    this.log.debug("[\u89e3\u6790SQL\u4e3b\u952e] [KEY:{}]", (Object)tmp);
                }
            }
        }
        return src;
    }

    protected RunPrepare createRunPrepare(Table table) {
        if (null == table) {
            return new SimplePrepare();
        }
        return this.createRunPrepare(table.getFullName());
    }

    protected RunPrepare createRunPrepare(String src) {
        RunPrepare prepare = null;
        if (BasicUtil.isEmpty((Object)src)) {
            return new DefaultTablePrepare();
        }
        src = src.trim();
        ArrayList<String> pks = new ArrayList();
        if (BasicUtil.checkEl((String)src)) {
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:{JAVA\u5b9a\u4e49}] [src:{}]", (Object)src);
            }
            src = src.substring(2, src.length() - 1);
            src = this.parsePrimaryKey(src, pks);
            prepare = new DefaultTextPrepare(src);
        } else {
            Table table = DataSourceUtil.parseDest(src, null, null);
            String id = table.getId();
            pks = Column.names((LinkedHashMap)table.primarys());
            DriverAdapter adapter = this.adapter();
            src = table.getText();
            if (null != adapter) {
                prepare = adapter.buildRunPrepare(this.runtime(), src);
            }
            if (null == prepare && null != id && RegularUtil.match((String)id, (String)"(\\.|\\S)*\\S+:\\S+")) {
                if (ConfigTable.isSQLDebug()) {
                    this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:XML\u5b9a\u4e49] [src:{}]", (Object)src);
                }
                if (null == (prepare = DefaultSQLStore.parseSQL(id))) {
                    this.log.error("[\u89e3\u6790SQL\u7c7b\u578b][XML\u89e3\u6790\u5931\u8d25][src:{}]", (Object)src);
                }
            }
            if (null == prepare) {
                String chk = src;
                if (null != chk) {
                    chk = chk.replace("\n", "").replace("\r", "").trim().toLowerCase();
                }
                if (BasicUtil.isEmpty((Object)chk) || chk.matches("^[a-z]+$") || chk.matches("^[a-z]+.*\\)$")) {
                    prepare = new DefaultTablePrepare(table);
                    if (ConfigTable.isSQLDebug()) {
                        this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:auto] [src:{}]", (Object)src);
                    }
                } else {
                    prepare = new DefaultTextPrepare(src);
                    if (ConfigTable.isSQLDebug()) {
                        this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:JAVA\u5b9a\u4e49] [src:{}]", (Object)src);
                    }
                }
            }
        }
        if (null != prepare && null != pks && !pks.isEmpty()) {
            prepare.setPrimaryKey(pks);
        }
        return prepare;
    }

    protected DataSet queryFromCache(String cache, String dest, ConfigStore configs, String ... conditions) {
        return this.queryFromCache(cache, DataSourceUtil.parseDest(dest, configs), configs, conditions);
    }

    protected DataSet queryFromCache(String cache, Table dest, ConfigStore configs, String ... conditions) {
        if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
            this.log.debug("[cache from][cache:{}][dest:{}]", (Object)cache, (Object)dest);
        }
        DataSet set = null;
        String key = "SET:";
        if (cache.contains(">")) {
            String[] tmp = cache.split(">");
            cache = tmp[0];
        }
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, dest, configs, conditions);
        RunPrepare prepare = this.createRunPrepare(dest);
        if (null != CacheProxy.provider) {
            CacheElement cacheElement = CacheProxy.provider.get(cache, key);
            if (null != cacheElement && null != cacheElement.getValue()) {
                Object cacheValue = cacheElement.getValue();
                if (cacheValue instanceof DataSet) {
                    set = (DataSet)cacheValue;
                    set.setIsFromCache(true);
                } else {
                    this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef, \u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
                }
                long age = (System.currentTimeMillis() - cacheElement.getCreateTime()) / 1000L;
                final int _max = cacheElement.getExpires();
                if ((double)age > (double)_max * 0.9) {
                    if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
                        this.log.debug("[\u7f13\u5b58\u5373\u5c06\u5230\u671f\u63d0\u524d\u5237\u65b0][dest:{}] [\u751f\u5b58:{}/{}]", new Object[]{dest, age, _max});
                    }
                    final String _key = key;
                    final String _cache = cache;
                    final RunPrepare _sql = prepare;
                    final ConfigStore _configs = configs;
                    final String[] _conditions = conditions;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CacheUtil.start(_key, _max / 10);
                            DataSet newSet = DefaultService.this.dao.querys(_sql, _configs, _conditions);
                            CacheProxy.provider.put(_cache, _key, (Object)newSet);
                            CacheUtil.stop(_key, _max / 10);
                        }
                    }).start();
                }
            } else {
                this.setPageLazy(dest, configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
                CacheProxy.provider.put(cache, key, (Object)set);
            }
        }
        return set;
    }

    private ConfigStore append(ConfigStore configs, Object entity) {
        block7: {
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            if (null == entity) break block7;
            if (entity instanceof Map) {
                Map map = (Map)entity;
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof Collection) {
                        configs.ands(key.toString(), value);
                        continue;
                    }
                    configs.and(key.toString(), value);
                }
            } else {
                List fields = ClassUtil.getFields(entity.getClass(), (boolean)false, (boolean)false);
                for (Field field : fields) {
                    Object value = BeanUtil.getFieldValue((Object)entity, (Field)field);
                    if (!BasicUtil.isNotEmpty((boolean)true, (Object)value)) continue;
                    String key = field.getName();
                    key = EntityAdapterProxy.column(entity.getClass(), (Field)field, (boolean)true);
                    if (BasicUtil.isEmpty((Object)key)) continue;
                    if (value instanceof Collection) {
                        configs.ands(key, value);
                        continue;
                    }
                    configs.and(key, value);
                }
            }
        }
        return configs;
    }

    @Override
    public LinkedHashMap<String, Column> metadata(String sql, boolean comment, boolean condition) {
        if (condition) {
            String up = sql.toUpperCase().replace("\n", " ").replace("\t", "");
            String key = " WHERE ";
            boolean split = false;
            if (up.contains(key)) {
                int idx = sql.lastIndexOf(key);
                sql = sql.substring(0, idx) + " WHERE 1=0 AND " + sql.substring(idx + key.length());
                split = true;
            } else {
                key = " GROUP ";
                if (up.contains(key)) {
                    int idx = sql.lastIndexOf(key);
                    sql = sql.substring(0, idx) + " WHERE 1=0 GROUP " + sql.substring(idx + key.length());
                    split = true;
                } else {
                    key = " ORDER ";
                    if (up.contains(key)) {
                        int idx = sql.lastIndexOf(key);
                        sql = sql.substring(0, idx) + " WHERE 1=0 ORDER " + sql.substring(idx + key.length());
                        split = true;
                    }
                }
            }
            if (!split) {
                sql = sql + " WHERE 1=0";
            }
        }
        RunPrepare prepare = this.createRunPrepare(sql);
        LinkedHashMap<String, Column> metadata = this.dao.metadata(prepare, comment);
        return metadata;
    }

    @Override
    public List<String> tables(Catalog catalog, Schema schema, String name, int types) {
        LinkedHashMap tables = this.metadata.tables(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> views(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
        LinkedHashMap tables = this.metadata.views(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
        LinkedHashMap tables = this.metadata.masterTables(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> columns(boolean greedy, Table table) {
        LinkedHashMap columns = this.metadata.columns(greedy, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        return list;
    }

    @Override
    public List<String> tags(boolean greedy, Table table) {
        LinkedHashMap tags = this.metadata.tags(greedy, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Tag tag : tags.values()) {
            list.add(tag.getName());
        }
        return list;
    }

    @Override
    public boolean save(Table table) throws Exception {
        return this.ddl.save(table);
    }

    @Override
    public boolean save(Column column) throws Exception {
        return this.ddl.save(column);
    }

    @Override
    public boolean drop(Table table) throws Exception {
        return this.ddl.drop(table);
    }

    @Override
    public boolean drop(Column column) throws Exception {
        return this.ddl.drop(column);
    }

    @Override
    public AnylineService.MetaDataService metadata() {
        return this.metadata;
    }

    @Override
    public AnylineService.DDLService ddl() {
        return this.ddl;
    }
}

