/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.service;

import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.transaction.TransactionDefine;
import org.anyline.data.transaction.TransactionState;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.User;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.TransactionProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;

public interface AnylineService<E> {
    public AnylineService setDao(AnylineDao var1);

    public AnylineDao getDao();

    public String datasource();

    public DriverAdapter adapter();

    public DataRuntime runtime();

    default public boolean validity() {
        return DataSourceHolder.validity(this.datasource());
    }

    default public boolean hit() throws Exception {
        return DataSourceHolder.hit(this.datasource());
    }

    default public List<String> copy() {
        return DataSourceHolder.copy(this.datasource());
    }

    public long insert(int var1, String var2, Object var3, ConfigStore var4, List<String> var5);

    default public long insert(int batch, String dest, Object data, List<String> columns) {
        return this.insert(batch, dest, data, null, columns);
    }

    default public long insert(int batch, Object data, String ... columns) {
        return this.insert(batch, (String)null, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, Object data, ConfigStore configs, String ... columns) {
        return this.insert(batch, (String)null, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, String dest, Object data, String ... columns) {
        return this.insert(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.insert(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(String dest, Object data, List<String> columns) {
        return this.insert(0, dest, data, columns);
    }

    default public long insert(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.insert(0, dest, data, configs, columns);
    }

    default public long insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.insert(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Object data, String ... columns) {
        return this.insert((String)null, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Object data, ConfigStore configs, String ... columns) {
        return this.insert((String)null, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long insert(int var1, Table var2, Object var3, ConfigStore var4, List<String> var5);

    default public long insert(int batch, Table dest, Object data, List<String> columns) {
        return this.insert(batch, dest, data, null, columns);
    }

    default public long insert(int batch, Table dest, Object data, String ... columns) {
        return this.insert(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.insert(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Table dest, Object data, List<String> columns) {
        return this.insert(0, dest, data, columns);
    }

    default public long insert(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.insert(0, dest, data, configs, columns);
    }

    default public long insert(Table dest, Object data, String ... columns) {
        return this.insert(dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.insert(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long insert(Table var1, Table var2, ConfigStore var3, Object var4, String ... var5);

    default public long insert(Table dest, Table origin, Object obj, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)null, obj, conditions);
    }

    default public long insert(Table dest, Table origin, long first, long last, Object obj, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)new DefaultConfigStore(first, last), obj, conditions);
    }

    default public long insert(Table dest, Table origin, ConfigStore configs, String ... conditions) {
        return this.insert(dest, origin, configs, (Object)null, conditions);
    }

    default public long insert(Table dest, Table origin, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)null, (Object)null, conditions);
    }

    default public long insert(Table dest, Table origin, PageNavi navi, String ... conditions) {
        return this.insert(dest, origin, new DefaultConfigStore(new String[0]).setPageNavi(navi), (Object)null, conditions);
    }

    default public long insert(Table dest, Table origin, long first, long last, String ... conditions) {
        return this.insert(dest, origin, first, last, (Object)null, conditions);
    }

    default public long insert(String dest, String origin, ConfigStore configs, Object obj, String ... conditions) {
        return this.insert(new Table(dest), new Table(origin), configs, obj, conditions);
    }

    default public long insert(String dest, String origin, Object obj, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)null, obj, conditions);
    }

    default public long insert(String dest, String origin, long first, long last, Object obj, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)new DefaultConfigStore(first, last), obj, conditions);
    }

    default public long insert(String dest, String origin, ConfigStore configs, String ... conditions) {
        return this.insert(dest, origin, configs, (Object)null, conditions);
    }

    default public long insert(String dest, String origin, String ... conditions) {
        return this.insert(dest, origin, (ConfigStore)null, (Object)null, conditions);
    }

    default public long insert(String dest, String origin, PageNavi navi, String ... conditions) {
        return this.insert(dest, origin, new DefaultConfigStore(new String[0]).setPageNavi(navi), (Object)null, conditions);
    }

    default public long insert(String dest, String origin, long first, long last, String ... conditions) {
        return this.insert(dest, origin, first, last, (Object)null, conditions);
    }

    public long insert(Table var1, RunPrepare var2, ConfigStore var3, Object var4, String ... var5);

    default public long insert(Table dest, RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.insert(dest, prepare, configs, obj, conditions);
    }

    default public long insert(Table dest, RunPrepare prepare, Object obj, String ... conditions) {
        return this.insert(dest, prepare, (ConfigStore)null, obj, conditions);
    }

    default public long insert(Table dest, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.insert(dest, prepare, (ConfigStore)configs, obj, conditions);
    }

    default public long insert(Table dest, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.insert(dest, prepare, configs, (Object)null, conditions);
    }

    default public long insert(Table dest, RunPrepare prepare, String ... conditions) {
        return this.insert(dest, prepare, (ConfigStore)null, (Object)null, conditions);
    }

    default public long insert(Table dest, RunPrepare prepare, long first, long last, String ... conditions) {
        return this.insert(dest, prepare, first, last, (Object)null, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return this.insert(new Table(dest), prepare, configs, obj, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        return this.insert(new Table(dest), prepare, first, last, configs, obj, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, Object obj, String ... conditions) {
        return this.insert(dest, prepare, (ConfigStore)null, obj, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.insert(dest, prepare, (ConfigStore)configs, obj, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.insert(dest, prepare, configs, (Object)null, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, String ... conditions) {
        return this.insert(dest, prepare, (ConfigStore)null, (Object)null, conditions);
    }

    default public long insert(String dest, RunPrepare prepare, long first, long last, String ... conditions) {
        return this.insert(dest, prepare, first, last, (Object)null, conditions);
    }

    public long update(int var1, String var2, Object var3, ConfigStore var4, List<String> var5);

    default public long update(int batch, String dest, Object data, String ... columns) {
        return this.update(batch, dest, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, Object data, String ... columns) {
        return this.update(batch, (String)null, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, Object data, ConfigStore configs, String ... columns) {
        return this.update(batch, (String)null, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(0, dest, data, configs, columns);
    }

    default public long update(String dest, Object data, String ... columns) {
        return this.update(dest, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Object data, String ... columns) {
        return this.update((String)null, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Object data, ConfigStore configs, String ... columns) {
        return this.update((String)null, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long update(int var1, Table var2, Object var3, ConfigStore var4, List<String> var5);

    default public long update(int batch, Table dest, Object data, String ... columns) {
        return this.update(batch, dest, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(0, dest, data, configs, columns);
    }

    default public long update(Table dest, Object data, String ... columns) {
        return this.update(dest, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long save(int var1, String var2, Object var3, ConfigStore var4, List<String> var5);

    default public long save(int batch, String dest, Object data, List<String> columns) {
        return this.save(batch, dest, data, null, columns);
    }

    default public long save(int batch, String dest, Object data, String ... columns) {
        return this.save(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.save(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(int batch, Object data, String ... columns) {
        return this.save(batch, (String)null, data, columns);
    }

    default public long save(int batch, Object data, ConfigStore configs, String ... columns) {
        return this.save(batch, (String)null, data, configs, columns);
    }

    default public long save(String dest, Object data, List<String> columns) {
        return this.save(0, dest, data, columns);
    }

    default public long save(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(0, dest, data, configs, columns);
    }

    default public long save(String dest, Object data, String ... columns) {
        return this.save(dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.save(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(Object data, String ... columns) {
        return this.save((String)null, data, columns);
    }

    default public long save(Object data, ConfigStore configs, String ... columns) {
        return this.save((String)null, data, configs, columns);
    }

    default public long save(Object data, List<String> columns) {
        return this.save((String)null, data, columns);
    }

    default public long save(Object data, ConfigStore configs, List<String> columns) {
        return this.save((String)null, data, configs, columns);
    }

    public long save(int var1, Table var2, Object var3, ConfigStore var4, List<String> var5);

    default public long save(int batch, Table dest, Object data, List<String> columns) {
        return this.save(batch, dest, data, null, columns);
    }

    default public long save(int batch, Table dest, Object data, String ... columns) {
        return this.save(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.save(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(Table dest, Object data, List<String> columns) {
        return this.save(0, dest, data, columns);
    }

    default public long save(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(0, dest, data, configs, columns);
    }

    default public long save(Table dest, Object data, String ... columns) {
        return this.save(dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.save(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public DataSet querys(String var1, ConfigStore var2, Object var3, String ... var4);

    default public DataSet querys(ConfigStore configs, Object obj, String ... conditions) {
        return this.querys((String)null, configs, obj, conditions);
    }

    default public DataSet querys(ConfigStore configs, String ... conditions) {
        return this.querys((String)null, configs, (Object)null, conditions);
    }

    default public DataSet querys(DataSet set, ConfigStore configs) {
        if (null != configs) {
            PageNavi navi;
            List<Config> list;
            ConfigChain chain = configs.getConfigChain();
            if (null != chain && null != (list = chain.getConfigs())) {
                for (Config config : list) {
                    set = set.select.filter(config.getCompare(), config.getVariable(), config.getValues());
                }
            }
            if (null != (navi = configs.getPageNavi())) {
                set = set.getRows(navi, new String[0]);
            }
        }
        return set;
    }

    default public DataSet querys(String dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(dest, configs, obj, conditions);
    }

    default public DataSet querys(String dest, Object obj, String ... conditions) {
        return this.querys(dest, (ConfigStore)null, obj, conditions);
    }

    default public void querys(String dest, DataHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String dest, PageNavi navi, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String dest, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String dest, ConfigStore configs, String ... conditions) {
        return this.querys(dest, configs, (Object)null, conditions);
    }

    default public DataSet querys(String dest, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(dest, configs, conditions);
    }

    default public DataSet querys(String dest, String ... conditions) {
        return this.querys(dest, (Object)null, conditions);
    }

    default public void querys(String dest, DataHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(dest, (ConfigStore)configs, conditions);
    }

    default public DataSet querys(String dest, PageNavi navi, String ... conditions) {
        return this.querys(dest, navi, (Object)null, conditions);
    }

    default public DataSet querys(String dest, long first, long last, String ... conditions) {
        return this.querys(dest, first, last, (ConfigStore)null, conditions);
    }

    default public DataSet querys(String dest, DataHandler handler, long first, long last, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        configs.handler(handler);
        return this.querys(dest, first, last, (ConfigStore)configs, conditions);
    }

    public DataSet querys(Table var1, ConfigStore var2, Object var3, String ... var4);

    default public DataSet querys(Table dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(dest, configs, obj, conditions);
    }

    default public DataSet querys(Table dest, Object obj, String ... conditions) {
        return this.querys(dest, (ConfigStore)null, obj, conditions);
    }

    default public void querys(Table dest, DataHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(Table dest, PageNavi navi, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(Table dest, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.querys(dest, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(Table dest, ConfigStore configs, String ... conditions) {
        return this.querys(dest, configs, (Object)null, conditions);
    }

    default public DataSet querys(Table dest, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(dest, configs, conditions);
    }

    default public DataSet querys(Table dest, String ... conditions) {
        return this.querys(dest, (Object)null, conditions);
    }

    default public void querys(Table dest, DataHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(dest, (ConfigStore)configs, conditions);
    }

    default public DataSet querys(Table dest, PageNavi navi, String ... conditions) {
        return this.querys(dest, navi, (Object)null, conditions);
    }

    default public DataSet querys(Table dest, long first, long last, String ... conditions) {
        return this.querys(dest, first, last, (ConfigStore)null, conditions);
    }

    default public DataSet querys(Table dest, DataHandler handler, long first, long last, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        configs.handler(handler);
        return this.querys(dest, first, last, (ConfigStore)configs, conditions);
    }

    public DataRow query(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    public DataRow query(String var1, ConfigStore var2, Object var3, String ... var4);

    default public DataRow query(ConfigStore configs, Object obj, String ... conditions) {
        return this.query((String)null, configs, obj, conditions);
    }

    default public DataRow query(ConfigStore configs, String ... conditions) {
        return this.query((String)null, configs, (Object)null, conditions);
    }

    default public DataRow query(String dest, Object obj, String ... conditions) {
        return this.query(dest, null, obj, conditions);
    }

    default public DataRow query(String dest, ConfigStore configs, String ... conditions) {
        return this.query(dest, configs, (Object)null, conditions);
    }

    default public DataRow query(String dest, String ... conditions) {
        return this.query(dest, (ConfigStore)null, conditions);
    }

    default public DataRow query(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.query(prepare, configs, (Object)null, conditions);
    }

    default public DataRow query(RunPrepare prepare, Object obj, String ... conditions) {
        return this.query(prepare, null, obj, conditions);
    }

    default public DataRow query(RunPrepare prepare, String ... conditions) {
        return this.query(prepare, null, (Object)null, conditions);
    }

    public DataRow query(Table var1, ConfigStore var2, Object var3, String ... var4);

    default public DataRow query(Table dest, Object obj, String ... conditions) {
        return this.query(dest, null, obj, conditions);
    }

    default public DataRow query(Table dest, ConfigStore configs, String ... conditions) {
        return this.query(dest, configs, (Object)null, conditions);
    }

    default public DataRow query(Table dest, String ... conditions) {
        return this.query(dest, (ConfigStore)null, conditions);
    }

    public BigDecimal sequence(boolean var1, String var2);

    default public BigDecimal sequence(String name) {
        return this.sequence(true, name);
    }

    public DataRow sequences(boolean var1, String ... var2);

    default public DataRow sequences(String ... names) {
        return this.sequences(true, names);
    }

    public <T> EntitySet<T> selects(String var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, T entity, String ... conditions) {
        return this.selects(dest, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(dest, clazz, configs, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(dest, clazz, navi, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, String ... conditions) {
        return this.selects(dest, clazz, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(dest, clazz, (ConfigStore)configs, conditions);
    }

    default public <T> EntitySet<T> selects(String dest, Class<T> clazz, long first, long last, String ... conditions) {
        return this.selects(dest, clazz, first, last, (T)null, conditions);
    }

    public <T> EntitySet<T> selects(Table var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, T entity, String ... conditions) {
        return this.selects(dest, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.selects(dest, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(dest, clazz, configs, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(dest, clazz, navi, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, String ... conditions) {
        return this.selects(dest, clazz, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(dest, clazz, (ConfigStore)configs, conditions);
    }

    default public <T> EntitySet<T> selects(Table dest, Class<T> clazz, long first, long last, String ... conditions) {
        return this.selects(dest, clazz, first, last, (T)null, conditions);
    }

    public <T> T select(String var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> T select(String dest, Class<T> clazz, T entity, String ... conditions) {
        return this.select(dest, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> T select(String dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(dest, clazz, configs, (T)null, conditions);
    }

    default public <T> T select(String dest, Class<T> clazz, String ... conditions) {
        return this.select(dest, clazz, (T)null, conditions);
    }

    public <T> T select(Table var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> T select(Table dest, Class<T> clazz, T entity, String ... conditions) {
        return this.select(dest, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> T select(Table dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(dest, clazz, configs, (T)null, conditions);
    }

    default public <T> T select(Table dest, Class<T> clazz, String ... conditions) {
        return this.select(dest, clazz, (T)null, conditions);
    }

    public <T> EntitySet<T> selects(Class<T> var1, ConfigStore var2, T var3, String ... var4);

    default public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, T entity, String ... conditions) {
        return this.selects(clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, long first, long last, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    public <T> T select(Class<T> var1, ConfigStore var2, T var3, String ... var4);

    default public <T> T select(Class<T> clazz, T entity, String ... conditions) {
        return this.select(clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(clazz, configs, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(clazz, navi, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, String ... conditions) {
        return this.selects(clazz, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.selects(clazz, (ConfigStore)configs, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, long first, long last, String ... conditions) {
        return this.selects(clazz, first, last, (T)null, conditions);
    }

    default public <T> T select(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(clazz, configs, (T)null, conditions);
    }

    default public <T> T select(Class<T> clazz, String ... conditions) {
        return this.select(clazz, (T)null, conditions);
    }

    public EntitySet<E> gets(ConfigStore var1, String ... var2);

    default public EntitySet<E> gets(PageNavi navi, String ... conditions) {
        return this.gets(new DefaultConfigStore(new String[0]).setPageNavi(navi), conditions);
    }

    default public EntitySet<E> gets(String ... conditions) {
        return this.gets((ConfigStore)null, conditions);
    }

    default public EntitySet<E> gets(EntityHandler<E> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        return this.gets(configs, conditions);
    }

    default public EntitySet<E> gets(long first, long last, String ... conditions) {
        return this.gets(new DefaultConfigStore(first, last), conditions);
    }

    public E get(ConfigStore var1, String ... var2);

    default public E get(String ... conditions) {
        return this.get((ConfigStore)null, conditions);
    }

    public List<Map<String, Object>> maps(String var1, ConfigStore var2, Object var3, String ... var4);

    default public List<Map<String, Object>> maps(ConfigStore configs, Object obj, String ... conditions) {
        return this.maps((String)null, configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(ConfigStore configs, String ... conditions) {
        return this.maps((String)null, configs, (Object)null, conditions);
    }

    default public void maps(String dest, DataHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.maps(dest, (ConfigStore)configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, Object obj, String ... conditions) {
        return this.maps(dest, (ConfigStore)null, obj, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, long first, long last, Object obj, String ... conditions) {
        return this.maps(dest, (ConfigStore)new DefaultConfigStore(first, last), obj, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, ConfigStore configs, String ... conditions) {
        return this.maps(dest, configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, String ... conditions) {
        return this.maps(dest, (ConfigStore)null, (Object)null, conditions);
    }

    default public void maps(String dest, DataHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.maps(dest, (ConfigStore)configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, PageNavi navi, String ... conditions) {
        return this.maps(dest, new DefaultConfigStore(new String[0]).setPageNavi(navi), (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, long first, long last, String ... conditions) {
        return this.maps(dest, first, last, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String dest, DataHandler handler, long first, long last, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        configs.handler(handler);
        return this.maps(dest, first, last, (Object)conditions, conditions);
    }

    public List<Map<String, Object>> maps(Table var1, ConfigStore var2, Object var3, String ... var4);

    default public void maps(Table dest, DataHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.maps(dest, (ConfigStore)configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, Object obj, String ... conditions) {
        return this.maps(dest, (ConfigStore)null, obj, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, long first, long last, Object obj, String ... conditions) {
        return this.maps(dest, (ConfigStore)new DefaultConfigStore(first, last), obj, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, ConfigStore configs, String ... conditions) {
        return this.maps(dest, configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, String ... conditions) {
        return this.maps(dest, (ConfigStore)null, (Object)null, conditions);
    }

    default public void maps(Table dest, DataHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.maps(dest, (ConfigStore)configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, PageNavi navi, String ... conditions) {
        return this.maps(dest, new DefaultConfigStore(new String[0]).setPageNavi(navi), (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, long first, long last, String ... conditions) {
        return this.maps(dest, first, last, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(Table dest, DataHandler handler, long first, long last, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        configs.handler(handler);
        return this.maps(dest, first, last, (Object)configs, conditions);
    }

    public List<Map<String, Object>> maps(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    default public List<Map<String, Object>> maps(RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.maps(prepare, configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(RunPrepare prepare, Object obj, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, obj, conditions);
    }

    default public void maps(RunPrepare prepare, StreamHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.maps(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.maps(prepare, configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(RunPrepare prepare, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, (Object)null, conditions);
    }

    default public void maps(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.maps(prepare, (ConfigStore)configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(RunPrepare prepare, long first, long last, String ... conditions) {
        return this.maps(prepare, first, last, (Object)null, conditions);
    }

    public List<String> column2param(String var1);

    public DataSet caches(String var1, String var2, ConfigStore var3, Object var4, String ... var5);

    default public DataSet caches(String cache, String dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, dest, configs, obj, conditions);
    }

    default public DataSet caches(String cache, String dest, Object obj, String ... conditions) {
        return this.caches(cache, dest, null, obj, conditions);
    }

    default public DataSet caches(String cache, String dest, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.caches(cache, dest, (ConfigStore)configs, obj, conditions);
    }

    public DataSet caches(String var1, Table var2, ConfigStore var3, Object var4, String ... var5);

    default public DataSet caches(String cache, Table dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, dest, configs, obj, conditions);
    }

    default public DataSet caches(String cache, Table dest, Object obj, String ... conditions) {
        return this.caches(cache, dest, null, obj, conditions);
    }

    default public DataSet caches(String cache, Table dest, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.caches(cache, dest, (ConfigStore)configs, obj, conditions);
    }

    public DataRow cache(String var1, String var2, ConfigStore var3, Object var4, String ... var5);

    default public DataRow cache(String cache, String dest, Object obj, String ... conditions) {
        return this.cache(cache, dest, null, obj, conditions);
    }

    default public DataSet caches(String cache, String dest, ConfigStore configs, String ... conditions) {
        return this.caches(cache, dest, configs, (Object)null, conditions);
    }

    default public DataSet caches(String cache, String dest, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, dest, configs, conditions);
    }

    default public DataSet caches(String cache, String dest, String ... conditions) {
        return this.caches(cache, dest, null, (Object)null, conditions);
    }

    default public DataSet caches(String cache, String dest, long first, long last, String ... conditions) {
        return this.caches(cache, dest, first, last, (ConfigStore)null, conditions);
    }

    default public DataRow cache(String cache, String dest, ConfigStore configs, String ... conditions) {
        return this.cache(cache, dest, configs, (Object)null, conditions);
    }

    default public DataRow cache(String cache, String dest, String ... conditions) {
        return this.cache(cache, dest, null, (Object)null, conditions);
    }

    public DataRow cache(String var1, Table var2, ConfigStore var3, Object var4, String ... var5);

    default public DataRow cache(String cache, Table dest, Object obj, String ... conditions) {
        return this.cache(cache, dest, null, obj, conditions);
    }

    default public DataSet caches(String cache, Table dest, ConfigStore configs, String ... conditions) {
        return this.caches(cache, dest, configs, (Object)null, conditions);
    }

    default public DataSet caches(String cache, Table dest, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, dest, configs, conditions);
    }

    default public DataSet caches(String cache, Table dest, String ... conditions) {
        return this.caches(cache, dest, null, (Object)null, conditions);
    }

    default public DataSet caches(String cache, Table dest, long first, long last, String ... conditions) {
        return this.caches(cache, dest, first, last, (ConfigStore)null, conditions);
    }

    default public DataRow cache(String cache, Table dest, ConfigStore configs, String ... conditions) {
        return this.cache(cache, dest, configs, (Object)null, conditions);
    }

    default public DataRow cache(String cache, Table dest, String ... conditions) {
        return this.cache(cache, dest, null, (Object)null, conditions);
    }

    public DataSet querys(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    default public DataSet querys(RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(prepare, configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, Object obj, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, obj, conditions);
    }

    default public void querys(RunPrepare prepare, StreamHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, (Object)null, conditions);
    }

    default public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, (Object)null, conditions);
    }

    default public void querys(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.handler(handler);
        this.querys(prepare, (ConfigStore)configs, (Object)null, conditions);
    }

    default public DataSet querys(RunPrepare prepare, long first, long last, String ... conditions) {
        return this.querys(prepare, first, last, (Object)null, conditions);
    }

    public DataSet caches(String var1, RunPrepare var2, ConfigStore var3, Object var4, String ... var5);

    default public DataSet caches(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return this.caches(cache, prepare, null, obj, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.caches(cache, prepare, (ConfigStore)configs, obj, conditions);
    }

    public DataRow cache(String var1, RunPrepare var2, ConfigStore var3, Object var4, String ... var5);

    default public DataRow cache(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return this.cache(cache, prepare, null, obj, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.caches(cache, prepare, configs, (Object)null, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, String ... conditions) {
        return this.caches(cache, prepare, null, (Object)null, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, long first, long last, String ... conditions) {
        return this.caches(cache, prepare, first, last, (Object)null, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.cache(cache, prepare, configs, (Object)null, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.cache(cache, prepare, configs, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, String ... conditions) {
        return this.cache(cache, prepare, null, (Object)null, conditions);
    }

    public boolean removeCache(String var1, String var2, ConfigStore var3, String ... var4);

    default public boolean removeCache(String channel, String dest, String ... conditions) {
        return this.removeCache(channel, dest, (ConfigStore)null, conditions);
    }

    default public boolean removeCache(String channel, String dest, long first, long last, String ... conditions) {
        return this.removeCache(channel, dest, (ConfigStore)new DefaultConfigStore(first, last), conditions);
    }

    public boolean removeCache(String var1, Table var2, ConfigStore var3, String ... var4);

    default public boolean removeCache(String channel, Table dest, String ... conditions) {
        return this.removeCache(channel, dest, (ConfigStore)null, conditions);
    }

    default public boolean removeCache(String channel, Table dest, long first, long last, String ... conditions) {
        return this.removeCache(channel, dest, (ConfigStore)new DefaultConfigStore(first, last), conditions);
    }

    public boolean clearCache(String var1);

    public boolean clearCaches();

    public boolean exists(String var1, ConfigStore var2, Object var3, String ... var4);

    default public boolean exists(String dest, Object obj, String ... conditions) {
        return this.exists(dest, null, obj, conditions);
    }

    default public boolean exists(String dest, ConfigStore configs, String ... conditions) {
        return this.exists(dest, configs, (Object)null, conditions);
    }

    default public boolean exists(String dest, String ... conditions) {
        return this.exists(dest, null, (Object)null, conditions);
    }

    public boolean exists(String var1, DataRow var2);

    default public boolean exists(DataRow row) {
        return this.exists((String)null, row);
    }

    public boolean exists(Table var1, ConfigStore var2, Object var3, String ... var4);

    default public boolean exists(Table dest, Object obj, String ... conditions) {
        return this.exists(dest, null, obj, conditions);
    }

    default public boolean exists(Table dest, ConfigStore configs, String ... conditions) {
        return this.exists(dest, configs, (Object)null, conditions);
    }

    default public boolean exists(Table dest, String ... conditions) {
        return this.exists(dest, null, (Object)null, conditions);
    }

    public boolean exists(Table var1, DataRow var2);

    public long count(String var1, ConfigStore var2, Object var3, String ... var4);

    default public long count(String dest, Object obj, String ... conditions) {
        return this.count(dest, null, obj, conditions);
    }

    default public long count(String dest, ConfigStore configs, String ... conditions) {
        return this.count(dest, configs, (Object)null, conditions);
    }

    default public long count(String dest, String ... conditions) {
        return this.count(dest, null, (Object)null, conditions);
    }

    public long count(Table var1, ConfigStore var2, Object var3, String ... var4);

    default public long count(Table dest, Object obj, String ... conditions) {
        return this.count(dest, null, obj, conditions);
    }

    default public long count(Table dest, ConfigStore configs, String ... conditions) {
        return this.count(dest, configs, (Object)null, conditions);
    }

    default public long count(Table dest, String ... conditions) {
        return this.count(dest, null, (Object)null, conditions);
    }

    public long count(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    default public long count(RunPrepare prepare, Object obj, String ... conditions) {
        return this.count(prepare, null, obj, conditions);
    }

    default public long count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.count(prepare, configs, (Object)null, conditions);
    }

    default public long count(RunPrepare prepare, String ... conditions) {
        return this.count(prepare, null, (Object)null, conditions);
    }

    public boolean execute(Procedure var1, String ... var2);

    public long execute(String var1, ConfigStore var2, String ... var3);

    default public long execute(String dest, String ... conditions) {
        return this.execute(dest, (ConfigStore)null, conditions);
    }

    default public int[] execute(File file, Charset charset, boolean brk) {
        String txt = FileUtil.read((File)file).toString();
        return this.execute(txt, brk);
    }

    default public int[] execute(File file, boolean brk) {
        return this.execute(file, StandardCharsets.UTF_8, brk);
    }

    default public int[] execute(String txt, boolean brk) {
        String[] sqls;
        int success = 0;
        int fail = 0;
        for (String sql : sqls = txt.split(";")) {
            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
            try {
                this.execute(sql, new String[0]);
                ++success;
            }
            catch (Exception e) {
                ++fail;
                e.printStackTrace();
                if (brk) break;
            }
        }
        return new int[]{success, fail};
    }

    public long execute(int var1, String var2, Collection<Object> var3);

    public long execute(int var1, int var2, String var3, Collection<Object> var4);

    default public boolean executeProcedure(String procedure, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        for (String input : inputs) {
            proc.addInput(input);
        }
        return this.execute(proc, new String[0]);
    }

    public DataSet querys(Procedure var1, PageNavi var2, String ... var3);

    default public DataSet querysProcedure(String procedure, long first, long last, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        return this.querysProcedure(procedure, (PageNavi)navi, inputs);
    }

    default public DataSet querysProcedure(String procedure, PageNavi navi, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        if (null != inputs) {
            for (String input : inputs) {
                proc.addInput(input);
            }
        }
        return this.querys(proc, navi, new String[0]);
    }

    default public DataSet querysProcedure(String procedure, String ... inputs) {
        return this.querysProcedure(procedure, (PageNavi)null, inputs);
    }

    default public DataSet querys(Procedure procedure, String ... inputs) {
        return this.querys(procedure, (PageNavi)null, inputs);
    }

    default public DataSet querys(Procedure procedure, long first, long last, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        return this.querys(procedure, (PageNavi)navi, inputs);
    }

    default public DataRow queryProcedure(String procedure, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        return this.query(procedure, inputs);
    }

    public DataRow query(Procedure var1, String ... var2);

    public long delete(String var1, ConfigStore var2, String ... var3);

    default public long delete(ConfigStore configs, String ... conditions) {
        return this.delete((String)null, configs, conditions);
    }

    default public long delete(ConfigStore configs) {
        return this.delete((String)null, configs, new String[0]);
    }

    public long delete(Table var1, ConfigStore var2, String ... var3);

    public long delete(String var1, DataSet var2, String ... var3);

    public long delete(Table var1, DataSet var2, String ... var3);

    default public long delete(DataSet set, String ... columns) {
        return this.delete((Table)null, set, columns);
    }

    public long delete(String var1, DataRow var2, String ... var3);

    public long delete(Table var1, DataRow var2, String ... var3);

    public long delete(Object var1, String ... var2);

    public long delete(String var1, String ... var2);

    public long delete(Table var1, String ... var2);

    public long delete(Table var1, Collection var2);

    public long delete(String var1, Collection var2);

    public <T> long deletes(int var1, String var2, String var3, Collection<T> var4);

    public <T> long deletes(int var1, Table var2, String var3, Collection<T> var4);

    default public <T> long deletes(String table, String key, Collection<T> values) {
        return this.deletes(0, table, key, values);
    }

    default public <T> long deletes(Table table, String key, Collection<T> values) {
        return this.deletes(0, table, key, values);
    }

    public <T> long deletes(int var1, String var2, String var3, T ... var4);

    public <T> long deletes(int var1, Table var2, String var3, T ... var4);

    default public <T> long deletes(String table, String key, T ... values) {
        return this.deletes(0, table, key, values);
    }

    default public <T> long deletes(Table table, String key, T ... values) {
        return this.deletes(0, table, key, values);
    }

    public long truncate(String var1);

    public long truncate(Table var1);

    public List<String> tables(Catalog var1, Schema var2, String var3, int var4);

    default public List<String> tables(String catalog, String schema, String name, int types) {
        Catalog _catalog = null;
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            _catalog = new Catalog(catalog);
        }
        return this.tables(_catalog, new Schema(schema), name, types);
    }

    default public List<String> tables(Schema schema, String name, int types) {
        return this.tables(null, schema, name, types);
    }

    default public List<String> tables(String schema, String name, int types) {
        return this.tables(null, new Schema(schema), name, types);
    }

    default public List<String> tables(String name, int types) {
        return this.tables((Catalog)null, null, name, types);
    }

    default public List<String> tables(int types) {
        return this.tables((Catalog)null, null, null, types);
    }

    default public List<String> tables() {
        return this.tables(Table.TYPE.NORMAL.value);
    }

    public List<String> views(boolean var1, Catalog var2, Schema var3, String var4, int var5);

    default public List<String> views(boolean greedy, Schema schema, String name, int types) {
        return this.views(greedy, null, schema, name, types);
    }

    default public List<String> views(boolean greedy, String name, int types) {
        return this.views(greedy, null, null, name, types);
    }

    default public List<String> views(boolean greedy, int types) {
        return this.views(greedy, null, null, null, types);
    }

    default public List<String> views(boolean greedy) {
        return this.views(greedy, View.TYPE.NORMAL.value);
    }

    default public List<String> views(Catalog catalog, Schema schema, String name, int types) {
        return this.views(false, catalog, schema, name, types);
    }

    default public List<String> views(Schema schema, String name, int types) {
        return this.views(false, null, schema, name, types);
    }

    default public List<String> views(String name, int types) {
        return this.views(false, null, null, name, types);
    }

    default public List<String> views(int types) {
        return this.views(false, null, null, null, types);
    }

    default public List<String> views() {
        return this.views(false, View.TYPE.NORMAL.value);
    }

    public List<String> masterTables(boolean var1, Catalog var2, Schema var3, String var4, int var5);

    default public List<String> masterTables(boolean greedy, Schema schema, String name, int types) {
        return this.masterTables(greedy, null, schema, name, types);
    }

    default public List<String> masterTables(boolean greedy, String name, int types) {
        return this.masterTables(greedy, null, null, name, types);
    }

    default public List<String> masterTables(boolean greedy, int types) {
        return this.masterTables(greedy, null, null, null, types);
    }

    default public List<String> masterTables(boolean greedy) {
        return this.masterTables(greedy, MasterTable.TYPE.NORMAL.value);
    }

    default public List<String> masterTables(Catalog catalog, Schema schema, String name, int types) {
        return this.masterTables(false, catalog, schema, name, types);
    }

    default public List<String> masterTables(Schema schema, String name, int types) {
        return this.masterTables(false, null, schema, name, types);
    }

    default public List<String> masterTables(String name, int types) {
        return this.masterTables(false, null, null, name, types);
    }

    default public List<String> masterTables(int types) {
        return this.masterTables(false, null, null, null, types);
    }

    default public List<String> masterTables() {
        return this.masterTables(false, MasterTable.TYPE.NORMAL.value);
    }

    public List<String> columns(boolean var1, Table var2);

    default public List<String> columns(boolean greedy, String table) {
        return this.columns(greedy, (Catalog)null, null, table);
    }

    default public List<String> columns(boolean greedy, Catalog catalog, Schema schema, String table) {
        return this.columns(greedy, new Table(catalog, schema, table));
    }

    default public List<String> columns(boolean greedy, String catalog, String schema, String table) {
        return this.columns(greedy, new Table(catalog, schema, table));
    }

    default public List<String> columns(Table table) {
        return this.columns(false, table);
    }

    default public List<String> columns(String table) {
        return this.columns(false, (Catalog)null, null, table);
    }

    default public List<String> columns(Catalog catalog, Schema schema, String table) {
        return this.columns(false, catalog, schema, table);
    }

    public List<String> tags(boolean var1, Table var2);

    default public List<String> tags(boolean greedy, Catalog catalog, Schema schema, String table) {
        return this.tags(greedy, new Table(catalog, schema, table));
    }

    default public List<String> tags(boolean greedy, String table) {
        return this.tags(greedy, null, null, table);
    }

    default public List<String> tags(Table table) {
        return this.tags(false, table);
    }

    default public List<String> tags(String table) {
        return this.tags(false, new Table(table));
    }

    default public List<String> tags(Catalog catalog, Schema schema, String table) {
        return this.tags(false, new Table(catalog, schema, table));
    }

    public boolean save(Table var1) throws Exception;

    public boolean save(Column var1) throws Exception;

    public boolean drop(Table var1) throws Exception;

    public boolean drop(Column var1) throws Exception;

    public DDLService ddl();

    public MetaDataService metadata();

    public LinkedHashMap<String, Column> metadata(String var1, boolean var2, boolean var3);

    default public LinkedHashMap<String, Column> metadata(String sql) {
        return this.metadata(sql, false, false);
    }

    public ConfigStore condition();

    default public TransactionState start(TransactionDefine define) throws Exception {
        return TransactionProxy.start(this.datasource(), define);
    }

    default public TransactionState start() throws Exception {
        return TransactionProxy.start(this.datasource());
    }

    default public TransactionState start(int behavior) throws Exception {
        return TransactionProxy.start(this.datasource(), behavior);
    }

    default public void commit(TransactionState state) throws Exception {
        TransactionProxy.commit(state);
    }

    default public void rollback(TransactionState state) throws Exception {
        TransactionProxy.rollback(state);
    }

    public List<Run> ddl(MetadataDiffer var1);

    public List<Run> ddl(List<MetadataDiffer> var1);

    public static interface Authorize {
        public boolean create(User var1);

        default public boolean create(String name, String password) {
            return this.create(new User(name, password));
        }

        public boolean rename(User var1, User var2);

        default public boolean rename(String origin, String update) {
            return this.rename(new User(origin), new User(update));
        }

        public boolean delete(User var1);

        default public boolean delete(String user) {
            return this.delete(new User(user));
        }

        public boolean grant(User var1, Privilege ... var2);

        default public boolean grant(String user, Privilege ... privileges) {
            return this.grant(new User(user), privileges);
        }

        public List<Privilege> privileges(User var1);

        default public List<Privilege> privileges(String user) {
            return this.privileges(new User(user));
        }

        public boolean revoke(User var1, Privilege ... var2);

        default public boolean revoke(String user, Privilege ... privileges) {
            return this.revoke(new User(user), privileges);
        }
    }

    public static interface DDLService {
        public boolean save(Table var1) throws Exception;

        public boolean create(Table var1) throws Exception;

        public boolean alter(Table var1) throws Exception;

        public boolean drop(Table var1) throws Exception;

        public boolean rename(Table var1, String var2) throws Exception;

        public boolean save(View var1) throws Exception;

        public boolean create(View var1) throws Exception;

        public boolean alter(View var1) throws Exception;

        public boolean drop(View var1) throws Exception;

        public boolean rename(View var1, String var2) throws Exception;

        public boolean save(MasterTable var1) throws Exception;

        public boolean create(MasterTable var1) throws Exception;

        public boolean alter(MasterTable var1) throws Exception;

        public boolean drop(MasterTable var1) throws Exception;

        public boolean rename(MasterTable var1, String var2) throws Exception;

        public boolean save(PartitionTable var1) throws Exception;

        public boolean create(PartitionTable var1) throws Exception;

        public boolean alter(PartitionTable var1) throws Exception;

        public boolean drop(PartitionTable var1) throws Exception;

        public boolean rename(PartitionTable var1, String var2) throws Exception;

        public boolean save(Column var1) throws Exception;

        public boolean add(Column var1) throws Exception;

        public boolean alter(Column var1) throws Exception;

        public boolean drop(Column var1) throws Exception;

        public boolean rename(Column var1, String var2) throws Exception;

        public boolean save(Tag var1) throws Exception;

        public boolean add(Tag var1) throws Exception;

        public boolean alter(Tag var1) throws Exception;

        public boolean drop(Tag var1) throws Exception;

        public boolean rename(Tag var1, String var2) throws Exception;

        public boolean add(PrimaryKey var1) throws Exception;

        public boolean alter(PrimaryKey var1) throws Exception;

        public boolean drop(PrimaryKey var1) throws Exception;

        public boolean rename(PrimaryKey var1, String var2) throws Exception;

        public boolean add(ForeignKey var1) throws Exception;

        public boolean alter(ForeignKey var1) throws Exception;

        public boolean drop(ForeignKey var1) throws Exception;

        public boolean rename(ForeignKey var1, String var2) throws Exception;

        public boolean add(Index var1) throws Exception;

        public boolean alter(Index var1) throws Exception;

        public boolean drop(Index var1) throws Exception;

        public boolean rename(Index var1, String var2) throws Exception;

        public boolean add(Constraint var1) throws Exception;

        public boolean alter(Constraint var1) throws Exception;

        public boolean drop(Constraint var1) throws Exception;

        public boolean rename(Constraint var1, String var2) throws Exception;

        public boolean create(Trigger var1) throws Exception;

        public boolean alter(Trigger var1) throws Exception;

        public boolean drop(Trigger var1) throws Exception;

        public boolean rename(Trigger var1, String var2) throws Exception;

        public boolean create(Procedure var1) throws Exception;

        public boolean alter(Procedure var1) throws Exception;

        public boolean drop(Procedure var1) throws Exception;

        public boolean rename(Procedure var1, String var2) throws Exception;

        public boolean create(Function var1) throws Exception;

        public boolean alter(Function var1) throws Exception;

        public boolean drop(Function var1) throws Exception;

        public boolean rename(Function var1, String var2) throws Exception;

        public boolean create(Sequence var1) throws Exception;

        public boolean alter(Sequence var1) throws Exception;

        public boolean drop(Sequence var1) throws Exception;

        public boolean rename(Sequence var1, String var2) throws Exception;
    }

    public static interface MetaDataService {
        public DatabaseType type();

        public String version();

        public String product();

        public Database database();

        public LinkedHashMap<String, Database> databases(String var1);

        default public LinkedHashMap<String, Database> databases() {
            return this.databases(null);
        }

        public List<Database> databases(boolean var1, String var2);

        default public List<Database> databases(boolean greedy) {
            return this.databases(greedy, null);
        }

        public Database database(String var1);

        public Catalog catalog();

        public LinkedHashMap<String, Catalog> catalogs(String var1);

        default public LinkedHashMap<String, Catalog> catalogs() {
            return this.catalogs(null);
        }

        public List<Catalog> catalogs(boolean var1, String var2);

        default public List<Catalog> catalogs(boolean greedy) {
            return this.catalogs(greedy, null);
        }

        public Schema schema();

        public LinkedHashMap<String, Schema> schemas(Catalog var1, String var2);

        default public LinkedHashMap<String, Schema> schemas(Catalog catalog) {
            return this.schemas(catalog, null);
        }

        default public LinkedHashMap<String, Schema> schemas() {
            return this.schemas(null, null);
        }

        default public LinkedHashMap<String, Schema> schemas(String name) {
            return this.schemas(null, name);
        }

        public List<Schema> schemas(boolean var1, Catalog var2, String var3);

        default public List<Schema> schemas(boolean greedy) {
            return this.schemas(greedy, null, null);
        }

        default public List<Schema> schemas(boolean greedy, Catalog catalog) {
            return this.schemas(greedy, catalog, null);
        }

        default public List<Schema> schemas(boolean greedy, String name) {
            return this.schemas(greedy, null, name);
        }

        public boolean exists(boolean var1, Table var2);

        default public boolean exists(Table table) {
            return this.exists(false, table);
        }

        public <T extends Table> List<T> tables(boolean var1, Catalog var2, Schema var3, String var4, int var5, int var6, ConfigStore var7);

        default public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.tables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.tables(greedy, catalog, schema, name, types, structs, configs);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.tables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Schema schema, String name, int types, int struct) {
            return this.tables(greedy, null, schema, name, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Schema schema, String name, int types, boolean struct) {
            return this.tables(greedy, null, schema, name, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, String name, int types, boolean struct) {
            return this.tables(greedy, null, null, name, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, String name, int types, int struct) {
            return this.tables(greedy, null, null, name, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, int types, int struct) {
            return this.tables(greedy, null, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, int types, boolean struct) {
            return this.tables(greedy, null, types, struct);
        }

        default public <T extends Table> List<T> tables(boolean greedy, boolean struct) {
            return this.tables(greedy, Table.TYPE.NORMAL.value, struct);
        }

        public <T extends Table> LinkedHashMap<String, T> tables(Catalog var1, Schema var2, String var3, int var4, int var5, ConfigStore var6);

        default public <T extends Table> LinkedHashMap<String, T> tables(Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.tables(catalog, schema, name, types, struct, null);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.tables(catalog, schema, name, types, structs, configs);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.tables(catalog, schema, name, types, struct, null);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Schema schema, String name, int types, int struct) {
            return this.tables(null, schema, name, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Schema schema, String name, int types, boolean struct) {
            return this.tables(null, schema, name, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(String name, int types, int struct) {
            return this.tables(null, null, name, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(String name, int types, boolean struct) {
            return this.tables(null, null, name, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types, int struct) {
            return this.tables(null, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types, boolean struct) {
            return this.tables(null, types, struct);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables() {
            return this.tables(Table.TYPE.NORMAL.value, false);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types, int struct, ConfigStore configs) {
            return this.tables(null, null, null, types, struct, configs);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types, boolean struct, ConfigStore configs) {
            return this.tables(null, null, null, types, struct, configs);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(ConfigStore configs) {
            return this.tables(Table.TYPE.NORMAL.value, false, configs);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types, ConfigStore configs) {
            return this.tables(greedy, catalog, schema, name, types, false, configs);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
            return this.tables(greedy, catalog, schema, name, types, false);
        }

        default public <T extends Table> List<T> tables(boolean greedy, Schema schema, String name, int types) {
            return this.tables(greedy, null, schema, name, types, false);
        }

        default public <T extends Table> List<T> tables(boolean greedy, String name, int types) {
            return this.tables(greedy, null, null, name, types, false);
        }

        default public <T extends Table> List<T> tables(boolean greedy, int types) {
            return this.tables(greedy, null, types, false);
        }

        default public <T extends Table> List<T> tables(boolean greedy) {
            return this.tables(greedy, Table.TYPE.NORMAL.value, false);
        }

        default public <T extends Table> List<T> tables(boolean greedy, int types, ConfigStore configs) {
            return this.tables(greedy, null, null, null, types, configs);
        }

        default public <T extends Table> List<T> tables(boolean greedy, ConfigStore configs) {
            return this.tables(greedy, null, null, null, Table.TYPE.NORMAL.value, configs);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Catalog catalog, Schema schema, String name, int types) {
            return this.tables(catalog, schema, name, types, false);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(Schema schema, String name, int types) {
            return this.tables(null, schema, name, types, false);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(String name, int types) {
            return this.tables(null, null, name, types, false);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types) {
            return this.tables(null, types, false);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(int types, ConfigStore configs) {
            return this.tables(null, null, null, types, false, configs);
        }

        public Table table(boolean var1, Catalog var2, Schema var3, String var4, int var5);

        default public Table table(boolean greedy, Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.table(greedy, catalog, schema, name, structs);
        }

        default public Table table(boolean greedy, Schema schema, String name, int struct) {
            return this.table(greedy, null, schema, name, struct);
        }

        default public Table table(boolean greedy, Schema schema, String name, boolean struct) {
            return this.table(greedy, null, schema, name, struct);
        }

        default public Table table(boolean greedy, String name, int struct) {
            return this.table(greedy, null, null, name, struct);
        }

        default public Table table(boolean greedy, String name, boolean struct) {
            return this.table(greedy, null, null, name, struct);
        }

        public Table table(Catalog var1, Schema var2, String var3, int var4);

        default public Table table(Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.table(catalog, schema, name, structs);
        }

        default public Table table(Schema schema, String name, int struct) {
            return this.table(false, null, schema, name, struct);
        }

        default public Table table(Schema schema, String name, boolean struct) {
            return this.table(false, null, schema, name, struct);
        }

        default public Table table(String name, int struct) {
            return this.table(false, null, null, name, struct);
        }

        default public Table table(String name, boolean struct) {
            return this.table(false, null, null, name, struct);
        }

        default public Table table(boolean greedy, Catalog catalog, Schema schema, String name) {
            return this.table(greedy, catalog, schema, name, true);
        }

        default public Table table(boolean greedy, Schema schema, String name) {
            return this.table(greedy, null, schema, name, true);
        }

        default public Table table(boolean greedy, String name) {
            return this.table(greedy, null, null, name, true);
        }

        default public Table table(Catalog catalog, Schema schema, String name) {
            return this.table(catalog, schema, name, true);
        }

        default public Table table(Schema schema, String name) {
            return this.table(null, schema, name, true);
        }

        default public Table table(String name) {
            return this.table(null, null, name, true);
        }

        public List<String> ddl(Table var1, boolean var2);

        default public List<String> ddl(String table, boolean init) {
            return this.ddl(new Table(table), init);
        }

        default public List<String> ddl(Table table) {
            return this.ddl(table, false);
        }

        default public List<String> ddl(String table) {
            return this.ddl(new Table(table));
        }

        public boolean exists(boolean var1, View var2);

        default public boolean exists(View view) {
            return this.exists(false, view);
        }

        public <T extends View> List<T> views(boolean var1, Catalog var2, Schema var3, String var4, int var5, int var6, ConfigStore var7);

        default public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.views(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.views(greedy, catalog, schema, name, types, structs, configs);
        }

        default public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.views(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends View> List<T> views(boolean greedy, Schema schema, String name, int types, int struct) {
            return this.views(greedy, null, schema, name, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, Schema schema, String name, int types, boolean struct) {
            return this.views(greedy, null, schema, name, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, String name, int types, boolean struct) {
            return this.views(greedy, null, null, name, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, String name, int types, int struct) {
            return this.views(greedy, null, null, name, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, int types, int struct) {
            return this.views(greedy, null, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, int types, boolean struct) {
            return this.views(greedy, null, types, struct);
        }

        default public <T extends View> List<T> views(boolean greedy, boolean struct) {
            return this.views(greedy, View.TYPE.NORMAL.value, struct);
        }

        public <T extends View> LinkedHashMap<String, T> views(Catalog var1, Schema var2, String var3, int var4, int var5, ConfigStore var6);

        default public <T extends View> LinkedHashMap<String, T> views(Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.views(catalog, schema, name, types, struct, null);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.views(catalog, schema, name, types, structs, configs);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.views(catalog, schema, name, types, struct, null);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Schema schema, String name, int types, int struct) {
            return this.views(null, schema, name, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Schema schema, String name, int types, boolean struct) {
            return this.views(null, schema, name, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views(String name, int types, int struct) {
            return this.views(null, null, name, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views(String name, int types, boolean struct) {
            return this.views(null, null, name, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types, int struct) {
            return this.views(null, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types, boolean struct) {
            return this.views(null, types, struct);
        }

        default public <T extends View> LinkedHashMap<String, T> views() {
            return this.views(View.TYPE.NORMAL.value, false);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types, int struct, ConfigStore configs) {
            return this.views(null, null, null, types, struct, configs);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types, boolean struct, ConfigStore configs) {
            return this.views(null, null, null, types, struct, configs);
        }

        default public <T extends View> LinkedHashMap<String, T> views(ConfigStore configs) {
            return this.views(View.TYPE.NORMAL.value, false, configs);
        }

        default public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types, ConfigStore configs) {
            return this.views(greedy, catalog, schema, name, types, false, configs);
        }

        default public <T extends View> List<T> views(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
            return this.views(greedy, catalog, schema, name, types, false);
        }

        default public <T extends View> List<T> views(boolean greedy, Schema schema, String name, int types) {
            return this.views(greedy, null, schema, name, types, false);
        }

        default public <T extends View> List<T> views(boolean greedy, String name, int types) {
            return this.views(greedy, null, null, name, types, false);
        }

        default public <T extends View> List<T> views(boolean greedy, int types) {
            return this.views(greedy, null, types, false);
        }

        default public <T extends View> List<T> views(boolean greedy) {
            return this.views(greedy, View.TYPE.NORMAL.value, false);
        }

        default public <T extends View> List<T> views(boolean greedy, int types, ConfigStore configs) {
            return this.views(greedy, null, null, null, types, configs);
        }

        default public <T extends View> List<T> views(boolean greedy, ConfigStore configs) {
            return this.views(greedy, null, null, null, View.TYPE.NORMAL.value, configs);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Catalog catalog, Schema schema, String name, int types) {
            return this.views(catalog, schema, name, types, false);
        }

        default public <T extends View> LinkedHashMap<String, T> views(Schema schema, String name, int types) {
            return this.views(null, schema, name, types, false);
        }

        default public <T extends View> LinkedHashMap<String, T> views(String name, int types) {
            return this.views(null, null, name, types, false);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types) {
            return this.views(null, types, false);
        }

        default public <T extends View> LinkedHashMap<String, T> views(int types, ConfigStore configs) {
            return this.views(null, null, null, types, false, configs);
        }

        public View view(boolean var1, Catalog var2, Schema var3, String var4, int var5);

        default public View view(boolean greedy, Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.view(greedy, catalog, schema, name, structs);
        }

        default public View view(boolean greedy, Schema schema, String name, int struct) {
            return this.view(greedy, null, schema, name, struct);
        }

        default public View view(boolean greedy, Schema schema, String name, boolean struct) {
            return this.view(greedy, null, schema, name, struct);
        }

        default public View view(boolean greedy, String name, int struct) {
            return this.view(greedy, null, null, name, struct);
        }

        default public View view(boolean greedy, String name, boolean struct) {
            return this.view(greedy, null, null, name, struct);
        }

        public View view(Catalog var1, Schema var2, String var3, int var4);

        default public View view(Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.view(catalog, schema, name, structs);
        }

        default public View view(Schema schema, String name, int struct) {
            return this.view(false, null, schema, name, struct);
        }

        default public View view(Schema schema, String name, boolean struct) {
            return this.view(false, null, schema, name, struct);
        }

        default public View view(String name, int struct) {
            return this.view(false, null, null, name, struct);
        }

        default public View view(String name, boolean struct) {
            return this.view(false, null, null, name, struct);
        }

        default public View view(boolean greedy, Catalog catalog, Schema schema, String name) {
            return this.view(greedy, catalog, schema, name, true);
        }

        default public View view(boolean greedy, Schema schema, String name) {
            return this.view(greedy, null, schema, name, true);
        }

        default public View view(boolean greedy, String name) {
            return this.view(greedy, null, null, name, true);
        }

        default public View view(Catalog catalog, Schema schema, String name) {
            return this.view(catalog, schema, name, true);
        }

        default public View view(Schema schema, String name) {
            return this.view(null, schema, name, true);
        }

        default public View view(String name) {
            return this.view(null, null, name, true);
        }

        public List<String> ddl(View var1, boolean var2);

        default public List<String> ddl(View view) {
            return this.ddl(view, false);
        }

        public boolean exists(boolean var1, MasterTable var2);

        default public boolean exists(MasterTable table) {
            return this.exists(false, table);
        }

        public <T extends MasterTable> List<T> masterTables(boolean var1, Catalog var2, Schema var3, String var4, int var5, int var6, ConfigStore var7);

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.masterTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.masterTables(greedy, catalog, schema, name, types, structs, configs);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.masterTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Schema schema, String name, int types, int struct) {
            return this.masterTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Schema schema, String name, int types, boolean struct) {
            return this.masterTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, String name, int types, boolean struct) {
            return this.masterTables(greedy, null, null, name, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, String name, int types, int struct) {
            return this.masterTables(greedy, null, null, name, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, int types, int struct) {
            return this.masterTables(greedy, null, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, int types, boolean struct) {
            return this.masterTables(greedy, null, types, struct);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, boolean struct) {
            return this.masterTables(greedy, MasterTable.TYPE.NORMAL.value, struct);
        }

        public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog var1, Schema var2, String var3, int var4, int var5, ConfigStore var6);

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.masterTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.masterTables(catalog, schema, name, types, structs, configs);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.masterTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Schema schema, String name, int types, int struct) {
            return this.masterTables(null, schema, name, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Schema schema, String name, int types, boolean struct) {
            return this.masterTables(null, schema, name, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(String name, int types, int struct) {
            return this.masterTables(null, null, name, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(String name, int types, boolean struct) {
            return this.masterTables(null, null, name, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types, int struct) {
            return this.masterTables(null, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types, boolean struct) {
            return this.masterTables(null, types, struct);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables() {
            return this.masterTables(MasterTable.TYPE.NORMAL.value, false);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types, int struct, ConfigStore configs) {
            return this.masterTables(null, null, null, types, struct, configs);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types, boolean struct, ConfigStore configs) {
            return this.masterTables(null, null, null, types, struct, configs);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(ConfigStore configs) {
            return this.masterTables(MasterTable.TYPE.NORMAL.value, false, configs);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, ConfigStore configs) {
            return this.masterTables(greedy, catalog, schema, name, types, false, configs);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
            return this.masterTables(greedy, catalog, schema, name, types, false);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, Schema schema, String name, int types) {
            return this.masterTables(greedy, null, schema, name, types, false);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, String name, int types) {
            return this.masterTables(greedy, null, null, name, types, false);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, int types) {
            return this.masterTables(greedy, null, types, false);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy) {
            return this.masterTables(greedy, MasterTable.TYPE.NORMAL.value, false);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, int types, ConfigStore configs) {
            return this.masterTables(greedy, null, null, null, types, configs);
        }

        default public <T extends MasterTable> List<T> masterTables(boolean greedy, ConfigStore configs) {
            return this.masterTables(greedy, null, null, null, MasterTable.TYPE.NORMAL.value, configs);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Catalog catalog, Schema schema, String name, int types) {
            return this.masterTables(catalog, schema, name, types, false);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(Schema schema, String name, int types) {
            return this.masterTables(null, schema, name, types, false);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(String name, int types) {
            return this.masterTables(null, null, name, types, false);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types) {
            return this.masterTables(null, types, false);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(int types, ConfigStore configs) {
            return this.masterTables(null, null, null, types, false, configs);
        }

        public MasterTable masterTable(boolean var1, Catalog var2, Schema var3, String var4, int var5);

        default public MasterTable masterTable(boolean greedy, Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.masterTable(greedy, catalog, schema, name, structs);
        }

        default public MasterTable masterTable(boolean greedy, Schema schema, String name, int struct) {
            return this.masterTable(greedy, null, schema, name, struct);
        }

        default public MasterTable masterTable(boolean greedy, Schema schema, String name, boolean struct) {
            return this.masterTable(greedy, null, schema, name, struct);
        }

        default public MasterTable masterTable(boolean greedy, String name, int struct) {
            return this.masterTable(greedy, null, null, name, struct);
        }

        default public MasterTable masterTable(boolean greedy, String name, boolean struct) {
            return this.masterTable(greedy, null, null, name, struct);
        }

        public MasterTable masterTable(Catalog var1, Schema var2, String var3, int var4);

        default public MasterTable masterTable(Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.masterTable(catalog, schema, name, structs);
        }

        default public MasterTable masterTable(Schema schema, String name, int struct) {
            return this.masterTable(false, null, schema, name, struct);
        }

        default public MasterTable masterTable(Schema schema, String name, boolean struct) {
            return this.masterTable(false, null, schema, name, struct);
        }

        default public MasterTable masterTable(String name, int struct) {
            return this.masterTable(false, null, null, name, struct);
        }

        default public MasterTable masterTable(String name, boolean struct) {
            return this.masterTable(false, null, null, name, struct);
        }

        default public MasterTable masterTable(boolean greedy, Catalog catalog, Schema schema, String name) {
            return this.masterTable(greedy, catalog, schema, name, true);
        }

        default public MasterTable masterTable(boolean greedy, Schema schema, String name) {
            return this.masterTable(greedy, null, schema, name, true);
        }

        default public MasterTable masterTable(boolean greedy, String name) {
            return this.masterTable(greedy, null, null, name, true);
        }

        default public MasterTable masterTable(Catalog catalog, Schema schema, String name) {
            return this.masterTable(catalog, schema, name, true);
        }

        default public MasterTable masterTable(Schema schema, String name) {
            return this.masterTable(null, schema, name, true);
        }

        default public MasterTable masterTable(String name) {
            return this.masterTable(null, null, name, true);
        }

        public List<String> ddl(MasterTable var1, boolean var2);

        default public List<String> ddl(MasterTable masterTable) {
            return this.ddl(masterTable, false);
        }

        public boolean exists(boolean var1, PartitionTable var2);

        default public boolean exists(PartitionTable table) {
            return this.exists(false, table);
        }

        public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean var1, MasterTable var2, Map<String, Object> var3, String var4);

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master, Map<String, Object> tags, String name) {
            return this.partitionTables(false, master, tags, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, MasterTable master, Map<String, Object> tags) {
            return this.partitionTables(greedy, master, tags, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master, Map<String, Object> tags) {
            return this.partitionTables(false, master, tags, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, Catalog catalog, Schema schema, String master, String name) {
            return this.partitionTables(greedy, new MasterTable(catalog, schema, master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, Schema schema, String master, String name) {
            return this.partitionTables(greedy, new MasterTable(schema, master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, String master, String name) {
            return this.partitionTables(greedy, new MasterTable(master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, String master) {
            return this.partitionTables(greedy, new MasterTable(master), null, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, MasterTable master) {
            return this.partitionTables(greedy, master, null, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(boolean greedy, MasterTable master, String name) {
            return this.partitionTables(greedy, master, null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(Catalog catalog, Schema schema, String master, String name) {
            return this.partitionTables(false, catalog, schema, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(Schema schema, String master, String name) {
            return this.partitionTables(false, schema, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(String master, String name) {
            return this.partitionTables(false, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(String master) {
            return this.partitionTables(false, master);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(MasterTable master) {
            return this.partitionTables(false, master);
        }

        public PartitionTable partitionTable(boolean var1, MasterTable var2, String var3);

        default public PartitionTable partitionTable(boolean greedy, Catalog catalog, Schema schema, String master, String name) {
            return this.partitionTable(greedy, new MasterTable(catalog, schema, master), name);
        }

        default public PartitionTable partitionTable(boolean greedy, Schema schema, String master, String name) {
            return this.partitionTable(greedy, new MasterTable(schema, master), name);
        }

        default public PartitionTable partitionTable(boolean greedy, String master, String name) {
            return this.partitionTable(greedy, new MasterTable(master), name);
        }

        default public PartitionTable partitionTable(Catalog catalog, Schema schema, String master, String name) {
            return this.partitionTable(false, catalog, schema, master, name);
        }

        default public PartitionTable partitionTable(Schema schema, String master, String name) {
            return this.partitionTable(false, new MasterTable(schema, master), name);
        }

        default public PartitionTable partitionTable(String master, String name) {
            return this.partitionTable(false, new MasterTable(master), name);
        }

        public List<String> ddl(PartitionTable var1);

        public boolean exists(boolean var1, VertexTable var2);

        default public boolean exists(VertexTable vertexTable) {
            return this.exists(false, vertexTable);
        }

        public <T extends VertexTable> List<T> vertexTables(boolean var1, Catalog var2, Schema var3, String var4, int var5, int var6, ConfigStore var7);

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.vertexTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.vertexTables(greedy, catalog, schema, name, types, structs, configs);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.vertexTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Schema schema, String name, int types, int struct) {
            return this.vertexTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Schema schema, String name, int types, boolean struct) {
            return this.vertexTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, String name, int types, boolean struct) {
            return this.vertexTables(greedy, null, null, name, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, String name, int types, int struct) {
            return this.vertexTables(greedy, null, null, name, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, int types, int struct) {
            return this.vertexTables(greedy, null, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, int types, boolean struct) {
            return this.vertexTables(greedy, null, types, struct);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, boolean struct) {
            return this.vertexTables(greedy, Table.TYPE.NORMAL.value, struct);
        }

        public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog var1, Schema var2, String var3, int var4, int var5, ConfigStore var6);

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.vertexTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.vertexTables(catalog, schema, name, types, structs, configs);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.vertexTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Schema schema, String name, int types, int struct) {
            return this.vertexTables(null, schema, name, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Schema schema, String name, int types, boolean struct) {
            return this.vertexTables(null, schema, name, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(String name, int types, int struct) {
            return this.vertexTables(null, null, name, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(String name, int types, boolean struct) {
            return this.vertexTables(null, null, name, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types, int struct) {
            return this.vertexTables(null, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types, boolean struct) {
            return this.vertexTables(null, types, struct);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables() {
            return this.vertexTables(Table.TYPE.NORMAL.value, false);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types, int struct, ConfigStore configs) {
            return this.vertexTables(null, null, null, types, struct, configs);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types, boolean struct, ConfigStore configs) {
            return this.vertexTables(null, null, null, types, struct, configs);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(ConfigStore configs) {
            return this.vertexTables(Table.TYPE.NORMAL.value, false, configs);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, ConfigStore configs) {
            return this.vertexTables(greedy, catalog, schema, name, types, false, configs);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
            return this.vertexTables(greedy, catalog, schema, name, types, false);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, Schema schema, String name, int types) {
            return this.vertexTables(greedy, null, schema, name, types, false);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, String name, int types) {
            return this.vertexTables(greedy, null, null, name, types, false);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, int types) {
            return this.vertexTables(greedy, null, types, false);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy) {
            return this.vertexTables(greedy, Table.TYPE.NORMAL.value, false);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, int types, ConfigStore configs) {
            return this.vertexTables(greedy, null, null, null, types, configs);
        }

        default public <T extends VertexTable> List<T> vertexTables(boolean greedy, ConfigStore configs) {
            return this.vertexTables(greedy, null, null, null, Table.TYPE.NORMAL.value, configs);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Catalog catalog, Schema schema, String name, int types) {
            return this.vertexTables(catalog, schema, name, types, false);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(Schema schema, String name, int types) {
            return this.vertexTables(null, schema, name, types, false);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(String name, int types) {
            return this.vertexTables(null, null, name, types, false);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types) {
            return this.vertexTables(null, types, false);
        }

        default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(int types, ConfigStore configs) {
            return this.vertexTables(null, null, null, types, false, configs);
        }

        public VertexTable vertexTable(boolean var1, Catalog var2, Schema var3, String var4, int var5);

        default public VertexTable vertexTable(boolean greedy, Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.vertexTable(greedy, catalog, schema, name, structs);
        }

        default public VertexTable vertexTable(boolean greedy, Schema schema, String name, int struct) {
            return this.vertexTable(greedy, null, schema, name, struct);
        }

        default public VertexTable vertexTable(boolean greedy, Schema schema, String name, boolean struct) {
            return this.vertexTable(greedy, null, schema, name, struct);
        }

        default public VertexTable vertexTable(boolean greedy, String name, int struct) {
            return this.vertexTable(greedy, null, null, name, struct);
        }

        default public VertexTable vertexTable(boolean greedy, String name, boolean struct) {
            return this.vertexTable(greedy, null, null, name, struct);
        }

        public VertexTable vertexTable(Catalog var1, Schema var2, String var3, int var4);

        default public VertexTable vertexTable(Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.vertexTable(catalog, schema, name, structs);
        }

        default public VertexTable vertexTable(Schema schema, String name, int struct) {
            return this.vertexTable(false, null, schema, name, struct);
        }

        default public VertexTable vertexTable(Schema schema, String name, boolean struct) {
            return this.vertexTable(false, null, schema, name, struct);
        }

        default public VertexTable vertexTable(String name, int struct) {
            return this.vertexTable(false, null, null, name, struct);
        }

        default public VertexTable vertexTable(String name, boolean struct) {
            return this.vertexTable(false, null, null, name, struct);
        }

        default public VertexTable vertexTable(boolean greedy, Catalog catalog, Schema schema, String name) {
            return this.vertexTable(greedy, catalog, schema, name, true);
        }

        default public VertexTable vertexTable(boolean greedy, Schema schema, String name) {
            return this.vertexTable(greedy, null, schema, name, true);
        }

        default public VertexTable vertexTable(boolean greedy, String name) {
            return this.vertexTable(greedy, null, null, name, true);
        }

        default public VertexTable vertexTable(Catalog catalog, Schema schema, String name) {
            return this.vertexTable(catalog, schema, name, true);
        }

        default public VertexTable vertexTable(Schema schema, String name) {
            return this.vertexTable(null, schema, name, true);
        }

        default public VertexTable vertexTable(String name) {
            return this.vertexTable(null, null, name, true);
        }

        public List<String> ddl(VertexTable var1, boolean var2);

        default public List<String> ddl(VertexTable vertexTable) {
            return this.ddl(vertexTable, false);
        }

        public boolean exists(boolean var1, EdgeTable var2);

        default public boolean exists(EdgeTable edgeTable) {
            return this.exists(false, edgeTable);
        }

        public <T extends EdgeTable> List<T> edgeTables(boolean var1, Catalog var2, Schema var3, String var4, int var5, int var6, ConfigStore var7);

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.edgeTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.edgeTables(greedy, catalog, schema, name, types, structs, configs);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.edgeTables(greedy, catalog, schema, name, types, struct, null);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Schema schema, String name, int types, int struct) {
            return this.edgeTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Schema schema, String name, int types, boolean struct) {
            return this.edgeTables(greedy, null, schema, name, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, String name, int types, boolean struct) {
            return this.edgeTables(greedy, null, null, name, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, String name, int types, int struct) {
            return this.edgeTables(greedy, null, null, name, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, int types, int struct) {
            return this.edgeTables(greedy, null, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, int types, boolean struct) {
            return this.edgeTables(greedy, null, types, struct);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, boolean struct) {
            return this.edgeTables(greedy, Table.TYPE.NORMAL.value, struct);
        }

        public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog var1, Schema var2, String var3, int var4, int var5, ConfigStore var6);

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog catalog, Schema schema, String name, int types, int struct) {
            return this.edgeTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog catalog, Schema schema, String name, int types, boolean struct, ConfigStore configs) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.edgeTables(catalog, schema, name, types, structs, configs);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog catalog, Schema schema, String name, int types, boolean struct) {
            return this.edgeTables(catalog, schema, name, types, struct, null);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Schema schema, String name, int types, int struct) {
            return this.edgeTables(null, schema, name, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Schema schema, String name, int types, boolean struct) {
            return this.edgeTables(null, schema, name, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(String name, int types, int struct) {
            return this.edgeTables(null, null, name, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(String name, int types, boolean struct) {
            return this.edgeTables(null, null, name, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types, int struct) {
            return this.edgeTables(null, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types, boolean struct) {
            return this.edgeTables(null, types, struct);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables() {
            return this.edgeTables(Table.TYPE.NORMAL.value, false);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types, int struct, ConfigStore configs) {
            return this.edgeTables(null, null, null, types, struct, configs);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types, boolean struct, ConfigStore configs) {
            return this.edgeTables(null, null, null, types, struct, configs);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(ConfigStore configs) {
            return this.edgeTables(Table.TYPE.NORMAL.value, false, configs);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types, ConfigStore configs) {
            return this.edgeTables(greedy, catalog, schema, name, types, false, configs);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Catalog catalog, Schema schema, String name, int types) {
            return this.edgeTables(greedy, catalog, schema, name, types, false);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, Schema schema, String name, int types) {
            return this.edgeTables(greedy, null, schema, name, types, false);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, String name, int types) {
            return this.edgeTables(greedy, null, null, name, types, false);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, int types) {
            return this.edgeTables(greedy, null, types, false);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy) {
            return this.edgeTables(greedy, Table.TYPE.NORMAL.value, false);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, int types, ConfigStore configs) {
            return this.edgeTables(greedy, null, null, null, types, configs);
        }

        default public <T extends EdgeTable> List<T> edgeTables(boolean greedy, ConfigStore configs) {
            return this.edgeTables(greedy, null, null, null, Table.TYPE.NORMAL.value, configs);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Catalog catalog, Schema schema, String name, int types) {
            return this.edgeTables(catalog, schema, name, types, false);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(Schema schema, String name, int types) {
            return this.edgeTables(null, schema, name, types, false);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(String name, int types) {
            return this.edgeTables(null, null, name, types, false);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types) {
            return this.edgeTables(null, types, false);
        }

        default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(int types, ConfigStore configs) {
            return this.edgeTables(null, null, null, types, false, configs);
        }

        public EdgeTable edgeTable(boolean var1, Catalog var2, Schema var3, String var4, int var5);

        default public EdgeTable edgeTable(boolean greedy, Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.edgeTable(greedy, catalog, schema, name, structs);
        }

        default public EdgeTable edgeTable(boolean greedy, Schema schema, String name, int struct) {
            return this.edgeTable(greedy, null, schema, name, struct);
        }

        default public EdgeTable edgeTable(boolean greedy, Schema schema, String name, boolean struct) {
            return this.edgeTable(greedy, null, schema, name, struct);
        }

        default public EdgeTable edgeTable(boolean greedy, String name, int struct) {
            return this.edgeTable(greedy, null, null, name, struct);
        }

        default public EdgeTable edgeTable(boolean greedy, String name, boolean struct) {
            return this.edgeTable(greedy, null, null, name, struct);
        }

        public EdgeTable edgeTable(Catalog var1, Schema var2, String var3, int var4);

        default public EdgeTable edgeTable(Catalog catalog, Schema schema, String name, boolean struct) {
            int structs = 0;
            if (struct) {
                structs = Short.MAX_VALUE;
            }
            return this.edgeTable(catalog, schema, name, structs);
        }

        default public EdgeTable edgeTable(Schema schema, String name, int struct) {
            return this.edgeTable(false, null, schema, name, struct);
        }

        default public EdgeTable edgeTable(Schema schema, String name, boolean struct) {
            return this.edgeTable(false, null, schema, name, struct);
        }

        default public EdgeTable edgeTable(String name, int struct) {
            return this.edgeTable(false, null, null, name, struct);
        }

        default public EdgeTable edgeTable(String name, boolean struct) {
            return this.edgeTable(false, null, null, name, struct);
        }

        default public EdgeTable edgeTable(boolean greedy, Catalog catalog, Schema schema, String name) {
            return this.edgeTable(greedy, catalog, schema, name, true);
        }

        default public EdgeTable edgeTable(boolean greedy, Schema schema, String name) {
            return this.edgeTable(greedy, null, schema, name, true);
        }

        default public EdgeTable edgeTable(boolean greedy, String name) {
            return this.edgeTable(greedy, null, null, name, true);
        }

        default public EdgeTable edgeTable(Catalog catalog, Schema schema, String name) {
            return this.edgeTable(catalog, schema, name, true);
        }

        default public EdgeTable edgeTable(Schema schema, String name) {
            return this.edgeTable(null, schema, name, true);
        }

        default public EdgeTable edgeTable(String name) {
            return this.edgeTable(null, null, name, true);
        }

        public List<String> ddl(EdgeTable var1, boolean var2);

        default public List<String> ddl(EdgeTable edgeTable) {
            return this.ddl(edgeTable, false);
        }

        public boolean exists(boolean var1, Table var2, Column var3);

        default public boolean exists(boolean greedy, Column column) {
            return this.exists(greedy, null, column);
        }

        default public boolean exists(boolean greedy, String table, String column) {
            return this.exists(greedy, new Table(table), new Column(column));
        }

        default public boolean exists(boolean greedy, Catalog catalog, Schema schema, String table, String column) {
            return this.exists(greedy, new Table(catalog, schema, table), new Column(column));
        }

        default public boolean exists(Column column) {
            return this.exists(false, null, column);
        }

        default public boolean exists(String table, String column) {
            return this.exists(false, new Table(table), new Column(column));
        }

        default public boolean exists(Table table, String column) {
            return this.exists(false, table, new Column(column));
        }

        default public boolean exists(Catalog catalog, Schema schema, String table, String column) {
            return this.exists(false, new Table(catalog, schema, table), new Column(column));
        }

        public <T extends Column> LinkedHashMap<String, T> columns(boolean var1, Table var2, ConfigStore var3);

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Table table) {
            return this.columns(greedy, table, null);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String table, ConfigStore configs) {
            return this.columns(greedy, new Table(table), configs);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String table) {
            return this.columns(greedy, new Table(table), null);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Catalog catalog, Schema schema, String table, ConfigStore configs) {
            return this.columns(greedy, new Table(catalog, schema, table), configs);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.columns(greedy, new Table(catalog, schema, table), null);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(Table table, ConfigStore configs) {
            return this.columns(false, table, configs);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(Table table) {
            return this.columns(false, table, null);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(String table, ConfigStore configs) {
            return this.columns(false, new Table(table), configs);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(String table) {
            return this.columns(false, new Table(table));
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(Catalog catalog, Schema schema, String table, ConfigStore configs) {
            return this.columns(false, new Table(catalog, schema, table), configs);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(Catalog catalog, Schema schema, String table) {
            return this.columns(false, new Table(catalog, schema, table), null);
        }

        public <T extends Column> List<T> columns(boolean var1, Catalog var2, Schema var3, ConfigStore var4);

        default public <T extends Column> List<T> columns(boolean greedy, Catalog catalog, Schema schema) {
            return this.columns(greedy, catalog, schema, (ConfigStore)null);
        }

        default public <T extends Column> List<T> columns(Catalog catalog, Schema schema, ConfigStore configs) {
            return this.columns(false, catalog, schema, configs);
        }

        default public <T extends Column> List<T> columns(Catalog catalog, Schema schema) {
            return this.columns(false, catalog, schema, (ConfigStore)null);
        }

        default public <T extends Column> List<T> columns(boolean greedy, ConfigStore configs) {
            return this.columns(greedy, (Catalog)null, (Schema)null, configs);
        }

        default public <T extends Column> List<T> columns(boolean greedy) {
            return this.columns(greedy, (Catalog)null, (Schema)null, (ConfigStore)null);
        }

        default public <T extends Column> List<T> columns(ConfigStore configs) {
            return this.columns(false, (Catalog)null, (Schema)null, configs);
        }

        default public <T extends Column> List<T> columns() {
            return this.columns(false, (Catalog)null, (Schema)null, (ConfigStore)null);
        }

        public Column column(boolean var1, Table var2, String var3);

        default public Column column(boolean greedy, String table, String name) {
            return this.column(greedy, new Table(table), name);
        }

        default public Column column(boolean greedy, Catalog catalog, Schema schema, String table, String name) {
            return this.column(greedy, new Table(catalog, schema, table), name);
        }

        default public Column column(Table table, String name) {
            return this.column(false, table, name);
        }

        default public Column column(String table, String name) {
            return this.column(false, new Table(table), name);
        }

        default public Column column(Catalog catalog, Schema schema, String table, String name) {
            return this.column(false, new Table(catalog, schema, table), name);
        }

        public <T extends Tag> LinkedHashMap<String, T> tags(boolean var1, Table var2);

        default public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String table) {
            return this.tags(greedy, new Table(table));
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.tags(greedy, new Table(catalog, schema, table));
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(Table table) {
            return this.tags(false, table);
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(String table) {
            return this.tags(false, null, null, table);
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(Catalog catalog, Schema schema, String table) {
            return this.tags(false, new Table(catalog, schema, table));
        }

        public PrimaryKey primary(boolean var1, Table var2);

        default public PrimaryKey primary(boolean greedy, String table) {
            return this.primary(greedy, new Table(table));
        }

        default public PrimaryKey primary(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.primary(greedy, new Table(catalog, schema, table));
        }

        default public PrimaryKey primary(Table table) {
            return this.primary(false, table);
        }

        default public PrimaryKey primary(String table) {
            return this.primary(false, new Table(table));
        }

        default public PrimaryKey primary(Catalog catalog, Schema schema, String table) {
            return this.primary(false, new Table(catalog, schema, table));
        }

        public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean var1, Table var2);

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, String table) {
            return this.foreigns(greedy, new Table(table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.foreigns(greedy, new Table(catalog, schema, table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(Table table) {
            return this.foreigns(false, table);
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(String table) {
            return this.foreigns(false, new Table(table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(Catalog catalog, Schema schema, String table) {
            return this.foreigns(false, new Table(catalog, schema, table));
        }

        public ForeignKey foreign(boolean var1, Table var2, List<String> var3);

        default public ForeignKey foreign(boolean greedy, Table table, String ... columns) {
            return this.foreign(greedy, table, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(boolean greedy, String table, String ... columns) {
            return this.foreign(greedy, new Table(table), (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(boolean greedy, String table, List<String> columns) {
            return this.foreign(greedy, new Table(table), columns);
        }

        default public ForeignKey foreign(boolean greedy, Catalog catalog, Schema schema, String table, List<String> columns) {
            return this.foreign(greedy, new Table(catalog, schema, table), columns);
        }

        default public ForeignKey foreign(Table table, String ... columns) {
            return this.foreign(false, table, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(Table table, List<String> columns) {
            return this.foreign(false, table, columns);
        }

        default public ForeignKey foreign(String table, String ... columns) {
            return this.foreign(false, new Table(table), (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(String table, List<String> columns) {
            return this.foreign(false, new Table(table), columns);
        }

        default public ForeignKey foreign(Catalog catalog, Schema schema, String table, List<String> columns) {
            return this.foreign(false, new Table(catalog, schema, table), columns);
        }

        public <T extends Index> List<T> indexes(boolean var1, Table var2);

        default public <T extends Index> List<T> indexes(boolean greedy, String table) {
            return this.indexes(greedy, new Table(table));
        }

        default public <T extends Index> List<T> indexes(boolean greedy) {
            return this.indexes(greedy, (Table)null);
        }

        default public <T extends Index> List<T> indexes(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.indexes(greedy, new Table(catalog, schema, table));
        }

        public <T extends Index> LinkedHashMap<String, T> indexes(Table var1);

        default public <T extends Index> LinkedHashMap<String, T> indexes(String table) {
            return this.indexes(new Table(table));
        }

        default public <T extends Index> LinkedHashMap<String, T> indexes() {
            return this.indexes((Table)null);
        }

        default public <T extends Index> LinkedHashMap<String, T> indexes(Catalog catalog, Schema schema, String table) {
            return this.indexes(new Table(catalog, schema, table));
        }

        public Index index(boolean var1, Table var2, String var3);

        default public Index index(boolean greedy, String table, String name) {
            return this.index(greedy, new Table(table), name);
        }

        default public Index index(boolean greedy, String name) {
            return this.index(greedy, (Table)null, name);
        }

        default public Index index(Table table, String name) {
            return this.index(false, table, name);
        }

        default public Index index(String table, String name) {
            return this.index(false, new Table(table), name);
        }

        default public Index index(String name) {
            return this.index(false, name);
        }

        public <T extends Constraint> List<T> constraints(boolean var1, Table var2, String var3);

        default public <T extends Constraint> List<T> constraints(boolean greedy, Table table) {
            return this.constraints(greedy, table, null);
        }

        default public <T extends Constraint> List<T> constraints(boolean greedy, String table) {
            return this.constraints(greedy, new Table(table));
        }

        default public <T extends Constraint> List<T> constraints(boolean greedy, Catalog catalog, Schema schema, String table) {
            return this.constraints(greedy, new Table(catalog, schema, table));
        }

        public <T extends Constraint> LinkedHashMap<String, T> constraints(Table var1, String var2);

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table) {
            return this.constraints(table, null);
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(String table) {
            return this.constraints(new Table(table));
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(Catalog catalog, Schema schema, String table) {
            return this.constraints(new Table(catalog, schema, table));
        }

        public <T extends Constraint> LinkedHashMap<String, T> constraints(Column var1, String var2);

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(Column column) {
            return this.constraints(column, null);
        }

        public Constraint constraint(boolean var1, Table var2, String var3);

        default public Constraint constraint(boolean greedy, String table, String name) {
            return this.constraint(greedy, new Table(table), name);
        }

        default public Constraint constraint(boolean greedy, String name) {
            return this.constraint(greedy, (Table)null, name);
        }

        default public Constraint constraint(Table table, String name) {
            return this.constraint(false, table, name);
        }

        default public Constraint constraint(String table, String name) {
            return this.constraint(false, table, name);
        }

        default public Constraint constraint(String name) {
            return this.constraint(false, name);
        }

        public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean var1, Table var2, List<Trigger.EVENT> var3);

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Catalog catalog, Schema schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(catalog, schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Schema schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, List<Trigger.EVENT> events) {
            return this.triggers(greedy, (Table)null, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy) {
            return this.triggers(greedy, (Table)null, null);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(Catalog catalog, Schema schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(false, new Table(catalog, schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(Schema schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(false, schema, table, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(String table, List<Trigger.EVENT> events) {
            return this.triggers(false, table, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(List<Trigger.EVENT> events) {
            return this.triggers(false, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers() {
            return this.triggers(false);
        }

        public Trigger trigger(boolean var1, Catalog var2, Schema var3, String var4);

        default public Trigger trigger(boolean greedy, Schema schema, String name) {
            return this.trigger(greedy, null, schema, name);
        }

        default public Trigger trigger(boolean greedy, String name) {
            return this.trigger(greedy, null, null, name);
        }

        default public Trigger trigger(Catalog catalog, Schema schema, String name) {
            return this.trigger(false, catalog, schema, name);
        }

        default public Trigger trigger(Schema schema, String name) {
            return this.trigger(false, null, schema, name);
        }

        default public Trigger trigger(String name) {
            return this.trigger(false, name);
        }

        public <T extends Procedure> List<T> procedures(boolean var1, Catalog var2, Schema var3, String var4);

        default public <T extends Procedure> List<T> procedures(boolean greedy, Schema schema, String name) {
            return this.procedures(greedy, null, schema, name);
        }

        default public <T extends Procedure> List<T> procedures(boolean greedy, String name) {
            return this.procedures(greedy, null, null, name);
        }

        default public <T extends Procedure> List<T> procedures(boolean greedy) {
            return this.procedures(greedy, null, null, null);
        }

        public <T extends Procedure> LinkedHashMap<String, T> procedures(Catalog var1, Schema var2, String var3);

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(Schema schema, String name) {
            return this.procedures(null, schema, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(String name) {
            return this.procedures(null, null, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures() {
            return this.procedures(null, null, null);
        }

        public Procedure procedure(boolean var1, Catalog var2, Schema var3, String var4);

        default public Procedure procedure(boolean greedy, Schema schema, String name) {
            return this.procedure(greedy, null, schema, name);
        }

        default public Procedure procedure(boolean greedy, String name) {
            return this.procedure(greedy, null, null, name);
        }

        default public Procedure procedure(Catalog catalog, Schema schema, String name) {
            return this.procedure(false, catalog, schema, name);
        }

        default public Procedure procedure(Schema schema, String name) {
            return this.procedure(false, schema, name);
        }

        default public Procedure procedure(String name) {
            return this.procedure(false, name);
        }

        public List<String> ddl(Procedure var1);

        public <T extends Function> List<T> functions(boolean var1, Catalog var2, Schema var3, String var4);

        default public <T extends Function> List<T> functions(boolean greedy, Schema schema, String name) {
            return this.functions(greedy, null, schema, name);
        }

        default public <T extends Function> List<T> functions(boolean greedy, String name) {
            return this.functions(greedy, null, null, name);
        }

        default public <T extends Function> List<T> functions(boolean greedy) {
            return this.functions(greedy, null, null, null);
        }

        public <T extends Function> LinkedHashMap<String, T> functions(Catalog var1, Schema var2, String var3);

        default public <T extends Function> LinkedHashMap<String, T> functions(Schema schema, String name) {
            return this.functions(null, schema, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(String name) {
            return this.functions(null, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions() {
            return this.functions(null);
        }

        public Function function(boolean var1, Catalog var2, Schema var3, String var4);

        default public Function function(boolean greedy, Schema schema, String name) {
            return this.function(greedy, null, schema, name);
        }

        default public Function function(boolean greedy, String name) {
            return this.function(greedy, null, null, name);
        }

        default public Function function(Catalog catalog, Schema schema, String name) {
            return this.function(false, catalog, schema, name);
        }

        default public Function function(Schema schema, String name) {
            return this.function(false, schema, name);
        }

        default public Function function(String name) {
            return this.function(false, name);
        }

        public List<String> ddl(Function var1);

        public <T extends Sequence> List<T> sequences(boolean var1, Catalog var2, Schema var3, String var4);

        default public <T extends Sequence> List<T> sequences(boolean greedy, Schema schema, String name) {
            return this.sequences(greedy, null, schema, name);
        }

        default public <T extends Sequence> List<T> sequences(boolean greedy, String name) {
            return this.sequences(greedy, null, null, name);
        }

        default public <T extends Sequence> List<T> sequences(boolean greedy) {
            return this.sequences(greedy, null, null, null);
        }

        public <T extends Sequence> LinkedHashMap<String, T> sequences(Catalog var1, Schema var2, String var3);

        default public <T extends Sequence> LinkedHashMap<String, T> sequences(Schema schema, String name) {
            return this.sequences(null, schema, name);
        }

        default public <T extends Sequence> LinkedHashMap<String, T> sequences(String name) {
            return this.sequences(null, name);
        }

        default public <T extends Sequence> LinkedHashMap<String, T> sequences() {
            return this.sequences(null);
        }

        public Sequence sequence(boolean var1, Catalog var2, Schema var3, String var4);

        default public Sequence sequence(boolean greedy, Schema schema, String name) {
            return this.sequence(greedy, null, schema, name);
        }

        default public Sequence sequence(boolean greedy, String name) {
            return this.sequence(greedy, null, null, name);
        }

        default public Sequence sequence(Catalog catalog, Schema schema, String name) {
            return this.sequence(false, catalog, schema, name);
        }

        default public Sequence sequence(Schema schema, String name) {
            return this.sequence(false, schema, name);
        }

        default public Sequence sequence(String name) {
            return this.sequence(false, name);
        }

        public List<String> ddl(Sequence var1);
    }
}

