/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.EnvironmentWorker;
import org.anyline.dao.init.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.init.AbstractRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.service.AnylineService;
import org.anyline.service.init.DefaultService;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxy {
    private static Logger log = LoggerFactory.getLogger(ServiceProxy.class);
    private static AnylineService service;
    private static AnylineService.DDLService ddl;
    private static AnylineService.MetaDataService metadata;

    public static void init(AnylineService service) {
        ServiceProxy.service = service;
        ddl = service.ddl();
        metadata = service.metadata();
    }

    public static AnylineService service() {
        return ServiceProxy.service("default");
    }

    public static AnylineService service(String key) {
        if (null == key) {
            key = "default";
        }
        AnylineService service = null;
        try {
            EnvironmentWorker worker = ConfigTable.environment();
            if (null != worker) {
                if (worker.containsBean("anyline.service." + key)) {
                    service = (AnylineService)worker.getBean("anyline.service." + key);
                }
            } else {
                log.error("\u8bf7\u5728\u4e0a\u4e0b\u6587\u73af\u5883\u521d\u59cb\u5316\u5b8c\u6210\u540e\u8c03\u7528");
            }
        }
        catch (Exception e) {
            log.error("get service exception:", (Throwable)e);
        }
        return service;
    }

    public static AnylineService service(DatabaseType type, DriverAdapter adapter) {
        if (null == adapter) {
            return null;
        }
        AbstractRuntime runtime = new AbstractRuntime();
        runtime.setAdapter(adapter);
        runtime.setKey("virtual(" + type + ")");
        DefaultService service = new DefaultService();
        DefaultDao dao = new DefaultDao();
        service.setDao(dao);
        dao.setRuntime(runtime);
        return service;
    }

    public static AnylineService service(DatabaseType type) {
        DriverAdapter adapter = DriverAdapterHolder.getAdapter(type);
        if (null == adapter && type.url().contains("jdbc:") && ConfigTable.IS_ENABLE_COMMON_JDBC_ADAPTER) {
            try {
                adapter = (DriverAdapter)ConfigTable.environment().getBean("anyline.data.jdbc.adapter.common");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ServiceProxy.service(type, adapter);
    }

    public static AnylineService temporary(Object datasource, String database, DatabaseType type, DriverAdapter adapter) throws Exception {
        DataRuntime runtime = DataSourceHolder.reg("temporary", datasource, database, type, adapter, true);
        DefaultDao dao = new DefaultDao();
        dao.setRuntime(runtime);
        DefaultService service = new DefaultService();
        service.setDao(dao);
        return service;
    }

    public static AnylineService temporary(Object datasource, DatabaseType type) throws Exception {
        return ServiceProxy.temporary(datasource, null, type, null);
    }

    public static AnylineService temporary(Object datasource, String database, DatabaseType type) throws Exception {
        return ServiceProxy.temporary(datasource, database, type, null);
    }

    public static AnylineService temporary(Object datasource) throws Exception {
        return ServiceProxy.temporary(datasource, null, null);
    }

    public static AnylineService temporary(Object datasource, String database) throws Exception {
        return ServiceProxy.temporary(datasource, database, null);
    }

    public static ConfigStore condition() {
        return new DefaultConfigStore(new String[0]);
    }

    public static long insert(int batch, String dest, Object data, List<String> columns) {
        return service.insert(batch, dest, data, columns);
    }

    public static long insert(int batch, String dest, Object data, String ... columns) {
        return service.insert(batch, dest, data, columns);
    }

    public static long insert(int batch, Object data, String ... columns) {
        return service.insert(batch, data, columns);
    }

    public static long insert(String dest, Object data, List<String> columns) {
        return service.insert(dest, data, columns);
    }

    public static long insert(String dest, Object data, String ... columns) {
        return service.insert(dest, data, columns);
    }

    public static long insert(Object data, String ... columns) {
        return service.insert(data, columns);
    }

    public static long insert(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.insert(batch, dest, data, configs, columns);
    }

    public static long insert(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.insert(batch, dest, data, configs, columns);
    }

    public static long insert(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.insert(batch, data, configs, columns);
    }

    public static long insert(String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.insert(dest, data, configs, columns);
    }

    public static long insert(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.insert(dest, data, configs, columns);
    }

    public static long insert(Object data, ConfigStore configs, String ... columns) {
        return service.insert(data, configs, columns);
    }

    public static long insert(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return service.insert(batch, dest, data, configs, columns);
    }

    public static long insert(int batch, Table dest, Object data, List<String> columns) {
        return ServiceProxy.insert(batch, dest, data, null, columns);
    }

    public static long insert(int batch, Table dest, Object data, String ... columns) {
        return ServiceProxy.insert(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long insert(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.insert(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long insert(Table dest, Object data, List<String> columns) {
        return ServiceProxy.insert(0, dest, data, columns);
    }

    public static long insert(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return ServiceProxy.insert(0, dest, data, configs, columns);
    }

    public static long insert(Table dest, Object data, String ... columns) {
        return ServiceProxy.insert(dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long insert(Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.insert(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long insert(Table dest, Table origin, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, origin, configs, obj, conditions);
    }

    public static long insert(Table dest, Table origin, Object obj, String ... conditions) {
        return service.insert(dest, origin, obj, conditions);
    }

    public static long insert(Table dest, Table origin, long first, long last, Object obj, String ... conditions) {
        return service.insert(dest, origin, first, last, obj, conditions);
    }

    public static long insert(Table dest, Table origin, ConfigStore configs, String ... conditions) {
        return service.insert(dest, origin, configs, conditions);
    }

    public static long insert(Table dest, Table origin, String ... conditions) {
        return service.insert(dest, origin, conditions);
    }

    public static long insert(Table dest, Table origin, PageNavi navi, String ... conditions) {
        return service.insert(dest, origin, navi, conditions);
    }

    public static long insert(Table dest, Table origin, long first, long last, String ... conditions) {
        return service.insert(dest, origin, first, last, conditions);
    }

    public static long insert(String dest, String origin, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, origin, configs, obj, conditions);
    }

    public static long insert(String dest, String origin, Object obj, String ... conditions) {
        return service.insert(dest, origin, obj, conditions);
    }

    public static long insert(String dest, String origin, long first, long last, Object obj, String ... conditions) {
        return service.insert(dest, origin, first, last, obj, conditions);
    }

    public static long insert(String dest, String origin, ConfigStore configs, String ... conditions) {
        return service.insert(dest, origin, configs, conditions);
    }

    public static long insert(String dest, String origin, String ... conditions) {
        return service.insert(dest, origin, conditions);
    }

    public static long insert(String dest, String origin, PageNavi navi, String ... conditions) {
        return service.insert(dest, origin, navi, conditions);
    }

    public static long insert(String dest, String origin, long first, long last, String ... conditions) {
        return service.insert(dest, origin, first, last, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, prepare, configs, obj, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, prepare, first, last, configs, obj, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, Object obj, String ... conditions) {
        return service.insert(dest, prepare, obj, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return service.insert(dest, prepare, first, last, obj, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.insert(dest, prepare, configs, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, String ... conditions) {
        return service.insert(dest, prepare, conditions);
    }

    public static long insert(Table dest, RunPrepare prepare, long first, long last, String ... conditions) {
        return service.insert(dest, prepare, first, last, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, prepare, configs, obj, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        return service.insert(dest, prepare, first, last, configs, obj, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, Object obj, String ... conditions) {
        return service.insert(dest, prepare, obj, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return ServiceProxy.insert(dest, prepare, first, last, obj, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.insert(dest, prepare, configs, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, String ... conditions) {
        return service.insert(dest, prepare, conditions);
    }

    public static long insert(String dest, RunPrepare prepare, long first, long last, String ... conditions) {
        return service.insert(dest, prepare, first, last, conditions);
    }

    public static long update(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.update(batch, dest, data, configs, columns);
    }

    public static long update(int batch, String dest, Object data, String ... columns) {
        return service.update(batch, dest, data, columns);
    }

    public static long update(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.update(batch, dest, data, configs, columns);
    }

    public static long update(int batch, Object data, String ... columns) {
        return service.update(batch, data, columns);
    }

    public static long update(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.update(batch, data, configs, columns);
    }

    public static long update(String dest, Object data, String ... columns) {
        return service.update(dest, data, columns);
    }

    public static long update(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.update(dest, data, configs, columns);
    }

    public static long update(Object data, String ... columns) {
        return service.update(data, columns);
    }

    public static long update(Object data, ConfigStore configs, String ... columns) {
        return service.update(data, configs, columns);
    }

    public static long update(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return service.update(batch, dest, data, configs, columns);
    }

    public static long update(int batch, Table dest, Object data, String ... columns) {
        return ServiceProxy.update(batch, dest, data, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long update(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.update(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long update(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return ServiceProxy.update(0, dest, data, configs, columns);
    }

    public static long update(Table dest, Object data, String ... columns) {
        return ServiceProxy.update(dest, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long update(Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long save(int batch, String dest, Object data, List<String> columns) {
        return service.save(batch, dest, data, columns);
    }

    public static long save(int batch, String dest, Object data, String ... columns) {
        return service.save(batch, dest, data, columns);
    }

    public static long save(int batch, Object data, String ... columns) {
        return service.save(batch, data, columns);
    }

    public static long save(String dest, Object data, String ... columns) {
        return service.save(dest, data, columns);
    }

    public static long save(Object data, String ... columns) {
        return service.save(data, columns);
    }

    public static long save(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.save(batch, data, configs, columns);
    }

    public static long save(int batch, String dest, ConfigStore configs, Object data, String ... columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.save(dest, data, configs, columns);
    }

    public static long save(Object data, ConfigStore configs, String ... columns) {
        return service.save(data, configs, columns);
    }

    public static long save(String dest, ConfigStore configs, Object data, String ... columns) {
        return service.save(dest, data, configs, columns);
    }

    public static long save(int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(int batch, Table dest, Object data, List<String> columns) {
        return ServiceProxy.save(batch, dest, data, null, columns);
    }

    public static long save(int batch, Table dest, Object data, String ... columns) {
        return ServiceProxy.save(batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long save(int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.save(batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long save(Table dest, Object data, List<String> columns) {
        return ServiceProxy.save(0, dest, data, columns);
    }

    public static long save(Table dest, Object data, ConfigStore configs, List<String> columns) {
        return ServiceProxy.save(0, dest, data, configs, columns);
    }

    public static long save(Table dest, Object data, String ... columns) {
        return ServiceProxy.save(dest, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static long save(Table dest, Object data, ConfigStore configs, String ... columns) {
        return ServiceProxy.save(dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public static DataSet querys(String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(dest, configs, obj, conditions);
    }

    public static DataSet querys(ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(configs, obj, conditions);
    }

    public static DataSet querys(ConfigStore configs, String ... conditions) {
        return service.querys(configs, conditions);
    }

    public static DataSet querys(DataSet set, ConfigStore configs) {
        return service.querys(set, configs);
    }

    public static DataSet querys(String dest, Object obj, String ... conditions) {
        return service.querys(dest, obj, conditions);
    }

    public static void querys(String dest, DataHandler handler, Object obj, String ... conditions) {
        service.querys(dest, handler, obj, conditions);
    }

    public static DataSet querys(String dest, PageNavi navi, Object obj, String ... conditions) {
        return service.querys(dest, navi, obj, conditions);
    }

    public static DataSet querys(String dest, long first, long last, Object obj, String ... conditions) {
        return service.querys(dest, first, last, obj, conditions);
    }

    public static DataRow query(String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.query(dest, configs, obj, conditions);
    }

    public static DataRow query(ConfigStore configs, Object obj, String ... conditions) {
        return service.query(configs, obj, conditions);
    }

    public static DataRow query(ConfigStore configs, String ... conditions) {
        return service.query(configs, conditions);
    }

    public static DataRow query(String dest, Object obj, String ... conditions) {
        return service.query(dest, obj, conditions);
    }

    public static DataSet querys(String dest, ConfigStore configs, String ... conditions) {
        return service.querys(dest, configs, conditions);
    }

    public static DataSet querys(String dest, String ... conditions) {
        return service.querys(dest, conditions);
    }

    public static void querys(String dest, DataHandler handler, String ... conditions) {
        service.querys(dest, handler, conditions);
    }

    public static DataSet querys(String dest, PageNavi navi, String ... conditions) {
        return service.querys(dest, navi, conditions);
    }

    public static DataSet querys(String dest, long first, long last, String ... conditions) {
        return service.querys(dest, first, last, conditions);
    }

    public static DataSet querys(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(dest, configs, obj, conditions);
    }

    public static DataSet querys(Table dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(dest, first, last, configs, obj, conditions);
    }

    public static DataSet querys(Table dest, Object obj, String ... conditions) {
        return service.querys(dest, obj, conditions);
    }

    public static void querys(Table dest, DataHandler handler, Object obj, String ... conditions) {
        service.querys(dest, handler, obj, conditions);
    }

    public static DataSet querys(Table dest, PageNavi navi, Object obj, String ... conditions) {
        return service.querys(dest, navi, obj, conditions);
    }

    public static DataSet querys(Table dest, long first, long last, Object obj, String ... conditions) {
        return service.querys(dest, first, last, obj, conditions);
    }

    public static DataSet querys(Table dest, ConfigStore configs, String ... conditions) {
        return service.querys(dest, configs, conditions);
    }

    public static DataSet querys(Table dest, long first, long last, ConfigStore configs, String ... conditions) {
        return service.querys(dest, first, last, configs, conditions);
    }

    public static DataSet querys(Table dest, String ... conditions) {
        return service.querys(dest, conditions);
    }

    public static void querys(Table dest, DataHandler handler, String ... conditions) {
        service.querys(dest, handler, conditions);
    }

    public static DataSet querys(Table dest, PageNavi navi, String ... conditions) {
        return service.querys(dest, navi, conditions);
    }

    public static DataSet querys(Table dest, long first, long last, String ... conditions) {
        return service.querys(dest, first, last, conditions);
    }

    public static DataSet querys(Table dest, DataHandler handler, long first, long last, String ... conditions) {
        return service.querys(dest, handler, first, last, conditions);
    }

    public static DataRow query(String dest, ConfigStore configs, String ... conditions) {
        return service.query(dest, configs, conditions);
    }

    public static DataRow query(String dest, String ... conditions) {
        return service.query(dest, conditions);
    }

    public static DataRow query(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.query(dest, configs, obj, conditions);
    }

    public static DataRow query(Table dest, Object obj, String ... conditions) {
        return service.query(dest, obj, conditions);
    }

    public static DataRow query(Table dest, ConfigStore configs, String ... conditions) {
        return service.query(dest, configs, conditions);
    }

    public static DataRow query(Table dest, String ... conditions) {
        return service.query(dest, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.selects(dest, clazz, configs, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return service.selects(dest, clazz, navi, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, T entity, String ... conditions) {
        return service.selects(dest, clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return service.selects(dest, clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        return service.selects(dest, clazz, first, last, entity, conditions);
    }

    public static <T> T select(String dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.select(dest, clazz, configs, entity, conditions);
    }

    public static <T> T select(String dest, Class<T> clazz, T entity, String ... conditions) {
        return (T)service.selects(dest, clazz, entity, conditions);
    }

    public static <T> T select(String dest, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return (T)service.selects(dest, clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.selects(dest, clazz, configs, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, PageNavi navi, String ... conditions) {
        return service.selects(dest, clazz, navi, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, String ... conditions) {
        return service.selects(dest, clazz, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        return service.selects(dest, clazz, handler, conditions);
    }

    public static <T> EntitySet<T> selects(String dest, Class<T> clazz, long first, long last, String ... conditions) {
        return service.selects(dest, clazz, first, last, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.selects(dest, clazz, configs, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return service.selects(dest, clazz, navi, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, T entity, String ... conditions) {
        return service.selects(dest, clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return service.selects(dest, clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        return service.selects(dest, clazz, first, last, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.selects(dest, clazz, configs, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, PageNavi navi, String ... conditions) {
        return service.selects(dest, clazz, navi, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, String ... conditions) {
        return service.selects(dest, clazz, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        return service.selects(dest, clazz, handler, conditions);
    }

    public static <T> EntitySet<T> selects(Table dest, Class<T> clazz, long first, long last, String ... conditions) {
        return service.selects(dest, clazz, first, last, conditions);
    }

    public static <T> T select(String dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.select(dest, clazz, configs, conditions);
    }

    public static <T> T select(String dest, Class<T> clazz, String ... conditions) {
        return service.select(dest, clazz, conditions);
    }

    public static <T> T select(Table dest, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.select(dest, clazz, configs, entity, conditions);
    }

    public static <T> T select(Table dest, Class<T> clazz, T entity, String ... conditions) {
        return service.select(dest, clazz, entity, conditions);
    }

    public static <T> T select(Table dest, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.select(dest, clazz, configs, conditions);
    }

    public static <T> T select(Table dest, Class<T> clazz, String ... conditions) {
        return service.select(dest, clazz, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.selects(clazz, configs, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return service.selects(clazz, navi, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, T entity, String ... conditions) {
        return service.selects(clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return service.selects(clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, long first, long last, T entity, String ... conditions) {
        return service.selects(clazz, first, last, entity, conditions);
    }

    public static <T> T select(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.select(clazz, configs, entity, conditions);
    }

    public static <T> T select(Class<T> clazz, T entity, String ... conditions) {
        return service.select(clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.selects(clazz, configs, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, String ... conditions) {
        return service.selects(clazz, navi, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, String ... conditions) {
        return service.selects(clazz, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        return service.selects(clazz, handler, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, long first, long last, String ... conditions) {
        return service.selects(clazz, first, last, conditions);
    }

    public static <T> T select(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.select(clazz, configs, conditions);
    }

    public static <T> T select(Class<T> clazz, String ... conditions) {
        return service.select(clazz, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.maps(dest, configs, conditions);
    }

    public static List<Map<String, Object>> maps(ConfigStore configs, Object obj, String ... conditions) {
        return service.maps(configs, obj, conditions);
    }

    public static List<Map<String, Object>> maps(ConfigStore configs, String ... conditions) {
        return service.maps(configs, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, Object obj, String ... conditions) {
        return service.maps(dest, obj, conditions);
    }

    public static void maps(String dest, DataHandler handler, Object obj, String ... conditions) {
        service.maps(dest, handler, obj, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, long first, long last, Object obj, String ... conditions) {
        return service.maps(dest, first, last, obj, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, ConfigStore configs, String ... conditions) {
        return service.maps(dest, configs, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, String ... conditions) {
        return service.maps(dest, conditions);
    }

    public static void maps(String dest, DataHandler handler, String ... conditions) {
        service.maps(dest, handler, conditions);
    }

    public static List<Map<String, Object>> maps(String dest, long first, long last, String ... conditions) {
        return service.maps(dest, first, last, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.maps(dest, configs, obj, conditions);
    }

    public static void maps(Table dest, DataHandler handler, Object obj, String ... conditions) {
        service.maps(dest, handler, obj, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, Object obj, String ... conditions) {
        return service.maps(dest, obj, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, long first, long last, Object obj, String ... conditions) {
        return service.maps(dest, first, last, obj, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, ConfigStore configs, String ... conditions) {
        return service.maps(dest, configs, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, String ... conditions) {
        return service.maps(dest, conditions);
    }

    public static void maps(Table dest, DataHandler handler, String ... conditions) {
        service.maps(dest, handler, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, PageNavi navi, String ... conditions) {
        return service.maps(dest, navi, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, long first, long last, String ... conditions) {
        return service.maps(dest, first, last, conditions);
    }

    public static List<Map<String, Object>> maps(Table dest, DataHandler handler, long first, long last, String ... conditions) {
        return service.maps(dest, handler, first, last, conditions);
    }

    public static List<String> column2param(String table) {
        return service.column2param(table);
    }

    public static DataSet caches(String cache, String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.caches(cache, dest, configs, obj, conditions);
    }

    public static DataSet caches(String cache, String dest, Object obj, String ... conditions) {
        return service.caches(cache, dest, obj, conditions);
    }

    public static DataSet caches(String cache, String dest, long first, long last, Object obj, String ... conditions) {
        return service.caches(cache, dest, first, last, obj, conditions);
    }

    public static DataSet caches(String cache, Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.caches(cache, dest, configs, obj, conditions);
    }

    public static DataSet caches(String cache, Table dest, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        return service.caches(cache, dest, first, last, configs, obj, conditions);
    }

    public static DataSet caches(String cache, Table dest, Object obj, String ... conditions) {
        return service.caches(cache, dest, obj, conditions);
    }

    public static DataSet caches(String cache, Table dest, long first, long last, Object obj, String ... conditions) {
        return service.caches(cache, dest, first, last, obj, conditions);
    }

    public static DataRow cache(String cache, String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.cache(cache, dest, configs, obj, conditions);
    }

    public static DataRow cache(String cache, String dest, Object obj, String ... conditions) {
        return service.cache(cache, dest, obj, conditions);
    }

    public static DataSet caches(String cache, String dest, ConfigStore configs, String ... conditions) {
        return service.caches(cache, dest, configs, conditions);
    }

    public static DataSet caches(String cache, String dest, String ... conditions) {
        return service.caches(cache, dest, conditions);
    }

    public static DataSet caches(String cache, String dest, long first, long last, String ... conditions) {
        return service.caches(cache, dest, first, last, conditions);
    }

    public static DataRow cache(String cache, String dest, ConfigStore configs, String ... conditions) {
        return service.cache(cache, dest, configs, conditions);
    }

    public static DataRow cache(String cache, String dest, String ... conditions) {
        return service.cache(cache, dest, conditions);
    }

    public static DataRow cache(String cache, Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.cache(cache, dest, configs, obj, conditions);
    }

    public static DataRow cache(String cache, Table dest, Object obj, String ... conditions) {
        return service.cache(cache, dest, obj, conditions);
    }

    public static DataSet caches(String cache, Table dest, ConfigStore configs, String ... conditions) {
        return service.caches(cache, dest, configs, conditions);
    }

    public static DataSet caches(String cache, Table dest, long first, long last, ConfigStore configs, String ... conditions) {
        return service.caches(cache, dest, first, last, configs, conditions);
    }

    public static DataSet caches(String cache, Table dest, String ... conditions) {
        return service.caches(cache, dest, conditions);
    }

    public static DataSet caches(String cache, Table dest, long first, long last, String ... conditions) {
        return service.caches(cache, dest, first, last, conditions);
    }

    public static DataRow cache(String cache, Table dest, ConfigStore configs, String ... conditions) {
        return service.cache(cache, dest, configs, conditions);
    }

    public static DataRow cache(String cache, Table dest, String ... conditions) {
        return service.cache(cache, dest, conditions);
    }

    public static DataSet querys(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(prepare, configs, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, Object obj, String ... conditions) {
        return service.querys(prepare, obj, conditions);
    }

    public static void querys(RunPrepare prepare, StreamHandler handler, Object obj, String ... conditions) {
        service.querys(prepare, handler, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return service.querys(prepare, first, last, obj, conditions);
    }

    public static DataRow query(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.query(prepare, configs, obj, conditions);
    }

    public static DataRow query(RunPrepare prepare, Object obj, String ... conditions) {
        return service.query(prepare, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.querys(prepare, configs, conditions);
    }

    public static DataSet querys(RunPrepare prepare, String ... conditions) {
        return service.querys(prepare, conditions);
    }

    public static void querys(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        service.querys(prepare, handler, conditions);
    }

    public static DataSet querys(RunPrepare prepare, long first, long last, String ... conditions) {
        return service.querys(prepare, first, last, conditions);
    }

    public static DataRow query(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.query(prepare, configs, conditions);
    }

    public static DataRow query(RunPrepare prepare, String ... conditions) {
        return service.query(prepare, conditions);
    }

    public static void query(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        service.query(prepare, (Object)handler, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.caches(cache, prepare, configs, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return service.caches(cache, prepare, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return service.caches(cache, prepare, first, last, obj, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.cache(cache, prepare, configs, obj, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return service.cache(cache, prepare, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.caches(cache, prepare, configs, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, String ... conditions) {
        return service.caches(cache, prepare, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, long first, long last, String ... conditions) {
        return service.caches(cache, prepare, first, last, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.cache(cache, prepare, configs, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, String ... conditions) {
        return service.cache(cache, prepare, conditions);
    }

    public static boolean removeCache(String channel, String dest, ConfigStore configs, String ... conditions) {
        return service.removeCache(channel, dest, configs, conditions);
    }

    public static boolean removeCache(String channel, String dest, String ... conditions) {
        return service.removeCache(channel, dest, conditions);
    }

    public static boolean removeCache(String channel, String dest, long first, long last, String ... conditions) {
        return service.removeCache(channel, dest, first, last, conditions);
    }

    public static boolean removeCache(String channel, Table dest, ConfigStore configs, String ... conditions) {
        return service.removeCache(channel, dest, configs, conditions);
    }

    public static boolean removeCache(String channel, Table dest, String ... conditions) {
        return service.removeCache(channel, dest, conditions);
    }

    public static boolean removeCache(String channel, Table dest, long first, long last, String ... conditions) {
        return service.removeCache(channel, dest, first, last, conditions);
    }

    public static boolean clearCache(String channel) {
        return service.clearCache(channel);
    }

    public static boolean exists(String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.exists(dest, configs, obj, conditions);
    }

    public static boolean exists(String dest, Object obj, String ... conditions) {
        return service.exists(dest, obj, conditions);
    }

    public static boolean exists(String dest, ConfigStore configs, String ... conditions) {
        return service.exists(dest, configs, conditions);
    }

    public static boolean exists(String dest, String ... conditions) {
        return service.exists(dest, conditions);
    }

    public static boolean exists(String dest, DataRow row) {
        return service.exists(dest, row);
    }

    public static boolean exists(DataRow row) {
        return service.exists(row);
    }

    public static boolean exists(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.exists(dest, configs, obj, conditions);
    }

    public static boolean exists(Table dest, Object obj, String ... conditions) {
        return service.exists(dest, obj, conditions);
    }

    public static boolean exists(Table dest, ConfigStore configs, String ... conditions) {
        return service.exists(dest, configs, conditions);
    }

    public static boolean exists(Table dest, String ... conditions) {
        return service.exists(dest, conditions);
    }

    public static boolean exists(Table dest, DataRow row) {
        return service.exists(dest, row);
    }

    public static long count(String dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.count(dest, configs, obj, conditions);
    }

    public static long count(String dest, Object obj, String ... conditions) {
        return service.count(dest, obj, conditions);
    }

    public static long count(String dest, ConfigStore configs, String ... conditions) {
        return service.count(dest, configs, conditions);
    }

    public static long count(String dest, String ... conditions) {
        return service.count(dest, conditions);
    }

    public static long count(Table dest, ConfigStore configs, Object obj, String ... conditions) {
        return service.count(dest, configs, obj, conditions);
    }

    public static long count(Table dest, Object obj, String ... conditions) {
        return service.count(dest, obj, conditions);
    }

    public static long count(Table dest, ConfigStore configs, String ... conditions) {
        return service.count(dest, configs, conditions);
    }

    public static long count(Table dest, String ... conditions) {
        return service.count(dest, conditions);
    }

    public static long count(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.count(prepare, configs, obj, conditions);
    }

    public static long count(RunPrepare prepare, Object obj, String ... conditions) {
        return ServiceProxy.count(prepare, null, obj, conditions);
    }

    public static long count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return ServiceProxy.count(prepare, configs, null, conditions);
    }

    public static long count(RunPrepare prepare, String ... conditions) {
        return ServiceProxy.count(prepare, null, null, conditions);
    }

    public static int[] execute(File file, Charset charset, boolean brk) {
        return service.execute(file, charset, brk);
    }

    public static int[] execute(File file, boolean brk) {
        return ServiceProxy.execute(file, StandardCharsets.UTF_8, brk);
    }

    public static int[] execute(String txt, boolean brk) {
        return service.execute(txt, brk);
    }

    public static long execute(String dest, ConfigStore configs, String ... conditions) {
        return service.execute(dest, configs, conditions);
    }

    public static long execute(String dest, String ... conditions) {
        return service.execute(dest, conditions);
    }

    public static boolean executeProcedure(String procedure, String ... inputs) {
        return service.executeProcedure(procedure, inputs);
    }

    public static boolean execute(Procedure procedure, String ... inputs) {
        return service.execute(procedure, inputs);
    }

    public static long execute(int batch, String sql, Collection<Object> values) {
        return service.execute(batch, sql, values);
    }

    public static long execute(int batch, int vol, String sql, Collection<Object> values) {
        return service.execute(batch, vol, sql, values);
    }

    public static DataSet querysProcedure(String procedure, long first, long last, String ... inputs) {
        return service.querysProcedure(procedure, first, last, inputs);
    }

    public static DataSet querysProcedure(String procedure, PageNavi navi, String ... inputs) {
        return service.querysProcedure(procedure, navi, inputs);
    }

    public static DataSet querysProcedure(String procedure, String ... inputs) {
        return service.querysProcedure(procedure, inputs);
    }

    public static DataSet querys(Procedure procedure, long first, long last, String ... inputs) {
        return service.querys(procedure, first, last, inputs);
    }

    public static DataSet querys(Procedure procedure, PageNavi navi, String ... inputs) {
        return service.querys(procedure, navi, inputs);
    }

    public static DataRow queryProcedure(String procedure, String ... inputs) {
        return service.queryProcedure(procedure, inputs);
    }

    public static DataRow query(Procedure procedure, String ... inputs) {
        return service.query(procedure, inputs);
    }

    public static long truncate(String table) {
        return service.truncate(table);
    }

    public static long truncate(Table table) {
        return service.truncate(table);
    }

    public static long delete(String table, ConfigStore configs, String ... conditions) {
        return service.delete(table, configs, conditions);
    }

    public static long delete(ConfigStore configs, String ... conditions) {
        return service.delete(configs, conditions);
    }

    public static long delete(ConfigStore configs) {
        return service.delete(configs);
    }

    public static long delete(Table dest, ConfigStore configs, String ... conditions) {
        return ServiceProxy.service().delete(dest, configs, conditions);
    }

    public static long delete(String dest, DataSet set, String ... columns) {
        return service.delete(dest, set, columns);
    }

    public static long delete(Table dest, DataSet set, String ... columns) {
        return service.delete(dest, set, columns);
    }

    public static long delete(DataSet set, String ... columns) {
        return service.delete(set, columns);
    }

    public static long delete(String dest, DataRow row, String ... columns) {
        return service.delete(dest, row, columns);
    }

    public static long delete(Table dest, DataRow row, String ... columns) {
        return service.delete(dest, row, columns);
    }

    public static long delete(Object obj, String ... columns) {
        return service.delete(obj, columns);
    }

    public static long delete(String table, String ... kvs) {
        return service.delete(table, kvs);
    }

    public static long delete(Table table, String ... kvs) {
        return service.delete(table, kvs);
    }

    public static long delete(Table table, Collection values) {
        return service.delete(table, values);
    }

    public static long delete(String table, Collection values) {
        return service.delete(table, values);
    }

    public static long deletes(String table, String key, Collection<Object> values) {
        return service.deletes(table, key, values);
    }

    public static long deletes(Table table, String key, Collection<Object> values) {
        return service.deletes(table, key, values);
    }

    public static long deletes(int batch, String table, String key, Collection<Object> values) {
        return service.deletes(batch, table, key, values);
    }

    public static long deletes(int batch, Table table, String key, Collection<Object> values) {
        return service.deletes(batch, table, key, values);
    }

    public static <T> long deletes(String table, String key, T ... values) {
        return service.deletes(table, key, values);
    }

    public static <T> long deletes(Table table, String key, T ... values) {
        return service.deletes(table, key, values);
    }

    public static <T> long deletes(int batch, String table, String key, T ... values) {
        return service.deletes(batch, table, key, values);
    }

    public static <T> long deletes(int batch, Table table, String key, T ... values) {
        return service.deletes(batch, table, key, values);
    }

    public static List<String> tables(Catalog catalog, Schema schema, String name, int types) {
        return service.tables(catalog, schema, name, types);
    }

    public static List<String> tables(Schema schema, String name, int types) {
        return service.tables(schema, name, types);
    }

    public static List<String> tables(String name, int types) {
        return service.tables(name, types);
    }

    public static List<String> tables(int types) {
        return service.tables(types);
    }

    public static List<String> tables() {
        return service.tables();
    }

    public static List<String> masterTables(Catalog catalog, Schema schema, String name, int types) {
        return service.masterTables(catalog, schema, name, types);
    }

    public static List<String> masterTables(Schema schema, String name, int types) {
        return service.masterTables(schema, name, types);
    }

    public static List<String> masterTables(String name, int types) {
        return service.masterTables(name, types);
    }

    public static List<String> masterTables(int types) {
        return service.masterTables(types);
    }

    public static List<String> masterTables() {
        return service.masterTables();
    }

    public static List<String> columns(Table table) {
        return service.columns(table);
    }

    public static List<String> columns(String table) {
        return service.columns(table);
    }

    public static List<String> columns(Catalog catalog, Schema schema, String table) {
        return service.columns(catalog, schema, table);
    }

    public static List<String> tags(Table table) {
        return service.tags(table);
    }

    public static List<String> tags(String table) {
        return service.tags(table);
    }

    public static List<String> tags(Catalog catalog, Schema schema, String table) {
        return service.tags(catalog, schema, table);
    }

    public static List<Run> ddl(MetadataDiffer differ) {
        return service.ddl(differ);
    }

    public static List<Run> ddl(List<MetadataDiffer> differs) {
        return service.ddl(differs);
    }

    public static LinkedHashMap<String, Column> metadata(String sql, boolean comment, boolean condition) {
        return service.metadata(sql, comment, condition);
    }

    public static LinkedHashMap<String, Column> metadata(String sql) {
        return ServiceProxy.metadata(sql, false, false);
    }

    public static AnylineService.DDLService ddl() {
        return service.ddl();
    }

    public static AnylineService.MetaDataService metadata() {
        return service.metadata();
    }
}

