/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.listener.init;

import java.util.Map;
import org.anyline.annotation.Component;
import org.anyline.bean.LoadListener;
import org.anyline.cache.CacheProvider;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.interceptor.CountInterceptor;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.interceptor.DeleteInterceptor;
import org.anyline.data.interceptor.ExecuteInterceptor;
import org.anyline.data.interceptor.InsertInterceptor;
import org.anyline.data.interceptor.QueryInterceptor;
import org.anyline.data.interceptor.UpdateInterceptor;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.listener.jdbc")
public class DataSourceLoadListener
implements LoadListener {
    public void start() {
        CacheProvider provider = (CacheProvider)ConfigTable.environment().getBean(CacheProvider.class);
        CacheProxy.init(provider);
        InterceptorProxy.setQueryInterceptors(ConfigTable.environment().getBeans(QueryInterceptor.class));
        InterceptorProxy.setCountInterceptors(ConfigTable.environment().getBeans(CountInterceptor.class));
        InterceptorProxy.setUpdateInterceptors(ConfigTable.environment().getBeans(UpdateInterceptor.class));
        InterceptorProxy.setInsertInterceptors(ConfigTable.environment().getBeans(InsertInterceptor.class));
        InterceptorProxy.setDeleteInterceptors(ConfigTable.environment().getBeans(DeleteInterceptor.class));
        InterceptorProxy.setExecuteInterceptors(ConfigTable.environment().getBeans(ExecuteInterceptor.class));
        InterceptorProxy.setDDInterceptors(ConfigTable.environment().getBeans(DDInterceptor.class));
        PrimaryGenerator primaryGenerator = (PrimaryGenerator)ConfigTable.environment().getBean(PrimaryGenerator.class);
        DMListener dmListener = (DMListener)ConfigTable.environment().getBean(DMListener.class);
        DDListener ddListener = (DDListener)ConfigTable.environment().getBean(DDListener.class);
        Map adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        Map workers = ConfigTable.environment().getBeans(DriverActuator.class);
        Map loaders = ConfigTable.environment().getBeans(DataSourceLoader.class);
        if (null != adapters) {
            DriverAdapterHolder.setAdapters(adapters);
            for (DriverAdapter adapter : adapters.values()) {
                String delimiter;
                if (null != dmListener) {
                    adapter.setListener(dmListener);
                }
                if (null != ddListener) {
                    adapter.setListener(ddListener);
                }
                if (null != primaryGenerator) {
                    adapter.setGenerator(primaryGenerator);
                }
                if (null == (delimiter = ConfigTable.getString((String)("anyline.data.jdbc.delimiter." + adapter.type().name().toLowerCase())))) continue;
                adapter.setDelimiter(delimiter);
            }
        }
        if (null != loaders) {
            for (DataSourceLoader loader : loaders.values()) {
                loader.load();
            }
        }
        Object def = ConfigTable.environment().getBean("anyline.service.default");
        if (null == ConfigTable.environment().getBean("anyline.service") && null != def) {
            ConfigTable.environment().regBean("anyline.service", def);
        }
        if (null == adapters || adapters.isEmpty()) {
            adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        }
        if (null == workers || workers.isEmpty()) {
            workers = ConfigTable.environment().getBeans(DriverActuator.class);
        }
        if (null != workers && null != adapters) {
            for (DriverActuator worker : workers.values()) {
                Class<? extends DriverAdapter> clazz = worker.supportAdapterType();
                for (DriverAdapter adapter : adapters.values()) {
                    DriverActuator origin;
                    if (!ClassUtil.isInSub(adapter.getClass(), (Class[])new Class[]{clazz}) || null != (origin = adapter.getActuator()) && origin.priority() >= worker.priority()) continue;
                    adapter.setActuator(worker);
                }
            }
        }
    }

    public void after() {
        AnylineService service;
        if (ConfigTable.environment().containsBean("anyline.service.default") && null != (service = (AnylineService)ConfigTable.environment().getBean("anyline.service.default", AnylineService.class))) {
            ServiceProxy.init(service);
            Map services = ConfigTable.environment().getBeans(AnylineService.class);
            for (AnylineService item : services.values()) {
                if (null != item.getDao()) continue;
                item.setDao(service.getDao());
            }
        }
    }
}

