/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.TypeMetadataAlias;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SyntaxHelper;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.AbstractRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Join;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.AnylineException;
import org.anyline.exception.CommandException;
import org.anyline.exception.CommandQueryException;
import org.anyline.exception.CommandUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.CMD;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.adapter.ColumnMetadataAdapter;
import org.anyline.metadata.adapter.ConstraintMetadataAdapter;
import org.anyline.metadata.adapter.EdgeTableMetadataAdapter;
import org.anyline.metadata.adapter.FunctionMetadataAdapter;
import org.anyline.metadata.adapter.IndexMetadataAdapter;
import org.anyline.metadata.adapter.MasterTableMetadataAdapter;
import org.anyline.metadata.adapter.MetadataAdapterHolder;
import org.anyline.metadata.adapter.PrimaryMetadataAdapter;
import org.anyline.metadata.adapter.ProcedureMetadataAdapter;
import org.anyline.metadata.adapter.SequenceMetadataAdapter;
import org.anyline.metadata.adapter.TableMetadataAdapter;
import org.anyline.metadata.adapter.TriggerMetadataAdapter;
import org.anyline.metadata.adapter.VertexTableMetadataAdapter;
import org.anyline.metadata.adapter.ViewMetadataAdapter;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.ConvertProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public abstract class AbstractDriverAdapter
implements DriverAdapter {
    protected DMListener dmListener;
    protected DDListener ddListener;
    protected PrimaryGenerator primaryGenerator;
    protected DriverActuator actuator;
    protected String delimiterFr = "";
    protected String delimiterTo = "";
    protected static Map<String, String> spells = new HashMap<String, String>();
    protected LinkedHashMap<String, TypeMetadata> alias = new LinkedHashMap();

    protected DMListener getListener() {
        return this.dmListener;
    }

    @Override
    public void setListener(DMListener listener) {
        this.dmListener = listener;
    }

    @Override
    public DMListener getDMListener() {
        return this.dmListener;
    }

    @Override
    public void setListener(DDListener listener) {
        this.ddListener = listener;
    }

    @Override
    public DDListener getDDListener() {
        return this.ddListener;
    }

    @Override
    public void setGenerator(PrimaryGenerator generator) {
        this.primaryGenerator = generator;
    }

    public PrimaryGenerator getPrimaryGenerator() {
        return this.primaryGenerator;
    }

    @Override
    public void setActuator(DriverActuator actuator) {
        this.actuator = actuator;
    }

    @Override
    public DriverActuator getActuator() {
        return this.actuator;
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    @Override
    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public DatabaseType compatible() {
        return null;
    }

    public AbstractDriverAdapter() {
        block0: for (StandardTypeMetadata type : StandardTypeMetadata.values()) {
            this.reg((TypeMetadata)type, type.config());
            List dbs = type.databaseTypes();
            for (DatabaseType db : dbs) {
                if (db != this.type()) continue;
                this.alias(type.getName(), (TypeMetadata)type);
                this.alias(type.name(), (TypeMetadata)type);
                continue block0;
            }
        }
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Config)new TypeMetadata.Config(0, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Config)new TypeMetadata.Config(0, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Config)new TypeMetadata.Config(1, 0, 0));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
        MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Config)new TypeMetadata.Config(1, 1, 1));
    }

    @Override
    public LinkedHashMap<String, TypeMetadata> alias() {
        return this.alias;
    }

    @Override
    public TypeMetadata.Config reg(TypeMetadataAlias alias) {
        TypeMetadata standard = alias.standard();
        if (standard == StandardTypeMetadata.NONE) {
            return null;
        }
        this.alias(alias.input(), standard);
        this.alias(standard.getName(), standard);
        TypeMetadata.Config config = alias.config();
        this.reg(alias.input(), config);
        this.reg(alias.standard(), config);
        return config;
    }

    protected void alias(String key, TypeMetadata value) {
        if (null != key && null != value && TypeMetadata.NONE != value) {
            this.alias.put(key, value);
            this.alias.put(key.replace("_", " "), value);
            this.alias.put(key.replace(" ", "_"), value);
        }
    }

    @Override
    public TypeMetadata.Config reg(TypeMetadata type, TypeMetadata.Config config) {
        return MetadataAdapterHolder.reg((DatabaseType)this.type(), (TypeMetadata)type, (TypeMetadata.Config)config);
    }

    @Override
    public TypeMetadata.Config reg(String type, TypeMetadata.Config config) {
        return MetadataAdapterHolder.reg((DatabaseType)this.type(), (String)type, (TypeMetadata.Config)config);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        DataSet set;
        Map tags;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        swt = InterceptorProxy.prepareInsert(runtime, random, batch, dest, data, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareInsert(runtime, random, batch, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap partitionTables = this.partitionTables(runtime, random, false, new MasterTable(dest), tags, null);
            if (partitionTables.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(partitionTables.keySet());
                if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    throw new CommandUpdateException(msg);
                }
                log.error(msg);
                return -1L;
            }
            dest = (Table)partitionTables.values().iterator().next();
        }
        Run run = this.buildInsertRun(runtime, batch, dest, data, configs, columns);
        if (ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            dest.setColumns(this.columns(runtime, random, false, dest, false));
        }
        if (null == run) {
            return 0L;
        }
        long cnt = 0L;
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeInsert(runtime, random, run, dest, data, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeInsert(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        cnt = this.insert(runtime, random, data, configs, run, null);
        if (null != this.dmListener) {
            this.dmListener.afterInsert(runtime, random, run, cnt, dest, data, columns, cmd_success, cnt, millis);
        }
        InterceptorProxy.afterInsert(runtime, random, run, dest, data, columns, cmd_success, cnt, System.currentTimeMillis() - fr);
        return cnt;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions)"), (int)37));
        }
        return 0L;
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (!list.isEmpty()) {
                run = this.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
            }
        } else {
            run = this.createInsertRun(runtime, dest, obj, configs, columns);
        }
        this.convert(runtime, configs, run);
        return run;
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String... conditions)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        LinkedHashMap cols = new LinkedHashMap<String, Column>();
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow(KeyAdapter.KEY_CASE.SRC, (Map)obj);
        }
        LinkedHashMap<String, Column> mastKeys = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        boolean each = true;
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = ConfigStore.IS_INSERT_NULL_FIELD(configs);
                isInsertEmptyColumn = ConfigStore.IS_INSERT_EMPTY_FIELD(configs);
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.INSERT));
                } else {
                    cols = new LinkedHashMap();
                    List fields = ClassUtil.getFields(obj.getClass(), (boolean)false, (boolean)false);
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        Field field = (Field)iterator.next();
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        cols.put(field.getName().toUpperCase(), new Column(field.getName()));
                    }
                }
            }
            if (batch) {
                isInsertNullColumn = true;
                isInsertEmptyColumn = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][columns:{}]", (Object)cols);
            }
            BeanUtil.removeAll(ignores, columns);
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][ignores:{}]", ignores);
            }
            List keys = Column.names((LinkedHashMap)cols);
            for (String key : keys) {
                if (mastKeys.containsKey(key.toUpperCase())) continue;
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    cols.remove(key);
                    continue;
                }
                if (!BasicUtil.isEmpty((boolean)true, (Object)value)) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                cols.remove(key);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[confirm insert columns][result:{}]", cols);
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.setPrimaryValue(value);
        } else {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), (Column)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run createInsertRun(DataRuntime runtime, Table dest, Object obj, List<String> columns)"), (int)37));
        }
        return null;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setBatch(batch);
        if (null == list || list.isEmpty()) {
            throw new CommandException("\u7a7a\u6570\u636e");
        }
        Object first = list.iterator().next();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Object item : list) {
            cols.putAll(this.confirmInsertColumns(runtime, dest, item, configs, columns, true));
            if (ConfigTable.IS_CHECK_ALL_INSERT_COLUMN) continue;
            break;
        }
        if (null == cols || cols.isEmpty()) {
            throw new CommandException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json(first) + "]");
        }
        run.setInsertColumns(cols);
        run.setVol(cols.size());
        this.fillInsertContent(runtime, (Run)run, dest, list, configs, cols);
        return run;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt;
        block18: {
            cnt = 0L;
            int batch = run.getBatch();
            String action = "insert";
            if (batch > 1) {
                action = "batch insert";
            }
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][action:{}][table:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)action, (Object)run.getTableName());
                }
                return -1L;
            }
            String cmd = run.getFinalInsert();
            if (run.isEmpty()) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:{}][table:{}]", (Object)action, (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][table:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, run.getTable(), cmd, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            long millis = -1L;
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            try {
                cnt = this.actuator.insert(this, runtime, random, data, configs, run, this.generatedKey(), pks);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, cmd, values, null, true, cnt, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = LogUtil.format((long)cnt, (int)34);
                    if (batch > 1) {
                        qty = LogUtil.format((String)("\u7ea6" + cnt), (int)34);
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), qty});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("insert \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}][table:{}]{}", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, action, run.getTable(), run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block18;
                CommandUpdateException ex = new CommandUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(cmd);
                ex.setValues(values);
                throw ex;
            }
        }
        return cnt;
    }

    @Override
    public boolean supportKeyHolder(DataRuntime runtime, ConfigStore configs) {
        return null == configs || configs.supportKeyHolder();
    }

    @Override
    public List<String> keyHolders(DataRuntime runtime, ConfigStore configs) {
        if (null != configs) {
            return configs.keyHolders();
        }
        return new ArrayList<String>();
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, batch, dest, data, configs, columns)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareUpdate(runtime, random, batch, dest, data, configs, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null == data) {
            if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new CommandUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        long result = 0L;
        if (data instanceof Collection && batch <= 1) {
            Collection list = (Collection)data;
            for (Object item : list) {
                DefaultConfigStore cfg = new DefaultConfigStore(new String[0]);
                cfg.copyProperty(configs);
                cfg.and(configs);
                result += this.update(runtime, random, 0, dest, item, (ConfigStore)cfg, columns);
            }
            return result;
        }
        Run run = this.buildUpdateRun(runtime, batch, dest, data, configs, columns);
        if (run.isEmptyCondition()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u6ca1\u6709\u66f4\u65b0\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        if (ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            dest.setColumns(this.columns(runtime, null, false, dest, false));
        }
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeUpdate(runtime, random, run, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeUpdate(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.update(runtime, random, dest, data, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterUpdate(runtime, random, run, result, dest, data, columns, cmd_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, dest, data, configs, columns, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public Run buildUpdateRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (!(obj instanceof DataRow) && obj instanceof Map) {
            obj = new DataRow((Map)obj);
        }
        run = obj instanceof Collection ? this.buildUpdateRunFromCollection(runtime, batch, dest, (Collection)obj, configs, cols) : (obj instanceof DataRow ? this.buildUpdateRunFromDataRow(runtime, dest, (DataRow)obj, configs, cols) : this.buildUpdateRunFromEntity(runtime, dest, obj, configs, cols));
        this.convert(runtime, configs, run);
        this.buildUpdateRunLimit(runtime, run);
        return run;
    }

    @Override
    public Run buildUpdateRunLimit(DataRuntime runtime, Run run) {
        return run;
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        List<String> primaryKeys;
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = run.getBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, obj, configs, list);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if ((primaryKeys = configs.keys()).isEmpty()) {
            if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
            } else {
                primaryKeys = new ArrayList<String>();
                primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
            }
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk = pk.toUpperCase()) || columns.containsKey("+" + pk) || configColumns.containsKey(pk)) continue;
            cols.remove(pk.toUpperCase());
        }
        String defaultPk = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(defaultPk) || columns.containsKey("+" + defaultPk) || configColumns.containsKey(defaultPk))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean isReplaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL(configs);
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    if (!first) {
                        builder.append(",");
                    }
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    first = false;
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if ("".equals(value) && !ConfigStore.IS_UPDATE_EMPTY_FIELD(configs)) {
                    chk = false;
                }
                if (!chk) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                if (this.isMultipleValue(runtime, run, key)) {
                    compare = Compare.IN;
                }
                this.addRunValue(runtime, run, compare, column, value);
            }
            builder.append("\n");
            if (configs.isEmptyCondition()) {
                for (String pk : primaryKeys) {
                    if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)pk);
                        configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, pk, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, pk, BeanUtil.getFieldValue((Object)obj, (String)pk));
                }
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        List<String> primaryKeys;
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)Column.names(columns));
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if ((primaryKeys = configs.keys()).isEmpty()) {
            primaryKeys.addAll(row.getPrimaryKeys());
        }
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        if (configs.isEmptyCondition()) {
            for (String string : primaryKeys) {
                Object pv = row.get(string);
                pv = this.convert(runtime, cols.get(string.toUpperCase()), pv);
                if (null == pv) continue;
                configs.and(Compare.EMPTY_VALUE_SWITCH.SRC, string, pv);
            }
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk = pk.toUpperCase()) || columns.containsKey("+" + pk) || configColumns.containsKey(pk)) continue;
            cols.remove(pk.toUpperCase());
        }
        String string = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(string) || columns.containsKey("+" + string) || configColumns.containsKey(string))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    continue;
                }
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                this.addRunValue(runtime, run, compare, col, value);
            }
            builder.append("\n");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition(this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        if (null == list || list.isEmpty()) {
            return run;
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        List<Object> primaryKeys = new ArrayList();
        boolean replaceEmptyNull = false;
        for (Object item : list) {
            if (item instanceof DataRow) {
                DataRow row = (DataRow)item;
                primaryKeys = row.getPrimaryKeys();
                cols.putAll(this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)Column.names(columns)));
                replaceEmptyNull = row.isReplaceEmptyNull();
            } else {
                ArrayList<String> ll = new ArrayList<String>();
                for (Column column : columns.values()) {
                    ll.add(column.getName());
                }
                cols.putAll(this.confirmUpdateColumns(runtime, dest, item, configs, ll));
                if (EntityAdapterProxy.hasAdapter(item.getClass())) {
                    primaryKeys.addAll(EntityAdapterProxy.primaryKeys(item.getClass()).keySet());
                } else {
                    primaryKeys = new ArrayList();
                    primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
                }
                replaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL(configs);
            }
            if (ConfigTable.IS_CHECK_ALL_UPDATE_COLUMN) continue;
            break;
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        StringBuilder builder = run.getBuilder();
        List<String> keys = configs.keys();
        if (!keys.isEmpty()) {
            primaryKeys = keys;
        }
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        LinkedHashMap<String, Column> configColumns = configs.getColumns();
        for (String string : primaryKeys) {
            String string2 = string.toUpperCase();
            if (columns.containsKey(string2) || columns.containsKey("+" + string2) || configColumns.containsKey(string2)) continue;
            cols.remove(string2.toUpperCase());
        }
        String defaultPk = DataRow.DEFAULT_PRIMARY_KEY.toUpperCase();
        if (!(columns.containsKey(defaultPk) || columns.containsKey("+" + defaultPk) || configColumns.containsKey(defaultPk))) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ");
            this.name(runtime, builder, (Metadata)dest);
            builder.append(" SET ");
            boolean start = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                if (!start) {
                    builder.append(",");
                }
                start = false;
                builder.append(key);
                builder.append(" = ?");
            }
            start = true;
            for (String string : primaryKeys) {
                if (start) {
                    builder.append(" WHERE ");
                } else {
                    builder.append(" AND ");
                }
                this.delimiter(builder, string).append(" = ?");
                start = false;
            }
        }
        run.setUpdateColumns(arrayList);
        ArrayList<RunValue> values = new ArrayList<RunValue>();
        for (Object e : list) {
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = BeanUtil.getFieldValue(e, (String)key);
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                values.add(new RunValue(key, value));
            }
            for (String string : primaryKeys) {
                values.add(new RunValue(string, BeanUtil.getFieldValue(e, (String)string)));
            }
        }
        run.setBatch(batch);
        run.setVol(cols.size() + primaryKeys.size());
        run.setRunValues(values);
        return run;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Column> cols = null;
        if (null == row) {
            return new LinkedHashMap<String, Column>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        if ((null == columns || columns.isEmpty()) && null != configs) {
            columns = configs.columns();
        }
        LinkedHashMap masters = row.getUpdateColumns(true);
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != configs) {
            BeanUtil.removeAll(configs.excludes(), columns);
        }
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            cols = masters;
        }
        if (each) {
            cols = row.getUpdateColumns(true);
            cols.putAll(masters);
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            List keys = Column.names(cols);
            for (String key : keys) {
                if (masters.containsKey(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key.toUpperCase());
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                cols.remove(key.toUpperCase());
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Object> cols = null;
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow(KeyAdapter.KEY_CASE.SRC, (Map)obj);
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        LinkedHashMap<String, Column> masters = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll(ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            cols = masters;
        }
        if (each) {
            boolean isUpdateNullColumn = ConfigStore.IS_UPDATE_NULL_FIELD(configs);
            boolean isUpdateEmptyColumn = ConfigStore.IS_UPDATE_EMPTY_FIELD(configs);
            cols = new LinkedHashMap();
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                masters.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isUpdateNullColumn = row.isUpdateNullColumn();
                isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            } else {
                cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
            }
            cols.putAll(masters);
            List keys = Column.names(cols);
            for (String key : keys) {
                if (masters.containsKey(key)) continue;
                Object value = BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key.toUpperCase());
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key.toUpperCase());
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                cols.remove(key.toUpperCase());
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) {
        long result;
        block17: {
            result = 0L;
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
                }
                return -1L;
            }
            if (run.isEmpty()) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:{}]", (Object)dest);
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List<Object> values = run.getValues();
            int batch = run.getBatch();
            String action = null;
            if (null != run.action()) {
                action = run.action().toString();
            }
            if (batch > 1) {
                action = "batch " + action;
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                result = this.actuator.update(this, runtime, random, dest, data, configs, run);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][{}][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, run.getFinalUpdate(), values, null, true, result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = result + "";
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), DateUtil.format((long)millis), LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("update \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    CommandUpdateException ex = new CommandUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) break block17;
                log.error("{}[{}][action:][{}]{}", new Object[]{random, action, run.getTable(), LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
            }
        }
        return result;
    }

    @Override
    public long save(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == data) {
            if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new CommandUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1L;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            long cnt = 0L;
            for (Object item : items) {
                cnt += this.save(runtime, random, dest, item, configs, columns);
            }
            return cnt;
        }
        return this.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        long cnt = 0L;
        return cnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        boolean isNew = BeanUtil.checkIsNew((Object)data);
        if (isNew) {
            return this.insert(runtime, random, 0, dest, data, configs, columns);
        }
        Boolean override = this.checkOverride(data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == override) return this.update(runtime, random, dest, data, configs, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists(runtime, random, prepare, stores, new String[0]);
        if (!exists) return this.insert(runtime, random, 0, dest, data, configs, columns);
        if (override.booleanValue()) {
            return this.update(runtime, random, dest, data, configs, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0L;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        LinkedHashMap columns;
        Table table = run.getTable();
        if (null != table && null != (columns = this.columns(runtime, null, false, table, false))) {
            Column column = (Column)columns.get(key.toUpperCase());
            return this.isMultipleValue(column);
        }
        return false;
    }

    protected boolean isMultipleValue(Column column) {
        String type;
        return null != column && ((type = column.getTypeName().toUpperCase()).contains("POINT") || type.contains("GEOMETRY") || type.contains("POLYGON"));
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (!ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
            return columns;
        }
        LinkedHashMap<String, Column> result = new LinkedHashMap<String, Column>();
        LinkedHashMap metadatas = this.columns(runtime, null, false, table, false);
        try {
            LinkedHashMap tags = this.tags(runtime, null, false, table);
            metadatas.putAll(tags);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!metadatas.isEmpty()) {
            for (String key : columns.keySet()) {
                if (metadatas.containsKey(key)) {
                    result.put(key, (Column)metadatas.get(key));
                    continue;
                }
                if (!ConfigStore.IS_LOG_SQL_WARN(configs)) continue;
                log.warn("[{}][column:{}.{}][insert/update\u5ffd\u7565\u5f53\u524d\u5217\u540d]", new Object[]{LogUtil.format((String)"\u5217\u540d\u68c0\u6d4b\u4e0d\u5b58\u5728", (int)33), table, key});
            }
        } else if (ConfigStore.IS_LOG_SQL_WARN(configs)) {
            log.warn("[{}][table:{}][\u5ffd\u7565\u5217\u540d\u68c0\u6d4b]", (Object)LogUtil.format((String)"\u8868\u7ed3\u6784\u68c0\u6d4b\u5931\u8d25(\u68c0\u67e5\u8868\u540d\u662f\u5426\u5b58\u5728)", (int)33), (Object)table);
        }
        if (ConfigStore.IS_LOG_SQL_WARN(configs)) {
            log.info("[check column metadata][origin:{}][result:{}]", (Object)columns.size(), (Object)result.size());
        }
        return result;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        Long fr = 0L;
        boolean cmd_success = false;
        Run run = null;
        PageNavi navi = null;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet().setTable(prepare.getTable());
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet().setTable(prepare.getTable());
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTableName() : prepare.getText();
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        if (null == (navi = run.getPageNavi()) && null != configs) {
            navi = configs.getPageNavi();
        }
        long total = 0L;
        Boolean autoCount = false;
        if (run.isValid() && null != navi) {
            autoCount = navi.autoCount();
            if (null == autoCount) {
                autoCount = true;
            }
            if (autoCount.booleanValue()) {
                if (null != this.dmListener) {
                    this.dmListener.beforeTotal(runtime, random, run);
                }
                fr = System.currentTimeMillis();
                if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                    total = 1L;
                } else if (navi.getTotalRow() == 0L) {
                    total = this.count(runtime, random, run);
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != this.dmListener) {
                    this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                }
                if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                    log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || total > 0L || !autoCount.booleanValue()) {
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                if ((swt = InterceptorProxy.beforeQuery(runtime, random, run, navi)) == ACTION.SWITCH.BREAK) {
                    return new DataSet().setTable(prepare.getTable());
                }
                set = this.select(runtime, random, false, prepare.getTable(), configs, run);
                cmd_success = true;
            } else {
                if (null != configs) {
                    configs.add(run);
                }
                set = new DataSet().setTable(prepare.getTable());
                if (ConfigStore.IS_CHECK_EMPTY_SET_METADATA(configs)) {
                    set.setMetadata(this.metadata(runtime, prepare, false));
                }
            }
        } else {
            set = new DataSet().setTable(prepare.getTable());
        }
        set.setDest(prepare.getDest());
        set.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            navi.setDataSize(set.size());
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, set, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, set, navi, System.currentTimeMillis() - fr);
        return set;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi)"), (int)37));
        }
        return new DataSet();
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == prepare) {
            prepare = new DefaultTablePrepare();
        }
        EntitySet<T> list = null;
        Long fr = System.currentTimeMillis();
        Run run = null;
        boolean cmd_success = false;
        PageNavi navi = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        if (BasicUtil.isEmpty((Object)prepare.getDest()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare)) {
            prepare.setDest(EntityAdapterProxy.table(clazz, (boolean)true));
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        navi = run.getPageNavi();
        long total = 0L;
        Boolean autoCount = false;
        if (run.isValid()) {
            if (null != navi) {
                autoCount = navi.autoCount();
                if (null == autoCount) {
                    autoCount = true;
                }
                if (autoCount.booleanValue()) {
                    if (null != this.dmListener) {
                        this.dmListener.beforeTotal(runtime, random, run);
                    }
                    fr = System.currentTimeMillis();
                    if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                        total = 1L;
                    } else if (navi.getTotalRow() == 0L) {
                        total = this.count(runtime, random, run);
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.dmListener) {
                        this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                    }
                }
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || !autoCount.booleanValue() || total > 0L) {
                swt = InterceptorProxy.beforeQuery(runtime, random, run, navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new EntitySet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                fr = System.currentTimeMillis();
                list = this.select(runtime, random, clazz, run.getTable(), configs, run);
                cmd_success = false;
            } else {
                list = new EntitySet();
            }
        } else {
            list = new EntitySet<T>();
        }
        list.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, list, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, list, navi, System.currentTimeMillis() - fr);
        return list;
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        EntitySet set = new EntitySet();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null != configs) {
            configs.entityClass(clazz);
        }
        DataSet rows = this.select(runtime, random, false, table, configs, run);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter(clazz) ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        return set;
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        List<Map<String, Object>> maps = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        Long fr = System.currentTimeMillis();
        if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs) && !run.isValid()) {
            String tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTableName() : prepare.getText();
            tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn(tmp);
        }
        if (run.isValid()) {
            Boolean autoCount;
            PageNavi navi;
            swt = InterceptorProxy.beforeQuery(runtime, random, run, null);
            if (swt == ACTION.SWITCH.BREAK) {
                return new ArrayList<Map<String, Object>>();
            }
            if (null != this.dmListener) {
                this.dmListener.beforeQuery(runtime, random, run, -1L);
            }
            if (null != configs && null != (navi = configs.getPageNavi()) && null != (autoCount = navi.autoCount()) && autoCount.booleanValue()) {
                long total = this.count(runtime, random, run);
                navi.setTotalRow(total);
            }
            maps = this.maps(runtime, random, configs, run);
            cmd_success = true;
        } else {
            maps = new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, maps, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, maps, null, System.currentTimeMillis() - fr);
        return maps;
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Run run = this.initQueryRun(runtime, prepare);
        this.init(runtime, run, configs, conditions);
        List<Run> unions = run.getUnions();
        if (null != unions) {
            for (Run union : unions) {
                this.init(runtime, union, configs, conditions);
            }
        }
        if (run.checkValid()) {
            run = this.fillQueryContent(runtime, run);
        }
        return run;
    }

    public void init(DataRuntime runtime, Run run, ConfigStore configs, String ... conditions) {
        if (null != run) {
            RunPrepare prepare = run.getPrepare();
            if (prepare instanceof TablePrepare) {
                this.likes(runtime, prepare.getTable(), configs);
            }
            if (run instanceof TextRun) {
                this.parseText(runtime, (TextRun)run);
            }
            run.addConfigStore(configs);
            configs = run.getConfigs();
            if (null != configs) {
                List<Object> statics = configs.getStaticValues();
                for (Object item : statics) {
                    run.addValue(new RunValue("none", item));
                }
            }
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                if (ConfigStore.IS_AUTO_CHECK_METADATA(configs)) {
                    List<Join> joins = prepare.getJoins();
                    Table table = run.getTable();
                    if (null != table && (null == joins || joins.isEmpty())) {
                        ConditionChain chain;
                        LinkedHashMap<String, Column> metadatas = this.columns(runtime, null, false, table, false);
                        OrderStore orders = run.getOrderStore();
                        if (null != orders) {
                            orders.filter(metadatas);
                        }
                        if (null != prepare) {
                            prepare.filter(metadatas);
                        }
                        if (null != (chain = run.getConditionChain())) {
                            chain.filter(metadatas);
                        }
                        if (null != configs) {
                            configs.filter(metadatas);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void parseText(DataRuntime runtime, TextRun run) {
        String text = run.getPrepare().getText();
        if (null == text) {
            return;
        }
        try {
            int varType = -1;
            Compare compare = Compare.EQUAL;
            List keys = null;
            int type = 0;
            keys = RegularUtil.fetchs((String)text, (String)"([^\\s\\$#]+)\\s*\\(?(\\s*[\\$|#]*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            type = 2;
            if (keys.isEmpty() && ConfigTable.IS_ENABLE_PLACEHOLDER_REGEX_EXT && this.supportSqlVarPlaceholderRegexExt(runtime)) {
                keys = RegularUtil.fetchs((String)text, (String)"(\\S+)\\s*\\(?(\\s*:+[A-Za-z]\\w+)(\\s|'|\\)|%|\\, )?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
                type = 1;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    Variable var = SyntaxHelper.buildVariable(type, (String)keyItem.get(0), (String)keyItem.get(1), (String)keyItem.get(2), (String)keyItem.get(3));
                    if (null == var) continue;
                    var.setSwt(Compare.EMPTY_VALUE_SWITCH.NULL);
                    run.addVariable(var);
                }
            } else {
                int qty = SQLUtil.countPlaceholder((String)text);
                if (qty > 0) {
                    for (int i = 0; i < qty; ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(0);
                        var.setSwt(Compare.EMPTY_VALUE_SWITCH.NULL);
                        run.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("parse text exception:", (Throwable)e);
        }
    }

    private void likes(DataRuntime runtime, Table table, ConfigStore configs) {
        if (null == table || null == configs) {
            return;
        }
        List<Config> list = configs.getConfigChain().getConfigs();
        for (Config config : list) {
            if (config.getCompare() != Compare.LIKES) continue;
            LinkedHashMap colums = this.columns(runtime, null, false, table, false);
            list.remove(config);
            DefaultConfigStore ors = new DefaultConfigStore(new String[0]);
            List<Object> values = config.getValues();
            Object value = null;
            if (null != values && !values.isEmpty()) {
                value = values.get(0);
            }
            for (Column column : colums.values()) {
                TypeMetadata tm = column.getTypeMetadata();
                if (null == tm || tm.getCategoryGroup() != TypeMetadata.CATEGORY_GROUP.STRING) continue;
                ors.or(Compare.LIKE, column.getName(), value);
            }
            configs.and(ors);
            break;
        }
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, Run run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, StringBuilder builder, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                run = this.fillQueryContent(runtime, builder, (TableRun)run);
            } else if (run instanceof XMLRun) {
                run = this.fillQueryContent(runtime, builder, (XMLRun)run);
            } else if (run instanceof TextRun) {
                run = this.fillQueryContent(runtime, builder, (TextRun)run);
            }
            this.convert(runtime, run.getConfigs(), run);
        }
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, XMLRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, TextRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
        return run;
    }

    protected Run fillQueryContent(DataRuntime runtime, TableRun run) {
        return this.fillQueryContent(runtime, run.getBuilder(), run);
    }

    protected Run fillQueryContent(DataRuntime runtime, StringBuilder builder, TableRun run) {
        ConfigStore configs;
        TablePrepare sql = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != sql.getDistinct()) {
            builder.append(sql.getDistinct());
        }
        builder.append("\n\t");
        LinkedHashMap<String, Object> columns = sql.getColumns();
        if ((null == columns || columns.isEmpty()) && null != (configs = run.getConfigs())) {
            List<String> cols = configs.columns();
            columns = new LinkedHashMap();
            Iterator<String> iterator = cols.iterator();
            while (iterator.hasNext()) {
                String col = iterator.next();
                columns.put(col.toUpperCase(), new Column(col));
            }
        }
        if (null != columns && !columns.isEmpty()) {
            boolean first = true;
            for (Column column : columns.values()) {
                if (BasicUtil.isEmpty((Object)column) || BasicUtil.isEmpty((Object)column.getName())) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                String name = column.getName();
                if (BasicUtil.checkEl((String)name)) {
                    name = name.substring(2, name.length() - 1);
                    builder.append(name);
                    continue;
                }
                if (name.contains("(") || name.contains(",")) {
                    builder.append(name);
                    continue;
                }
                if (name.toUpperCase().contains(" AS ")) {
                    int split = name.toUpperCase().indexOf(" AS ");
                    String tmp = name.substring(0, split).trim();
                    this.delimiter(builder, tmp);
                    builder.append(" ");
                    tmp = name.substring(split + 4).trim();
                    this.delimiter(builder, tmp);
                    continue;
                }
                if ("*".equals(name)) {
                    builder.append("*");
                    continue;
                }
                this.delimiter(builder, name);
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        Table table = run.getTable();
        builder.append("FROM").append("\n\t");
        this.name(runtime, builder, (Metadata)table);
        String alias = table.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(" ");
            this.delimiter(builder, alias);
        }
        builder.append("\n");
        List<Join> joins = sql.getJoins();
        if (null != joins) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String joinTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (Metadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)joinTableAlias)) {
                    builder.append("  ");
                    this.delimiter(builder, joinTableAlias);
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        run.appendCondition(builder, this, true, true);
        run.appendGroup(builder);
        return run;
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return run.getBaseQuery();
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder)"), (int)37));
        }
        return null;
    }

    @Override
    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder)"), (int)37));
        }
        return null;
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run)"), (int)37));
        }
        return new DataSet().setTable(table);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        List<Map<String, Object>> maps;
        block11: {
            maps = null;
            if (null == random) {
                random = this.random(runtime);
            }
            if (null != configs) {
                configs.add(run);
            }
            String sql = run.getFinalQuery();
            List<Object> values = run.getValues();
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new CommandQueryException("\u672a\u6307\u5b9a\u547d\u4ee4");
                }
                log.error("\u672a\u6307\u5b9a\u547d\u4ee4");
                return new ArrayList<Map<String, Object>>();
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new ArrayList<Map<String, Object>>();
            }
            try {
                maps = this.actuator.maps(this, runtime, random, configs, run);
                maps = this.process(runtime, maps);
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("maps \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) break block11;
                CommandQueryException ex = new CommandQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return maps;
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long fr;
        List<Object> values;
        String sql;
        Map<String, Object> map;
        block11: {
            map = null;
            sql = run.getFinalExists();
            values = run.getValues();
            if (null != configs) {
                configs.add(run);
            }
            fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.EXISTS, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new HashMap<String, Object>();
            }
            try {
                map = this.actuator.map(this, runtime, random, configs, run);
            }
            catch (Exception e) {
                if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION(configs)) {
                    throw new CommandQueryException("\u67e5\u8be2\u5f02\u5e38", e);
                }
                if (!ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) break block11;
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    e.printStackTrace();
                }
                log.error("{}[{}][action:select][cmd:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e, sql, LogUtil.param(values)});
            }
        }
        Long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
        if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:exists][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n]\n[param:{}]", new Object[]{random, DateUtil.format((Long)millis), sql, LogUtil.param(values)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, sql, values, null, true, map, millis);
            }
        }
        if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
            log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((Long)millis), LogUtil.format((int)(map == null ? 0 : 1), (int)34)});
        }
        return map;
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return list;
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long count = -1L;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        boolean cmd_success = false;
        ACTION.SWITCH swt = InterceptorProxy.prepareCount(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTableName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeCount(runtime, random, run);
        }
        if ((swt = InterceptorProxy.beforeCount(runtime, random, run)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        fr = System.currentTimeMillis();
        count = this.count(runtime, random, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        return count;
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalTotal(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long count(DataRuntime runtime, String random, Run run)"), (int)37));
        }
        return -1L;
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0  exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions)"), (int)37));
        }
        return false;
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalExists(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareExecute(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildExecuteRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTableName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeExecute(runtime, random, run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeExecute(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterExecute(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterExecute(runtime, random, run, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        if (null == random) {
            random = this.random(runtime);
        }
        prepare.setBatch(batch);
        Run run = this.buildExecuteRun(runtime, prepare, configs, new String[0]);
        if (null != values && !values.isEmpty()) {
            Object first = values.iterator().next();
            if (first instanceof Collection) {
                ArrayList<Object> list = new ArrayList<Object>();
                int vol = 0;
                for (Object item : values) {
                    Collection col = (Collection)item;
                    list.addAll(col);
                    vol = col.size();
                }
                run.setValues(null, list);
                run.setVol(vol);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                List<Variable> vars = run.getVariables();
                ArrayList<String> keys = new ArrayList<String>();
                run.setVol(vars.size());
                for (Variable var : vars) {
                    keys.add(var.getKey());
                }
                for (Object item : values) {
                    for (String key : keys) {
                        Object value = BeanUtil.getFieldValue((Object)item, (String)key);
                        list.add(value);
                    }
                }
                run.setValues(null, list);
            }
        }
        return this.execute(runtime, random, configs, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, int vol, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        if (null == random) {
            random = this.random(runtime);
        }
        prepare.setBatch(batch);
        Run run = this.buildExecuteRun(runtime, prepare, configs, new String[0]);
        run.setVol(vol);
        run.setValues(null, values);
        return this.execute(runtime, random, configs, run);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Procedure procedure)"), (int)37));
        }
        return false;
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        AbstractRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setBatch(prepare.getBatch());
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            if (run instanceof TextRun) {
                this.parseText(runtime, (TextRun)run);
            }
            run.setConfigStore(configs);
            run.addCondition(conditions);
            run.init();
            this.fillExecuteContent(runtime, run);
        }
        return run;
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        this.replaceVariable(runtime, run);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillExecuteContent(runtime, r);
            }
        }
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result;
        block16: {
            result = -1L;
            if (null == random) {
                random = this.random(runtime);
            }
            String sql = run.getFinalExecute();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            int batch = run.getBatch();
            String action = "execute";
            if (batch > 1) {
                action = "batch execute";
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL(configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM(configs)) {
                    log.info("{}[action:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, sql, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
            }
            if (null != configs) {
                configs.add(run);
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                result = this.actuator.execute(this, runtime, random, configs, run);
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS(configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL(configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][\u6267\u884c\u8017\u65f6:{}][cmd:\n{}\n]\n[param:{}]", new Object[]{random, action, DateUtil.format((long)millis), sql, LogUtil.param(values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, sql, values, null, true, result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME(configs)) {
                    String qty = "" + result;
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][\u6267\u884c\u8017\u65f6:{}][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, DateUtil.format((long)millis), LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE(configs)) {
                    log.error("execute exception:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR(configs)) {
                    log.error("{}[{}][action:{}]{}", new Object[]{random, LogUtil.format((String)"\u547d\u4ee4\u6267\u884c\u5f02\u5e38:", (int)33) + e, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER(configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) break block16;
                throw new CommandUpdateException("\u547d\u4ee4\u6267\u884c\u5f02\u5e38", e);
            }
        }
        return result;
    }

    protected void replaceVariable(DataRuntime runtime, TextRun run) {
        StringBuilder builder = run.getBuilder();
        List<Variable> variables = run.getVariables();
        String result = run.getText();
        if (this.supportPlaceholder() && null != variables) {
            List<Object> varValues;
            Object value;
            List<Object> values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    result = result.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                result = result.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (run.getBatch() > 1) {
                    result = result.replace(var.getFullKey(), "?");
                    continue;
                }
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        String replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = replaceDst + " ?";
                        }
                        this.addRunValue(runtime, run, Compare.IN, new Column(var.getKey()), varValues);
                        replaceDst = replaceDst.trim().replace(" ", ",");
                        result = result.replace(var.getFullKey(), replaceDst);
                        continue;
                    }
                    result = result.replace(var.getFullKey(), "?");
                    this.addRunValue(runtime, run, Compare.EQUAL, new Column(var.getKey()), varValues.get(0));
                    continue;
                }
                result = result.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    value = varValues.get(0);
                }
                this.addRunValue(runtime, run, Compare.EQUAL, new Column(var.getKey()), value);
            }
        }
        builder.append(result);
    }

    @Override
    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String key, Collection<T> values) {
        ACTION.SWITCH swt;
        long result = -1L;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareDelete(runtime, random, batch, table, key, values)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, batch, table, key, values);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        List<Run> runs = this.buildDeleteRun(runtime, batch, table, configs, key, values);
        for (Run run : runs) {
            if (!run.isValid()) {
                if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                continue;
            }
            if (result == -1L) {
                result = 1L;
            }
            result += this.delete(runtime, random, configs, run);
        }
        return result;
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long size = -1L;
        if (null != obj) {
            swt = InterceptorProxy.prepareDelete(runtime, random, 0, dest, obj, columns);
            if (swt == ACTION.SWITCH.BREAK) {
                return -1L;
            }
            if (null != this.dmListener) {
                swt = this.dmListener.prepareDelete(runtime, random, 0, dest, obj, columns);
            }
            if (swt == ACTION.SWITCH.BREAK) {
                return -1L;
            }
            List<Run> runs = this.buildDeleteRun(runtime, dest, configs, obj, columns);
            for (Run run : runs) {
                if (!run.isValid()) {
                    if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                    continue;
                }
                if (size == -1L) {
                    size = 0L;
                }
                size += this.delete(runtime, random, configs, run);
            }
        }
        return size;
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        long result = -1L;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        swt = InterceptorProxy.prepareDelete(runtime, random, 0, table, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, 0, table, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        List<Run> runs = this.buildDeleteRun(runtime, table, configs, (Object)conditions, new String[0]);
        for (Run run : runs) {
            if (!run.isValid()) {
                if (!log.isWarnEnabled() || !ConfigStore.IS_LOG_SQL(configs)) continue;
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                continue;
            }
            if (result == -1L) {
                result = 0L;
            }
            result += this.delete(runtime, random, configs, run);
        }
        return result;
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        List<Run> runs = this.buildTruncateRun(runtime, table);
        if (null != runs && runs.size() > 0) {
            DefaultTextPrepare prepare = new DefaultTextPrepare(runs.get(0).getFinalUpdate());
            return (int)this.execute(runtime, random, prepare, null, new String[0]);
        }
        return -1L;
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        List<Run> runs = new ArrayList<Run>();
        if (null == obj && (null == configs || configs.isEmptyCondition())) {
            return null;
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                runs.addAll(this.buildDeleteRun(runtime, dest, configs, item, columns));
            }
            return runs;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, obj, configs);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table;
            }
        }
        if (null == dest || BasicUtil.isEmpty((Object)dest.getName())) {
            runs = this.buildDeleteRunFromConfig(runtime, configs);
        } else if (obj instanceof ConfigStore) {
            TableRun run = new TableRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDest(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, run);
            runs.add(run);
        } else {
            runs = this.buildDeleteRunFromEntity(runtime, dest, configs, obj, columns);
        }
        this.convert(runtime, (ConfigStore)new DefaultConfigStore(new String[0]), runs);
        return runs;
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, String key, Object values) {
        List<Run> runs = this.buildDeleteRunFromTable(runtime, batch, table, configs, key, values);
        this.convert(runtime, (ConfigStore)new DefaultConfigStore(new String[0]), runs);
        return runs;
    }

    @Override
    public List<Run> buildTruncateRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    @Override
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs,String column, Object values)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, String ... columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDeleteRunFromEntity(DataRuntime runtime, String table, ConfigStore configs, Object obj, String... columns)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillDeleteRunContent(DataRuntime runtime, Run run)"), (int)37));
        }
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result = -1L;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete(runtime, random, run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        long millis = -1L;
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete(runtime, random, run, cmd_success, result, millis);
        return result;
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, String random)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        String product = null;
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryProductRun(runtime);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            product = this.product(runtime, idx++, true, product, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[product][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (null == product) {
                product = this.product(runtime, false, product);
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[product][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, product, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[product][result:fail][msg:{}]", (Object)e.toString());
        }
        return product;
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        String version = null;
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryProductRun(runtime);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            version = this.version(runtime, idx++, true, version, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[version][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (null == version) {
                version = this.version(runtime, false, version);
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[version][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, version, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[version][result:fail][msg:{}]", (Object)e.toString());
        }
        return version;
    }

    @Override
    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Database> databases = new ArrayList<Database>();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryDatabasesRun(runtime, greedy, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            databases = this.databases(runtime, idx++, true, databases, null, null, set);
                        }
                    }
                    if (databases.isEmpty()) {
                        databases = this.getActuator().databases(this, runtime);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, databases.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        try {
            long fr;
            block12: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryDatabasesRun(runtime, false, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            databases = this.databases(runtime, idx++, true, databases, null, null, set);
                        }
                    }
                    if (databases.isEmpty()) {
                        List<Database> list = this.getActuator().databases(this, runtime);
                        for (Database item : list) {
                            databases.put(item.getName().toUpperCase(), item);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block12;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, databases.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabaseRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryProductRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVersionRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Database>();
    }

    @Override
    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new ArrayList<Database>();
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database database, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, int index, boolean create, Database database,DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database database) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, boolean create, Database database)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String product(DataRuntime runtime, int index, boolean create, String product, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String product(DataRuntime runtime, boolean create, String product)"), (int)37));
        }
        return null;
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String version(DataRuntime runtime, int index, boolean create, String version, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String version(DataRuntime runtime, boolean create, String version)"), (int)37));
        }
        return null;
    }

    @Override
    public Catalog catalog(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        Catalog catalog = null;
        try {
            long fr;
            block14: {
                block13: {
                    fr = System.currentTimeMillis();
                    try {
                        List<Run> runs = this.buildQueryCatalogRun(runtime, random);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                                catalog = this.catalog(runtime, idx++, true, catalog, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block13;
                        log.warn("{}[catalog][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                    }
                }
                try {
                    catalog = this.catalog(runtime, true, catalog);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[catalog][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636eJDBC\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalog][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalog][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalog;
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Catalog> catalogs = new LinkedHashMap<String, Catalog>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryCatalogsRun(runtime, false, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, null, null, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalogs.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Catalog> catalogs = new ArrayList<Catalog>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryCatalogsRun(runtime, greedy, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, null, null, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalogs.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public List<Run> buildQueryCatalogRun(DataRuntime runtime, String random) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryCatalogRun(DataRuntime runtime, String random)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Catalog>();
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set)"), (int)37));
        }
        return new ArrayList<Catalog>();
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs)"), (int)37));
        }
        return new LinkedHashMap<String, Catalog>();
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs)"), (int)37));
        }
        return new ArrayList<Catalog>();
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog)"), (int)37));
        }
        return null;
    }

    @Override
    public Schema schema(DataRuntime runtime, String random) {
        if (null == random) {
            random = this.random(runtime);
        }
        Schema schema = null;
        try {
            long fr;
            block14: {
                block13: {
                    fr = System.currentTimeMillis();
                    try {
                        List<Run> runs = this.buildQuerySchemaRun(runtime, random);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                                schema = this.schema(runtime, idx++, true, schema, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block13;
                        log.warn("{}[schema][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                    }
                }
                try {
                    schema = this.schema(runtime, true, schema);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                    log.warn("{}[schema][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636eJDBC\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schema][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schema, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schema][result:fail][msg:{}]", (Object)e.toString());
        }
        return schema;
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySchemasRun(runtime, false, catalog, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            schemas = this.schemas(runtime, idx++, true, schemas, null, null, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schemas.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Schema> schemas = new ArrayList<Schema>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySchemasRun(runtime, greedy, catalog, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            schemas = this.schemas(runtime, idx++, true, schemas, null, null, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, schemas.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public List<Run> buildQuerySchemaRun(DataRuntime runtime, String random) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySchemaRun(DataRuntime runtime, String random)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Schema>();
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new ArrayList<Schema>();
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, Schema> schemas) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Schema> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, Schema> schemas)"), (int)37));
        }
        return new LinkedHashMap<String, Schema>();
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, boolean create, List<Schema> schemas) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Schema> schemas(DataRuntime runtime, boolean create, List<Schema> schemas)"), (int)37));
        }
        return new ArrayList<Schema>();
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema schema) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Schema schema(DataRuntime runtime, boolean create, Schema schema)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Metadata> T checkName(DataRuntime runtime, String random, T meta) throws RuntimeException {
        if (null == meta) {
            return null;
        }
        String name = meta.getName();
        if (null != name && name.contains(".")) {
            String[] ks = name.split("\\.");
            if (ks.length == 3) {
                meta.setCatalog(ks[0]);
                meta.setSchema(ks[1]);
                meta.setName(ks[2]);
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5b9e\u522bschema\u6216catalog(\u5b50\u7c7b\u672a" + this.getClass().getSimpleName() + "\u5b9e\u73b0)");
            }
        }
        return meta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            String caches_key;
            long fr;
            block36: {
                PageNavi navi;
                block35: {
                    fr = System.currentTimeMillis();
                    Table search = new Table();
                    if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                        Table tmp = new Table();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                            catalog = tmp.getCatalog();
                        }
                        if (this.supportSchema() && this.empty((Metadata)schema)) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null != (list = CacheProxy.tables(caches_key = CacheProxy.key(runtime, "tables", greedy, catalog, schema, pattern, types, configs))) && !list.isEmpty()) {
                        return list;
                    }
                    String cache_key = CacheProxy.key(runtime, "table", greedy, catalog, schema, pattern);
                    origin = CacheProxy.name(cache_key);
                    if (null == origin && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.tableMap(runtime, random, greedy, catalog, schema, null);
                        origin = CacheProxy.name(cache_key);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    navi = null;
                    if (null == configs) {
                        configs = new DefaultConfigStore(new String[0]);
                    }
                    navi = configs.getPageNavi();
                    try {
                        List<Run> runs = this.buildQueryTablesRun(runtime, greedy, catalog, schema, origin, types, configs);
                        if (null == runs) break block35;
                        int idx = 0;
                        for (Run run : runs) {
                            if (null != navi) {
                                run.setPageNavi(navi);
                                this.mergeFinalQuery(runtime, run);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.tables(runtime, idx++, true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.isEmpty()) {
                    try {
                        list = this.tables(runtime, true, list, catalog, schema, origin, types);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                Table table = (Table)list.get(i);
                                if (this.equals(catalog, table.getCatalog()) && this.equals(schema, table.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[tables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (Table table : list) {
                    if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryTablesCommentRun(runtime, catalog, schema, origin, types);
                        if (null == runs) break block36;
                        boolean bl = false;
                        for (Run run : runs) {
                            void var20_32;
                            if (null != navi) {
                                run.setPageNavi(navi);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.comments(runtime, (int)(++var20_32), true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, origin, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<Table> tmp = new ArrayList<Table>();
                for (Table table : list) {
                    String name = table.getName(greedy) + "";
                    if (!RegularUtil.match((String)name.toUpperCase(), (String)origin.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, table.getCatalog()) || !this.equals(schema, table.getSchema())) continue;
                    tmp.add(table);
                }
                list = tmp;
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                List columns = this.columns(runtime, random, greedy, catalog, schema, list);
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                this.indexes(runtime, random, greedy, list);
            }
            CacheProxy.tables(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List tables = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryTablesRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, null);
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    tables = this.tables(runtime, idx++, true, tables, catalog, schema, set);
                    for (Table table : tables) {
                        String cache_key = CacheProxy.key(runtime, "table", greedy, catalog, schema, table.getName());
                        CacheProxy.name(cache_key, table.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                tables = this.tables(runtime, true, tables, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (Table table : tables) {
                    String cache_key = CacheProxy.key(runtime, "table", greedy, catalog, schema, table.getName());
                    CacheProxy.name(cache_key, table.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        List<T> list = this.tables(runtime, random, false, catalog, schema, pattern, types, struct, configs);
        for (Table table : list) {
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T table = null;
            if (null == this.search(tables, (table = this.init(runtime, index, table, catalog, schema, row)).getCatalog(), table.getSchema(), table.getName())) {
                tables.add(table);
            }
            this.detail(runtime, index, table, catalog, schema, row);
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        return tables;
    }

    @Override
    public <T extends Table> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Table> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public TableMetadataAdapter tableMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 TableMetadataAdapter tableMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new TableMetadataAdapter();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0  <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return tables;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, table);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = table.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, table, true);
                        table.setColumns(columns);
                        table.setTags(this.tags(runtime, random, false, table));
                    }
                    if (null == (pk = table.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, table);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    table.setPrimaryKey(pk);
                    LinkedHashMap indexes = table.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        table.setIndexes(this.indexes(runtime, random, table, null));
                    }
                    runs = this.buildCreateRun(runtime, table);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        table.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            String caches_key;
            long fr;
            block36: {
                PageNavi navi;
                block35: {
                    fr = System.currentTimeMillis();
                    VertexTable search = new VertexTable();
                    if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                        VertexTable tmp = new VertexTable();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                            catalog = tmp.getCatalog();
                        }
                        if (this.supportSchema() && this.empty((Metadata)schema)) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null != (list = CacheProxy.vertexTables(caches_key = CacheProxy.key(runtime, "vertexTables", greedy, catalog, schema, pattern, types, configs))) && !list.isEmpty()) {
                        return list;
                    }
                    String cache_key = CacheProxy.key(runtime, "vertexTable", greedy, catalog, schema, pattern);
                    origin = CacheProxy.name(cache_key);
                    if (null == origin && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.vertexTableMap(runtime, random, greedy, catalog, schema, null);
                        origin = CacheProxy.name(cache_key);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    navi = null;
                    if (null == configs) {
                        configs = new DefaultConfigStore(new String[0]);
                    }
                    navi = configs.getPageNavi();
                    try {
                        List<Run> runs = this.buildQueryVertexTablesRun(runtime, greedy, catalog, schema, origin, types, configs);
                        if (null == runs) break block35;
                        int idx = 0;
                        for (Run run : runs) {
                            if (null != navi) {
                                run.setPageNavi(navi);
                                this.mergeFinalQuery(runtime, run);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.vertexTables(runtime, idx++, true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[vertexTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.isEmpty()) {
                    try {
                        list = this.vertexTables(runtime, true, list, catalog, schema, origin, types);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                VertexTable vertexTable = (VertexTable)list.get(i);
                                if (this.equals(catalog, vertexTable.getCatalog()) && this.equals(schema, vertexTable.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[vertexTables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (VertexTable vertexTable : list) {
                    if (!BasicUtil.isNotEmpty((Object)vertexTable.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryVertexTablesCommentRun(runtime, catalog, schema, origin, types);
                        if (null == runs) break block36;
                        boolean bl = false;
                        for (Run run : runs) {
                            void var20_32;
                            if (null != navi) {
                                run.setPageNavi(navi);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.comments(runtime, (int)(++var20_32), true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.info("{}[vertexTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[vertexTables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, origin, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<VertexTable> tmp = new ArrayList<VertexTable>();
                for (VertexTable vertexTable : list) {
                    String name = vertexTable.getName(greedy) + "";
                    if (!RegularUtil.match((String)name.toUpperCase(), (String)origin.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, vertexTable.getCatalog()) || !this.equals(schema, vertexTable.getSchema())) continue;
                    tmp.add(vertexTable);
                }
                list = tmp;
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                List columns = this.columns(runtime, random, greedy, catalog, schema, list);
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                // empty if block
            }
            CacheProxy.tables(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[vertexTables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void vertexTableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List vertexTables = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryVertexTablesRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, null);
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    vertexTables = this.vertexTables(runtime, idx++, true, vertexTables, catalog, schema, set);
                    for (VertexTable vertexTable : vertexTables) {
                        String cache_key = CacheProxy.key(runtime, "vertexTable", greedy, catalog, schema, vertexTable.getName());
                        CacheProxy.name(cache_key, vertexTable.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                vertexTables = this.vertexTables(runtime, true, vertexTables, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (VertexTable vertexTable : vertexTables) {
                    String cache_key = CacheProxy.key(runtime, "vertexTable", greedy, catalog, schema, vertexTable.getName());
                    CacheProxy.name(cache_key, vertexTable.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, VertexTable> vertexTables = new LinkedHashMap<String, VertexTable>();
        List<T> list = this.vertexTables(runtime, random, false, catalog, schema, pattern, types, struct, configs);
        for (VertexTable vertexTable : list) {
            vertexTables.put(vertexTable.getName().toUpperCase(), vertexTable);
        }
        return vertexTables;
    }

    @Override
    public List<Run> buildQueryVertexTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVertexTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryVertexTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryVertexTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> vertexTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> vertexTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == vertexTables) {
            vertexTables = new LinkedHashMap();
        }
        return vertexTables;
    }

    @Override
    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, int index, boolean create, List<T> vertexTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, int index, boolean create, List<T> vertexTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == vertexTables) {
            vertexTables = new ArrayList<T>();
        }
        return vertexTables;
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> vertexTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> vertexTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == vertexTables) {
            vertexTables = new LinkedHashMap();
        }
        return vertexTables;
    }

    @Override
    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, boolean create, List<T> vertexTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, boolean create, List<T> vertexTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == vertexTables) {
            vertexTables = new ArrayList<T>();
        }
        return vertexTables;
    }

    @Override
    public <T extends VertexTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public VertexTableMetadataAdapter vertexTableMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 VertexTableMetadataAdapter vertexTableMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new VertexTableMetadataAdapter();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, VertexTable vertexTable, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, vertexTable);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)((VertexTable)null), new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, vertexTable, list, set);
                    }
                    vertexTable.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = vertexTable.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)vertexTable, true);
                        vertexTable.setColumns(columns);
                        vertexTable.setTags(this.tags(runtime, random, false, (Table)vertexTable));
                    }
                    if (null == (pk = vertexTable.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)vertexTable);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    vertexTable.setPrimaryKey(pk);
                    LinkedHashMap indexes = vertexTable.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        vertexTable.setIndexes(this.indexes(runtime, random, (Table)vertexTable, null));
                    }
                    runs = this.buildCreateRun(runtime, (Table)vertexTable);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        vertexTable.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[vertexTable ddl][vertexTable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, vertexTable.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[vertexTable ddl][{}][vertexTable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), vertexTable.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, VertexTable vertexTable) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, VertexTable vertexTable)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, VertexTable vertexTable, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, VertexTable vertexTable, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            String caches_key;
            long fr;
            block36: {
                PageNavi navi;
                block35: {
                    fr = System.currentTimeMillis();
                    EdgeTable search = new EdgeTable();
                    if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                        EdgeTable tmp = new EdgeTable();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                            catalog = tmp.getCatalog();
                        }
                        if (this.supportSchema() && this.empty((Metadata)schema)) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null != (list = CacheProxy.edgeTables(caches_key = CacheProxy.key(runtime, "edgeTables", greedy, catalog, schema, pattern, types, configs))) && !list.isEmpty()) {
                        return list;
                    }
                    String cache_key = CacheProxy.key(runtime, "edgeTable", greedy, catalog, schema, pattern);
                    origin = CacheProxy.name(cache_key);
                    if (null == origin && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.edgeTableMap(runtime, random, greedy, catalog, schema, null);
                        origin = CacheProxy.name(cache_key);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    navi = null;
                    if (null == configs) {
                        configs = new DefaultConfigStore(new String[0]);
                    }
                    navi = configs.getPageNavi();
                    try {
                        List<Run> runs = this.buildQueryEdgeTablesRun(runtime, greedy, catalog, schema, origin, types, configs);
                        if (null == runs) break block35;
                        int idx = 0;
                        for (Run run : runs) {
                            if (null != navi) {
                                run.setPageNavi(navi);
                                this.mergeFinalQuery(runtime, run);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.edgeTables(runtime, idx++, true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[edgeTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.isEmpty()) {
                    try {
                        list = this.edgeTables(runtime, true, list, catalog, schema, origin, types);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                EdgeTable edgeTable = (EdgeTable)list.get(i);
                                if (this.equals(catalog, edgeTable.getCatalog()) && this.equals(schema, edgeTable.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[edgeTables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (EdgeTable edgeTable : list) {
                    if (!BasicUtil.isNotEmpty((Object)edgeTable.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryEdgeTablesCommentRun(runtime, catalog, schema, origin, types);
                        if (null == runs) break block36;
                        boolean bl = false;
                        for (Run run : runs) {
                            void var20_32;
                            if (null != navi) {
                                run.setPageNavi(navi);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.comments(runtime, (int)(++var20_32), true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.info("{}[edgeTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[edgeTables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, origin, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<EdgeTable> tmp = new ArrayList<EdgeTable>();
                for (EdgeTable edgeTable : list) {
                    String name = edgeTable.getName(greedy) + "";
                    if (!RegularUtil.match((String)name.toUpperCase(), (String)origin.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, edgeTable.getCatalog()) || !this.equals(schema, edgeTable.getSchema())) continue;
                    tmp.add(edgeTable);
                }
                list = tmp;
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                List columns = this.columns(runtime, random, greedy, catalog, schema, list);
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                this.indexes(runtime, random, greedy, list);
            }
            CacheProxy.tables(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[edgeTables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void edgeTableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List edgeTables = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryEdgeTablesRun(runtime, greedy, catalog, schema, null, Table.TYPE.NORMAL.value, null);
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    edgeTables = this.edgeTables(runtime, idx++, true, edgeTables, catalog, schema, set);
                    for (EdgeTable item : edgeTables) {
                        String cache_key = CacheProxy.key(runtime, "edgeTable", greedy, catalog, schema, item.getName());
                        CacheProxy.name(cache_key, item.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                edgeTables = this.edgeTables(runtime, true, edgeTables, catalog, schema, null, Table.TYPE.NORMAL.value);
                for (EdgeTable item : edgeTables) {
                    String cache_key = CacheProxy.key(runtime, "edgeTable", greedy, catalog, schema, item.getName());
                    CacheProxy.name(cache_key, item.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, EdgeTable> edgeTables = new LinkedHashMap<String, EdgeTable>();
        List<T> list = this.edgeTables(runtime, random, false, catalog, schema, pattern, types, struct, configs);
        for (EdgeTable edgeTable : list) {
            edgeTables.put(edgeTable.getName().toUpperCase(), edgeTable);
        }
        return edgeTables;
    }

    @Override
    public List<Run> buildQueryEdgeTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryEdgeTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryEdgeTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryEdgeTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> edgeTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> edgeTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == edgeTables) {
            edgeTables = new LinkedHashMap();
        }
        return edgeTables;
    }

    @Override
    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, int index, boolean create, List<T> edgeTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, int index, boolean create, List<T> edgeTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == edgeTables) {
            edgeTables = new ArrayList<T>();
        }
        return edgeTables;
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> edgeTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> edgeTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == edgeTables) {
            edgeTables = new LinkedHashMap();
        }
        return edgeTables;
    }

    @Override
    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, boolean create, List<T> edgeTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, boolean create, List<T> edgeTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == edgeTables) {
            edgeTables = new ArrayList<T>();
        }
        return edgeTables;
    }

    @Override
    public <T extends EdgeTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public EdgeTableMetadataAdapter edgeTableMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 EdgeTableMetadataAdapter edgeTableMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new EdgeTableMetadataAdapter();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, EdgeTable meta, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, meta);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)((EdgeTable)null), new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    meta.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = meta.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)meta, true);
                        meta.setColumns(columns);
                        meta.setTags(this.tags(runtime, random, false, (Table)meta));
                    }
                    if (null == (pk = meta.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)meta);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    meta.setPrimaryKey(pk);
                    LinkedHashMap indexes = meta.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        meta.setIndexes(this.indexes(runtime, random, (Table)meta, null));
                    }
                    runs = this.buildCreateRun(runtime, (Table)meta);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[edgeTable ddl][edgeTable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[edgeTable ddl][{}][edgeTable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, EdgeTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, EdgeTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, EdgeTable meta, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, EdgeTable meta, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            String caches_key;
            long fr;
            block36: {
                PageNavi navi;
                block35: {
                    fr = System.currentTimeMillis();
                    View search = new View();
                    if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                        View tmp = new View();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                            catalog = tmp.getCatalog();
                        }
                        if (this.supportSchema() && this.empty((Metadata)schema)) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null != (list = CacheProxy.views(caches_key = CacheProxy.key(runtime, "views", greedy, catalog, schema, pattern, types, configs))) && !list.isEmpty()) {
                        return list;
                    }
                    String cache_key = CacheProxy.key(runtime, "view", greedy, catalog, schema, pattern);
                    origin = CacheProxy.name(cache_key);
                    if (null == origin && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.viewMap(runtime, random, greedy, catalog, schema, null);
                        origin = CacheProxy.name(cache_key);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    navi = null;
                    if (null == configs) {
                        configs = new DefaultConfigStore(new String[0]);
                    }
                    navi = configs.getPageNavi();
                    try {
                        List<Run> runs = this.buildQueryViewsRun(runtime, greedy, catalog, schema, origin, types, configs);
                        if (null == runs) break block35;
                        int idx = 0;
                        for (Run run : runs) {
                            if (null != navi) {
                                run.setPageNavi(navi);
                                this.mergeFinalQuery(runtime, run);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.views(runtime, idx++, true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u89c6\u56fe\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.isEmpty()) {
                    try {
                        list = this.views(runtime, true, list, catalog, schema, origin, types);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                View view = (View)list.get(i);
                                if (this.equals(catalog, view.getCatalog()) && this.equals(schema, view.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[views][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (View view : list) {
                    if (!BasicUtil.isNotEmpty((Object)view.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryViewsCommentRun(runtime, catalog, schema, origin, types);
                        if (null == runs) break block36;
                        boolean bl = false;
                        for (Run run : runs) {
                            void var20_32;
                            if (null != navi) {
                                run.setPageNavi(navi);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.comments(runtime, (int)(++var20_32), true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.info("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u89c6\u56fe\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, origin, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<View> tmp = new ArrayList<View>();
                for (View view : list) {
                    String name = view.getName(greedy) + "";
                    if (!RegularUtil.match((String)name.toUpperCase(), (String)origin.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, view.getCatalog()) || !this.equals(schema, view.getSchema())) continue;
                    tmp.add(view);
                }
                list = tmp;
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                List columns = this.columns(runtime, random, greedy, catalog, schema, list);
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                this.indexes(runtime, random, greedy, list);
            }
            CacheProxy.views(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[views][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void viewMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List views = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryViewsRun(runtime, greedy, catalog, schema, null, View.TYPE.NORMAL.value, null);
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    views = this.views(runtime, idx++, true, views, catalog, schema, set);
                    for (View view : views) {
                        String cache_key = CacheProxy.key(runtime, "view", greedy, catalog, schema, view.getName());
                        CacheProxy.name(cache_key, view.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                views = this.views(runtime, true, views, catalog, schema, null, View.TYPE.NORMAL.value);
                for (View view : views) {
                    String cache_key = CacheProxy.key(runtime, "view", greedy, catalog, schema, view.getName());
                    CacheProxy.name(cache_key, view.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, View> views = new LinkedHashMap<String, View>();
        List<T> list = this.views(runtime, random, false, catalog, schema, pattern, types, struct, configs);
        for (View view : list) {
            views.put(view.getName().toUpperCase(), view);
        }
        return views;
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewsRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryViewsCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewsCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public <T extends View> List<T> views(DataRuntime runtime, int index, boolean create, List<T> views, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> List<T> views(DataRuntime runtime, int index, boolean create, List<T> views, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == views) {
            views = new ArrayList<T>();
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> views, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> views, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == views) {
            views = new ArrayList<T>();
        }
        return views;
    }

    @Override
    public <T extends View> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends View> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public ViewMetadataAdapter viewMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 ViewMetadataAdapter viewMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new ViewMetadataAdapter();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, view);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)((View)null), new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, view, list, set);
                    }
                    view.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = view.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)view, true);
                        view.setColumns(columns);
                        view.setTags(this.tags(runtime, random, false, (Table)view));
                    }
                    if (null == (pk = view.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)view);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    view.setPrimaryKey(pk);
                    LinkedHashMap indexes = view.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        view.setIndexes(this.indexes(runtime, random, (Table)view, null));
                    }
                    runs = this.buildCreateRun(runtime, view);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        view.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[view ddl][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, view.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[view ddl][{}][view:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u89c6\u56fe\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), view.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        List<Object> list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            String caches_key;
            long fr;
            block36: {
                PageNavi navi;
                block35: {
                    fr = System.currentTimeMillis();
                    MasterTable search = new MasterTable();
                    if (this.supportCatalog() && this.empty((Metadata)catalog) || this.supportSchema() && this.empty((Metadata)schema)) {
                        MasterTable tmp = new MasterTable();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (this.supportCatalog() && this.empty((Metadata)catalog)) {
                            catalog = tmp.getCatalog();
                        }
                        if (this.supportSchema() && this.empty((Metadata)schema)) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null != (list = CacheProxy.masterTables(caches_key = CacheProxy.key(runtime, "masterTables", greedy, catalog, schema, pattern, types, configs))) && !list.isEmpty()) {
                        return list;
                    }
                    String cache_key = CacheProxy.key(runtime, "masterTable", greedy, catalog, schema, pattern);
                    origin = CacheProxy.name(cache_key);
                    if (null == origin && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.masterTableMap(runtime, random, greedy, catalog, schema, null);
                        origin = CacheProxy.name(cache_key);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    navi = null;
                    if (null == configs) {
                        configs = new DefaultConfigStore(new String[0]);
                    }
                    navi = configs.getPageNavi();
                    try {
                        List<Run> runs = this.buildQueryMasterTablesRun(runtime, greedy, catalog, schema, origin, types, configs);
                        if (null == runs) break block35;
                        int idx = 0;
                        for (Run run : runs) {
                            if (null != navi) {
                                run.setPageNavi(navi);
                                this.mergeFinalQuery(runtime, run);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, configs.keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.masterTables(runtime, idx++, true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block35;
                        log.warn("{}[masterTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.isEmpty()) {
                    try {
                        list = this.masterTables(runtime, true, list, catalog, schema, origin, types);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                MasterTable masterTable = (MasterTable)list.get(i);
                                if (this.equals(catalog, masterTable.getCatalog()) && this.equals(schema, masterTable.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[masterTables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (MasterTable masterTable : list) {
                    if (!BasicUtil.isNotEmpty((Object)masterTable.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryMasterTablesCommentRun(runtime, catalog, schema, origin, types);
                        if (null == runs) break block36;
                        boolean bl = false;
                        for (Run run : runs) {
                            void var20_32;
                            if (null != navi) {
                                run.setPageNavi(navi);
                            }
                            DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            list = this.comments(runtime, (int)(++var20_32), true, list, catalog, schema, set);
                            if (null == navi) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.info("{}[masterTables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[masterTables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, origin, types, list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<MasterTable> tmp = new ArrayList<MasterTable>();
                for (MasterTable masterTable : list) {
                    String name = masterTable.getName(greedy) + "";
                    if (!RegularUtil.match((String)name.toUpperCase(), (String)origin.toUpperCase(), (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH) || !this.equals(catalog, masterTable.getCatalog()) || !this.equals(schema, masterTable.getSchema())) continue;
                    tmp.add(masterTable);
                }
                list = tmp;
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.COLUMN)) {
                List columns = this.columns(runtime, random, greedy, catalog, schema, list);
            }
            if (Metadata.check((int)struct, (Type)Metadata.TYPE.INDEX)) {
                this.indexes(runtime, random, greedy, list);
            }
            CacheProxy.tables(caches_key, list);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[masterTables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void masterTableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        if (null == random) {
            random = this.random(runtime);
        }
        DriverAdapter adapter = runtime.getAdapter();
        List masterTables = null;
        boolean sys = false;
        if (greedy) {
            catalog = null;
            schema = null;
        }
        try {
            List<Run> runs = this.buildQueryMasterTablesRun(runtime, greedy, catalog, schema, null, MasterTable.TYPE.NORMAL.value, null);
            if (null != runs && !runs.isEmpty()) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    masterTables = this.masterTables(runtime, idx++, true, masterTables, catalog, schema, set);
                    for (MasterTable masterTable : masterTables) {
                        String cache_key = CacheProxy.key(runtime, "masterTable", greedy, catalog, schema, masterTable.getName());
                        CacheProxy.name(cache_key, masterTable.getName());
                    }
                    sys = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!sys) {
            try {
                masterTables = this.masterTables(runtime, true, masterTables, catalog, schema, null, MasterTable.TYPE.NORMAL.value);
                for (MasterTable masterTable : masterTables) {
                    String cache_key = CacheProxy.key(runtime, "masterTable", greedy, catalog, schema, masterTable.getName());
                    CacheProxy.name(cache_key, masterTable.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        LinkedHashMap<String, MasterTable> masterTables = new LinkedHashMap<String, MasterTable>();
        List<T> list = this.masterTables(runtime, random, false, catalog, schema, pattern, types, struct, configs);
        for (MasterTable masterTable : list) {
            masterTables.put(masterTable.getName().toUpperCase(), masterTable);
        }
        return masterTables;
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> masterTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> masterTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == masterTables) {
            masterTables = new LinkedHashMap();
        }
        return masterTables;
    }

    @Override
    public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, int index, boolean create, List<T> masterTables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> List<T> masterTables(DataRuntime runtime, int index, boolean create, List<T> masterTables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == masterTables) {
            masterTables = new ArrayList<T>();
        }
        return masterTables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> masterTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> masterTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == masterTables) {
            masterTables = new LinkedHashMap();
        }
        return masterTables;
    }

    @Override
    public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, boolean create, List<T> masterTables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> List<T> masterTables(DataRuntime runtime, boolean create, List<T> masterTables, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        if (null == masterTables) {
            masterTables = new ArrayList<T>();
        }
        return masterTables;
    }

    @Override
    public <T extends MasterTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return null;
    }

    @Override
    public MasterTableMetadataAdapter masterTableMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 MasterTableMetadataAdapter masterTableMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new MasterTableMetadataAdapter();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        List<String> list;
        block14: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, meta);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)((MasterTable)null), new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    meta.setDdls(list);
                } else {
                    PrimaryKey pk;
                    LinkedHashMap columns = meta.getColumns();
                    if (null == columns || columns.isEmpty()) {
                        columns = this.columns(runtime, random, false, (Table)meta, true);
                        meta.setColumns(columns);
                        meta.setTags(this.tags(runtime, random, false, (Table)meta));
                    }
                    if (null == (pk = meta.getPrimaryKey())) {
                        pk = this.primary(runtime, random, false, (Table)meta);
                    }
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    meta.setPrimaryKey(pk);
                    LinkedHashMap indexes = meta.getIndexes();
                    if (null == indexes || indexes.isEmpty()) {
                        meta.setIndexes(this.indexes(runtime, random, (Table)meta, null));
                    }
                    runs = this.buildCreateRun(runtime, meta);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[masterTable ddl][masterTable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block14;
                log.info("{}[masterTable ddl][{}][masterTable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable masterTable) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable masterTable)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable masterTable, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, MasterTable masterTable, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        LinkedHashMap tables = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryPartitionTablesRun(runtime, (Table)master, tags, pattern);
                    if (null != runs) {
                        int idx = 0;
                        int total = runs.size();
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, false, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            tables = this.partitionTables(runtime, total, idx++, true, master, tables, master.getCatalog(), master.getSchema(), set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, master.getName(), tables.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[partitionTables][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String, Object> tags, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String,Object> tags, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String, Object> tags) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String,Object> tags)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> partitionTables(DataRuntime runtime, int total, int index, boolean create, MasterTable table, Catalog catalog, Schema schema, LinkedHashMap<String, PartitionTable> tables, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> partitionTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[partition table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, table.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[partition table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b50\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends PartitionTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PartitionTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends PartitionTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PartitionTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary, ConfigStore configs) {
        if (!greedy) {
            this.checkSchema(runtime, table);
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        String key = CacheProxy.key(runtime, "table_columns", greedy, table);
        LinkedHashMap<String, Object> columns = CacheProxy.columns(key);
        if (null != columns && !columns.isEmpty()) {
            return columns;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            int n;
            List<Run> runs;
            int qty_jdbc;
            int qty_dialect;
            int qty_total;
            block33: {
                qty_total = 0;
                qty_dialect = 0;
                boolean bl = false;
                qty_jdbc = 0;
                try {
                    runs = this.buildQueryColumnsRun(runtime, table, false, configs);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                            columns = this.columns(runtime, idx, true, table, columns, set);
                            ++idx;
                        }
                    }
                    if (null != columns) {
                        qty_dialect = columns.size();
                        qty_total = columns.size();
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (primary) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block33;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            if (null == columns || columns.isEmpty()) {
                block34: {
                    try {
                        runs = this.buildQueryColumnsRun(runtime, table, true);
                        if (null != runs) {
                            for (Run run : runs) {
                                String sql = run.getFinalQuery();
                                if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                                columns = this.actuator.columns(this, runtime, true, columns, table, sql);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            log.error("columns exception:", (Throwable)e);
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block34;
                        log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                    }
                }
                if (null != columns) {
                    n = columns.size() - qty_dialect;
                    qty_total = columns.size();
                }
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, n, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if ((null == columns || columns.isEmpty()) && null != (columns = this.actuator.metadata(this, runtime, true, columns, table, null))) {
                qty_total = columns.size();
                qty_jdbc = columns.size() - n - qty_dialect;
            }
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[columns][catalog:{}][schema:{}][table:{}][total:{}][\u6839\u636emetadata\u89e3\u6790:{}][\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2:{}][\u6839\u636e\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, catalog, schema, table, qty_total, n, qty_dialect, qty_jdbc, DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
            if (ConfigTable.IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY && (null != columns || !columns.isEmpty())) {
                LinkedHashMap linkedHashMap;
                PrimaryKey pk;
                boolean exists = false;
                for (Column column : columns.values()) {
                    if (column.isPrimaryKey() == -1) continue;
                    exists = true;
                    break;
                }
                if (!exists && null != (pk = this.primary(runtime, random, false, table)) && null != (linkedHashMap = pk.getColumns())) {
                    for (String k : linkedHashMap.keySet()) {
                        Column column = (Column)columns.get(k);
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                log.error("columns exception:", (Throwable)e);
            }
            log.error("{}[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != columns) {
            CacheProxy.cache(key, columns);
        } else {
            columns = new LinkedHashMap();
        }
        int index = 0;
        for (Column column : columns.values()) {
            if (null == column.getPosition() || -1 == column.getPosition()) {
                column.setPosition(Integer.valueOf(index++));
            }
            if (column.isAutoIncrement() != 1) {
                column.autoIncrement(Boolean.valueOf(false));
            }
            if (column.isPrimaryKey() != 1) {
                column.setPrimary(Boolean.valueOf(false));
            }
            if (null != column.getTable() || greedy) continue;
            column.setTable(table);
        }
        return columns;
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table, ConfigStore configs) {
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(table);
        return this.columns(runtime, random, greedy, catalog, schema, tables, configs);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Collection<? extends Table> tables, ConfigStore configs) {
        List columns = new ArrayList();
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        Table tab = null;
        if (null != tables && !tables.isEmpty()) {
            tab = tables.iterator().next();
        }
        if (null != tab) {
            tab.setCatalog(catalog);
            tab.setSchema(schema);
            if (BasicUtil.isEmpty((Object)catalog) && BasicUtil.isEmpty((Object)schema) && !greedy) {
                this.checkSchema(runtime, tab);
            }
        }
        try {
            List<Run> runs = this.buildQueryColumnsRun(runtime, catalog, schema, tables, false, configs);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                    columns = this.columns(runtime, idx, true, (Table)null, columns, set);
                    ++idx;
                }
            }
            for (Table table : tables) {
                Long tObjectId = table.getObjectId();
                LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
                table.setColumns(cols);
                for (Column column : columns) {
                    if (!table.equals(column.getTable())) continue;
                    Catalog cCatalog = column.getCatalog();
                    Schema cSchema = column.getSchema();
                    Long cObjectId = column.getObjectId();
                    if (null != tObjectId && null != cObjectId && tObjectId == cObjectId) {
                        cols.put(column.getName().toUpperCase(), column);
                        continue;
                    }
                    if (!this.equals(cCatalog, column.getCatalog()) || !this.equals(cSchema, column.getSchema()) || !BasicUtil.equals((Object)table.getName(), (Object)column.getTableName(), (boolean)true)) continue;
                    cols.put(column.getName().toUpperCase(), column);
                }
                table.setColumns(cols);
                columns.removeAll(cols.values());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Catalog catalog, Schema schema, Collection<? extends Table> tables, boolean metadata, ConfigStore configs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnsRun(DataRuntime runtime, Catalog catalog, Schema schema, Collection<? extends Table> tables, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Collection<? extends Table> tables, List<T> columns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Collection<? extends Table> tables, List<T> columns, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public ColumnMetadataAdapter columnMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 ColumnMetadataAdapter columnMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return null;
    }

    @Override
    public ColumnMetadataAdapter columnMetadataAdapter(DataRuntime runtime, TypeMetadata meta) {
        return DriverAdapter.super.columnMetadataAdapter(runtime, meta);
    }

    @Override
    public String columnMetadataLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getLengthRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getLengthRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getLengthRefer();
        }
        if (null == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.getLengthRefer();
        }
        return result;
    }

    @Override
    public String columnMetadataPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getPrecisionRefer();
        }
        if (null == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.getPrecisionRefer();
        }
        return result;
    }

    @Override
    public String columnMetadataScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return null;
        }
        String result = null;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.getScaleRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.getScaleRefer();
        }
        if (null == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.getScaleRefer();
        }
        if (null == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.getScaleRefer();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnoreLength(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignoreLength();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignoreLength();
        }
        if (-1 == result) {
            result = meta.ignoreLength();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignoreLength();
        }
        if (-1 == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.ignoreLength();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnorePrecision(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignorePrecision();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignorePrecision();
        }
        if (-1 == result) {
            result = meta.ignorePrecision();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignorePrecision();
        }
        if (-1 == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.ignorePrecision();
        }
        return result;
    }

    @Override
    public int columnMetadataIgnoreScale(DataRuntime runtime, TypeMetadata meta) {
        ColumnMetadataAdapter adapter;
        if (null == meta) {
            return -1;
        }
        int result = -1;
        TypeMetadata.Config config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata)meta);
        if (null != config) {
            result = config.ignoreScale();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (String)meta.getName()))) {
            result = config.ignoreScale();
        }
        if (-1 == result) {
            result = meta.ignoreScale();
        }
        if (-1 == result && null != (config = MetadataAdapterHolder.get((DatabaseType)this.type(), (TypeMetadata.CATEGORY)meta.getCategory()))) {
            result = config.ignoreScale();
        }
        if (-1 == result && null != (adapter = this.columnMetadataAdapter(runtime)) && null != (config = adapter.getTypeConfig())) {
            result = config.ignoreScale();
        }
        return result;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTagsRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Tag> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        Object primary;
        block8: {
            primary = null;
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            String tab = table.getName();
            Catalog catalog = table.getCatalog();
            Schema schema = table.getSchema();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                List<Run> runs = this.buildQueryPrimaryRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, false, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        primary = this.init(runtime, idx, primary, table, set);
                        if (null != (primary = this.detail(runtime, idx, primary, table, set))) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.warn("{}[primary][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        table.setPrimaryKey(primary);
        return primary;
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T meta, Table table, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PrimaryKey> T init(DataRuntime runtime, int index, T meta, Table table, DataSet set)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataSet set)"), (int)37));
        }
        return meta;
    }

    @Override
    public PrimaryMetadataAdapter primaryMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String primaryMetadataName(DataRuntime runtime)"), (int)37));
        }
        return null;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 PrimaryKey primary(DataRuntime runtime, Table table)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap foreigns;
        block6: {
            foreigns = new LinkedHashMap();
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            try {
                List<Run> runs = this.buildQueryForeignsRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        foreigns = this.foreigns(runtime, idx, table, foreigns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables) {
        List indexes = null;
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            List<Run> runs = this.buildQueryIndexesRun(runtime, tables);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                    indexes = this.indexes(runtime, idx, true, tables, indexes, set);
                    ++idx;
                }
            }
            if (null != indexes) {
                for (Table table : tables) {
                    Long tObjectId = table.getObjectId();
                    LinkedHashMap<String, Index> idxs = new LinkedHashMap<String, Index>();
                    table.setIndexes(idxs);
                    for (Index index : indexes) {
                        if (!table.equals(index.getTable())) continue;
                        Catalog cCatalog = index.getCatalog();
                        Schema cSchema = index.getSchema();
                        Long cObjectId = index.getObjectId();
                        if (null != tObjectId && null != cObjectId && tObjectId == cObjectId) {
                            idxs.put(index.getName().toUpperCase(), index);
                            continue;
                        }
                        if (!this.equals(cCatalog, index.getCatalog()) || !this.equals(cSchema, index.getSchema()) || !BasicUtil.equals((Object)table.getName(), (Object)index.getTableName(), (boolean)true)) continue;
                        idxs.put(index.getName().toUpperCase(), index);
                    }
                    indexes.removeAll(idxs.values());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == indexes) {
            indexes = new ArrayList();
        }
        return indexes;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        List indexes;
        block12: {
            List<Run> runs;
            indexes = null;
            if (null == table) {
                table = new Table();
            }
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            if (null != (runs = this.buildQueryIndexesRun(runtime, table, pattern))) {
                int idx = 0;
                for (Run run : runs) {
                    block11: {
                        DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        try {
                            indexes = this.indexes(runtime, idx, true, table, indexes, set);
                        }
                        catch (Exception e) {
                            if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block11;
                            e.printStackTrace();
                        }
                    }
                    ++idx;
                }
            }
            if ((null == indexes || indexes.isEmpty()) && null != table.getName()) {
                try {
                    LinkedHashMap maps = this.indexes(runtime, true, new LinkedHashMap(), table, false, false);
                    table.setIndexes(maps);
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block12;
                    e.printStackTrace();
                }
            }
        }
        if (null == indexes) {
            indexes = new ArrayList();
        }
        return indexes;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Table table, String pattern) {
        LinkedHashMap<String, Object> indexes = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        this.checkSchema(runtime, table);
        List<Run> runs = this.buildQueryIndexesRun(runtime, table, pattern);
        if (null != runs) {
            int idx = 0;
            for (Run run : runs) {
                block19: {
                    DataSet set = (DataSet)this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        indexes = this.indexes(runtime, idx, true, table, indexes, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block19;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        if ((null == indexes || indexes.isEmpty()) && null != table.getName()) {
            try {
                indexes = this.indexes(runtime, true, indexes, table, false, false);
                table.setIndexes(indexes);
            }
            catch (Exception e) {
                log.info("{}[{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"JDBC\u65b9\u5f0f\u83b7\u53d6\u7d22\u5f15\u5931\u8d25", (int)33), table, e.toString()});
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                indexes = new LinkedHashMap();
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                Index index = (Index)indexes.get(pattern.toUpperCase());
                indexes = new LinkedHashMap();
                indexes.put(pattern.toUpperCase(), index);
            }
        }
        PrimaryKey pk = null;
        if (null != indexes) {
            for (Index index : indexes.values()) {
                if (!index.isPrimary()) continue;
                pk = index;
                break;
            }
        }
        if (null == pk) {
            pk = table.getPrimaryKey();
            if (null == pk) {
                pk = this.primary(runtime, random, false, table);
            }
            if (null != pk) {
                Index index = (Index)indexes.get(pk.getName().toUpperCase());
                if (null != index) {
                    index.setPrimary(true);
                } else {
                    indexes.put(pk.getName().toUpperCase(), pk);
                }
            }
        }
        if (null == indexes) {
            indexes = new LinkedHashMap();
        }
        return indexes;
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, Table table, String name) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexesRun(DataRuntime runtime, Table table, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, Collection<? extends Table> tables) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexesRun(DataRuntime runtime, Collection<? extends Table> tables)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexes, DataSet set) throws Exception {
        if (null == indexes) {
            indexes = new LinkedHashMap();
        }
        IndexMetadataAdapter config = this.indexMetadataAdapter(runtime);
        for (DataRow row : set) {
            String name = row.getString(config.getNameRefers());
            if (null == name) continue;
            Index meta = (Index)indexes.get(name.toUpperCase());
            meta = this.init(runtime, index, meta, table, row);
            if (null != table && !table.getName().equalsIgnoreCase(meta.getTableName()) || null == (meta = this.detail(runtime, index, meta, table, row))) continue;
            indexes.put(meta.getName().toUpperCase(), meta);
        }
        return indexes;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, Table table, List<T> indexes, DataSet set) throws Exception {
        if (null == indexes) {
            indexes = new ArrayList<T>();
        }
        IndexMetadataAdapter config = this.indexMetadataAdapter(runtime);
        for (DataRow row : set) {
            String name = row.getString(config.getNameRefers());
            if (null == name) continue;
            Index meta = new Index(name.toUpperCase());
            meta = this.init(runtime, index, meta, table, row);
            if (null != table && !table.getName().equalsIgnoreCase(meta.getTableName()) || null == (meta = this.detail(runtime, index, meta, table, row))) continue;
            indexes.add(meta);
        }
        return indexes;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, Collection<? extends Table> tables, List<T> indexes, DataSet set) throws Exception {
        if (null == indexes) {
            indexes = new ArrayList<T>();
        }
        HashMap<String, Table> tbls = new HashMap<String, Table>();
        for (Table table : tables) {
            tbls.put(table.getName().toUpperCase(), table);
        }
        for (DataRow dataRow : set) {
            Table table;
            Index meta = null;
            if (null == Metadata.match(meta = this.init(runtime, index, meta, null, dataRow), indexes)) {
                indexes.add(meta);
            }
            this.detail(runtime, index, meta, null, dataRow);
            String tableName = meta.getTableName();
            if (null == tableName || null == (table = (Table)tbls.get(tableName.toUpperCase()))) continue;
            table.add(meta);
        }
        return indexes;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> indexes, Table table, boolean unique, boolean approximate) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, List<T> indexes, Table table, boolean unique, boolean approximate)"), (int)37));
        }
        if (null == indexes) {
            indexes = new ArrayList<T>();
        }
        return indexes;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Table table, boolean unique, boolean approximate) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Table table, boolean unique, boolean approximate)"), (int)37));
        }
        if (null == indexes) {
            indexes = new LinkedHashMap();
        }
        return indexes;
    }

    @Override
    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        IndexMetadataAdapter config = this.indexMetadataAdapter(runtime);
        String name = row.getString(config.getNameRefers());
        if (null == meta) {
            meta = new Index();
            meta.setName(name);
            Catalog catalog = null;
            Schema schema = null;
            String catalogName = row.getString(config.getCatalogRefers());
            if (BasicUtil.isNotEmpty((Object)catalogName)) {
                catalog = new Catalog(catalogName);
            } else if (null != table) {
                catalog = table.getCatalog();
            }
            String schemaName = row.getString(config.getSchemaRefers());
            if (BasicUtil.isNotEmpty((Object)schemaName)) {
                schema = new Schema(schemaName);
            } else if (null != table) {
                schema = table.getSchema();
            }
            if (null == table) {
                String tableName = row.getString(config.getTableRefers());
                table = new Table(catalog, schema, tableName);
            }
            meta.setCatalog(catalog);
            meta.setSchema(schema);
            meta.setTable(table);
            meta.setMetadata(row);
            String[] chks = config.getCheckPrimaryRefers();
            String[] vals = config.getCheckPrimaryValues();
            Boolean bol = this.parseBoolean(row, chks, vals);
            if (null != bol) {
                meta.setPrimary(bol.booleanValue());
            }
            if (null != (bol = this.parseBoolean(row, chks = config.getCheckUniqueRefers(), vals = config.getCheckUniqueValues()))) {
                meta.setUnique(bol.booleanValue());
            }
        }
        return meta;
    }

    protected Boolean parseBoolean(DataRow row, String[] cols, String[] vals) {
        Boolean bol = null;
        if (null != cols) {
            for (String col : cols) {
                Object value = row.get(col);
                if (null == value) continue;
                if (value instanceof Boolean) {
                    bol = BasicUtil.parseBoolean((Object)value);
                } else if (null != vals) {
                    String str = value.toString();
                    for (String val : vals) {
                        if (!str.equalsIgnoreCase(val)) continue;
                        bol = true;
                        break;
                    }
                }
                if (null != bol) break;
            }
            if (null == bol) {
                bol = false;
            }
        }
        return bol;
    }

    @Override
    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        IndexMetadataAdapter config = this.indexMetadataAdapter(runtime);
        String columnName = row.getStringWithoutEmpty(config.getColumnRefers());
        if (null == columnName) {
            return meta;
        }
        Column column = meta.getColumn((columnName = columnName.replace("\"", "")).toUpperCase());
        if (null == column) {
            column = new Column();
        }
        column.setName(columnName);
        meta.addColumn(column);
        Integer position = row.getInt(config.getColumnPositionRefers());
        if (null == position) {
            position = 0;
        }
        column.setPosition(position);
        meta.setPosition(column, position);
        String order = row.getString(config.getColumnOrderRefers());
        if (null != order) {
            order = order.toUpperCase();
            Order.TYPE type = Order.TYPE.ASC;
            if (order.contains("DESC")) {
                type = Order.TYPE.DESC;
            }
            meta.setOrder(column, type);
        }
        return meta;
    }

    @Override
    public IndexMetadataAdapter indexMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 IndexMetadataAdapter indexMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new IndexMetadataAdapter();
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new ArrayList<T>();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint>  constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Constraint> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public ConstraintMetadataAdapter constraintMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 ConstraintMetadataAdapter constraintMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new ConstraintMetadataAdapter();
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set)"), (int)37));
        }
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        return triggers;
    }

    @Override
    public <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public TriggerMetadataAdapter triggerMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 TriggerMetadataAdapter triggerMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new TriggerMetadataAdapter();
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> ArrayList<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, procedure);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, procedure, list, set);
                    }
                    if (list.size() > 0) {
                        procedure.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[procedure ddl][procedure:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, procedure.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[procedure ddl][{}][procedure:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b58\u50a8\u8fc7\u7a0b\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), procedure.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return new ArrayList<String>();
    }

    @Override
    public <T extends Procedure> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Procedure> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return meta;
    }

    @Override
    public ProcedureMetadataAdapter procedureMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 ProcedureMetadataAdapter procedureMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new ProcedureMetadataAdapter();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, Catalog catalog, Schema schema, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> functions) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> functions)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, meta);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    if (list.size() > 0) {
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[function ddl][function:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[function ddl][{}][function:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u51fd\u6570\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends Function> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        FunctionMetadataAdapter config = this.functionMetadataAdapter(runtime);
        if (null == meta) {
            meta = new Function();
        }
        if (null != config) {
            meta.setName(row.getString(config.getNameRefers()));
            meta.setSchema(row.getString(config.getSchemaRefers()));
            meta.setComment(row.getString(config.getCommentRefers()));
            meta.setDefinition(row.getString(config.getDefineRefers()));
        }
        return meta;
    }

    @Override
    public <T extends Function> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public FunctionMetadataAdapter functionMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 FunctionMetadataAdapter functionMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new FunctionMetadataAdapter();
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        if (null == random) {
            random = this.random(runtime);
        }
        List sequences = new ArrayList();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySequencesRun(runtime, catalog, schema, pattern);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            sequences = this.sequences(runtime, idx++, true, sequences, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[sequences][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[sequences][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, sequences.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[sequences][result:fail][msg:{}]", (Object)e.toString());
        }
        return sequences;
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap sequences = new LinkedHashMap();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySequencesRun(runtime, catalog, schema, pattern);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                            sequences = this.sequences(runtime, idx++, true, sequences, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[sequences][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[sequences][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, sequences.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[sequences][result:fail][msg:{}]", (Object)e.toString());
        }
        return sequences;
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequencesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> sequences, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> sequences, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> sequences) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, boolean create, LinkedHashMap<String, T> sequences) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, boolean create, LinkedHashMap<String, T> sequences)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDdlsRun(runtime, meta);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = (DataSet)this.select(runtime, random, true, (Table)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    if (list.size() > 0) {
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[sequence ddl][sequence:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), list.size(), DateUtil.format((long)(System.currentTimeMillis() - fr))});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[sequence ddl][{}][sequence:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5e8f\u5217\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDdlsRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends Sequence> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Sequence> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Sequence> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public SequenceMetadataAdapter sequenceMetadataAdapter(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 SequenceMetadataAdapter sequenceMetadataAdapter(DataRuntime runtime)"), (int)37));
        }
        return new SequenceMetadataAdapter();
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        if (null != schemas) {
            for (Schema schema : schemas) {
                if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)schema.getCatalog()) || !schema.getName().equalsIgnoreCase(name)) continue;
                return (T)schema;
            }
        }
        return null;
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        if (null != catalogs) {
            for (Catalog catalog : catalogs) {
                if (!catalog.getName().equalsIgnoreCase(name)) continue;
                return (T)catalog;
            }
        }
        return null;
    }

    public <T extends Database> T database(List<T> databases, String name) {
        if (null != databases) {
            for (Database database : databases) {
                if (!database.getName().equalsIgnoreCase(name)) continue;
                return (T)database;
            }
        }
        return null;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run)"), (int)37));
        }
        return false;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        long frs = System.currentTimeMillis();
        ACTION.SWITCH swt = meta.swt();
        if (swt == ACTION.SWITCH.CONTINUE && (swt = InterceptorProxy.before(runtime, random, action, meta, runs)) == ACTION.SWITCH.CONTINUE) {
            for (Run run : runs) {
                swt = InterceptorProxy.before(runtime, random, action, meta, run, runs);
                long fr = System.currentTimeMillis();
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.execute(runtime, random + "[index:" + idx++ + "]", meta, action, run) && result;
                } else {
                    if (swt == ACTION.SWITCH.SKIP) continue;
                    if (swt == ACTION.SWITCH.BREAK) break;
                }
                if ((swt = InterceptorProxy.after(runtime, random, action, meta, run, runs, result, System.currentTimeMillis() - fr)) != ACTION.SWITCH.BREAK) continue;
                break;
            }
            long millis = System.currentTimeMillis() - frs;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][meta:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, action, meta.getName(), runs.size(), result, DateUtil.format((long)millis)});
            }
            swt = InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        this.checkPrimary(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    protected LinkedHashMap<String, Column> checkColumnAction(DataRuntime runtime, Table meta) {
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        for (Object col : columns.values()) {
            this.typeMetadata(runtime, (Column)col);
        }
        for (Object col : ucolumns.values()) {
            this.typeMetadata(runtime, (Column)col);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = (Column)ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals(ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                column.setAction(ACTION.DDL.COLUMN_ALTER);
                ucolumn.setAction(ACTION.DDL.COLUMN_ALTER);
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction(ACTION.DDL.COLUMN_ADD);
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction(ACTION.DDL.COLUMN_DROP);
            cols.put(column.getName().toUpperCase(), column);
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || ACTION.DDL.COLUMN_DROP == column.getAction() || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction(ACTION.DDL.COLUMN_DROP);
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        for (Column column : cols.values()) {
            if (columns.containsKey(column.getName().toUpperCase()) || column.getAction() != ACTION.DDL.COLUMN_DROP) continue;
            column.setAction(ACTION.DDL.IGNORE);
        }
        return cols;
    }

    protected List<Run> checkAutoIncrement(DataRuntime runtime, String random, Table table, boolean slice) throws Exception {
        List<Run> runs = new ArrayList<Run>();
        Table update = (Table)table.getUpdate();
        if (!table.primaryEquals(update)) {
            LinkedHashMap pks = table.getPrimaryKeyColumns();
            LinkedHashMap npks = update.getPrimaryKeyColumns();
            LinkedHashMap columns = table.getColumns();
            if (null != pks) {
                for (String k : pks.keySet()) {
                    Column auto = (Column)columns.get(k.toUpperCase());
                    if (null == auto || auto.isAutoIncrement() != 1 || null == npks || npks.containsKey(auto.getName().toUpperCase())) continue;
                    auto.primary(Boolean.valueOf(false));
                    runs = this.buildDropAutoIncrement(runtime, auto, slice);
                }
            }
        }
        return runs;
    }

    @Override
    public List<Run> merge(DataRuntime runtime, Table meta, List<Run> slices) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun merge = null;
        if (null != slices && !slices.isEmpty()) {
            StringBuilder builder = null;
            boolean first = true;
            for (Run item : slices) {
                String line;
                if (!BasicUtil.isNotEmpty((Object)item) || BasicUtil.isEmpty((Object)(line = item.getFinalUpdate().trim()))) continue;
                if (!item.slice()) {
                    runs.add(item);
                    continue;
                }
                if (null == merge) {
                    merge = new SimpleRun(runtime);
                    builder = merge.getBuilder();
                    builder.append("ALTER ").append(this.keyword((Metadata)meta)).append(" ");
                    this.name(runtime, builder, (Metadata)meta);
                }
                builder.append("\n");
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(line);
            }
        }
        if (null != merge) {
            runs.add(merge);
        }
        return runs;
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        List<Run> merges;
        boolean change_pk;
        boolean result = true;
        ArrayList<Run> runs = new ArrayList<Run>();
        Table update = (Table)meta.getUpdate();
        this.checkPrimary(runtime, update);
        String name = meta.getName();
        String uname = update.getName();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        this.checkSchema(runtime, update);
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
            meta.setName(uname);
        }
        if (!result) {
            return result;
        }
        String ucomment = update.getComment();
        String comment = meta.getComment();
        if (!(BasicUtil.isEmpty((Object)ucomment) && BasicUtil.isEmpty((Object)comment) || BasicUtil.equals((Object)comment, (Object)ucomment))) {
            swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_COMMENT, meta);
            if (swt == ACTION.SWITCH.BREAK) {
                return false;
            }
            if (BasicUtil.isNotEmpty((Object)meta.getComment())) {
                runs.addAll(this.buildChangeCommentRun(runtime, update));
            } else {
                runs.addAll(this.buildAddCommentRun(runtime, update));
            }
            boolean bl = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_COMMENT, runs) && result;
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        boolean slice = this.slice();
        ArrayList<Run> slices = new ArrayList<Run>();
        LinkedHashMap<String, Column> cols = this.checkColumnAction(runtime, meta);
        PrimaryKey src_primary = this.primary(runtime, random, false, meta);
        PrimaryKey cur_primary = update.getPrimaryKey();
        boolean bl = change_pk = !meta.primaryEquals(update);
        if (change_pk) {
            meta.setChangePrimary(1);
        }
        try {
            List<Run> autos = this.checkAutoIncrement(runtime, null, meta, slice);
            if (slice) {
                slices.addAll(autos);
            } else {
                boolean bl2 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_ALTER, autos) && result;
                if (meta.swt() == ACTION.SWITCH.BREAK) {
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (change_pk && null != src_primary) {
            src_primary.execute(meta.execute());
            if (slice) {
                slices.addAll(this.buildDropRun(runtime, src_primary, slice));
            } else {
                this.drop(runtime, src_primary);
            }
            src_primary = null;
        }
        List<Run> alters = this.buildAlterRun(runtime, meta, cols.values(), slice);
        if (slice) {
            slices.addAll(alters);
        } else if (null != alters && alters.size() > 0) {
            boolean bl3 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.COLUMN_ALTER, alters) && result;
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        if (null != cur_primary && change_pk) {
            if (slice) {
                slices.addAll(this.buildAddRun(runtime, cur_primary, slice));
            } else {
                this.add(runtime, cur_primary);
            }
        }
        boolean bl4 = result = this.execute(runtime, random, (Metadata)meta, ACTION.DDL.TABLE_ALTER, merges = this.merge(runtime, meta, slices)) && result;
        if (meta.swt() == ACTION.SWITCH.BREAK) {
            return result;
        }
        LinkedHashMap oindexes = this.indexes(runtime, random, meta, null);
        LinkedHashMap indexes = update.getIndexes();
        for (Index index : indexes.values()) {
            if (index.isPrimary()) continue;
            index.execute(meta.execute());
            if (index.isDrop()) {
                this.drop(runtime, index);
                continue;
            }
            if (null != index.getUpdate()) {
                this.alter(runtime, index);
                continue;
            }
            Index oindex = (Index)oindexes.get(index.getName().toUpperCase());
            if (null == oindex) {
                this.add(runtime, index);
                continue;
            }
            if (index.equals(oindex) || oindex.isPrimary()) continue;
            oindex.execute(meta.execute());
            oindex.setUpdate((Metadata)index, false, false);
            this.alter(runtime, oindex);
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public String keyword(Metadata meta) {
        return meta.getKeyword();
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        if (null != meta) {
            return this.buildAlterRun(runtime, meta, meta.columns());
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Column column : columns) {
            ACTION.DDL action = column.getAction();
            CMD cmd = null;
            if (null != action) {
                cmd = action.getCmd();
            }
            if (CMD.IGNORE == cmd) continue;
            if (CMD.CREATE == cmd) {
                runs.addAll(this.buildAddRun(runtime, column, slice));
                continue;
            }
            if (CMD.ALTER == cmd) {
                runs.addAll(this.buildAlterRun(runtime, column, slice));
                continue;
            }
            if (CMD.DROP != cmd) continue;
            runs.addAll(this.buildDropRun(runtime, column, slice));
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        if (null != table) {
            table.checkColumnPrimary();
        }
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table table) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder indexes(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder indexes(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.VIEW_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = meta.getTags();
        LinkedHashMap utags = update.getTags();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable(update);
                tag.setUpdate(utag, false, false);
                this.alter(runtime, tag);
                result = true;
                continue;
            }
            utag.setTable(update);
            this.add(runtime, utag);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable(update);
                this.drop(runtime, tag);
                result = true;
            }
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), result, DateUtil.format((long)(System.currentTimeMillis() - fr))});
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((Metadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}]", new Object[]{random, meta.getName(), result, DateUtil.format((long)(System.currentTimeMillis() - fr))});
        }
        return result;
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.COLUMN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta, false);
        try {
            result = this.execute(runtime, random, (Metadata)meta, action, runs);
            if (meta.swt() == ACTION.SWITCH.BREAK) {
                return result;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)((Column)meta.getUpdate()).getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == -1) {
                    throw e;
                }
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    swt = this.ddListener.afterAlterColumnException(runtime, random, table, meta, e);
                }
                log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.alter(runtime, table, meta, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(runtime, null, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.COLUMN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin, false);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return "";
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        String define = meta.getDefinition();
        if (BasicUtil.isNotEmpty((Object)define)) {
            builder.append(" ").append(define);
            return builder;
        }
        this.type(runtime, builder, meta);
        this.aggregation(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.defaultValue(runtime, builder, meta);
        this.nullable(runtime, builder, meta, action);
        this.primary(runtime, builder, meta);
        this.unique(runtime, builder, meta);
        this.increment(runtime, builder, meta);
        this.onupdate(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        this.position(runtime, builder, meta);
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        String finalType;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (BasicUtil.isNotEmpty((Object)(finalType = meta.getFinalType()))) {
            builder.append(finalType);
            return builder;
        }
        meta.ignoreLength(ignoreLength);
        meta.ignorePrecision(ignorePrecision);
        meta.ignoreScale(ignoreScale);
        meta.parseType(2);
        builder.append(meta.getFullType(this.type()));
        return builder;
    }

    @Override
    public int ignoreLength(DataRuntime runtime, TypeMetadata type) {
        return MetadataAdapterHolder.ignoreLength((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public int ignorePrecision(DataRuntime runtime, TypeMetadata type) {
        return MetadataAdapterHolder.ignorePrecision((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public int ignoreScale(DataRuntime runtime, TypeMetadata type) {
        return MetadataAdapterHolder.ignoreScale((DatabaseType)this.type(), (TypeMetadata)type);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        int nullable;
        if (meta.isPrimaryKey() == 1) {
            builder.append(" NOT NULL");
            return builder;
        }
        if (null == meta.getDefaultValue() && (nullable = meta.isNullable()) != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        void var4_12;
        void var4_10;
        void var4_7;
        Object var4_4 = null;
        boolean defaultCurrentDateTime = false;
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            if (update.isAutoIncrement() == 1) {
                return builder;
            }
            Object object = update.getDefaultValue();
            defaultCurrentDateTime = update.isDefaultCurrentDateTime();
        } else {
            if (meta.isAutoIncrement() == 1) {
                return builder;
            }
            Object object = meta.getDefaultValue();
            defaultCurrentDateTime = meta.isDefaultCurrentDateTime();
        }
        if (null == var4_7 && defaultCurrentDateTime) {
            String type = meta.getFullType(this.type()).toLowerCase();
            if (type.contains("timestamp")) {
                DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIMESTAMP;
            } else {
                DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
            }
        }
        if (null == var4_10) return builder;
        String str = var4_10.toString().trim();
        builder.append(" DEFAULT ");
        DriverAdapter.SQL_BUILD_IN_VALUE val = this.checkDefaultBuildInValue(runtime, var4_10);
        if (null != val) {
            DriverAdapter.SQL_BUILD_IN_VALUE sQL_BUILD_IN_VALUE = val;
        }
        if (var4_12 instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
            String value = this.value(runtime, meta, (DriverAdapter.SQL_BUILD_IN_VALUE)var4_12);
            if (null == value) throw new RuntimeException("\u5f53\u524dadapter\u6ca1\u6709\u89e3\u6790" + var4_12 + ",\u53ef\u4ee5\u7528${\u539f\u751fSQL}\u4ee3\u66ff,\u5982column.setDefaultValue(\"${now()}\");");
            builder.append(value);
            return builder;
        } else if (str.startsWith("${") && str.endsWith("}")) {
            builder.append(str.substring(2, str.length() - 1));
            return builder;
        } else {
            void var4_17;
            void var4_14;
            Object object;
            if (null != var4_12 && var4_12.toString().contains("::")) {
                String string = var4_12.toString().split("::")[0];
            }
            if (null == (object = this.write(runtime, meta, var4_14, false))) {
                Object object2 = meta.getDefaultValue();
            }
            builder.append(var4_17);
        }
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (Metadata)meta, action, runs);
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
            if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    swt = this.ddListener.afterAlterColumnException(runtime, random, table, (Column)meta, e);
                }
                log.warn("{}[\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                if (swt == ACTION.SWITCH.CONTINUE) {
                    result = this.alter(runtime, table, meta, false);
                }
            }
            log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), 1);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TAG_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin, this.slice());
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta, false);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, origin, meta);
        return this.execute(runtime, random, (Metadata)table, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.FOREIGN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        ACTION.SWITCH swt;
        ACTION.DDL action = ACTION.DDL.INDEX_ADD;
        String random = this.random(runtime);
        Index update = (Index)meta.getUpdate();
        if (null != update) {
            meta = update;
        }
        if ((swt = InterceptorProxy.prepare(runtime, random, action, meta)) == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.INDEX_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        LinkedHashMap indexes;
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta && null != (indexes = meta.getIndexes())) {
            for (Index index : indexes.values()) {
                if (index.isPrimary()) continue;
                runs.addAll(this.buildAddRun(runtime, index));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Index meta) {
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), Table.TYPE.NORMAL.value);
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.TRIGGER_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.PROCEDURE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.FUNCTION_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.FUNCTION_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.FUNCTION_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.FUNCTION_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action = ACTION.DDL.SEQUENCE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.SEQUENCE_ALTER, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        ACTION.DDL action;
        boolean result = false;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.SEQUENCE_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        return this.execute(runtime, random, (Metadata)meta, action, runs);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        ACTION.DDL action = ACTION.DDL.SEQUENCE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        return this.execute(runtime, random, (Metadata)origin, action, runs);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Sequence meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    protected PrimaryGenerator checkPrimaryGenerator(DatabaseType type, String table) {
        PrimaryGenerator generator = GeneratorConfig.get((String)(table = table.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "")));
        if (null != generator && generator != PrimaryGenerator.GENERATOR.DISABLE && generator != PrimaryGenerator.GENERATOR.AUTO) {
            return generator;
        }
        if (null == this.primaryGenerator) {
            if (null == this.primaryGenerator) {
                this.primaryGenerator = GeneratorConfig.get();
            }
            if (null == this.primaryGenerator) {
                if (ConfigTable.PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.SNOWFLAKE;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.RANDOM;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.UUID;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIME_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIME;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIMESTAMP_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIMESTAMP;
                }
            }
        }
        if (null != this.primaryGenerator) {
            return this.primaryGenerator;
        }
        return null;
    }

    @Override
    public TypeMetadata typeMetadata(DataRuntime runtime, Column meta) {
        TypeMetadata typeMetadata = meta.getTypeMetadata();
        if (null == typeMetadata || TypeMetadata.NONE == typeMetadata || meta.getParseLvl() < 2 || this.type() != meta.getDatabase()) {
            typeMetadata = TypeMetadata.parse((DatabaseType)this.type(), (Column)meta, this.alias, spells);
            meta.setDatabase(this.type());
            meta.setParseLvl(2);
        }
        return typeMetadata;
    }

    public TypeMetadata spell(String name) {
        TypeMetadata typeMetadata = this.alias.get(name.toUpperCase());
        if (null == typeMetadata || TypeMetadata.NONE == typeMetadata) {
            typeMetadata = this.alias.get(spells.get(name.toUpperCase()));
        }
        return typeMetadata;
    }

    @Override
    public TypeMetadata typeMetadata(DataRuntime runtime, String type) {
        if (null == type) {
            return null;
        }
        Column tmp = new Column();
        tmp.setTypeName(type, false);
        return this.typeMetadata(runtime, tmp);
    }

    public String name(Metadata meta) {
        StringBuilder builder = new StringBuilder();
        String catalog = meta.getCatalogName();
        String schema = meta.getSchemaName();
        String name = meta.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append(catalog).append(".");
        }
        if (!this.empty(schema)) {
            builder.append(schema).append(".");
        }
        builder.append(name);
        return builder.toString();
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Metadata meta) {
        this.checkName(runtime, null, meta);
        String catalog = meta.getCatalogName();
        String schema = meta.getSchemaName();
        String name = meta.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.delimiter(builder, catalog).append(".");
        }
        if (!this.empty(schema)) {
            this.delimiter(builder, schema).append(".");
        }
        this.delimiter(builder, name);
        return builder;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (null != meta) {
            this.delimiter(builder, meta.getName());
        }
        return builder;
    }

    public StringBuilder delimiter(StringBuilder builder, String src) {
        return SQLUtil.delimiter((StringBuilder)builder, (String)src, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
    }

    public StringBuilder delimiter(StringBuilder builder, List<String> list) {
        String fr = this.getDelimiterFr();
        String to = this.getDelimiterTo();
        boolean first = true;
        for (String item : list) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            SQLUtil.delimiter((StringBuilder)builder, (String)item, (String)fr, (String)to);
        }
        return builder;
    }

    @Override
    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).startsWith("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).startsWith("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return !this.isNumberColumn(runtime, column) && !this.isBooleanColumn(runtime, column);
    }

    @Override
    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    @Override
    public Object write(DataRuntime runtime, Column metadata, Object value, boolean placeholder) {
        Class writeClass;
        if (null == value || "NULL".equals(value)) {
            return null;
        }
        Object result = null;
        TypeMetadata columnType = null;
        DataWriter writer = null;
        boolean isArray = false;
        if (null != metadata) {
            String typeName;
            isArray = metadata.isArray();
            columnType = metadata.getTypeMetadata();
            if (null != columnType) {
                writer = this.writer(columnType);
            }
            if (null == writer && null != (typeName = metadata.getTypeName())) {
                writer = this.writer(typeName);
                if (null != columnType) {
                    writer = this.writer(this.typeMetadata(runtime, metadata));
                }
            }
        }
        if (null == columnType || TypeMetadata.NONE == columnType) {
            columnType = this.typeMetadata(runtime, value.getClass().getSimpleName());
        }
        if (null != columnType && TypeMetadata.NONE != columnType && null != (writeClass = columnType.compatible())) {
            value = ConvertProxy.convert((Object)value, (Class)writeClass, (boolean)isArray);
        }
        if (null != columnType && TypeMetadata.NONE != columnType && null == (writer = this.writer(columnType))) {
            writer = this.writer(columnType.getCategory());
        }
        if (null == writer && null != value) {
            writer = this.writer(value.getClass());
        }
        if (null != writer) {
            result = writer.write(value, placeholder, columnType);
        }
        if (null != result) {
            return result;
        }
        if (null != columnType && TypeMetadata.NONE != columnType) {
            result = columnType.write(value, null, false);
        }
        if (null != result) {
            return result;
        }
        if (!placeholder) {
            result = null == value || BasicUtil.isNumber((Object)value) || "NULL".equals(value) ? value : "'" + value + "'";
        }
        return result;
    }

    @Override
    public Object read(DataRuntime runtime, Column metadata, Object value, Class clazz) {
        Object result = value;
        if (null == value) {
            return null;
        }
        DataReader reader = null;
        TypeMetadata ctype = null;
        if (null != metadata) {
            String typeName;
            ctype = metadata.getTypeMetadata();
            if (null != ctype) {
                reader = this.reader(ctype);
            }
            if (null == reader && null != (typeName = metadata.getTypeName()) && null == (reader = this.reader(typeName))) {
                reader = this.reader(this.typeMetadata(runtime, metadata));
            }
        }
        if (null == reader) {
            reader = this.reader(value.getClass());
        }
        if (null != reader) {
            result = reader.read(value);
        }
        if ((null == reader || null == result) && null != ctype) {
            result = ctype.read(value, null, clazz);
        }
        return result;
    }

    @Override
    public void value(DataRuntime runtime, StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        if (null != value) {
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                builder.append(this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
            } else {
                TypeMetadata type = this.typeMetadata(runtime, value.getClass().getName());
                if (null != type) {
                    value = type.write(value, null, false);
                }
                builder.append(value);
            }
        } else {
            builder.append("null");
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, Catalog catalog, Schema schema, String table, RunValue value) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap<String, Column> columns = this.columns(runtime, null, false, new Table(catalog, schema, table), false);
            result = this.convert(runtime, columns, value);
        } else {
            result = this.convert(runtime, (Column)null, value);
        }
        return result;
    }

    @Override
    public void addRunValue(DataRuntime runtime, Run run, Compare compare, Column column, Object value) {
        boolean split = ConfigTable.IS_AUTO_SPLIT_ARRAY;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap columns;
            String type = null;
            if (null != column && null == (type = column.getTypeName()) && BasicUtil.isNotEmpty((Object)run.getTable()) && null != (column = (Column)(columns = this.columns(runtime, null, false, run.getTable(), false)).get(column.getName().toUpperCase()))) {
                type = column.getTypeName();
            }
        }
        RunValue rv = run.addValues(compare, column, value, split);
        if (null != column) {
            // empty if block
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, ConfigStore configs, Run run) {
        boolean result = false;
        if (null != run) {
            result = this.convert(runtime, run.getTable(), run);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Table table, Run run) {
        boolean result = false;
        if (null != table) {
            List<RunValue> values;
            LinkedHashMap<String, Column> columns = table.getColumns();
            if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                columns = this.columns(runtime, null, false, table, false);
            }
            if (null != (values = run.getRunValues())) {
                for (RunValue value : values) {
                    if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                        result = this.convert(runtime, columns, value);
                        continue;
                    }
                    result = this.convert(runtime, (Column)null, value);
                }
            }
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Map<String, Column> columns, RunValue value) {
        String key;
        boolean result = false;
        if (null != columns && null != value && null != (key = value.getKey())) {
            Column meta = columns.get(key.toUpperCase());
            result = this.convert(runtime, meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Column metadata, RunValue run) {
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            if (null != metadata) {
                value = this.convert(runtime, metadata, value);
            } else {
                DataWriter writer = this.writer(value.getClass());
                if (null != writer) {
                    value = writer.write(value, true, metadata.getTypeMetadata());
                }
            }
            run.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Object convert(DataRuntime runtime, Column metadata, Object value) {
        if (null == value) {
            return value;
        }
        try {
            if (null != metadata) {
                TypeMetadata columnType = metadata.getTypeMetadata();
                if (null == columnType && null != (columnType = this.typeMetadata(runtime, metadata))) {
                    columnType.setArray(metadata.isArray());
                    metadata.setTypeMetadata(columnType);
                }
                value = this.convert(runtime, columnType, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Object convert(DataRuntime runtime, TypeMetadata columnType, Object value) {
        if (null == columnType) {
            return value;
        }
        String typeName = columnType.getName();
        boolean parseJson = false;
        if (null != typeName && !(value instanceof String)) {
            if (typeName.contains("JSON")) {
                value = BeanUtil.object2json((Object)value);
                parseJson = true;
            } else if (typeName.contains("XML")) {
                value = BeanUtil.object2xml((Object)value);
                parseJson = true;
            }
        }
        if (!parseJson && null != columnType) {
            DataWriter writer = this.writer(columnType);
            if (null == writer) {
                writer = this.writer(columnType.getCategory());
            }
            if (null != writer) {
                value = writer.write(value, true, columnType);
            } else {
                Class transfer = columnType.transfer();
                Class compatible = columnType.compatible();
                if (null != transfer) {
                    value = ConvertProxy.convert((Object)value, (Class)transfer, (boolean)columnType.isArray());
                }
                if (null != compatible) {
                    value = ConvertProxy.convert((Object)value, (Class)compatible, (boolean)columnType.isArray());
                }
            }
        }
        return value;
    }

    @Override
    public String objectName(DataRuntime runtime, String name) {
        KeyAdapter.KEY_CASE keyCase = this.type().nameCase();
        if (null != keyCase) {
            return keyCase.convert(name);
        }
        return name;
    }

    protected String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[cmd:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }

    protected String concat(String prefix, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)prefix)) {
            prefix = "";
        } else if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append(prefix);
            this.delimiter(builder, column);
        }
        return builder.toString();
    }

    protected String concatEqual(String master, String data, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)master)) {
            master = "";
        } else if (!master.endsWith(".")) {
            master = master + ".";
        }
        if (BasicUtil.isEmpty((Object)data)) {
            data = "";
        } else if (!data.endsWith(".")) {
            data = data + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append(master).append(column).append(" = ").append(data).append(column);
        }
        return builder.toString();
    }

    @Override
    public <T extends Metadata> T search(List<T> list, Catalog catalog, Schema schema, String name) {
        if (null != list) {
            for (Metadata meta : list) {
                if (!this.equals(catalog, meta.getCatalog()) || !this.equals(schema, meta.getSchema()) || !BasicUtil.equalsIgnoreCase((Object)meta.getName(), (Object)name)) continue;
                return (T)meta;
            }
        }
        return (T)Metadata.match(list, (Catalog)catalog, (Schema)schema, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String catalog, String schema, String name) {
        return (T)Metadata.match(list, (String)catalog, (String)schema, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String catalog, String name) {
        return (T)Metadata.match(list, (String)catalog, (String)name);
    }

    public <T extends Metadata> T search(List<T> list, String name) {
        return (T)Metadata.match(list, (String)name);
    }

    static {
        for (StandardTypeMetadata type : StandardTypeMetadata.values()) {
            String name = type.name().toUpperCase();
            String standard = type.getName().toUpperCase();
            spells.put(name, standard);
            if (name.contains(" ")) {
                spells.put(name.replace(" ", "_"), standard);
            }
            if (name.contains("_")) {
                spells.put(name.replace("_", " "), standard);
            }
            if (standard.contains(" ")) {
                spells.put(standard.replace(" ", "_"), standard);
            }
            if (!standard.contains("_")) continue;
            spells.put(standard.replace("_", " "), standard);
        }
    }
}

