/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.data.adapter.DataReaderFactory;
import org.anyline.data.adapter.DataWriterFactory;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.SystemDataReaderFactory;
import org.anyline.data.adapter.SystemDataWriterFactory;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.TypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.TextRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.adapter.ColumnMetadataAdapter;
import org.anyline.metadata.adapter.ConstraintMetadataAdapter;
import org.anyline.metadata.adapter.EdgeTableMetadataAdapter;
import org.anyline.metadata.adapter.FunctionMetadataAdapter;
import org.anyline.metadata.adapter.IndexMetadataAdapter;
import org.anyline.metadata.adapter.MasterTableMetadataAdapter;
import org.anyline.metadata.adapter.PrimaryMetadataAdapter;
import org.anyline.metadata.adapter.ProcedureMetadataAdapter;
import org.anyline.metadata.adapter.SequenceMetadataAdapter;
import org.anyline.metadata.adapter.TableMetadataAdapter;
import org.anyline.metadata.adapter.TriggerMetadataAdapter;
import org.anyline.metadata.adapter.VertexTableMetadataAdapter;
import org.anyline.metadata.adapter.ViewMetadataAdapter;
import org.anyline.metadata.differ.ColumnsDiffer;
import org.anyline.metadata.differ.FunctionsDiffer;
import org.anyline.metadata.differ.IndexesDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.PrimaryKeyDiffer;
import org.anyline.metadata.differ.ProceduresDiffer;
import org.anyline.metadata.differ.TableDiffer;
import org.anyline.metadata.differ.TablesDiffer;
import org.anyline.metadata.differ.ViewsDiffer;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DriverAdapter {
    public static final Logger log = LoggerFactory.getLogger(DriverAdapter.class);
    public static final String TAB = "\t";
    public static final String BR = "\n";
    public static final String BR_TAB = "\n\t";

    public DatabaseType type();

    default public LinkedHashMap<String, TypeMetadata> types() {
        LinkedHashMap<String, TypeMetadata> types = new LinkedHashMap<String, TypeMetadata>();
        for (TypeMetadata type : this.alias().values()) {
            types.put(type.getName().toUpperCase(), type);
        }
        return types;
    }

    public LinkedHashMap<String, TypeMetadata> alias();

    public void setActuator(DriverActuator var1);

    public DriverActuator getActuator();

    public boolean supportCatalog();

    public boolean supportSchema();

    default public boolean supportPlaceholder() {
        return true;
    }

    public void setListener(DDListener var1);

    public DDListener getDDListener();

    public void setListener(DMListener var1);

    public DMListener getDMListener();

    public void setGenerator(PrimaryGenerator var1);

    public void setDelimiter(String var1);

    default public boolean equals(Metadata m1, Metadata m2) {
        String c1 = null;
        String c2 = null;
        String s1 = null;
        String s2 = null;
        String n1 = null;
        String n2 = null;
        if (null != m1) {
            if (null == m2) {
                return false;
            }
            c1 = m1.getCatalogName();
            s1 = m1.getSchemaName();
            n1 = m1.getName();
        }
        if (null != m2) {
            if (null == m1) {
                return false;
            }
            c2 = m2.getCatalogName();
            s2 = m2.getSchemaName();
            n2 = m2.getName();
        }
        if (this.supportCatalog() && !BasicUtil.equals((Object)c1, (Object)c2, (boolean)true)) {
            return false;
        }
        if (this.supportSchema() && !BasicUtil.equals((Object)s1, (Object)s2, (boolean)true)) {
            return false;
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    default public boolean empty(Metadata meta) {
        if (null == meta) {
            return true;
        }
        return BasicUtil.isEmpty((Object)meta.getName());
    }

    default public boolean empty(String meta) {
        return BasicUtil.isEmpty((Object)meta);
    }

    default public boolean equals(Catalog c1, Catalog c2) {
        if (!this.supportCatalog()) {
            return true;
        }
        String n1 = null;
        String n2 = null;
        if (null != c1) {
            if (null == c2) {
                return false;
            }
            n1 = c1.getName();
        }
        if (null != c2) {
            if (null == c1) {
                return false;
            }
            n2 = c2.getName();
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    default public boolean equals(Schema s1, Schema s2) {
        if (!this.supportCatalog()) {
            return true;
        }
        String n1 = null;
        String n2 = null;
        if (null != s1) {
            if (null == s2) {
                return false;
            }
            n1 = s1.getName();
        }
        if (null != s2) {
            if (null == s1) {
                return false;
            }
            n2 = s2.getName();
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    public TypeMetadata.Config reg(TypeMetadataAlias var1);

    public TypeMetadata.Config reg(String var1, TypeMetadata.Config var2);

    public TypeMetadata.Config reg(TypeMetadata var1, TypeMetadata.Config var2);

    default public boolean match(DataRuntime runtime, boolean compensate) {
        if (BasicUtil.isNotEmpty((Object)runtime.getAdapterKey())) {
            return this.matchByAdapter(runtime);
        }
        String feature = runtime.getFeature();
        if (BasicUtil.isNotEmpty((Object)runtime.getAdapterKey())) {
            return this.matchByAdapter(runtime);
        }
        List keywords = this.type().keywords();
        return this.match(feature, keywords, compensate);
    }

    default public boolean matchByAdapter(DataRuntime runtime) {
        String config_adapter_key = runtime.getAdapterKey();
        if (BasicUtil.isNotEmpty((Object)config_adapter_key)) {
            String type = this.type().name();
            boolean result = false;
            if (config_adapter_key.equalsIgnoreCase(type)) {
                result = true;
            }
            if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                log.info("[adapter match][result:{}][config adapter:{}][match adapter:{}]", new Object[]{result, config_adapter_key, type});
            }
            return result;
        }
        return false;
    }

    default public boolean match(String feature, List<String> keywords, boolean compensate) {
        if (null == feature) {
            return false;
        }
        feature = feature.toLowerCase();
        if (null != keywords) {
            for (String k : keywords) {
                if (BasicUtil.isEmpty((Object)k)) {
                    if (!ConfigTable.IS_LOG_ADAPTER_MATCH) continue;
                    log.info("[adapter match][result:{}][feature:{}][key:{}][match adapter:{}]", new Object[]{false, feature, k, this.getClass()});
                    continue;
                }
                if (!feature.contains(k)) continue;
                if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                    log.info("[adapter match][result:{}][feature:{}][key:{}][match adapter:{}]", new Object[]{true, feature, k, this.getClass()});
                }
                return true;
            }
        }
        return false;
    }

    public String getDelimiterFr();

    public String getDelimiterTo();

    public DatabaseType compatible();

    public TypeMetadata typeMetadata(DataRuntime var1, Column var2);

    public TypeMetadata typeMetadata(DataRuntime var1, String var2);

    default public void reg(Object[] supports, DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), supports, writer);
    }

    default public void reg(DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), null, writer);
    }

    default public void reg(Object[] supports, DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), supports, reader);
    }

    default public void reg(DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), null, reader);
    }

    default public DataReader reader(Object type) {
        DataReader reader = DataReaderFactory.reader(this.type(), type);
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(this.type(), type);
        }
        if (null == reader) {
            reader = DataReaderFactory.reader(DatabaseType.NONE, type);
        }
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(DatabaseType.NONE, type);
        }
        return reader;
    }

    default public DataWriter writer(Object type) {
        DataWriter writer = DataWriterFactory.writer(this.type(), type);
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(this.type(), type);
        }
        if (null == writer) {
            writer = DataWriterFactory.writer(DatabaseType.NONE, type);
        }
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(DatabaseType.NONE, type);
        }
        return writer;
    }

    public String name(Type var1);

    default public List<String> names(List<Type> types) {
        ArrayList<String> list = new ArrayList<String>();
        for (Type type : types) {
            String name = this.name(type);
            if (null == name) continue;
            list.add(name);
        }
        return list;
    }

    default public void in(DataRuntime runtime, StringBuilder builder, String column, List<String> list) {
        if (!list.isEmpty()) {
            builder.append(" AND ").append(column);
            if (list.size() == 1) {
                builder.append(" = '").append(this.objectName(runtime, list.get(0))).append("'");
            } else {
                boolean first = true;
                builder.append(" IN(");
                for (String item : list) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append("'").append(this.objectName(runtime, item)).append("'");
                    first = false;
                }
                builder.append(")");
            }
        }
    }

    public List<Run> merge(DataRuntime var1, Table var2, List<Run> var3);

    default public List<Run> ddl(DataRuntime runtime, String random, MetadataDiffer differ) {
        return this.ddl(runtime, random, differ, true);
    }

    default public List<Run> ddl(DataRuntime runtime, String random, MetadataDiffer differ, boolean merge) {
        ArrayList<Run> list;
        block70: {
            block77: {
                block76: {
                    block75: {
                        block74: {
                            block73: {
                                block72: {
                                    block71: {
                                        list = new ArrayList<Run>();
                                        if (!(differ instanceof TablesDiffer)) break block71;
                                        TablesDiffer df = (TablesDiffer)differ;
                                        LinkedHashMap adds = df.getAdds();
                                        LinkedHashMap drops = df.getDrops();
                                        LinkedHashMap updates = df.getAlters();
                                        LinkedHashMap diffs = df.getDiffers();
                                        for (Table add : adds.values()) {
                                            try {
                                                list.addAll(this.buildCreateRun(runtime, add));
                                            }
                                            catch (Exception e) {
                                                log.error("build ddl exception:", (Throwable)e);
                                            }
                                        }
                                        for (TableDiffer dif : diffs.values()) {
                                            list.addAll(this.ddl(runtime, random, (MetadataDiffer)dif, merge));
                                        }
                                        for (Table drop : drops.values()) {
                                            try {
                                                list.addAll(this.buildDropRun(runtime, drop));
                                            }
                                            catch (Exception e) {
                                                log.error("build ddl exception:", (Throwable)e);
                                            }
                                        }
                                        break block70;
                                    }
                                    if (!(differ instanceof ViewsDiffer)) break block72;
                                    ViewsDiffer df = (ViewsDiffer)differ;
                                    LinkedHashMap adds = df.getAdds();
                                    LinkedHashMap drops = df.getDrops();
                                    LinkedHashMap updates = df.getAlters();
                                    for (View add : adds.values()) {
                                        try {
                                            list.addAll(this.buildCreateRun(runtime, add));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    for (View update : updates.values()) {
                                        try {
                                            list.addAll(this.buildAlterRun(runtime, update));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    for (View drop : drops.values()) {
                                        try {
                                            list.addAll(this.buildDropRun(runtime, drop));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    break block70;
                                }
                                if (!(differ instanceof TableDiffer)) break block73;
                                try {
                                    TableDiffer dif = (TableDiffer)differ;
                                    ArrayList<Run> slices = new ArrayList<Run>();
                                    Table direct = dif.getDirect();
                                    Table dest = dif.getDest();
                                    Table origin = dif.getOrigin();
                                    Table update = origin.clone();
                                    if (null != update) {
                                        update.setUpdate((Metadata)dest, false, false);
                                    }
                                    ColumnsDiffer columns_dif = dif.getColumnsDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)columns_dif, false));
                                    PrimaryKeyDiffer primary_dif = dif.getPrimaryKeyDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)primary_dif, false));
                                    IndexesDiffer index_dif = dif.getIndexesDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)index_dif, false));
                                    if (merge) {
                                        List<Run> merges = this.merge(runtime, direct, slices);
                                        list.addAll(merges);
                                        break block70;
                                    }
                                    list.addAll(slices);
                                }
                                catch (Exception e) {
                                    log.error("build ddl exception:", (Throwable)e);
                                }
                                break block70;
                            }
                            if (!(differ instanceof PrimaryKeyDiffer)) break block74;
                            PrimaryKeyDiffer df = (PrimaryKeyDiffer)differ;
                            Table table = null;
                            PrimaryKey add = df.getAdd();
                            PrimaryKey drop = df.getDrop();
                            PrimaryKey alter = df.getAlter();
                            boolean slice = this.slice();
                            ArrayList<Run> slices = new ArrayList<Run>();
                            try {
                                if (null != drop) {
                                    if (null == table) {
                                        table = drop.getTable();
                                    }
                                    slices.addAll(this.buildDropRun(runtime, drop, slice));
                                }
                                if (null != add) {
                                    if (null == table) {
                                        table = add.getTable();
                                    }
                                    slices.addAll(this.buildAddRun(runtime, add, slice));
                                }
                                if (null != alter) {
                                    if (null == table) {
                                        table = alter.getTable();
                                    }
                                    slices.addAll(this.buildAlterRun(runtime, alter, (PrimaryKey)alter.getUpdate(), slice));
                                }
                                if (merge) {
                                    list.addAll(this.merge(runtime, table, slices));
                                    break block70;
                                }
                                list.addAll(slices);
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                            break block70;
                        }
                        if (!(differ instanceof ColumnsDiffer)) break block75;
                        boolean slice = this.slice();
                        ColumnsDiffer df = (ColumnsDiffer)differ;
                        LinkedHashMap adds = df.getAdds();
                        LinkedHashMap drops = df.getDrops();
                        LinkedHashMap updates = df.getAlters();
                        Table direct = differ.getDirect();
                        ArrayList<Run> slices = new ArrayList<Run>();
                        for (Column add : adds.values()) {
                            try {
                                if (null == direct) {
                                    direct = add.getTable();
                                }
                                slices.addAll(this.buildAddRun(runtime, add, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        for (Column update : updates.values()) {
                            try {
                                if (null == direct) {
                                    direct = update.getTable();
                                }
                                slices.addAll(this.buildAlterRun(runtime, update, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        for (Column drop : drops.values()) {
                            try {
                                if (null == direct) {
                                    direct = drop.getTable();
                                }
                                slices.addAll(this.buildDropRun(runtime, drop, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        if (merge) {
                            list.addAll(this.merge(runtime, direct, slices));
                        } else {
                            list.addAll(slices);
                        }
                        break block70;
                    }
                    if (!(differ instanceof IndexesDiffer)) break block76;
                    IndexesDiffer df = (IndexesDiffer)differ;
                    LinkedHashMap adds = df.getAdds();
                    LinkedHashMap drops = df.getDrops();
                    LinkedHashMap updates = df.getAlters();
                    for (Index add : adds.values()) {
                        try {
                            list.addAll(this.buildAddRun(runtime, add));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    for (Index update : updates.values()) {
                        try {
                            list.addAll(this.buildAlterRun(runtime, update));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    for (Index drop : drops.values()) {
                        try {
                            list.addAll(this.buildDropRun(runtime, drop));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    break block70;
                }
                if (!(differ instanceof FunctionsDiffer)) break block77;
                FunctionsDiffer df = (FunctionsDiffer)differ;
                List adds = df.getAdds();
                List drops = df.getDrops();
                List updates = df.getAlters();
                for (Function add : adds) {
                    try {
                        list.addAll(this.buildCreateRun(runtime, add));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                for (Function update : updates) {
                    try {
                        list.addAll(this.buildAlterRun(runtime, update));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                for (Function drop : drops) {
                    try {
                        list.addAll(this.buildDropRun(runtime, drop));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                break block70;
            }
            if (!(differ instanceof ProceduresDiffer)) break block70;
            ProceduresDiffer df = (ProceduresDiffer)differ;
            LinkedHashMap adds = df.getAdds();
            LinkedHashMap drops = df.getDrops();
            LinkedHashMap updates = df.getUpdates();
            for (Procedure add : adds.values()) {
                try {
                    list.addAll(this.buildCreateRun(runtime, add));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
            for (Procedure update : updates.values()) {
                try {
                    list.addAll(this.buildAlterRun(runtime, update));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
            for (Procedure drop : drops.values()) {
                try {
                    list.addAll(this.buildDropRun(runtime, drop));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
        }
        return list;
    }

    default public List<Run> ddl(DataRuntime runtime, String random, List<MetadataDiffer> differs) {
        ArrayList<Run> list = new ArrayList<Run>();
        for (MetadataDiffer differ : differs) {
            list.addAll(this.ddl(runtime, random, differ));
        }
        return list;
    }

    public long insert(DataRuntime var1, String var2, int var3, Table var4, Object var5, ConfigStore var6, List<String> var7);

    default public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, List<String> columns) {
        return this.insert(runtime, random, batch, dest, data, null, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, String ... columns) {
        return this.insert(runtime, random, batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.insert(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.insert(runtime, random, 0, dest, data, columns);
    }

    default public long insert(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.insert(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.insert(runtime, random, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.insert(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, batch, dest, data, null, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, 0, dest, data, columns);
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long insert(DataRuntime var1, String var2, Table var3, RunPrepare var4, ConfigStore var5, Object var6, String ... var7);

    public Run buildInsertRun(DataRuntime var1, Table var2, RunPrepare var3, ConfigStore var4, Object var5, String ... var6);

    public Run buildInsertRun(DataRuntime var1, int var2, Table var3, Object var4, ConfigStore var5, List<String> var6);

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore confgis, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, null), obj, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, ConfigStore configs, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, ConfigStore configs, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore confgis, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public void fillInsertContent(DataRuntime var1, Run var2, Table var3, Collection var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, columns);
    }

    public void fillInsertContent(DataRuntime var1, Run var2, Table var3, DataSet var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, list, configs), list, configs, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, set, configs), set, configs, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime var1, Table var2, Object var3, ConfigStore var4, List<String> var5, boolean var6);

    default public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object data, ConfigStore configs, List<String> columns, boolean batch) {
        return this.confirmInsertColumns(runtime, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns, batch);
    }

    public String batchInsertSeparator();

    public boolean supportInsertPlaceholder();

    public String generatedKey();

    public long insert(DataRuntime var1, String var2, Object var3, ConfigStore var4, Run var5, String[] var6);

    public boolean supportKeyHolder(DataRuntime var1, ConfigStore var2);

    public List<String> keyHolders(DataRuntime var1, ConfigStore var2);

    public long update(DataRuntime var1, String var2, int var3, Table var4, Object var5, ConfigStore var6, List<String> var7);

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, List<String> columns) {
        return this.update(runtime, random, batch, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, String ... columns) {
        return this.update(runtime, random, batch, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, null), data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.update(runtime, random, 0, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, null), data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, batch, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.update(runtime, random, batch, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.update(runtime, random, 0, dest, data, BeanUtil.array2string((Object[])columns));
    }

    public Run buildUpdateRun(DataRuntime var1, int var2, Table var3, Object var4, ConfigStore var5, List<String> var6);

    public Run buildUpdateRunLimit(DataRuntime var1, Run var2);

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public Run buildUpdateRunFromEntity(DataRuntime var1, Table var2, Object var3, ConfigStore var4, LinkedHashMap<String, Column> var5);

    public Run buildUpdateRunFromDataRow(DataRuntime var1, Table var2, DataRow var3, ConfigStore var4, LinkedHashMap<String, Column> var5);

    public Run buildUpdateRunFromCollection(DataRuntime var1, int var2, Table var3, Collection var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    default public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromEntity(runtime, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, columns);
    }

    default public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromDataRow(runtime, DataSourceUtil.parseDest(dest, row, configs), row, configs, columns);
    }

    default public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromCollection(runtime, batch, DataSourceUtil.parseDest(dest, list, configs), list, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, Table var2, DataRow var3, ConfigStore var4, List<String> var5);

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, Table var2, Object var3, ConfigStore var4, List<String> var5);

    default public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return this.confirmUpdateColumns(runtime, DataSourceUtil.parseDest(dest, row, configs), row, configs, columns);
    }

    default public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.confirmUpdateColumns(runtime, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, columns);
    }

    public long update(DataRuntime var1, String var2, Table var3, Object var4, ConfigStore var5, Run var6);

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return this.update(runtime, random, DataSourceUtil.parseDest(dest, data, configs), data, configs, run);
    }

    public long save(DataRuntime var1, String var2, Table var3, Object var4, ConfigStore var5, List<String> var6);

    default public long save(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.save(runtime, random, dest, data, null, columns);
    }

    default public long save(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(null, data, null), data, columns);
    }

    default public long save(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.save(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.save(runtime, random, dest, data, null, columns);
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.save(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public DataSet querys(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public DataSet querys(DataRuntime var1, String var2, Procedure var3, PageNavi var4);

    public <T> EntitySet<T> selects(DataRuntime var1, String var2, RunPrepare var3, Class<T> var4, ConfigStore var5, String ... var6);

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public Run buildQueryRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, String ... var4);

    default public Run initQueryRun(DataRuntime runtime, RunPrepare prepare) {
        return prepare.build(runtime);
    }

    default public RunPrepare buildRunPrepare(DataRuntime runtime, String text) {
        return null;
    }

    public void parseText(DataRuntime var1, TextRun var2);

    default public boolean supportSqlVarPlaceholderRegexExt(DataRuntime runtime) {
        return true;
    }

    public List<Run> buildQuerySequence(DataRuntime var1, boolean var2, String ... var3);

    public Run fillQueryContent(DataRuntime var1, StringBuilder var2, Run var3);

    public Run fillQueryContent(DataRuntime var1, Run var2);

    public String mergeFinalQuery(DataRuntime var1, Run var2);

    public RunValue createConditionLike(DataRuntime var1, StringBuilder var2, Compare var3, Object var4, boolean var5);

    default public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionJsonContains(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionJsonContainsPath(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    public StringBuilder createConditionIn(DataRuntime var1, StringBuilder var2, Compare var3, Object var4, boolean var5);

    public DataSet select(DataRuntime var1, String var2, boolean var3, Table var4, ConfigStore var5, Run var6);

    default public DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        return this.select(runtime, random, system, new Table(table), configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public Map<String, Object> map(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public DataRow sequence(DataRuntime var1, String var2, boolean var3, String ... var4);

    public List<Map<String, Object>> process(DataRuntime var1, List<Map<String, Object>> var2);

    public long count(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long count(DataRuntime var1, String var2, Run var3);

    public String mergeFinalTotal(DataRuntime var1, Run var2);

    public boolean exists(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public String mergeFinalExists(DataRuntime var1, Run var2);

    public long execute(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long execute(DataRuntime var1, String var2, int var3, ConfigStore var4, RunPrepare var5, Collection<Object> var6);

    public long execute(DataRuntime var1, String var2, int var3, int var4, ConfigStore var5, RunPrepare var6, Collection<Object> var7);

    public boolean execute(DataRuntime var1, String var2, Procedure var3);

    public Run buildExecuteRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, String ... var4);

    public void fillExecuteContent(DataRuntime var1, Run var2);

    public long execute(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public <T> long deletes(DataRuntime var1, String var2, int var3, Table var4, ConfigStore var5, String var6, Collection<T> var7);

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, table, (ConfigStore)null, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, new Table(table), configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, table, (ConfigStore)null, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    public long delete(DataRuntime var1, String var2, Table var3, ConfigStore var4, Object var5, String ... var6);

    default public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.delete(runtime, random, new Table(table), configs, obj, columns);
    }

    public long delete(DataRuntime var1, String var2, Table var3, ConfigStore var4, String ... var5);

    default public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return this.delete(runtime, random, new Table(table), configs, conditions);
    }

    public long truncate(DataRuntime var1, String var2, Table var3);

    default public long truncate(DataRuntime runtime, String random, String table) {
        return this.truncate(runtime, random, new Table(table));
    }

    public List<Run> buildDeleteRun(DataRuntime var1, Table var2, ConfigStore var3, Object var4, String ... var5);

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRun(runtime, new Table(table), configs, obj, columns);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, Table table, ConfigStore configs) {
        return this.buildDeleteRun(runtime, table, configs, null, null);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs) {
        return this.buildDeleteRun(runtime, new Table(table), configs, null, null);
    }

    public List<Run> buildDeleteRun(DataRuntime var1, int var2, Table var3, ConfigStore var4, String var5, Object var6);

    default public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRun(runtime, batch, new Table(table), configs, column, values);
    }

    public List<Run> buildTruncateRun(DataRuntime var1, Table var2);

    default public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return this.buildTruncateRun(runtime, new Table(table));
    }

    public List<Run> buildDeleteRunFromTable(DataRuntime var1, int var2, Table var3, ConfigStore var4, String var5, Object var6);

    default public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, new Table(table), configs, column, values);
    }

    public List<Run> buildDeleteRunFromEntity(DataRuntime var1, Table var2, ConfigStore var3, Object var4, String ... var5);

    default public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRunFromEntity(runtime, new Table(table), configs, obj, columns);
    }

    default public List<Run> buildDeleteRunFromConfig(DataRuntime runtime, ConfigStore configs) {
        Table table = configs.table();
        if (null != table && BasicUtil.isNotEmpty((Object)table.getName())) {
            return this.buildDeleteRunFromTable(runtime, 1, table, configs, null, null);
        }
        return null;
    }

    public void fillDeleteRunContent(DataRuntime var1, Run var2);

    public long delete(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public <T extends Metadata> void checkSchema(DataRuntime var1, T var2);

    default public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema, boolean overrideRuntime, boolean overrideMeta) {
        if (this.supportCatalog()) {
            if (overrideMeta || this.empty((Metadata)meta.getCatalog())) {
                meta.setCatalog(catalog);
            }
            if (overrideRuntime || BasicUtil.isEmpty((Object)runtime.getCatalog())) {
                runtime.setCatalog(catalog);
            }
        } else {
            meta.setCatalog((Catalog)null);
            runtime.setCatalog(null);
        }
        if (this.supportSchema()) {
            if (overrideMeta || this.empty((Metadata)meta.getSchema())) {
                meta.setSchema(schema);
            }
            if (overrideRuntime || BasicUtil.isEmpty((Object)runtime.getSchema())) {
                runtime.setSchema(schema);
            }
        } else {
            meta.setSchema((Schema)null);
            runtime.setSchema(null);
        }
    }

    default public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema) {
        this.correctSchemaFromJDBC(runtime, meta, catalog, schema, false, true);
    }

    default public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return new String[]{catalog, schema};
    }

    public LinkedHashMap<String, Column> metadata(DataRuntime var1, RunPrepare var2, boolean var3);

    public Database database(DataRuntime var1, String var2);

    public String product(DataRuntime var1, String var2);

    public String version(DataRuntime var1, String var2);

    public LinkedHashMap<String, Database> databases(DataRuntime var1, String var2, String var3);

    public List<Database> databases(DataRuntime var1, String var2, boolean var3, String var4);

    default public Database database(DataRuntime runtime, String random, String name) {
        List<Database> databases = this.databases(runtime, random, false, name);
        if (!databases.isEmpty()) {
            return databases.get(0);
        }
        return null;
    }

    public List<Run> buildQueryProductRun(DataRuntime var1) throws Exception;

    public List<Run> buildQueryVersionRun(DataRuntime var1) throws Exception;

    public List<Run> buildQueryDatabasesRun(DataRuntime var1, boolean var2, String var3) throws Exception;

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, null);
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, String name) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, name);
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, null);
    }

    public String product(DataRuntime var1, int var2, boolean var3, String var4, DataSet var5);

    public String product(DataRuntime var1, boolean var2, String var3);

    public String version(DataRuntime var1, int var2, boolean var3, String var4, DataSet var5);

    public String version(DataRuntime var1, boolean var2, String var3);

    public LinkedHashMap<String, Database> databases(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Database> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public List<Database> databases(DataRuntime var1, int var2, boolean var3, List<Database> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public Database database(DataRuntime var1, int var2, boolean var3, Database var4, DataSet var5) throws Exception;

    public Database database(DataRuntime var1, boolean var2, Database var3) throws Exception;

    public Catalog catalog(DataRuntime var1, String var2);

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, String var2, String var3);

    public List<Catalog> catalogs(DataRuntime var1, String var2, boolean var3, String var4);

    default public Catalog catalog(DataRuntime runtime, String random, String name) {
        List<Catalog> catalogs = this.catalogs(runtime, random, false, name);
        if (!catalogs.isEmpty()) {
            return catalogs.get(0);
        }
        return null;
    }

    public List<Run> buildQueryCatalogRun(DataRuntime var1, String var2) throws Exception;

    public List<Run> buildQueryCatalogsRun(DataRuntime var1, boolean var2, String var3) throws Exception;

    default public List<Run> buildQueryCatalogsRun(DataRuntime runtime) throws Exception {
        return this.buildQueryCatalogsRun(runtime, false, null);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Catalog> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public List<Catalog> catalogs(DataRuntime var1, int var2, boolean var3, List<Catalog> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, boolean var2, LinkedHashMap<String, Catalog> var3) throws Exception;

    public List<Catalog> catalogs(DataRuntime var1, boolean var2, List<Catalog> var3) throws Exception;

    public Catalog catalog(DataRuntime var1, int var2, boolean var3, Catalog var4, DataSet var5) throws Exception;

    public Catalog catalog(DataRuntime var1, boolean var2, Catalog var3) throws Exception;

    public Schema schema(DataRuntime var1, String var2);

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, String var2, Catalog var3, String var4);

    default public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, String name) {
        return this.schemas(runtime, random, null, name);
    }

    public List<Schema> schemas(DataRuntime var1, String var2, boolean var3, Catalog var4, String var5);

    default public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, String name) {
        return this.schemas(runtime, random, greedy, null, name);
    }

    default public Schema schema(DataRuntime runtime, String random, Catalog catalog, String name) {
        List<Schema> schemas = this.schemas(runtime, random, false, catalog, name);
        if (!schemas.isEmpty()) {
            return schemas.get(0);
        }
        return null;
    }

    public List<Run> buildQuerySchemaRun(DataRuntime var1, String var2) throws Exception;

    public List<Run> buildQuerySchemasRun(DataRuntime var1, boolean var2, Catalog var3, String var4) throws Exception;

    default public List<Run> buildQuerySchemasRun(DataRuntime runtime, String name) throws Exception {
        return this.buildQuerySchemasRun(runtime, false, null, name);
    }

    default public List<Run> buildQuerySchemasRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return this.buildQuerySchemasRun(runtime, false, catalog, null);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Schema> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public List<Schema> schemas(DataRuntime var1, int var2, boolean var3, List<Schema> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, boolean var2, LinkedHashMap<String, Schema> var3) throws Exception;

    public List<Schema> schemas(DataRuntime var1, boolean var2, List<Schema> var3) throws Exception;

    public Schema schema(DataRuntime var1, int var2, boolean var3, Schema var4, DataSet var5) throws Exception;

    public Schema schema(DataRuntime var1, boolean var2, Schema var3) throws Exception;

    public <T extends Metadata> T checkName(DataRuntime var1, String var2, T var3) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, int var7, int var8, ConfigStore var9);

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, int var6, int var7, ConfigStore var8);

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.tables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.tables(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.tables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.tables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryTablesRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, int var6, ConfigStore var7) throws Exception;

    public List<Run> buildQueryTablesCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends Table> List<T> comments(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Table var3, boolean var4);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, Table var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Table var3, List<String> var4, DataSet var5);

    public <T extends Table> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Table> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public TableMetadataAdapter tableMetadataAdapter(DataRuntime var1);

    public <T extends VertexTable> List<T> vertexTables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, int var7, int var8, ConfigStore var9);

    default public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.vertexTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.vertexTables(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.vertexTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.vertexTables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, int var6, int var7, ConfigStore var8);

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.vertexTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.vertexTables(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.vertexTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.vertexTables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryVertexTablesRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, int var6, ConfigStore var7) throws Exception;

    public List<Run> buildQueryVertexTablesCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends VertexTable> List<T> vertexTables(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends VertexTable> List<T> vertexTables(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, VertexTable var3, boolean var4);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, VertexTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, VertexTable var3, List<String> var4, DataSet var5);

    public <T extends VertexTable> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends VertexTable> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public VertexTableMetadataAdapter vertexTableMetadataAdapter(DataRuntime var1);

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, int var7, int var8, ConfigStore var9);

    default public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.edgeTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.edgeTables(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.edgeTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.edgeTables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, int var6, int var7, ConfigStore var8);

    default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.edgeTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.edgeTables(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.edgeTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.edgeTables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryEdgeTablesRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, int var6, ConfigStore var7) throws Exception;

    public List<Run> buildQueryEdgeTablesCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, EdgeTable var3, boolean var4);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, EdgeTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, EdgeTable var3, List<String> var4, DataSet var5);

    public <T extends EdgeTable> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends EdgeTable> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public EdgeTableMetadataAdapter edgeTableMetadataAdapter(DataRuntime var1);

    public <T extends View> List<T> views(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, int var7, int var8, ConfigStore var9);

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, int var6, int var7, ConfigStore var8);

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.views(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.views(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.views(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.views(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryViewsRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, int var6, ConfigStore var7) throws Exception;

    public List<Run> buildQueryViewsCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends View> List<T> views(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends View> List<T> views(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, View var3, boolean var4);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, View var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, View var3, List<String> var4, DataSet var5);

    public <T extends View> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends View> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public ViewMetadataAdapter viewMetadataAdapter(DataRuntime var1);

    public <T extends MasterTable> List<T> masterTables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, int var7, int var8, ConfigStore var9);

    default public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.masterTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.masterTables(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.masterTables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> List<T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.masterTables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, int var6, int var7, ConfigStore var8);

    default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.masterTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Short.MAX_VALUE;
        }
        return this.masterTables(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.masterTables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.masterTables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryMasterTablesRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, int var6, ConfigStore var7) throws Exception;

    public List<Run> buildQueryMasterTablesCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends MasterTable> List<T> masterTables(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public <T extends MasterTable> List<T> masterTables(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, int var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, MasterTable var3, boolean var4);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, MasterTable var3, List<String> var4, DataSet var5);

    public <T extends MasterTable> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends MasterTable> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public MasterTableMetadataAdapter masterTableMetadataAdapter(DataRuntime var1);

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime var1, String var2, boolean var3, MasterTable var4, Map<String, Object> var5, String var6);

    public List<Run> buildQueryPartitionTablesRun(DataRuntime var1, Catalog var2, Schema var3, String var4, int var5) throws Exception;

    public List<Run> buildQueryPartitionTablesRun(DataRuntime var1, Table var2, Map<String, Object> var3, String var4) throws Exception;

    public List<Run> buildQueryPartitionTablesRun(DataRuntime var1, Table var2, Map<String, Object> var3) throws Exception;

    public List<Run> buildQueryPartitionTablesRun(DataRuntime var1, Table var2) throws Exception;

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime var1, int var2, int var3, boolean var4, MasterTable var5, LinkedHashMap<String, T> var6, Catalog var7, Schema var8, DataSet var9) throws Exception;

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, MasterTable var6) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, PartitionTable var3);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, PartitionTable var3, List<String> var4, DataSet var5);

    public <T extends PartitionTable> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends PartitionTable> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, String var2, boolean var3, Table var4, boolean var5, ConfigStore var6);

    default public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        return this.columns(runtime, random, greedy, table, primary, null);
    }

    public <T extends Column> List<T> columns(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, Table var6, ConfigStore var7);

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table) {
        return this.columns(runtime, random, greedy, catalog, schema, table, null);
    }

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String table, ConfigStore configs) {
        return this.columns(runtime, random, greedy, catalog, schema, new Table(table), configs);
    }

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String table) {
        return this.columns(runtime, random, greedy, catalog, schema, new Table(table), null);
    }

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, ConfigStore configs) {
        return this.columns(runtime, random, greedy, catalog, schema, (Table)null, configs);
    }

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        return this.columns(runtime, random, greedy, catalog, schema, (Table)null);
    }

    public <T extends Column> List<T> columns(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, Collection<? extends Table> var6, ConfigStore var7);

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Collection<? extends Table> tables) {
        return this.columns(runtime, random, greedy, catalog, schema, tables, null);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, String var5, ConfigStore var6) throws Exception;

    default public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return this.columns(runtime, create, columns, table, pattern, null);
    }

    public List<Run> buildQueryColumnsRun(DataRuntime var1, Table var2, boolean var3, ConfigStore var4) throws Exception;

    default public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return this.buildQueryColumnsRun(runtime, table, metadata, null);
    }

    public List<Run> buildQueryColumnsRun(DataRuntime var1, Catalog var2, Schema var3, Collection<? extends Table> var4, boolean var5, ConfigStore var6) throws Exception;

    default public List<Run> buildQueryColumnsRun(DataRuntime runtime, Catalog catalog, Schema schema, Collection<? extends Table> tables, boolean metadata) throws Exception {
        return this.buildQueryColumnsRun(runtime, catalog, schema, tables, metadata, null);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Column> List<T> columns(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Column> List<T> columns(DataRuntime var1, int var2, boolean var3, Collection<? extends Table> var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Column> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5);

    public <T extends Column> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public ColumnMetadataAdapter columnMetadataAdapter(DataRuntime var1);

    default public ColumnMetadataAdapter columnMetadataAdapter(DataRuntime runtime, TypeMetadata meta) {
        int ignoreScale;
        int ignorePrecision;
        int ignoreLength;
        String columnMetadataScaleRefer;
        String columnMetadataPrecisionRefer;
        String columnMetadataLengthRefer;
        TypeMetadata.Config config;
        ColumnMetadataAdapter adapter = this.columnMetadataAdapter(runtime);
        if (null == adapter) {
            adapter = new ColumnMetadataAdapter();
        }
        if (null == (config = adapter.getTypeConfig())) {
            config = new TypeMetadata.Config();
        }
        if (null != (columnMetadataLengthRefer = this.columnMetadataLengthRefer(runtime, meta))) {
            config.setLengthRefer(columnMetadataLengthRefer);
        }
        if (null != (columnMetadataPrecisionRefer = this.columnMetadataPrecisionRefer(runtime, meta))) {
            config.setPrecisionRefer(columnMetadataPrecisionRefer);
        }
        if (null != (columnMetadataScaleRefer = this.columnMetadataScaleRefer(runtime, meta))) {
            config.setScaleRefer(columnMetadataScaleRefer);
        }
        if (-1 != (ignoreLength = this.ignoreLength(runtime, meta))) {
            config.setIgnoreLength(ignoreLength);
        }
        if (-1 != (ignorePrecision = this.ignorePrecision(runtime, meta))) {
            config.setIgnorePrecision(ignorePrecision);
        }
        if (-1 != (ignoreScale = this.ignoreScale(runtime, meta))) {
            config.setIgnoreScale(ignoreScale);
        }
        adapter.setTypeConfig(config);
        return adapter;
    }

    public String columnMetadataLengthRefer(DataRuntime var1, TypeMetadata var2);

    public String columnMetadataPrecisionRefer(DataRuntime var1, TypeMetadata var2);

    public String columnMetadataScaleRefer(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnoreLength(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnorePrecision(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnoreScale(DataRuntime var1, TypeMetadata var2);

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryTagsRun(DataRuntime var1, Table var2, boolean var3) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, String var5) throws Exception;

    public <T extends Tag> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5);

    public <T extends Tag> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public PrimaryKey primary(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryPrimaryRun(DataRuntime var1, Table var2) throws Exception;

    public <T extends PrimaryKey> T init(DataRuntime var1, int var2, T var3, Table var4, DataSet var5) throws Exception;

    public <T extends PrimaryKey> T detail(DataRuntime var1, int var2, T var3, Table var4, DataSet var5) throws Exception;

    public PrimaryMetadataAdapter primaryMetadataAdapter(DataRuntime var1);

    public PrimaryKey primary(DataRuntime var1, Table var2) throws Exception;

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryForeignsRun(DataRuntime var1, Table var2) throws Exception;

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, int var2, Table var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends ForeignKey> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5) throws Exception;

    public <T extends ForeignKey> T detail(DataRuntime var1, int var2, T var3, Table var4, DataRow var5) throws Exception;

    public <T extends Index> List<T> indexes(DataRuntime var1, String var2, boolean var3, Table var4, String var5);

    public <T extends Index> List<T> indexes(DataRuntime var1, String var2, boolean var3, Collection<? extends Table> var4);

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, String var2, Table var3, String var4);

    public List<Run> buildQueryIndexesRun(DataRuntime var1, Table var2, String var3);

    public List<Run> buildQueryIndexesRun(DataRuntime var1, Collection<? extends Table> var2);

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Index> List<T> indexes(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Index> List<T> indexes(DataRuntime var1, int var2, boolean var3, Collection<? extends Table> var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Index> List<T> indexes(DataRuntime var1, boolean var2, List<T> var3, Table var4, boolean var5, boolean var6) throws Exception;

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, boolean var5, boolean var6) throws Exception;

    public <T extends Index> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5) throws Exception;

    public <T extends Index> T detail(DataRuntime var1, int var2, T var3, Table var4, DataRow var5) throws Exception;

    public IndexMetadataAdapter indexMetadataAdapter(DataRuntime var1);

    public <T extends Constraint> List<T> constraints(DataRuntime var1, String var2, boolean var3, Table var4, String var5);

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, String var2, Table var3, Column var4, String var5);

    public List<Run> buildQueryConstraintsRun(DataRuntime var1, Table var2, Column var3, String var4);

    public <T extends Constraint> List<T> constraints(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, int var2, boolean var3, Table var4, Column var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public <T extends Constraint> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Constraint> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public ConstraintMetadataAdapter constraintMetadataAdapter(DataRuntime var1);

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, String var2, boolean var3, Table var4, List<Trigger.EVENT> var5);

    public List<Run> buildQueryTriggersRun(DataRuntime var1, Table var2, List<Trigger.EVENT> var3);

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Trigger> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Trigger> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public TriggerMetadataAdapter triggerMetadataAdapter(DataRuntime var1);

    public <T extends Procedure> List<T> procedures(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5);

    public List<Run> buildQueryProceduresRun(DataRuntime var1, Catalog var2, Schema var3, String var4);

    public <T extends Procedure> List<T> procedures(DataRuntime var1, int var2, boolean var3, List<T> var4, DataSet var5) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends Procedure> List<T> procedures(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Procedure var3);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Procedure var3, List<String> var4, DataSet var5);

    public <T extends Procedure> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Procedure> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public ProcedureMetadataAdapter procedureMetadataAdapter(DataRuntime var1);

    public <T extends Function> List<T> functions(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5);

    public List<Run> buildQueryFunctionsRun(DataRuntime var1, Catalog var2, Schema var3, String var4);

    public <T extends Function> List<T> functions(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, Schema var6, DataSet var7) throws Exception;

    public <T extends Function> List<T> functions(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Function var3);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, Function var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Function var3, List<String> var4, DataSet var5);

    public <T extends Function> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Function> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public FunctionMetadataAdapter functionMetadataAdapter(DataRuntime var1);

    public <T extends Sequence> List<T> sequences(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5);

    public List<Run> buildQuerySequencesRun(DataRuntime var1, Catalog var2, Schema var3, String var4);

    public <T extends Sequence> List<T> sequences(DataRuntime var1, int var2, boolean var3, List<T> var4, DataSet var5) throws Exception;

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends Sequence> List<T> sequences(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Sequence var3);

    public List<Run> buildQueryDdlsRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Sequence var3, List<String> var4, DataSet var5);

    public <T extends Sequence> T init(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public <T extends Sequence> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public SequenceMetadataAdapter sequenceMetadataAdapter(DataRuntime var1);

    default public boolean slice() {
        return false;
    }

    default public boolean slice(boolean slice) {
        return slice && this.slice();
    }

    public <T extends Metadata> T search(List<T> var1, Catalog var2, Schema var3, String var4);

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.DDL var4, Run var5);

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.DDL var4, List<Run> var5);

    public boolean create(DataRuntime var1, Table var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2) throws Exception;

    public boolean drop(DataRuntime var1, Table var2) throws Exception;

    public boolean rename(DataRuntime var1, Table var2, String var3) throws Exception;

    default public String keyword(Metadata meta) {
        return meta.getKeyword();
    }

    public List<Run> buildCreateRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2, Collection<Column> var3, boolean var4) throws Exception;

    default public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return this.buildAlterRun(runtime, meta, columns, false);
    }

    public List<Run> buildRenameRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAppendColumnCommentRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Table var2) throws Exception;

    default public List<Run> buildAddCommentRun(DataRuntime runtime, Table table) throws Exception {
        return this.buildChangeCommentRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public void checkPrimary(DataRuntime var1, Table var2);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder engine(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder body(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder columns(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder indexes(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder keys(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder distribution(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder materialize(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder partitionBy(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder partitionOf(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder partitionFor(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder inherit(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public boolean create(DataRuntime var1, View var2) throws Exception;

    public boolean alter(DataRuntime var1, View var2) throws Exception;

    public boolean drop(DataRuntime var1, View var2) throws Exception;

    public boolean rename(DataRuntime var1, View var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, View var2) throws Exception;

    public StringBuilder buildCreateRunHead(DataRuntime var1, StringBuilder var2, View var3) throws Exception;

    public StringBuilder buildCreateRunOption(DataRuntime var1, StringBuilder var2, View var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, View var2) throws Exception;

    public StringBuilder checkViewExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, View var3);

    public boolean create(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean alter(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean drop(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean rename(DataRuntime var1, MasterTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean create(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean alter(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean drop(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean rename(DataRuntime var1, PartitionTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean add(DataRuntime var1, Column var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Column var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Column meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Column var2) throws Exception;

    public boolean drop(DataRuntime var1, Column var2) throws Exception;

    public boolean rename(DataRuntime var1, Column var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    default public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeTypeRun(runtime, column, false);
    }

    public String alterColumnKeyword(DataRuntime var1);

    public StringBuilder addColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder dropColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildDropAutoIncrement(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public StringBuilder define(DataRuntime var1, StringBuilder var2, Column var3, ACTION.DDL var4);

    public StringBuilder checkColumnExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3);

    public int ignoreLength(DataRuntime var1, TypeMetadata var2);

    public int ignorePrecision(DataRuntime var1, TypeMetadata var2);

    public int ignoreScale(DataRuntime var1, TypeMetadata var2);

    public StringBuilder aggregation(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3, String var4, int var5, int var6, int var7);

    public StringBuilder nullable(DataRuntime var1, StringBuilder var2, Column var3, ACTION.DDL var4);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder defaultValue(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder unique(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder increment(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder onupdate(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder position(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Column var3);

    public boolean add(DataRuntime var1, Tag var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Tag var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Tag meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Tag var2) throws Exception;

    public boolean drop(DataRuntime var1, Tag var2) throws Exception;

    public boolean rename(DataRuntime var1, Tag var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public StringBuilder checkTagExists(DataRuntime var1, StringBuilder var2, boolean var3);

    default public SQL_BUILD_IN_VALUE checkDefaultBuildInValue(DataRuntime runtime, Object def) {
        String chk;
        SQL_BUILD_IN_VALUE result = null;
        if (null != def && ("CURRENT_TIMESTAMP".equals(chk = def.toString().toUpperCase().trim()) || "CURRENT TIMESTAMP".equals(chk) || "SYSDATE".equals(chk) || "NOW()".equals(chk) || "NOW".equals(chk) || "SYSTIMESTAMP".equals(chk) || "GETDATE()".equals(chk) || chk.contains("DATETIME("))) {
            result = SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
        }
        return result;
    }

    public boolean add(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, PrimaryKey var3, PrimaryKey var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return this.alter(runtime, table, table.getPrimaryKey(), meta);
    }

    public boolean drop(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean rename(DataRuntime var1, PrimaryKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, PrimaryKey var2, boolean var3) throws Exception;

    default public List<Run> buildAppendPrimaryRun(DataRuntime runtime, Table meta) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildAlterRun(DataRuntime var1, PrimaryKey var2, PrimaryKey var3, boolean var4) throws Exception;

    default public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return this.buildAlterRun(runtime, origin, meta, false);
    }

    default public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return this.buildAlterRun(runtime, null, meta);
    }

    public List<Run> buildDropRun(DataRuntime var1, PrimaryKey var2, boolean var3) throws Exception;

    default public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return this.buildDropRun(runtime, primary, false);
    }

    public List<Run> buildRenameRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean add(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, ForeignKey var3) throws Exception;

    public boolean drop(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean rename(DataRuntime var1, ForeignKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean add(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Index var3) throws Exception;

    public boolean drop(DataRuntime var1, Index var2) throws Exception;

    public boolean rename(DataRuntime var1, Index var2, String var3) throws Exception;

    public List<Run> buildAppendIndexRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Index var2) throws Exception;

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder checkIndexExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public boolean add(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Constraint var3) throws Exception;

    public boolean drop(DataRuntime var1, Constraint var2) throws Exception;

    public boolean rename(DataRuntime var1, Constraint var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Constraint var2) throws Exception;

    public boolean add(DataRuntime var1, Trigger var2) throws Exception;

    public boolean alter(DataRuntime var1, Trigger var2) throws Exception;

    public boolean drop(DataRuntime var1, Trigger var2) throws Exception;

    public boolean rename(DataRuntime var1, Trigger var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Trigger var2) throws Exception;

    public StringBuilder each(DataRuntime var1, StringBuilder var2, Trigger var3);

    public boolean create(DataRuntime var1, Procedure var2) throws Exception;

    public boolean alter(DataRuntime var1, Procedure var2) throws Exception;

    public boolean drop(DataRuntime var1, Procedure var2) throws Exception;

    public boolean rename(DataRuntime var1, Procedure var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Procedure var2) throws Exception;

    public StringBuilder parameter(DataRuntime var1, StringBuilder var2, Parameter var3);

    public boolean create(DataRuntime var1, Function var2) throws Exception;

    public boolean alter(DataRuntime var1, Function var2) throws Exception;

    public boolean drop(DataRuntime var1, Function var2) throws Exception;

    public boolean rename(DataRuntime var1, Function var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Function var2) throws Exception;

    public boolean create(DataRuntime var1, Sequence var2) throws Exception;

    public boolean alter(DataRuntime var1, Sequence var2) throws Exception;

    public boolean drop(DataRuntime var1, Sequence var2) throws Exception;

    public boolean rename(DataRuntime var1, Sequence var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Sequence var2) throws Exception;

    public StringBuilder name(DataRuntime var1, StringBuilder var2, Metadata var3);

    public StringBuilder name(DataRuntime var1, StringBuilder var2, Column var3);

    public boolean convert(DataRuntime var1, Catalog var2, Schema var3, String var4, RunValue var5);

    public boolean convert(DataRuntime var1, Table var2, Run var3);

    public boolean convert(DataRuntime var1, ConfigStore var2, Run var3);

    default public boolean convert(DataRuntime runtime, ConfigStore configs, List<Run> runs) {
        for (Run run : runs) {
            this.convert(runtime, configs, run);
        }
        return true;
    }

    public boolean convert(DataRuntime var1, Map<String, Column> var2, RunValue var3);

    public boolean convert(DataRuntime var1, Column var2, RunValue var3);

    public Object convert(DataRuntime var1, Column var2, Object var3);

    public Object convert(DataRuntime var1, TypeMetadata var2, Object var3);

    public void value(DataRuntime var1, StringBuilder var2, Object var3, String var4);

    public Object read(DataRuntime var1, Column var2, Object var3, Class var4);

    public Object write(DataRuntime var1, Column var2, Object var3, boolean var4);

    public String concat(DataRuntime var1, String ... var2);

    public boolean isNumberColumn(DataRuntime var1, Column var2);

    public boolean isBooleanColumn(DataRuntime var1, Column var2);

    public boolean isCharColumn(DataRuntime var1, Column var2);

    public String value(DataRuntime var1, Column var2, SQL_BUILD_IN_VALUE var3);

    default public String defaultValue(DataRuntime runtime, Column column, SQL_BUILD_IN_VALUE value) {
        return this.value(runtime, column, value);
    }

    public void addRunValue(DataRuntime var1, Run var2, Compare var3, Column var4, Object var5);

    public String objectName(DataRuntime var1, String var2);

    default public String compressCondition(DataRuntime runtime, String cmd) {
        String head = this.conditionHead();
        cmd = cmd.replaceAll(head + "\\s*1=1\\s*AND", head);
        return cmd;
    }

    default public String conditionHead() {
        return "WHERE";
    }

    default public void formula(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Column metadata, Object value, boolean placeholder) {
        if (!placeholder) {
            value = this.write(runtime, metadata, value, placeholder);
        }
        builder.append(compare.formula(column, value, placeholder));
    }

    public static enum SQL_BUILD_IN_VALUE {
        CURRENT_DATETIME("CURRENT_DATETIME", "\u5f53\u524d\u65e5\u671f\u65f6\u95f4"),
        CURRENT_DATE("CURRENT_DATE", "\u5f53\u524d\u65e5\u671f"),
        CURRENT_TIME("CURRENT_TIME", "\u5f53\u524d\u65f6\u95f4"),
        CURRENT_TIMESTAMP("CURRENT_TIMESTAMP", "\u5f53\u524d\u65f6\u95f4\u6233");

        private final String code;
        private final String name;

        private SQL_BUILD_IN_VALUE(String code, String name) {
            this.code = code;
            this.name = name;
        }

        String getCode() {
            return this.code;
        }

        String getName() {
            return this.name;
        }
    }
}

