/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceUtil {
    public static Logger log = LoggerFactory.getLogger(DataSourceUtil.class);
    public static final String POOL_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";

    public static DataSource build(Map params) {
        try {
            String type = (String)params.get("pool");
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)params.get("type");
            }
            if (type == null) {
                throw new Exception("\u672a\u8bbe\u7f6e\u6570\u636e\u6e90\u7c7b\u578b(\u5982:pool=com.zaxxer.hikari.HikariDataSource)");
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"driver", "driver-class", "driver-class-name"});
            Object url = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"url", "jdbc-url"});
            Object user = BeanUtil.propertyNvl((Map)params, (String[])new String[]{"user", "username"});
            DataSource datasource = (DataSource)poolClass.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(params);
            map.put("url", url);
            map.put("jdbcUrl", url);
            map.put("driver", driver);
            map.put("driverClass", driver);
            map.put("driverClassName", driver);
            map.put("user", user);
            map.put("username", user);
            BeanUtil.setFieldsValue((Object)datasource, map, (boolean)false);
            return datasource;
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][\u6570\u636e\u6e90:{}][msg:{}]", (Object)e.toString());
            return null;
        }
    }

    public static DataSource build(String pool, String driver, String url, String user, String password) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", pool);
        param.put("driverClassName", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return DataSourceUtil.build(param);
    }

    public static DataSource build(DatabaseType type, String url, String user, String password) {
        return DataSourceUtil.build(POOL_TYPE_DEFAULT, type.driver(), url, user, password);
    }
}

