/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.handler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.handler.ConnectionHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.entity.DataRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResultSetHandler
implements ResultSetHandler {
    private static Logger log = LoggerFactory.getLogger(SimpleResultSetHandler.class);
    private ConnectionHandler handler;
    private ResultSet result;
    private List<String> keys;
    private int size;
    private int vol;

    public SimpleResultSetHandler() {
    }

    public SimpleResultSetHandler(int size) {
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public void handler(ConnectionHandler handler) {
        this.handler = handler;
    }

    public boolean keep() {
        return true;
    }

    public boolean read(ResultSet result) {
        this.result = result;
        try {
            this.keys = new ArrayList<String>();
            ResultSetMetaData rsmd = result.getMetaData();
            this.vol = rsmd.getColumnCount();
            for (int i = 1; i <= this.vol; ++i) {
                this.keys.add(rsmd.getColumnLabel(i));
            }
        }
        catch (Exception e) {
            log.error("Read ResultSet \u5f02\u5e38:", (Throwable)e);
        }
        return true;
    }

    public LinkedHashMap<String, Object> map() throws Exception {
        LinkedHashMap<String, Object> map = null;
        if (null != this.result && !this.result.isClosed()) {
            if (this.result.next()) {
                map = new LinkedHashMap<String, Object>();
                for (int i = 1; i <= this.vol; ++i) {
                    map.put(this.keys.get(i - 1), this.result.getObject(i));
                }
            } else {
                this.handler.close();
            }
        }
        return map;
    }

    public DataRow row() throws Exception {
        LinkedHashMap<String, Object> map = this.map();
        if (null != map) {
            return new DataRow(map);
        }
        return null;
    }

    public ResultSet result() {
        return this.result;
    }

    public void close() throws Exception {
        this.handler.close();
        this.result = null;
    }
}

