/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.regular;

import java.util.ArrayList;
import java.util.List;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.Regular;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegularMatchPrefix
implements Regular {
    private static final Logger log = LoggerFactory.getLogger(RegularMatchPrefix.class);
    private static PatternCompiler patternCompiler = new Perl5Compiler();

    @Override
    public boolean match(String src, String regx) {
        boolean result = false;
        try {
            Pattern pattern = patternCompiler.compile(regx, 0);
            Perl5Matcher matcher = new Perl5Matcher();
            result = matcher.matchesPrefix(src, pattern);
        }
        catch (Exception e) {
            result = false;
            log.error("[match error][src:{}][regx:{}]", (Object)src, (Object)regx);
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<List<String>> fetchs(String src, String regx) {
        ArrayList<List<String>> list;
        block4: {
            list = new ArrayList<List<String>>();
            try {
                Pattern pattern = patternCompiler.compile(regx, 1);
                Perl5Matcher matcher = new Perl5Matcher();
                PatternMatcherInput input = new PatternMatcherInput(src);
                while (matcher.matchesPrefix(input, pattern)) {
                    MatchResult matchResult = matcher.getMatch();
                    int groups = matchResult.groups();
                    ArrayList<String> item = new ArrayList<String>();
                    for (int i = 0; i <= groups; ++i) {
                        item.add(matchResult.group(i));
                    }
                    list.add(item);
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_DEBUG || !log.isWarnEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public List<String> fetch(String src, String regx, int idx) {
        ArrayList<String> list;
        block3: {
            list = new ArrayList<String>();
            try {
                Pattern pattern = patternCompiler.compile(regx, 1);
                Perl5Matcher matcher = new Perl5Matcher();
                PatternMatcherInput input = new PatternMatcherInput(src);
                while (matcher.matchesPrefix(input, pattern)) {
                    MatchResult matchResult = matcher.getMatch();
                    list.add(matchResult.group(idx));
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_DEBUG || !log.isWarnEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public List<String> fetch(String src, String regx) throws Exception {
        return this.fetch(src, regx, 0);
    }

    @Override
    public List<String> pick(List<String> src, String regx) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : src) {
            if (!this.match(item, regx)) continue;
            list.add(item);
        }
        return list;
    }

    @Override
    public List<String> wipe(List<String> src, String regx) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : src) {
            if (this.match(item, regx)) continue;
            list.add(item);
        }
        return list;
    }
}

