/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.adapter.MetadataAdapterHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.JavaType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;

public class Column
extends Metadata<Column>
implements Serializable {
    public static LinkedHashMap<TypeMetadata.CATEGORY, TypeMetadata.Config> typeCategoryConfigs = new LinkedHashMap();
    protected String keyword = "COLUMN";
    protected String originName;
    protected String typeName;
    protected String originType;
    protected TypeMetadata typeMetadata;
    protected String fullType;
    protected String finalType;
    protected int ignoreLength = -1;
    protected int ignorePrecision = -1;
    protected int ignoreScale = -1;
    protected Integer precisionLength;
    protected Integer length;
    protected Integer precision;
    protected Integer scale;
    protected String className;
    protected Integer displaySize;
    protected Integer type;
    protected String childTypeName;
    protected TypeMetadata childTypeMetadata;
    protected JavaType javaType;
    protected String jdbcType;
    protected String dateScale;
    protected int nullable = -1;
    protected int caseSensitive = -1;
    protected int currency = -1;
    protected int signed = -1;
    protected int autoIncrement = -1;
    protected Integer incrementSeed = 1;
    protected Integer incrementStep = 1;
    protected int primary = -1;
    protected String primaryType;
    protected int unique = -1;
    protected int generated = -1;
    protected Object defaultValue;
    protected String defaultConstraint;
    protected String charset;
    protected String collate;
    protected Aggregation aggregation;
    protected int withTimeZone = -1;
    protected int withLocalTimeZone = -1;
    protected Column reference;
    protected Integer srid;
    protected boolean array;
    protected boolean isKey;
    protected Integer position;
    protected String order;
    protected String after;
    protected String before;
    protected int onUpdate = -1;
    protected Object value;
    protected boolean defaultCurrentDateTime = false;
    protected Boolean index;
    protected Boolean store;
    protected String analyzer;
    protected String searchAnalyzer;
    protected Integer ignoreAbove;
    private String coerce;
    private String copyTo;
    private String docValues;
    private String dynamic;
    private String eagerGlobalOrdinals;
    private String enabled;
    private String format;
    private String ignoreMalformed;
    private String indexOptions;
    private String indexPhrases;
    private String indexPrefixes;
    private String meta;
    private String fields;
    private String normalizer;
    private String norms;
    private String nullValue;
    private String positionIncrementGap;
    private LinkedHashMap<String, Property> properties = new LinkedHashMap();
    private String similarity;
    private String subObjects;
    private String termVector;
    protected int parseLvl = 0;

    public static <T extends Column> void sort(Map<String, T> columns) {
        Column.sort(columns, false);
    }

    public static <T extends Column> void sort(Map<String, T> columns, boolean nullFirst) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(columns.values());
        Column.sort(list, nullFirst);
        columns.clear();
        for (Column column : list) {
            columns.put(column.getName().toUpperCase(), column);
        }
    }

    public static <T extends Column> void sort(List<T> columns) {
        Column.sort(columns, false);
    }

    public static <T extends Column> void sort(List<T> columns, final boolean nullFirst) {
        Collections.sort(columns, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Integer p2;
                Integer p1 = ((Column)o1).getPosition();
                if (p1 == (p2 = ((Column)o2).getPosition())) {
                    return 0;
                }
                if (nullFirst) {
                    if (null == p1) {
                        return -1;
                    }
                    if (null == p2) {
                        return 1;
                    }
                } else {
                    if (null == p1) {
                        return 1;
                    }
                    if (null == p2) {
                        return -1;
                    }
                }
                return p1 > p2 ? 1 : -1;
            }
        });
    }

    public Column() {
    }

    public Column(Table table, String name, String type) {
        this.setTable(table);
        this.setName(name);
        this.setType(type);
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(Schema schema, String table, String name) {
        this(null, schema, table, name);
    }

    public Column(Catalog catalog, Schema schema, String table, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setName(name);
        this.setTable(table);
    }

    public Column(String name, String type, int precision, int scale) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(String name, String type, int precision) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(Table table, String name, String type, int precision, int scale) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(Table table, String name, String type, int precision) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(String name, String type) {
        this.name = name;
        this.setType(type);
    }

    public Boolean getIndex() {
        return this.index;
    }

    public Column setIndex(Boolean index) {
        this.index = index;
        return this;
    }

    public Boolean getStore() {
        return this.store;
    }

    public Column setStore(Boolean store) {
        this.store = store;
        return this;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public Column setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Column setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
        return this;
    }

    public Integer getIgnoreAbove() {
        return this.ignoreAbove;
    }

    public Column setIgnoreAbove(Integer ignoreAbove) {
        this.ignoreAbove = ignoreAbove;
        return this;
    }

    public String getCoerce() {
        return this.coerce;
    }

    public Column setCoerce(String coerce) {
        this.coerce = coerce;
        return this;
    }

    public String getCopyTo() {
        return this.copyTo;
    }

    public Column setCopyTo(String copyTo) {
        this.copyTo = copyTo;
        return this;
    }

    public String getDocValues() {
        return this.docValues;
    }

    public Column setDocValues(String docValues) {
        this.docValues = docValues;
        return this;
    }

    public String getDynamic() {
        return this.dynamic;
    }

    public Column setDynamic(String dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public String getEagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public Column setEagerGlobalOrdinals(String eagerGlobalOrdinals) {
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
        return this;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public Column setEnabled(String enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public Column setIgnoreMalformed(String ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    public String getIndexOptions() {
        return this.indexOptions;
    }

    public Column setIndexOptions(String indexOptions) {
        this.indexOptions = indexOptions;
        return this;
    }

    public String getIndexPhrases() {
        return this.indexPhrases;
    }

    public Column setIndexPhrases(String indexPhrases) {
        this.indexPhrases = indexPhrases;
        return this;
    }

    public String getIndexPrefixes() {
        return this.indexPrefixes;
    }

    public Column setIndexPrefixes(String indexPrefixes) {
        this.indexPrefixes = indexPrefixes;
        return this;
    }

    public String getMeta() {
        return this.meta;
    }

    public Column setMeta(String meta) {
        this.meta = meta;
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public Column setFields(String fields) {
        this.fields = fields;
        return this;
    }

    public String getNormalizer() {
        return this.normalizer;
    }

    public Column setNormalizer(String normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    public String getNorms() {
        return this.norms;
    }

    public Column setNorms(String norms) {
        this.norms = norms;
        return this;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Column setNullValue(String nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public String getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    public Column setPositionIncrementGap(String positionIncrementGap) {
        this.positionIncrementGap = positionIncrementGap;
        return this;
    }

    public String getSimilarity() {
        return this.similarity;
    }

    public Column setSimilarity(String similarity) {
        this.similarity = similarity;
        return this;
    }

    public String getSubObjects() {
        return this.subObjects;
    }

    public Column setSubObjects(String subObjects) {
        this.subObjects = subObjects;
        return this;
    }

    public String getTermVector() {
        return this.termVector;
    }

    public Column setTermVector(String termVector) {
        this.termVector = termVector;
        return this;
    }

    public Column addProperty(String name, String type) {
        this.properties.put(name, new Property(type));
        return this;
    }

    public LinkedHashMap<String, Property> getProperties() {
        return this.properties;
    }

    public void setProperties(LinkedHashMap<String, Property> properties) {
        this.properties = properties;
    }

    @Override
    public Column drop() {
        this.action = ACTION.DDL.COLUMN_DROP;
        return (Column)super.drop();
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public boolean isArray() {
        return this.array;
    }

    public Column setArray(boolean array) {
        this.array = array;
        return this;
    }

    public String getDateScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDateScale();
        }
        return this.dateScale;
    }

    public int getWithTimeZone() {
        return this.withTimeZone;
    }

    public void setWithTimeZone(int withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    public int getWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    public void setWithLocalTimeZone(int withLocalTimeZone) {
        this.withLocalTimeZone = withLocalTimeZone;
    }

    public Column setDateScale(String dateScale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDateScale(dateScale);
            return this;
        }
        this.dateScale = dateScale;
        return this;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean key) {
        this.isKey = key;
    }

    public String getClassName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getClassName();
        }
        return this.className;
    }

    public Column setClassName(String className) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setClassName(className);
            return this;
        }
        this.className = className;
        return this;
    }

    public String getChildTypeName() {
        if (this.getmap && null != this.childTypeName) {
            return ((Column)this.update).getChildTypeName();
        }
        return this.childTypeName;
    }

    public Column setChildTypeName(String childTypeName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildTypeName(childTypeName);
            return this;
        }
        this.childTypeName = childTypeName;
        return this;
    }

    public TypeMetadata getChildTypeMetadata() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).childTypeMetadata;
        }
        if (this.array && null != this.childTypeMetadata) {
            this.childTypeMetadata.setArray(this.array);
        }
        return this.childTypeMetadata;
    }

    public Column setChildTypeMetadata(TypeMetadata childTypeMetadata) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildTypeMetadata(childTypeMetadata);
            return this;
        }
        this.childTypeMetadata = childTypeMetadata;
        return this;
    }

    public Integer getDisplaySize() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDisplaySize();
        }
        return this.displaySize;
    }

    public Column setDisplaySize(Integer displaySize) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDisplaySize(displaySize);
            return this;
        }
        this.displaySize = displaySize;
        return this;
    }

    public String getOriginType() {
        if (null == this.originType) {
            return this.typeName;
        }
        return this.originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public Integer getType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getType();
        }
        return this.type;
    }

    public Column setType(Integer type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        if (this.type != type) {
            this.className = null;
        }
        this.type = type;
        return this;
    }

    public Column setType(String type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        return this.setTypeName(type);
    }

    public String getTypeName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getTypeName();
        }
        if (null == this.typeName && null != this.typeMetadata && this.typeMetadata != TypeMetadata.ILLEGAL && this.typeMetadata != TypeMetadata.NONE) {
            this.typeName = this.typeMetadata.getName();
        }
        return this.typeName;
    }

    public String getJdbcType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).jdbcType;
        }
        return this.jdbcType;
    }

    public Column setJdbcType(String jdbcType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJdbcType(jdbcType);
            return this;
        }
        this.jdbcType = jdbcType;
        return this;
    }

    public Column setTypeName(String typeName) {
        return this.setTypeName(typeName, true);
    }

    public Column setTypeName(String typeName, boolean parse) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setTypeName(typeName, parse);
            return this;
        }
        if (null == this.typeName || !this.typeName.equalsIgnoreCase(typeName)) {
            this.parseLvl = 0;
        }
        this.typeName = typeName;
        if (parse) {
            this.setOriginType(typeName);
            this.parseType(1);
        }
        return this;
    }

    public Column parseType(int lvl) {
        if (lvl <= this.parseLvl) {
            return this;
        }
        TypeMetadata.parse(DatabaseType.NONE, this, null, null);
        return this;
    }

    public int getParseLvl() {
        return this.parseLvl;
    }

    public void setParseLvl(int parseLvl) {
        this.parseLvl = parseLvl;
    }

    public Column setFullType(String fullType) {
        this.fullType = fullType;
        return this;
    }

    public String getFullType() {
        return this.getFullType(this.database);
    }

    public String getFullType(DatabaseType database) {
        return this.getFullType(database, null);
    }

    public String getFullType(DatabaseType database, TypeMetadata.Config config) {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getFullType(database);
        }
        if (null != this.fullType && this.database == database) {
            return this.fullType;
        }
        int ignoreLength = -1;
        int ignorePrecision = -1;
        int ignoreScale = -1;
        String result = null;
        String type = null;
        String formula = null;
        if (null != config) {
            ignoreLength = config.ignoreLength();
            ignorePrecision = config.ignorePrecision();
            ignoreScale = config.ignoreScale();
            formula = config.getFormula();
        } else {
            ignoreLength = this.ignoreLength(database);
            ignorePrecision = this.ignorePrecision(database);
            ignoreScale = this.ignoreScale(database);
            formula = this.formula(database);
        }
        type = null != this.typeMetadata && this.typeMetadata != TypeMetadata.NONE && this.typeMetadata != TypeMetadata.ILLEGAL && database == this.database ? this.typeMetadata.getName() : this.getTypeName();
        boolean appendLength = false;
        boolean appendPrecision = false;
        boolean appendScale = false;
        if (ignoreLength != 1) {
            if (null == this.length && null != this.precision && this.precision != -1) {
                this.length = this.precision;
            }
            if (null != this.length && (this.length > 0 || this.length == -2)) {
                appendLength = true;
            }
        }
        if (ignorePrecision != 1) {
            if (null == this.precision && null != this.length && this.length != -1) {
                this.precision = this.length;
            }
            if (null != this.precision && this.precision > 0) {
                appendPrecision = ignorePrecision == 3 ? null != this.scale && this.scale > 0 : true;
            }
        }
        if (ignoreScale != 1 && null != this.scale && this.scale > 0) {
            appendScale = ignoreScale == 3 ? null != this.precision && this.precision > 0 : true;
        }
        if (BasicUtil.isNotEmpty(formula)) {
            result = formula;
            result = result.replace("{L}", "" + this.length);
            result = result.replace("{P}", "" + this.precision);
            result = result.replace("{S}", "" + this.scale);
            result = result.replace("(null)", "");
        } else if (null != type) {
            StringBuilder builder = new StringBuilder();
            if (type.contains("{")) {
                result = type;
                result = result.replace("{L}", "" + this.length);
                result = result.replace("{P}", "" + this.precision);
                result = result.replace("{S}", "" + this.scale);
                result = result.replace("(null)", "");
            } else {
                builder.append(type);
                if (appendLength || appendPrecision || appendScale) {
                    builder.append("(");
                }
                if (appendLength) {
                    if (this.length == -2) {
                        builder.append("max");
                    } else {
                        builder.append(this.length);
                    }
                } else {
                    if (appendPrecision) {
                        builder.append(this.precision);
                    }
                    if (appendScale) {
                        if (appendPrecision) {
                            builder.append(",");
                        }
                        builder.append(this.scale);
                    }
                }
                if (appendLength || appendPrecision || appendScale) {
                    builder.append(")");
                }
                String child = this.getChildTypeName();
                Integer srid = this.getSrid();
                if (null != child) {
                    builder.append("(");
                    builder.append(child);
                    if (null != srid) {
                        builder.append(",").append(srid);
                    }
                    builder.append(")");
                }
                if (this.isArray()) {
                    builder.append("[]");
                }
                result = builder.toString();
            }
        }
        return result;
    }

    public Integer getPrecisionLength() {
        if (null != this.precisionLength && this.precisionLength != -1) {
            return this.precisionLength;
        }
        this.precisionLength = null != this.precision && this.precision != -1 ? this.precision : this.length;
        return this.precisionLength;
    }

    public Integer getLength() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getLength();
        }
        if (null != this.length && this.length != -1) {
            return this.length;
        }
        return this.precision;
    }

    public Column setLength(Integer length) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setLength(length);
            return this;
        }
        if (this.ignoreLength == 1) {
            this.precision = length;
        } else {
            this.length = length;
        }
        return this;
    }

    public Integer getPrecision() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getPrecision();
        }
        if (null != this.precision && this.precision != -1) {
            return this.precision;
        }
        return this.length;
    }

    public Column setPrecision(Integer precision) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision);
            return this;
        }
        if (this.ignorePrecision == 1) {
            this.length = precision;
        } else {
            this.precision = precision;
        }
        return this;
    }

    public Column setPrecision(Integer precision, Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision, scale);
            return this;
        }
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public Object getValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).value;
        }
        return this.value;
    }

    public Column setValue(Object value) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setValue(value);
            return this;
        }
        this.value = value;
        return this;
    }

    public int isCaseSensitive() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).caseSensitive;
        }
        return this.caseSensitive;
    }

    public Column setCaseSensitive(int caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCaseSensitive(caseSensitive);
            return this;
        }
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Column caseSensitive(int caseSensitive) {
        return this.setCaseSensitive(caseSensitive);
    }

    public Column caseSensitive(Boolean caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).caseSensitive(caseSensitive);
            return this;
        }
        if (null != caseSensitive) {
            this.caseSensitive = caseSensitive != false ? 1 : 0;
        }
        return this;
    }

    public int isCurrency() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).currency;
        }
        return this.currency;
    }

    public Column setCurrency(int currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCurrency(currency);
            return this;
        }
        this.currency = currency;
        return this;
    }

    public Column currency(int currency) {
        return this.setCurrency(currency);
    }

    public Column setCurrency(Boolean currency) {
        return this.currency(currency);
    }

    public Column currency(Boolean currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).currency(currency);
            return this;
        }
        if (null != currency) {
            this.currency = currency != false ? 1 : 0;
        }
        return this;
    }

    public int isSigned() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).signed;
        }
        return this.signed;
    }

    public Column setSigned(int signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        this.signed = signed;
        return this;
    }

    public Column signed(int signed) {
        return this.setSigned(signed);
    }

    public Column setSigned(Boolean signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        if (null != signed) {
            this.signed = signed != false ? 1 : 0;
        }
        return this;
    }

    public Aggregation getAggregation() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).aggregation;
        }
        return this.aggregation;
    }

    public Column setAggregation(Aggregation aggregation) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAggregation(aggregation);
            return this;
        }
        this.aggregation = aggregation;
        return this;
    }

    public Integer getScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getScale();
        }
        return this.scale;
    }

    public Column setScale(Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setScale(scale);
            return this;
        }
        this.scale = scale;
        return this;
    }

    public int isNullable() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).nullable;
        }
        return this.nullable;
    }

    public Column setNullable(int nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setNullable(nullable);
            return this;
        }
        this.nullable = nullable;
        return this;
    }

    public Column nullable(int nullable) {
        return this.setNullable(nullable);
    }

    public Column setNullable(Boolean nullable) {
        return this.nullable(nullable);
    }

    public Column nullable(Boolean nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).nullable(nullable);
            return this;
        }
        if (null != nullable) {
            this.nullable = nullable != false ? 1 : 0;
        }
        return this;
    }

    public int isAutoIncrement() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).autoIncrement;
        }
        return this.autoIncrement;
    }

    public Column setAutoIncrement(int autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(autoIncrement);
            return this;
        }
        this.autoIncrement = autoIncrement;
        if (autoIncrement == 1) {
            this.nullable(false);
        }
        return this;
    }

    public Column autoIncrement(int autoIncrement) {
        return this.setAutoIncrement(autoIncrement);
    }

    public Column setAutoIncrement(Boolean autoIncrement) {
        return this.autoIncrement(autoIncrement);
    }

    public Column autoIncrement(Boolean autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).autoIncrement(autoIncrement);
            return this;
        }
        if (null != autoIncrement) {
            if (autoIncrement.booleanValue()) {
                this.autoIncrement = 1;
                this.nullable(false);
            } else {
                this.autoIncrement = 0;
            }
        }
        return this;
    }

    public Column setAutoIncrement(int seed, int step) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(seed, step);
            return this;
        }
        this.setAutoIncrement(1);
        this.incrementSeed = seed;
        this.incrementStep = step;
        return this;
    }

    public int isUnique() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).unique;
        }
        return this.unique;
    }

    public Column setUnique(int unique) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setUnique(unique);
            return this;
        }
        this.unique = unique;
        return this;
    }

    public Column unique(int unique) {
        return this.setUnique(unique);
    }

    public Column setUnique(Boolean unique) {
        return this.unique(unique);
    }

    public Column unique(Boolean unique) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).unique(unique);
            return this;
        }
        if (null != unique) {
            this.unique = unique != false ? 1 : 0;
        }
        return this;
    }

    public int isPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).primary;
        }
        return this.primary;
    }

    public Column setPrimary(int primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrimary(primary);
            return this;
        }
        this.primary = primary;
        return this;
    }

    public Column primary(int primary) {
        return this.setPrimary(primary);
    }

    public Column setPrimary(Boolean primary) {
        return this.primary(primary);
    }

    public Column setPrimaryKey(Boolean primary) {
        return this.primary(primary);
    }

    public Column primary(Boolean primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).primary(primary);
            return this;
        }
        if (null != primary) {
            if (primary.booleanValue()) {
                this.primary = 1;
                this.nullable(false);
            } else {
                this.primary = 0;
            }
        }
        return this;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
    }

    public Column setPrimary(int primary, String type) {
        this.setPrimary(primary);
        this.primaryType = type;
        return this;
    }

    public Column primary(int primary, String type) {
        this.primary(primary);
        this.primaryType = type;
        return this;
    }

    public Column setPrimary(Boolean primary, String type) {
        this.setPrimary(primary);
        this.primaryType = type;
        return this;
    }

    public Column setPrimaryKey(Boolean primary, String type) {
        this.setPrimaryKey(primary);
        this.primaryType = type;
        return this;
    }

    public Column primary(Boolean primary, String type) {
        this.primary(primary);
        this.primaryType = type;
        return this;
    }

    public int isGenerated() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).generated;
        }
        return this.generated;
    }

    public Column setGenerated(int generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setGenerated(generated);
            return this;
        }
        this.generated = generated;
        return this;
    }

    public Column generated(int generated) {
        return this.setGenerated(generated);
    }

    public Column setGenerated(Boolean generated) {
        return this.generated(generated);
    }

    public Column generated(Boolean generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).generated(generated);
            return this;
        }
        if (null != generated) {
            this.generated = generated != false ? 1 : 0;
        }
        return this;
    }

    public Object getDefaultValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).defaultValue;
        }
        return this.defaultValue;
    }

    public Column setDefaultValue(Object defaultValue) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultValue(defaultValue);
            return this;
        }
        this.defaultValue = defaultValue;
        return this;
    }

    public Column setDefaultCurrentDateTime(boolean currentDateTime) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultCurrentDateTime(currentDateTime);
            return this;
        }
        this.defaultCurrentDateTime = currentDateTime;
        return this;
    }

    public Column setDefaultCurrentDateTime() {
        return this.setDefaultCurrentDateTime(true);
    }

    public boolean isDefaultCurrentDateTime() {
        return this.defaultCurrentDateTime;
    }

    public String getDefaultConstraint() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).defaultConstraint;
        }
        return this.defaultConstraint;
    }

    public Column setDefaultConstraint(String defaultConstraint) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultConstraint(defaultConstraint);
            return this;
        }
        this.defaultConstraint = defaultConstraint;
        return this;
    }

    public Integer getPosition() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).position;
        }
        return this.position;
    }

    public String getOrder() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).order;
        }
        return this.order;
    }

    public Column setOrder(String order) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOrder(order);
            return this;
        }
        this.order = order;
        return this;
    }

    public Column setPosition(Integer position) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPosition(position);
            return this;
        }
        this.position = position;
        return this;
    }

    public String getAfter() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).after;
        }
        return this.after;
    }

    public Integer getIncrementSeed() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementSeed;
        }
        return this.incrementSeed;
    }

    public Column setIncrementSeed(Integer incrementSeed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementSeed(incrementSeed);
            return this;
        }
        this.incrementSeed = incrementSeed;
        return this;
    }

    public Integer getIncrementStep() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementStep;
        }
        return this.incrementStep;
    }

    public Column setIncrementStep(Integer incrementStep) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementStep(incrementStep);
            return this;
        }
        this.incrementStep = incrementStep;
        return this;
    }

    public int isOnUpdate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).onUpdate;
        }
        return this.onUpdate;
    }

    public Column setOnUpdate(int onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public Column onUpdate(int onUpdate) {
        return this.setOnUpdate(onUpdate);
    }

    public Column setOnUpdate(boolean onUpdate) {
        return this.onUpdate(onUpdate);
    }

    public Column onUpdate(boolean onUpdate) {
        this.onUpdate = onUpdate ? 1 : -1;
        return this;
    }

    public Column setAfter(String after) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAfter(after);
            return this;
        }
        this.after = after;
        return this;
    }

    public String getOriginName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).originName;
        }
        return this.originName;
    }

    public Column setOriginName(String originName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOriginName(originName);
            return this;
        }
        this.originName = originName;
        return this;
    }

    public String getBefore() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).before;
        }
        return this.before;
    }

    public String getCharset() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).charset;
        }
        return this.charset;
    }

    public Column setCharset(String charset) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCharset(charset);
            return this;
        }
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).collate;
        }
        return this.collate;
    }

    public Column setCollate(String collate) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCollate(collate);
            return this;
        }
        this.collate = collate;
        return this;
    }

    public Column setBefore(String before) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setBefore(before);
            return this;
        }
        this.before = before;
        return this;
    }

    public boolean equals(Column column) {
        return this.equals(column, true);
    }

    public boolean equals(Column column, boolean ignoreCase) {
        if (null == column) {
            return false;
        }
        if (!BasicUtil.equals((Object)this.name, (Object)column.getName(), ignoreCase)) {
            return false;
        }
        TypeMetadata columnTypeMetadata = column.getTypeMetadata();
        TypeMetadata origin = null;
        TypeMetadata columnOrigin = null;
        if (null != this.typeMetadata) {
            origin = this.typeMetadata.getOrigin();
        }
        if (null != columnTypeMetadata) {
            columnOrigin = columnTypeMetadata.getOrigin();
        }
        if (!(BasicUtil.equals((Object)this.typeMetadata, (Object)columnTypeMetadata, ignoreCase) || BasicUtil.equals((Object)this.typeMetadata, (Object)columnOrigin, ignoreCase) || BasicUtil.equals((Object)origin, (Object)columnTypeMetadata, ignoreCase) || BasicUtil.equals((Object)origin, (Object)columnOrigin, ignoreCase))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignoreLength() || BasicUtil.equals(this.getLength(), column.getLength()))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignorePrecision() || BasicUtil.equals(this.getPrecision(), column.getPrecision()))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignoreScale() || BasicUtil.equals(this.getScale(), column.getScale()))) {
            return false;
        }
        if (!BasicUtil.equals(this.getDefaultValue(), column.getDefaultValue())) {
            return false;
        }
        if (!BasicUtil.equals(this.getComment(), column.getComment())) {
            return false;
        }
        if (!BasicUtil.equals(this.isNullable(), column.isNullable())) {
            return false;
        }
        if (!BasicUtil.equals(this.isAutoIncrement(), column.isAutoIncrement())) {
            return false;
        }
        if (!BasicUtil.equals((Object)this.getCharset(), (Object)column.getCharset(), ignoreCase)) {
            return false;
        }
        return BasicUtil.equals(this.isPrimaryKey(), column.isPrimaryKey());
    }

    public TypeMetadata getTypeMetadata() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).typeMetadata;
        }
        if (this.array && null != this.typeMetadata) {
            this.typeMetadata.setArray(this.array);
        }
        return this.typeMetadata;
    }

    public TypeMetadata.CATEGORY getTypeCategory() {
        if (null != this.typeMetadata) {
            return this.typeMetadata.getCategory();
        }
        return TypeMetadata.CATEGORY.NONE;
    }

    public Column setTypeMetadata(TypeMetadata typeMetadata) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setTypeMetadata(typeMetadata);
            return this;
        }
        this.typeMetadata = typeMetadata;
        return this;
    }

    @Override
    public Column setNewName(String newName, boolean setmap, boolean getmap) {
        LinkedHashMap<String, Column> pks;
        if (null == this.update) {
            this.update(setmap, getmap);
        }
        ((Column)this.update).setName(newName);
        Table table = this.getTable();
        if (null != table && null != (pks = table.getPrimaryKeyColumns()) && pks.containsKey(this.getName().toUpperCase())) {
            pks.remove(this.getName().toUpperCase());
            pks.put(newName.toUpperCase(), (Column)this.update);
        }
        return (Column)this.update;
    }

    public JavaType getJavaType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).javaType;
        }
        return this.javaType;
    }

    public Column setJavaType(JavaType javaType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJavaType(javaType);
            return this;
        }
        this.javaType = javaType;
        return this;
    }

    public Integer getSrid() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).srid;
        }
        return this.srid;
    }

    public Column setSrid(Integer srid) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSrid(srid);
            return this;
        }
        this.srid = srid;
        return this;
    }

    public Column getReference() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).reference;
        }
        return this.reference;
    }

    public Column setReference(Column reference) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setReference(reference);
            return this;
        }
        this.reference = reference;
        return this;
    }

    public void ignoreLength(int ignoreLength) {
        this.ignoreLength = ignoreLength;
    }

    public void ignorePrecision(int ignorePrecision) {
        this.ignorePrecision = ignorePrecision;
    }

    public void ignoreScale(int ignoreScale) {
        this.ignoreScale = ignoreScale;
    }

    public int ignoreScale(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataAdapterHolder.ignoreScale(database, this.typeMetadata);
        }
        return this.ignoreScale();
    }

    public String formula(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataAdapterHolder.formula(database, this.typeMetadata);
        }
        return null;
    }

    public int ignoreLength() {
        if (-1 != this.ignoreLength) {
            return this.ignoreLength;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignoreLength();
        }
        return this.ignoreLength;
    }

    public int ignoreLength(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataAdapterHolder.ignoreLength(database, this.typeMetadata);
        }
        return this.ignoreLength();
    }

    public int ignorePrecision() {
        if (-1 != this.ignorePrecision) {
            return this.ignorePrecision;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignorePrecision();
        }
        return this.ignorePrecision;
    }

    public int ignorePrecision(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataAdapterHolder.ignorePrecision(database, this.typeMetadata);
        }
        return this.ignorePrecision();
    }

    public String getFinalType() {
        return this.finalType;
    }

    public Column setFinalType(String finalType) {
        this.finalType = finalType;
        return this;
    }

    public int ignoreScale() {
        if (-1 != this.ignoreScale) {
            return this.ignoreScale;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignoreScale();
        }
        return this.ignoreScale;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(" ");
        builder.append(this.getFullType());
        if (BasicUtil.isNotEmpty(this.defaultValue)) {
            builder.append(" default ").append(this.defaultValue);
        }
        return builder.toString();
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public static class Property {
        String type;

        public Property(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static enum Aggregation {
        MIN("MIN", "\u6700\u5c0f"),
        MAX("MAX", "\u6700\u5927"),
        SUM("SUM", "\u6c42\u548c"),
        REPLACE("REPLACE", "\u66ff\u6362"),
        REPLACE_IF_NOT_NULL("REPLACE_IF_NOT_NULL", "\u975e\u7a7a\u503c\u66ff\u6362"),
        HLL_UNION("HLL_UNION", "HLL \u7c7b\u578b\u7684\u5217\u7684\u805a\u5408\u65b9\u5f0f"),
        BITMAP_UNION("BITMAP_UNION", "BIMTAP \u7c7b\u578b\u7684\u5217\u7684\u805a\u5408\u65b9\u5f0f\uff0c");

        final String code;
        final String name;

        private Aggregation(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }
    }
}

