/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.EntityAdapter;
import org.anyline.annotation.AnylineAutowired;
import org.anyline.annotation.AnylineComponent;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@AnylineComponent(value="anyline.entity.adapter.proxy")
public class EntityAdapterProxy {
    public static LinkedHashMap<String, Table> class2table = new LinkedHashMap();
    public static LinkedHashMap<String, Column> field2column = new LinkedHashMap();
    public static LinkedHashMap<String, Field> column2field = new LinkedHashMap();
    public static LinkedHashMap<String, LinkedHashMap<String, Column>> primarys = new LinkedHashMap();
    public static LinkedHashMap<String, LinkedHashMap<String, Column>> insert_columns = new LinkedHashMap();
    public static LinkedHashMap<String, LinkedHashMap<String, Column>> update_columns = new LinkedHashMap();
    public static LinkedHashMap<String, LinkedHashMap<String, Column>> ddl_columns = new LinkedHashMap();
    public static Map<Class, List<EntityAdapter>> adapters = new HashMap<Class, List<EntityAdapter>>();
    public static Map<Class, TypeMetadata> types = new HashMap<Class, TypeMetadata>();

    public static TypeMetadata type(Class clazz) {
        return types.get(clazz);
    }

    public static void clear() {
        class2table = new LinkedHashMap();
        field2column = new LinkedHashMap();
        column2field = new LinkedHashMap();
        primarys = new LinkedHashMap();
        insert_columns = new LinkedHashMap();
        update_columns = new LinkedHashMap();
    }

    public static boolean hasAdapter(Class calzz) {
        return !EntityAdapterProxy.getAdapters(calzz).isEmpty();
    }

    public static List<EntityAdapter> getAdapters(Class type) {
        ArrayList<EntityAdapter> list = new ArrayList<EntityAdapter>();
        for (Class clazz : adapters.keySet()) {
            if (!ClassUtil.isInSub(type, clazz)) continue;
            list.addAll((Collection<EntityAdapter>)adapters.get(clazz));
        }
        return list;
    }

    @AnylineAutowired(required=false)
    public static void setAdapters(Map<String, EntityAdapter> adapters) {
        String defaultKey = "anyline.entity.adapter.default";
        if (ConfigTable.IS_DISABLED_DEFAULT_ENTITY_ADAPTER) {
            adapters.remove(defaultKey);
        }
        for (EntityAdapter entityAdapter : adapters.values()) {
            Class type = entityAdapter.type();
            EntityAdapterProxy.push(type, entityAdapter);
            List<Class> types = entityAdapter.types();
            if (null == types) continue;
            for (Class t : types) {
                EntityAdapterProxy.push(t, entityAdapter);
            }
        }
        for (List list : EntityAdapterProxy.adapters.values()) {
            EntityAdapter.sort(list);
        }
    }

    public static void push(EntityAdapter adapter) {
        EntityAdapterProxy.push(Object.class, adapter);
    }

    public static void push(Class type, EntityAdapter adapter) {
        if (null != type) {
            List<EntityAdapter> list = adapters.get(type);
            if (null == list) {
                list = new ArrayList<EntityAdapter>();
                adapters.put(type, list);
            }
            list.add(adapter);
        }
    }

    public static Table table(Class clazz) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            Table table = adapter.table(clazz);
            if (null == table) continue;
            return table;
        }
        return null;
    }

    public static String table(Class clazz, boolean simple) {
        Table table = EntityAdapterProxy.table(clazz);
        if (null != table) {
            return table.getName();
        }
        return null;
    }

    public static LinkedHashMap<String, Column> columns(Class clazz, EntityAdapter.MODE mode) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            LinkedHashMap<String, Column> columns = adapter.columns(clazz, mode);
            if (null == columns || columns.isEmpty()) continue;
            return columns;
        }
        return new LinkedHashMap<String, Column>();
    }

    public static Column column(Class clazz, Field field) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            Column column = adapter.column(clazz, field, new String[0]);
            if (null == column) continue;
            return column;
        }
        return null;
    }

    public static String column(Class clazz, Field field, boolean simple) {
        Column column = EntityAdapterProxy.column(clazz, field);
        if (null != column) {
            return column.getName();
        }
        return null;
    }

    public static Field field(Class clazz, String column) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            Field field = adapter.field(clazz, column);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public static Field field(Class clazz, Column column) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            Field field = adapter.field(clazz, column);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public static Column primaryKey(Class clazz) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            Column column = adapter.primaryKey(clazz);
            if (null == column) continue;
            return column;
        }
        return null;
    }

    public static String primaryKey(Class clazz, boolean simple) {
        Column column = EntityAdapterProxy.primaryKey(clazz);
        if (null != column) {
            return column.getName();
        }
        return null;
    }

    public static LinkedHashMap<String, Column> primaryKeys(Class clazz) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        for (EntityAdapter adapter : list) {
            LinkedHashMap<String, Column> pks = adapter.primaryKeys(clazz);
            if (null == pks || pks.isEmpty()) continue;
            return pks;
        }
        return new LinkedHashMap<String, Column>();
    }

    public static List<String> primaryKeys(Class clazz, boolean simple) {
        LinkedHashMap<String, Column> pks = EntityAdapterProxy.primaryKeys(clazz);
        ArrayList<String> list = new ArrayList<String>();
        if (null != pks) {
            for (Column col : pks.values()) {
                list.add(col.getName());
            }
        }
        return list;
    }

    public static Map<String, Object> primaryValue(Object obj) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            Map<String, Object> value = adapter.primaryValue(obj);
            if (null == value || value.isEmpty()) continue;
            return value;
        }
        return new LinkedHashMap<String, Object>();
    }

    public static Object primaryValue(Object obj, boolean simple) {
        if (!ClassUtil.isWrapClass(obj) || obj instanceof String) {
            return obj;
        }
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            Iterator<Object> iterator;
            Map<String, Object> value = adapter.primaryValue(obj);
            if (null == value || value.isEmpty() || !(iterator = value.values().iterator()).hasNext()) continue;
            Object v = iterator.next();
            return v;
        }
        return null;
    }

    public static Map<String, Object> primaryValues(Object obj) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            Map<String, Object> value = adapter.primaryValues(obj);
            if (null == value || value.isEmpty()) continue;
            return value;
        }
        return new LinkedHashMap<String, Object>();
    }

    public static boolean createPrimaryValue(Object obj, List<String> inserts) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            boolean create = adapter.createPrimaryValue(obj, inserts);
            if (!create) continue;
            return create;
        }
        return false;
    }

    public static boolean createPrimaryValue(Object obj, LinkedHashMap<String, Column> inserts) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            boolean create = adapter.createPrimaryValue(obj, inserts);
            if (!create) continue;
            return create;
        }
        return false;
    }

    public static <T> T entity(Class<T> clazz, Map<String, Object> map, LinkedHashMap columns) {
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(clazz);
        Object entity = null;
        for (EntityAdapter adapter : list) {
            entity = adapter.entity(entity, clazz, map, columns);
        }
        return entity;
    }

    public static <T> EntitySet<T> entitys(Class<T> clazz, DataSet set, LinkedHashMap columns) {
        EntitySet<T> entitys = new EntitySet<T>();
        if (null != set) {
            for (DataRow row : set) {
                T entity = EntityAdapterProxy.entity(clazz, row, columns);
                entitys.add(entity);
            }
            entitys.setNavi(set.getNavi());
        }
        return entitys;
    }

    public static DataRow row(Object obj, String ... keys) {
        return EntityAdapterProxy.row(null, obj, keys);
    }

    public static DataRow row(DataRow row, Object obj, String ... keys) {
        if (null == obj) {
            return row;
        }
        List<EntityAdapter> list = EntityAdapterProxy.getAdapters(obj.getClass());
        for (EntityAdapter adapter : list) {
            row = adapter.row(row, obj, keys);
        }
        return row;
    }

    public static DataSet set(EntitySet entitys, String ... keys) {
        DataSet set = new DataSet();
        if (null != entitys) {
            for (Object obj : entitys) {
                DataRow row = EntityAdapterProxy.row(obj, keys);
                set.addRow(row);
            }
            set.setNavi(entitys.getNavi());
        }
        return set;
    }

    public static List<String> column2param(List<String> metadatas) {
        for (List<EntityAdapter> list : adapters.values()) {
            for (EntityAdapter adapter : list) {
                List<String> params = adapter.column2param(metadatas);
                if (null == params || params.isEmpty()) continue;
                return params;
            }
        }
        return metadatas;
    }

    public static String column2param(String metadata) {
        for (List<EntityAdapter> list : adapters.values()) {
            for (EntityAdapter adapter : list) {
                String param = adapter.column2param(metadata);
                if (!BasicUtil.isNotEmpty(param)) continue;
                return param;
            }
        }
        return metadata;
    }

    static {
        types.put(Integer.TYPE, StandardTypeMetadata.INT32);
        types.put(Integer.class, StandardTypeMetadata.INT32);
        types.put(Long.TYPE, StandardTypeMetadata.BIGINT);
        types.put(Long.class, StandardTypeMetadata.BIGINT);
        types.put(Double.TYPE, StandardTypeMetadata.DOUBLE);
        types.put(Double.class, StandardTypeMetadata.DOUBLE);
        types.put(Float.TYPE, StandardTypeMetadata.FLOAT);
        types.put(Float.class, StandardTypeMetadata.FLOAT);
        types.put(BigDecimal.class, StandardTypeMetadata.DECIMAL);
        types.put(Short.TYPE, StandardTypeMetadata.INT16);
        types.put(Short.class, StandardTypeMetadata.INT16);
        types.put(String.class, StandardTypeMetadata.VARCHAR);
        types.put(Date.class, StandardTypeMetadata.DATETIME);
        types.put(LocalDate.class, StandardTypeMetadata.DATE);
        types.put(LocalTime.class, StandardTypeMetadata.TIME);
        types.put(LocalDateTime.class, StandardTypeMetadata.DATETIME);
        types.put(byte[].class, StandardTypeMetadata.BLOB);
        types.put(Boolean.TYPE, StandardTypeMetadata.BOOLEAN);
        types.put(Boolean.class, StandardTypeMetadata.BOOLEAN);
        types.put(Point.class, StandardTypeMetadata.POINT);
    }
}

