/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.Run;
import org.anyline.entity.DataRow;
import org.anyline.entity.authorize.User;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Database;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Type;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

public class Metadata<T extends Metadata> {
    private static Map<Integer, Type> types = new HashMap<Integer, Type>();
    protected DatabaseType databaseType = DatabaseType.NONE;
    protected String datasource;
    protected Catalog catalog;
    protected Database database;
    protected Schema schema;
    protected String name;
    protected String alias;
    protected String comment;
    protected boolean execute = true;
    protected String text;
    protected String id;
    protected User user;
    protected String engine;
    protected Long objectId;
    protected String definition;
    protected T origin;
    protected T update;
    protected boolean setmap = false;
    protected boolean getmap = false;
    protected boolean drop = false;
    protected ACTION.DDL action = null;
    protected List<String> ddls;
    protected List<Run> runs;
    protected String identity;
    protected Object extend;
    protected Date checkSchemaTime;
    protected LinkedHashMap<String, Object> property;
    protected List<String> options = new ArrayList<String>();
    protected DataRow metadata = null;
    protected ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
    public static final String FIELD_DATABASE = "DATABASE";
    public static final String FIELD_DATASOURCE = "DATASOURCE";
    public static final String FIELD_CATALOG = "CATALOG";
    public static final String FIELD_SCHEMA = "SCHEMA";
    public static final String FIELD_NAME = "NAME";
    public static final String FIELD_ALIAS = "ALIAS";
    public static final String FIELD_COMMENT = "COMMENT";
    public static final String FIELD_EXECUTE = "EXECUTE";
    public static final String FIELD_EXECUTE_CHECK = "EXECUTE_CHECK";
    public static final String FIELD_EXECUTE_CHECK_VALUE = "EXECUTE_CHECK_VALUE";
    public static final String FIELD_TEXT = "TEXT";
    public static final String FIELD_ID = "ID";
    public static final String FIELD_USER = "USER";
    public static final String FIELD_OBJECT_ID = "OBJECT_ID";
    public static final String FIELD_DEFINITION = "DEFINITION";
    public static final String FIELD_SETMAP = "SETMAP";
    public static final String FIELD_SETMAP_CHECK = "SETMAP_CHECK";
    public static final String FIELD_SETMAP_CHECK_VALUE = "SETMAP_CHECK_VALUE";
    public static final String FIELD_GETMAP = "GETMAP";
    public static final String FIELD_GETMAP_CHECK = "GETMAP_CHECK";
    public static final String FIELD_GETMAP_CHECK_VALUE = "GETMAP_CHECK_VALUE";
    public static final String FIELD_DROP = "DROP";
    public static final String FIELD_DROP_CHECK = "DROP_CHECK";
    public static final String FIELD_DROP_CHECK_VALUE = "DROP_CHECK_VALUE";
    public static final String FIELD_ACTION = "ACTION";
    public static final String FIELD_DDL = "DDL";
    public static final String FIELD_RUN = "RUN";
    public static final String FIELD_IDENTITY = "IDENTITY";
    public static final String FIELD_EXTEND = "EXTEND";
    public static final String FIELD_CHECK_SCHEMA_TIME = "CHECK_SCHEMA_TIME";
    public static final String FIELD_PROPERTY = "PROPERTY";
    public static final String FIELD_METADATA = "METADATA";
    public static final String FIELD_SWT = "SWT";
    public static final String FIELD_ENGINE = "ENGINE";

    public static <T extends Metadata> T match(T meta, List<T> metas) {
        for (Metadata item : metas) {
            if (!item.getIdentity().equals(meta.getIdentity())) continue;
            return (T)item;
        }
        return null;
    }

    public static boolean check(int strut, Type type) {
        int tp = type.value();
        return (strut & tp) == tp;
    }

    public static Map<Integer, Type> types() {
        return types;
    }

    public static Type type(int type) {
        return Metadata.types().get(type);
    }

    public static List<Type> types(int types) {
        ArrayList<Type> list = new ArrayList<Type>();
        int count = 0;
        while (types >= 1) {
            int temp = types % 2;
            types = (types - temp) / 2;
            if (temp == 1) {
                Type t = null;
                t = count == 0 ? Metadata.type(1) : Metadata.type(2 << count - 1);
                if (null != t) {
                    list.add(t);
                }
            }
            ++count;
        }
        return list;
    }

    public DataRow getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DataRow metadata) {
        this.metadata = metadata;
    }

    public String getIdentity() {
        if (null == this.identity) {
            this.identity = BasicUtil.nvl(this.getCatalogName(), "") + "_" + BasicUtil.nvl(this.getSchemaName(), "") + "_" + BasicUtil.nvl(this.getName(), "");
            this.identity = this.identity.toUpperCase();
        }
        return this.identity;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getDatabaseName() {
        if (null != this.database) {
            return this.database.getName();
        }
        return null;
    }

    public T setDatabase(Database database) {
        this.database = database;
        return (T)this;
    }

    public T setDatabase(String database) {
        this.database = new Database(database);
        return (T)this;
    }

    public String getEngine() {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).engine;
        }
        return this.engine;
    }

    public T setEngine(String engine) {
        if (this.setmap && null != this.update) {
            ((Metadata)this.update).setEngine(engine);
            return (T)this;
        }
        this.engine = engine;
        return (T)this;
    }

    public static <T extends Metadata> List<String> names(LinkedHashMap<String, T> metas) {
        return Metadata.names(metas, false);
    }

    public static <T extends Metadata> List<String> names(LinkedHashMap<String, T> metas, boolean upper) {
        ArrayList<String> names = new ArrayList<String>();
        if (null != metas) {
            for (Metadata meta : metas.values()) {
                String name = meta.getName();
                if (upper && null != name) {
                    name = name.toUpperCase();
                }
                names.add(name);
            }
        }
        return names;
    }

    public static <T extends Metadata> List<String> names(Collection<T> metas) {
        return Metadata.names(metas, false);
    }

    public static <T extends Metadata> List<String> names(Collection<T> metas, boolean upper) {
        ArrayList<String> names = new ArrayList<String>();
        if (null != metas) {
            for (Metadata meta : metas) {
                String name = meta.getName();
                if (upper && null != name) {
                    name = name.toUpperCase();
                }
                names.add(name);
            }
        }
        return names;
    }

    public static <T extends Metadata> void sort(final LinkedHashMap<String, Integer> positions, LinkedHashMap<String, T> columns) {
        if (null == positions || positions.isEmpty()) {
            return;
        }
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(columns.values());
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Integer p2;
                Integer p1 = (Integer)positions.get(((Metadata)o1).getName().toUpperCase());
                if (p1 == (p2 = (Integer)positions.get(((Metadata)o2).getName().toUpperCase()))) {
                    return 0;
                }
                if (null == p1) {
                    return 1;
                }
                if (null == p2) {
                    return -1;
                }
                return p1 > p2 ? 1 : -1;
            }
        });
        columns.clear();
        for (Metadata column : list) {
            columns.put(column.getName().toUpperCase(), column);
        }
    }

    public boolean isEmpty() {
        return null == this.name || this.name.trim().isEmpty();
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public String getDataSource() {
        return this.datasource;
    }

    public void setDataSource(String datasource) {
        this.datasource = datasource;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogName() {
        this.catalog = this.getCatalog();
        if (null == this.catalog) {
            return null;
        }
        return this.catalog.getName();
    }

    public T setCatalog(String catalog) {
        this.catalog = BasicUtil.isEmpty((Object)catalog) ? null : new Catalog(catalog);
        return (T)this;
    }

    public T setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return (T)this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getSchemaName() {
        this.schema = this.getSchema();
        if (null == this.schema) {
            return null;
        }
        return this.schema.getName();
    }

    public T setSchema(String schema) {
        this.schema = null == schema ? null : new Schema(schema);
        return (T)this;
    }

    public T setSchema(Schema schema) {
        this.schema = schema;
        return (T)this;
    }

    public User getUser() {
        return this.user;
    }

    public String getUserName() {
        if (null != this.user) {
            return this.user.getName();
        }
        return null;
    }

    public T setUser(User user) {
        this.user = user;
        return (T)this;
    }

    public T setUser(String user) {
        this.user = new User(user);
        return (T)this;
    }

    public Date getCheckSchemaTime() {
        return this.checkSchemaTime;
    }

    public T setCheckSchemaTime(Date checkSchemaTime) {
        if (this.setmap && null != this.update) {
            ((Metadata)this.update).setCheckSchemaTime(checkSchemaTime);
            return (T)this;
        }
        this.checkSchemaTime = checkSchemaTime;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.name;
        if (BasicUtil.isNotEmpty(catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty(schemaName)) {
            dest = null == dest ? schemaName : dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty(tableName)) {
            dest = null == dest ? tableName : dest + "." + tableName;
        }
        return dest;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public String getAlias() {
        return this.alias;
    }

    public T setAlias(String alias) {
        this.alias = alias;
        return (T)this;
    }

    public T setComment(String comment) {
        if (this.setmap && null != this.update) {
            ((Metadata)this.update).comment = comment;
            return (T)this;
        }
        this.comment = comment;
        return (T)this;
    }

    public String getComment() {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).comment;
        }
        return this.comment;
    }

    public T delete() {
        return this.drop();
    }

    public boolean isDelete() {
        return this.drop;
    }

    public T setDelete(boolean drop) {
        this.drop = drop;
        return (T)this;
    }

    public ACTION.DDL getAction() {
        return this.action;
    }

    public T setAction(ACTION.DDL action) {
        this.action = action;
        return (T)this;
    }

    public T drop() {
        this.drop = true;
        return (T)this;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public T setDrop(boolean drop) {
        this.drop = drop;
        return (T)this;
    }

    public T setNewName(String newName) {
        return this.setNewName(newName, true, true);
    }

    public T setNewName(String newName, boolean setmap, boolean getmap) {
        if (null == this.update) {
            this.update(setmap, getmap);
        }
        ((Metadata)this.update).setName(newName);
        return this.update;
    }

    public List<String> options() {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).options();
        }
        return this.options;
    }

    public T addOption(String option) {
        if (this.setmap && null != this.update) {
            this.addOption(option);
            return (T)this;
        }
        this.options.add(option);
        return (T)this;
    }

    public LinkedHashMap<String, Object> getProperty() {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).getProperty();
        }
        return this.property;
    }

    public T setProperty(String key, Object value) {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).setProperty(key, value);
        }
        if (null == this.property) {
            this.property = new LinkedHashMap();
        }
        this.property.put(key, value);
        return (T)this;
    }

    public T setProperty(LinkedHashMap<String, Object> property) {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).setProperty(property);
        }
        this.property = property;
        return (T)this;
    }

    public String getDefinition() {
        if (this.getmap && null != this.update) {
            return ((Metadata)this.update).definition;
        }
        return this.definition;
    }

    public T setDefinition(String definition) {
        if (this.setmap && null != this.update) {
            ((Metadata)this.update).definition = definition;
            return (T)this;
        }
        this.definition = definition;
        return (T)this;
    }

    public boolean isRename() {
        if (null != this.update) {
            return !BasicUtil.equalsIgnoreCase(this.name, ((Metadata)this.update).getName());
        }
        return false;
    }

    public String getDdl() {
        if (null != this.ddls && !this.ddls.isEmpty()) {
            return this.ddls.get(0);
        }
        return null;
    }

    public List<String> getDdls() {
        return this.ddls;
    }

    public void setDdls(List<String> ddl) {
        this.ddls = ddl;
    }

    public void addDdl(String ddl) {
        if (this.ddls == null) {
            this.ddls = new ArrayList<String>();
        }
        this.ddls.add(ddl);
    }

    public List<String> ddls() {
        return this.ddls;
    }

    public List<String> ddls(boolean init) {
        return this.ddls;
    }

    public List<String> getDdls(boolean init) {
        return this.ddls;
    }

    public String ddl() {
        if (null != this.ddls && !this.ddls.isEmpty()) {
            return this.ddls.get(0);
        }
        return null;
    }

    public String ddl(boolean init) {
        if (null != this.ddls && !this.ddls.isEmpty()) {
            return this.ddls.get(0);
        }
        return null;
    }

    public String getDdl(boolean init) {
        if (null != this.ddls && !this.ddls.isEmpty()) {
            return this.ddls.get(0);
        }
        return null;
    }

    public Run getRun() {
        if (null != this.runs && !this.runs.isEmpty()) {
            return this.runs.get(0);
        }
        return null;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public void setRuns(List<Run> run) {
        this.runs = run;
    }

    public void addRun(Run run) {
        if (null != this.origin) {
            ((Metadata)this.origin).addRun(run);
            return;
        }
        if (this.runs == null) {
            this.runs = new ArrayList<Run>();
        }
        if (!this.runs.contains(run)) {
            this.runs.add(run);
        }
    }

    public List<Run> runs() {
        return this.runs;
    }

    public List<Run> runs(boolean init) {
        return this.runs;
    }

    public List<Run> getRuns(boolean init) {
        return this.runs;
    }

    public Run run() {
        if (null != this.runs && !this.runs.isEmpty()) {
            return this.runs.get(0);
        }
        return null;
    }

    public Run run(boolean init) {
        if (null != this.runs && !this.runs.isEmpty()) {
            return this.runs.get(0);
        }
        return null;
    }

    public Run getRun(boolean init) {
        if (null != this.runs && !this.runs.isEmpty()) {
            return this.runs.get(0);
        }
        return null;
    }

    public Object getExtend() {
        return this.extend;
    }

    public void setExtend(Object extend) {
        this.extend = extend;
    }

    public boolean execute() {
        if (null != this.origin && !((Metadata)this.origin).execute()) {
            return false;
        }
        return this.execute;
    }

    public void execute(boolean execute) {
        this.execute = execute;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public T getUpdate() {
        return this.update;
    }

    public T getOrigin() {
        return this.origin;
    }

    public T setUpdate(T update, boolean setmap, boolean getmap) {
        this.update = update;
        this.setmap = setmap;
        this.getmap = getmap;
        if (null != update) {
            ((Metadata)update).update = null;
            ((Metadata)update).origin = this;
        }
        return (T)this;
    }

    public T update() {
        return this.update(true, true);
    }

    public T update(boolean setmap, boolean getmap) {
        this.setmap = setmap;
        this.getmap = getmap;
        this.update = this.clone();
        ((Metadata)this.update).update = null;
        ((Metadata)this.update).origin = this;
        return this.update;
    }

    public T clone() {
        Metadata clone = null;
        try {
            clone = (Metadata)super.clone();
        }
        catch (Exception e) {
            try {
                clone = (Metadata)this.getClass().newInstance();
                BeanUtil.copyFieldValue(clone, this);
                clone.update = null;
                clone.setmap = false;
                clone.getmap = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)clone;
    }

    public static <T extends Metadata> T match(List<T> list, String catalog, String schema, String name) {
        for (Metadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getCatalogName(), catalog) || !BasicUtil.equalsIgnoreCase(item.getSchemaName(), schema) || !BasicUtil.equalsIgnoreCase(item.getName(), name)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T extends Metadata> T match(List<T> list, Catalog catalog, Schema schema, String name) {
        for (Metadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getCatalogName(), catalog) || !BasicUtil.equalsIgnoreCase(item.getSchemaName(), schema) || !BasicUtil.equalsIgnoreCase(item.getName(), name)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T extends Metadata> T match(List<T> list, String catalog, String name) {
        for (Metadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getName(), name) || !BasicUtil.equalsIgnoreCase(item.getCatalogName(), catalog)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T extends Metadata> T match(List<T> list, String name) {
        for (Metadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getName(), name)) continue;
            return (T)item;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void swt(ACTION.SWITCH swt) {
        this.swt = swt;
    }

    public ACTION.SWITCH swt() {
        return this.swt;
    }

    public String getKeyword() {
        return "object";
    }

    public String toString() {
        return this.getKeyword() + ":" + this.getName();
    }

    static {
        for (TYPE type : TYPE.values()) {
            types.put(type.value, type);
        }
    }

    public static enum TYPE implements Type
    {
        ALL(Short.MAX_VALUE),
        TABLE(1),
        VIEW(2),
        COLUMN(4),
        PRIMARY(8),
        FOREIGN(16),
        INDEX(32),
        CONSTRAINT(64),
        SCHEMA(128),
        CATALOG(256),
        FUNCTION(512),
        PROCEDURE(1024),
        TRIGGER(2048),
        SEQUENCE(4096),
        SYNONYM(8192),
        DDL(16384);

        public final int value;

        private TYPE(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

