/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.LineString;

public class MultiLine
extends Geometry {
    private List<LineString> lines = new ArrayList<LineString>();

    public MultiLine() {
        this.type = 5;
    }

    public MultiLine(List<LineString> lines) {
        this();
        this.lines = lines;
    }

    public MultiLine add(LineString line) {
        this.lines.add(line);
        return this;
    }

    public MultiLine add(List<LineString> lines) {
        if (null != lines) {
            lines.addAll(lines);
        }
        return this;
    }

    public MultiLine clear() {
        this.lines = new ArrayList<LineString>();
        return this;
    }

    public List<LineString> lines() {
        return this.lines;
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (LineString line : this.lines) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(line.toString(false));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (LineString line : this.lines) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(line.sql(false, false));
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    public List<LineString> getLines() {
        return this.lines;
    }
}

