/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.util.LinkedHashMap;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class DefaultOrderStore
implements OrderStore {
    private static final long serialVersionUID = -2129393152486629564L;
    private LinkedHashMap<String, Order> orders = new LinkedHashMap();

    @Override
    public void add(Order order, boolean override) {
        if (null == order) {
            return;
        }
        String column = order.getColumn();
        Order exists = this.get(column.toUpperCase());
        if (null != exists) {
            if (override) {
                exists.setType(order.getType());
            }
        } else {
            this.orders.put(column.toUpperCase(), order);
        }
    }

    @Override
    public void add(Order order) {
        this.add(order, true);
    }

    @Override
    public void add(String col, Order.TYPE type, boolean override) {
        this.add(new DefaultOrder(col, type), override);
    }

    @Override
    public void add(String col, Order.TYPE type) {
        this.add(col, type, true);
    }

    @Override
    public void add(String col, String type, boolean override) {
        this.add(new DefaultOrder(col, type), override);
    }

    @Override
    public void add(String col, String type) {
        this.add(col, type, true);
    }

    @Override
    public void add(String str, boolean override) {
        String[] tmps;
        if (BasicUtil.isEmpty((Object)str)) {
            return;
        }
        String up = (str = str.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
        if (up.startsWith("ORDER BY")) {
            str = str.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
        }
        for (String tmp : tmps = str.split(",")) {
            this.add(new DefaultOrder(tmp), override);
        }
    }

    @Override
    public void add(String str) {
        this.add(str, true);
    }

    @Override
    public Order get(String order) {
        if (null == order) {
            return null;
        }
        return this.orders.get(order.toUpperCase());
    }

    @Override
    public String getRunText(String delimiter) {
        StringBuilder builder = new StringBuilder();
        if (null != this.orders && !this.orders.isEmpty()) {
            builder.append("\nORDER BY ");
            boolean first = true;
            for (Order order : this.orders.values()) {
                if (null == order) continue;
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                SQLUtil.delimiter(builder, order.getColumn(), delimiter).append(" ").append((Object)order.getType());
            }
        }
        return builder.toString();
    }

    @Override
    public void clear() {
        this.orders.clear();
    }

    @Override
    public LinkedHashMap<String, Order> gets() {
        return this.orders;
    }

    @Override
    public boolean isEmpty() {
        if (null != this.orders) {
            return this.orders.isEmpty();
        }
        return true;
    }

    @Override
    public DefaultOrderStore clone() {
        DefaultOrderStore clone = null;
        try {
            clone = (DefaultOrderStore)super.clone();
        }
        catch (Exception ignored) {
            clone = new DefaultOrderStore();
        }
        if (null != this.orders) {
            for (Order order : this.orders.values()) {
                clone.add(order.clone());
            }
        }
        return clone;
    }
}

