/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Function;
import org.anyline.metadata.differ.AbstractDiffer;
import org.anyline.metadata.differ.MetadataDiffer;

public class FunctionsDiffer
extends AbstractDiffer {
    private List<Function> adds = new ArrayList<Function>();
    private List<Function> drops = new ArrayList<Function>();
    private List<Function> alters = new ArrayList<Function>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.alters.isEmpty();
    }

    public static FunctionsDiffer compare(LinkedHashMap<String, Function> origins, LinkedHashMap<String, Function> dests, MetadataDiffer.DIRECT direct) {
        FunctionsDiffer differ = new FunctionsDiffer();
        ArrayList<Function> adds = new ArrayList<Function>();
        ArrayList<Function> drops = new ArrayList<Function>();
        ArrayList<Function> updates = new ArrayList<Function>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Function origin = origins.get(key);
            Function dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setAlters(updates);
        return differ;
    }

    public List<Function> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Function> adds) {
        this.adds = adds;
    }

    public List<Function> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Function> drops) {
        this.drops = drops;
    }

    public List<Function> getAlters() {
        return this.alters;
    }

    public void setAlters(List<Function> alters) {
        this.alters = alters;
    }
}

