/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.anyline.log.Group;
import org.anyline.log.Log;
import org.anyline.log.LogFactory;

public class LogProxy {
    private static final List<LogFactory> factors = new ArrayList<LogFactory>();
    private static final Vector<Group> caches = new Vector();

    public static int size() {
        return factors.size();
    }

    public static void append(LogFactory factory) {
        factors.add(factory);
        LogProxy.enrich();
    }

    private static void enrich() {
        for (Group group : caches) {
            for (LogFactory factory : factors) {
                if (factory.disabled()) continue;
                String name = group.getName();
                Class<?> clazz = group.getClazz();
                if (null != name) {
                    group.add(factory.get(name));
                    continue;
                }
                if (null == clazz) continue;
                group.add(factory.get(clazz));
            }
        }
    }

    public static Log get(String name) {
        Group group = new Group();
        group.setName(name);
        for (LogFactory factory : factors) {
            if (factory.disabled()) continue;
            group.add(factory.get(name));
        }
        caches.add(group);
        return group;
    }

    public static Log get(Class<?> clazz) {
        Group group = new Group();
        group.setClazz(clazz);
        for (LogFactory factory : factors) {
            if (factory.disabled()) continue;
            group.add(factory.get(clazz));
        }
        caches.add(group);
        return group;
    }
}

