/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);
    private static Map<Class, Class> INTERFACE_IMPLEMENT = new HashMap<Class, Class>();

    public static void regImplement(Class interfaceClass, Class implementClass) {
        INTERFACE_IMPLEMENT.put(interfaceClass, implementClass);
    }

    public static boolean isPrimitiveClass(Object obj) {
        try {
            Class<?> clazz = null;
            clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            return clazz.isPrimitive() || ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isJavaType(Object check) {
        if (null == check) {
            return true;
        }
        if (ClassUtil.isPrimitiveClass(check)) {
            return true;
        }
        return check instanceof Class ? ((Class)check).getName().startsWith("java.") : check.getClass().getName().startsWith("java.");
    }

    public static boolean isWrapClass(Object obj) {
        return !ClassUtil.isPrimitiveClass(obj);
    }

    public static List<Class<?>> list(String packageName, boolean recursion, Class<?> ... bases) {
        ArrayList list = new ArrayList();
        try {
            List<String> names = ClassUtil.getClassNames(packageName, recursion);
            for (String name : names) {
                try {
                    Class<?> c;
                    if (name.startsWith("java") || !ClassUtil.isInSub(c = Class.forName(name), bases)) continue;
                    list.add(c);
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Exception e) {}
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public static List<String> names(String packageName, boolean recursion, Class<?> ... bases) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<String> names = ClassUtil.getClassNames(packageName, recursion);
            for (String name : names) {
                try {
                    Class<?> c = Class.forName(name);
                    if (!ClassUtil.isInSub(c, bases)) continue;
                    list.add(name);
                }
                catch (Exception ignored) {}
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return list;
    }

    public static boolean isInSub(Class<?> clazz, Class<?> ... bases) {
        ArrayList list = new ArrayList();
        if (null != bases) {
            for (Class<?> base : bases) {
                if (null == base) continue;
                list.add(base);
            }
        }
        if (list.isEmpty()) {
            return true;
        }
        for (Class<?> base : bases) {
            if (!base.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllSub(Class<?> clazz, Class<?> ... bases) {
        ArrayList list = new ArrayList();
        if (null != bases) {
            for (Class<?> base : bases) {
                if (null == base) continue;
                list.add(base);
            }
        }
        if (list.isEmpty()) {
            return true;
        }
        for (Class<?> base : bases) {
            if (base.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    private static List<String> getClassNames(String packageName, boolean childPackage) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        log.info("[\u6b63\u5728\u52a0\u8f7d\u672c\u5730\u7c7b][package:{}]", (Object)packageName);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> urls = loader.getResources(packagePath);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames.addAll(ClassUtil.getClassNameListFromFile(url.getPath(), childPackage));
                continue;
            }
            if (!type.equals("jar")) continue;
            fileNames.addAll(ClassUtil.getClassNameListFromJar(url.getPath(), childPackage));
        }
        return fileNames;
    }

    private static List<String> getClassNameListFromFile(String filePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        File[] childFiles = file.listFiles();
        if (childFiles == null) {
            return myClassName;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(ClassUtil.getClassNameListFromFile(childFile.getPath(), childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class") || childFilePath.contains("$")) continue;
            String c = childFilePath.split("classes")[1].replace(".class", "");
            if ((c = c.replace("\\", ".").replace("//", ".")).startsWith(".")) {
                c = c.substring(1);
            }
            myClassName.add(c);
        }
        return myClassName;
    }

    private static List<String> getClassNameListFromJar(String jarPath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> names = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    names.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                names.add(entryName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return names;
    }

    private static List<String> getClassNameListFromJar(URL[] urls, String packagePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> names = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                names.addAll(ClassUtil.getClassNameListFromJar(jarPath, childPackage));
            }
        }
        return names;
    }

    public static boolean hasAnnotation(Class clazz, String annotation) {
        Annotation[] annotations;
        for (Annotation item : annotations = clazz.getAnnotations()) {
            if (!item.annotationType().getSimpleName().equalsIgnoreCase(annotation)) continue;
            return true;
        }
        return false;
    }

    public static List<Object> getAnnotationFieldValues(Class target, String annotation, String field, int qty) {
        Annotation[] annotations = target.getAnnotations();
        return ClassUtil.getAnnotationFieldValues(annotations, annotation, field, qty);
    }

    public static List<Object> getAnnotationFieldValues(Class target, String annotation, String field) {
        return ClassUtil.getAnnotationFieldValues(target, annotation, field, -1);
    }

    public static Object getAnnotationFieldValue(Class target, String annotation, String field) {
        List<Object> values = ClassUtil.getAnnotationFieldValues(target, annotation, field, 1);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public static List<Object> getAnnotationFieldValues(Field target, String annotation, String field, int qty) {
        Annotation[] annotations = target.getAnnotations();
        return ClassUtil.getAnnotationFieldValues(annotations, annotation, field, qty);
    }

    public static List<Object> getAnnotationFieldValues(Field target, String annotation, String field) {
        return ClassUtil.getAnnotationFieldValues(target, annotation, field, -1);
    }

    public static Object getAnnotationFieldValue(Field target, String annotation, String field) {
        List<Object> values = ClassUtil.getAnnotationFieldValues(target, annotation, field, 1);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    private static List<Object> getAnnotationFieldValues(Annotation[] annotations, String annotation, String field, int qty) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Annotation an : annotations) {
            Method[] methods;
            String name = an.annotationType().getSimpleName();
            if (!ClassUtil.match(name, annotation)) continue;
            for (Method method : methods = an.annotationType().getMethods()) {
                name = method.getName();
                if (!ClassUtil.match(name, field)) continue;
                try {
                    Object value = method.invoke((Object)an, new Object[0]);
                    if (null != value && value.getClass().isArray()) {
                        int len = Array.getLength(value);
                        for (int i = 0; i < len; ++i) {
                            Object v = Array.get(value, i);
                            list.add(v);
                            if (qty <= 0 || list.size() < qty) continue;
                            return list;
                        }
                        continue;
                    }
                    list.add(value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    private static boolean match(String value, String regex) {
        regex = regex.replace("*", ".*").toUpperCase();
        return value.toUpperCase().matches(regex);
    }

    public static List<Field> getFields(Class<?> clazz, boolean statics, boolean finals) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (null != clazz) {
            Field[] tmp;
            for (Field field : tmp = clazz.getDeclaredFields()) {
                if (!statics && Modifier.isStatic(field.getModifiers()) || !finals && Modifier.isFinal(field.getModifiers())) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getFields(Class<?> clazz) {
        return ClassUtil.getFields(clazz, true, true);
    }

    public static List<String> getFieldsName(Class<?> clazz) {
        List<Field> fields = ClassUtil.getFields(clazz);
        ArrayList<String> keys = new ArrayList<String>();
        for (Field field : fields) {
            keys.add(field.getName());
        }
        return keys;
    }

    public static List<Method> getMethods(Class<?> clazz, boolean recursion) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            list.add(method);
        }
        if (null != clazz && recursion && null != (clazz = clazz.getSuperclass())) {
            list.addAll(ClassUtil.getMethods(clazz, recursion));
        }
        return list;
    }

    public static Method getMethod(Class<?> clazz, String name, boolean recursion, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (null == method) {
            try {
                method = clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == method && recursion && null != (clazz = clazz.getSuperclass())) {
            method = ClassUtil.getMethod(clazz, name, recursion, parameterTypes);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ClassUtil.getMethod(clazz, name, false, parameterTypes);
    }

    public static Field getField(Class<?> clazz, String name, boolean recursion) {
        return ClassUtil.getField(clazz, name, recursion, false);
    }

    public static Field getField(Class<?> clazz, String name, boolean recursion, boolean ignoreCase) {
        Field field = null;
        try {
            field = clazz.getField(name);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (null == field) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == field && ignoreCase) {
            Field[] fields;
            name = name.replace("_", "");
            for (Field item : fields = clazz.getFields()) {
                if (!name.equalsIgnoreCase(item.getName().replace("_", ""))) continue;
                field = item;
                break;
            }
            if (null == field) {
                for (Field item : fields = clazz.getDeclaredFields()) {
                    if (!name.equalsIgnoreCase(item.getName().replace("_", ""))) continue;
                    field = item;
                    break;
                }
            }
        }
        if (null == field && recursion && null != (clazz = clazz.getSuperclass())) {
            field = ClassUtil.getField(clazz, name, recursion, ignoreCase);
        }
        return field;
    }

    public static Field getField(List<Field> fields, String name, boolean ignoreCase, boolean ignoreSplit) {
        if (null == name) {
            return null;
        }
        Field field = null;
        for (Field item : fields) {
            String itemName = item.getName();
            if (ignoreCase) {
                itemName = itemName.toUpperCase();
                name = name.toUpperCase();
            }
            if (ignoreSplit) {
                itemName = itemName.replace("-", "").replace("_", "");
                name = name.replace("-", "").replace("_", "");
            }
            if (!name.equals(itemName)) continue;
            field = item;
        }
        return field;
    }

    public static Field getField(Class<?> clazz, String name) {
        return ClassUtil.getField(clazz, name, true);
    }

    public static List<Field> getFieldsByAnnotation(Class clazz, Class annotation) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            List<Field> fields = ClassUtil.getFields(clazz);
            for (Field field : fields) {
                Object at = field.getAnnotation(annotation);
                if (null == at) continue;
                list.add(field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Annotation> getFieldAnnotations(Field field, String ... names) {
        Annotation[] annotations;
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        block0: for (Annotation annotation : annotations = field.getAnnotations()) {
            for (String name : names) {
                if (!ClassUtil.match(annotation.annotationType().getSimpleName(), name)) continue;
                list.add(annotation);
                continue block0;
            }
        }
        return list;
    }

    public static Annotation getFieldAnnotation(Field field, String ... names) {
        List<Annotation> list = ClassUtil.getFieldAnnotations(field, names);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<Field> getFieldsByAnnotation(Class clazz, String ... annotations) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            List<Field> fields = ClassUtil.getFields(clazz);
            for (Field field : fields) {
                Annotation[] ans;
                block3: for (Annotation an : ans = field.getAnnotations()) {
                    for (String annotation : annotations) {
                        if (!ClassUtil.match(an.annotationType().getSimpleName(), annotation)) continue;
                        list.add(field);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Class> getClasses(String pack, Class ... bases) {
        ArrayList<Class> list = new ArrayList<Class>();
        File dir = new File(ClassUtil.class.getResource("/").getFile(), pack.replace(".", File.separator));
        List<File> files = FileUtil.getAllChildrenFile(dir, ".class");
        for (File file : files) {
            try {
                Class<?> clazz;
                String path = file.getAbsolutePath();
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.debug("[\u68c0\u7d22\u7c7b][file:{}]", (Object)path);
                }
                if (path.contains(File.separator + "classes" + File.separator)) {
                    path = path.substring(path.indexOf(File.separator + "classes" + File.separator));
                }
                path = path.replace(File.separator, ".");
                path = path.replace(".classes.", "").replace(".class", "");
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.debug("[\u68c0\u7d22\u7c7b][class:{}]", (Object)path);
                }
                if ((clazz = Class.forName(path)).getName().contains("$")) continue;
                if (null != bases && bases.length > 0) {
                    for (Class base : bases) {
                        if (clazz.equals(base) || !base.isAssignableFrom(clazz)) continue;
                        list.add(clazz);
                    }
                    continue;
                }
                list.add(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static String parseAnnotationFieldValue(Class clazz, String ... configs) {
        for (String config : configs) {
            Object name;
            String[] tmps = config.split("\\.");
            if (tmps.length < 2 || !BasicUtil.isNotEmpty(name = ClassUtil.getAnnotationFieldValue(clazz, tmps[0], tmps[1]))) continue;
            return name.toString();
        }
        return null;
    }

    public static String parseAnnotationFieldValue(Field field, String ... configs) {
        for (String config : configs) {
            Object value;
            String[] tmps = config.split("\\.");
            if (tmps.length >= 2) {
                value = ClassUtil.getAnnotationFieldValue(field, tmps[0], tmps[1]);
                if (!BasicUtil.isNotEmpty(value)) continue;
                return value.toString();
            }
            value = ClassUtil.getAnnotationFieldValue(field, config, "name");
            if (BasicUtil.isNotEmpty(value)) {
                return value.toString();
            }
            value = ClassUtil.getAnnotationFieldValue(field, config, "value");
            if (!BasicUtil.isNotEmpty(value)) continue;
            return value.toString();
        }
        return null;
    }

    public static Class getComponentClass(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type gtype = field.getGenericType();
        if (gtype instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gtype;
            Type[] args = pt.getActualTypeArguments();
            if (null != args && args.length > 0 && args[0] instanceof Class) {
                Class itemClass = (Class)args[0];
                return itemClass;
            }
        } else if (gtype instanceof Class) {
            return (Class)gtype;
        }
        return null;
    }

    public static Class[] getComponentClasses(Field field) {
        Type gtype;
        Class[] array = new Class[2];
        if (field.getType().isArray()) {
            array[0] = field.getType().getComponentType();
        }
        if ((gtype = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gtype;
            Type[] args = pt.getActualTypeArguments();
            if (null != args) {
                if (args.length > 0 && args[0] instanceof Class) {
                    array[0] = (Class)args[0];
                }
                if (args.length > 1 && args[1] instanceof Class) {
                    array[1] = (Class)args[1];
                }
            }
        } else if (gtype instanceof Class) {
            array[0] = (Class)gtype;
        }
        return array;
    }

    public static Class getComponentClass(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        ParameterizedType pty = (ParameterizedType)genericSuperclass;
        Type actualTypeArgument = pty.getActualTypeArguments()[0];
        return (Class)actualTypeArgument;
    }

    public static Class getComponentClass(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Field) {
            return ClassUtil.getComponentClass((Field)obj);
        }
        if (obj instanceof Class) {
            return ClassUtil.getComponentClass((Class)obj);
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            Iterator iterator = col.iterator();
            if (iterator.hasNext()) {
                Object item = iterator.next();
                return item.getClass();
            }
        } else if (obj.getClass().isArray()) {
            return obj.getClass().getComponentType();
        }
        return ClassUtil.getComponentClass(obj.getClass());
    }

    public static String type(Object obj) {
        String type = null;
        if (null != obj) {
            type = ClassUtil.type(obj.getClass());
        }
        return type;
    }

    public static String type(Field field) {
        String type = null;
        if (null != field) {
            Class<?> clazz = field.getType();
            type = ClassUtil.type(clazz);
        }
        return type;
    }

    public static String type(Class clazz) {
        String type = null;
        if (null != clazz) {
            type = clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName();
        }
        return type;
    }

    public static Object newInstance(Class clazz) throws Exception {
        if (!(clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum() || clazz.isArray() || Modifier.isAbstract(clazz.getModifiers()))) {
            return clazz.newInstance();
        }
        Class implementClass = INTERFACE_IMPLEMENT.get(clazz);
        if (null != implementClass) {
            return implementClass.newInstance();
        }
        if (ClassUtil.isInSub(clazz, List.class)) {
            return new ArrayList();
        }
        if (ClassUtil.isInSub(clazz, Set.class)) {
            return new HashSet();
        }
        if (ClassUtil.isInSub(clazz, Collection.class)) {
            return new ArrayList();
        }
        if (ClassUtil.isInSub(clazz, Map.class)) {
            return new HashMap();
        }
        return null;
    }
}

