/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Table;

public class ForeignKey
extends Constraint<ForeignKey>
implements Serializable {
    protected String keyword = "FOREIGNKEY";
    protected Table reference;
    protected ForeignKey update;
    public static final String FIELD_KEYWORD = "KEYWORD";
    public static final String FIELD_REFERENCE_CATALOG = "REFERENCE_CATALOG";
    public static final String FIELD_REFERENCE_SCHEMA = "REFERENCE_SCHEMA";
    public static final String FIELD_REFERENCE_TABLE = "REFERENCE_TABLE";
    public static final String FIELD_REFERENCE_COLUMN = "REFERENCE_COLUMN";
    public static final String FIELD_COLUMN = "COLUMN";
    public static final String FIELD_COLUMN_POSITION = "COLUMN_POSITION";

    public boolean isForeign() {
        return true;
    }

    public ForeignKey() {
    }

    public ForeignKey(String name) {
        this.setName(name);
    }

    public ForeignKey(String table, String column, String rtable, String rcolumn) {
        this.setTable(table);
        this.setReference(rtable);
        this.addColumn(column, rcolumn);
    }

    @Override
    public ForeignKey addColumn(String column, String reference) {
        this.addColumn(new Column(column).setReference(new Column(reference)));
        return this;
    }

    public ForeignKey setReference(Table reference) {
        if (this.setmap && null != this.update) {
            this.update.setReference(reference);
            return this;
        }
        this.reference = reference;
        return this;
    }

    public ForeignKey setReference(String reference) {
        if (this.setmap && null != this.update) {
            this.update.setReference(reference);
            return this;
        }
        this.reference = new Table(reference);
        return this;
    }

    public Table getReference() {
        if (this.getmap && null != this.update) {
            return this.update.reference;
        }
        return this.reference;
    }

    @Override
    public ForeignKey addColumn(Column column) {
        if (this.setmap && null != this.update) {
            this.update.addColumn(column);
            return this;
        }
        super.addColumn(column);
        return this;
    }

    public ForeignKey addColumn(String column, String table, Column reference) {
        if (this.setmap && null != this.update) {
            this.update.addColumn(column, table, reference);
            return this;
        }
        this.reference = new Table(table);
        this.addColumn(new Column(column).setReference(reference));
        return this;
    }

    public ForeignKey addColumn(String column, Column reference) {
        if (this.setmap && null != this.update) {
            this.update.addColumn(column, reference);
            return this;
        }
        this.addColumn(new Column(column).setReference(reference));
        return this;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public ForeignKey clone() {
        ForeignKey copy = (ForeignKey)super.clone();
        copy.reference = this.reference.clone();
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column column : this.columns.values()) {
            Column col = (Column)column.clone();
            cols.put(col.getName().toUpperCase(), col);
        }
        copy.columns = cols;
        return copy;
    }
}

