/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.anyline.util.BasicUtil;
import org.anyline.util.NumberTextUtil;

public class NumberUtil {
    public static String format(String src, String pattern) {
        if (BasicUtil.isEmpty((Object)src) || BasicUtil.isEmpty((Object)src.trim())) {
            return "";
        }
        BigDecimal num = null;
        try {
            num = new BigDecimal(src);
        }
        catch (Exception ignored) {
            return "";
        }
        return NumberUtil.format(num, pattern);
    }

    public static String format(Number src, String pattern) {
        if (null == src) {
            return "";
        }
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(src);
    }

    public static String upper(long num) {
        return NumberTextUtil.getInstance(NumberTextUtil.Lang.ChineseSimplified).getText(num);
    }

    public static BigDecimal max(BigDecimal ... nums) {
        BigDecimal max = nums[0];
        for (BigDecimal num : nums) {
            if (null == max) {
                max = num;
                continue;
            }
            if (null == num || max.compareTo(num) >= 0) continue;
            max = num;
        }
        return max;
    }

    public static BigDecimal min(BigDecimal ... nums) {
        BigDecimal min = nums[0];
        for (BigDecimal num : nums) {
            if (null == min) {
                min = num;
                continue;
            }
            if (null == num || min.compareTo(num) <= 0) continue;
            min = num;
        }
        return min;
    }

    public static double max(double ... nums) {
        double max = nums[0];
        for (double num : nums) {
            if (!(max < num)) continue;
            max = num;
        }
        return max;
    }

    public static double min(double ... nums) {
        double min = nums[0];
        for (double num : nums) {
            if (!(min > num)) continue;
            min = num;
        }
        return min;
    }

    public static int max(int ... nums) {
        int max = nums[0];
        for (int num : nums) {
            if (max >= num) continue;
            max = num;
        }
        return max;
    }

    public static int min(int ... nums) {
        int min = nums[0];
        for (int num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static long max(long ... nums) {
        long max = nums[0];
        int size = nums.length;
        for (int i = 0; i < size; ++i) {
            if (max >= nums[i]) continue;
            max = nums[i];
        }
        return max;
    }

    public static long min(long ... nums) {
        long min = nums[0];
        for (long num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static float max(float ... nums) {
        float max = nums[0];
        for (float num : nums) {
            if (!(max < num)) continue;
            max = num;
        }
        return max;
    }

    public static float min(float ... nums) {
        float min = nums[0];
        for (float num : nums) {
            if (!(min > num)) continue;
            min = num;
        }
        return min;
    }

    public static short max(short ... nums) {
        short max = nums[0];
        for (short num : nums) {
            if (max >= num) continue;
            max = num;
        }
        return max;
    }

    public static short min(short ... nums) {
        short min = nums[0];
        for (short num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static int random(int fr, int to) {
        int result = 0;
        Random r = new Random();
        result = fr + r.nextInt(to - fr);
        return result;
    }

    public static double random(double fr, double to) {
        double result = 0.0;
        Random r = new Random();
        result = fr + r.nextDouble() * (to - fr);
        return result;
    }

    public static long random(long fr, long to) {
        long result = 0L;
        Random r = new Random();
        result = fr + r.nextLong() * (to - fr);
        return result;
    }

    public static float random(float fr, float to) {
        float result = 0.0f;
        Random r = new Random();
        result = fr + r.nextFloat() * (to - fr);
        return result;
    }

    public static List<Integer> random(int fr, int to, int qty) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Random r = new Random();
        while (true) {
            int rdm;
            if (list.contains(rdm = fr + r.nextInt(to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Double> random(double fr, double to, int qty) {
        ArrayList<Double> list = new ArrayList<Double>();
        Random r = new Random();
        while (true) {
            double rdm;
            if (list.contains(rdm = fr + r.nextDouble() * (to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Float> random(float fr, float to, int qty) {
        ArrayList<Float> list = new ArrayList<Float>();
        Random r = new Random();
        while (true) {
            float rdm;
            if (list.contains(Float.valueOf(rdm = fr + r.nextFloat() * (to - fr)))) {
                continue;
            }
            list.add(Float.valueOf(rdm));
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Long> random(long fr, long to, int qty) {
        ArrayList<Long> list = new ArrayList<Long>();
        Random r = new Random();
        while (true) {
            long rdm;
            if (list.contains(rdm = fr + r.nextLong() * (to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static boolean isInt(double src) {
        return src == (double)((int)src);
    }

    public static boolean isInt(float src) {
        return src == (float)((int)src);
    }

    public static int bin2dec(String number) {
        return Integer.parseInt(number, 2);
    }

    public static String dec2bin(int number) {
        return Integer.toBinaryString((number & 0xFF) + 256).substring(1);
    }

    public static byte[] int2bytes(int in, boolean big) {
        byte[] bytes = new byte[4];
        int idx = 0;
        if (big) {
            for (int i = 3; i >= 0; --i) {
                bytes[i] = (byte)(0xFF & in >> idx++ * 8);
            }
        } else {
            for (int i = 0; i <= 3; ++i) {
                bytes[i] = (byte)(0xFF & in >> idx++ * 8);
            }
        }
        return bytes;
    }

    public static byte[] short2bytes(short in, boolean big) {
        byte[] bytes = new byte[2];
        int idx = 0;
        if (big) {
            for (int i = 1; i >= 0; --i) {
                bytes[i] = (byte)(0xFF & in >> idx++ * 8);
            }
        } else {
            for (int i = 0; i <= 1; ++i) {
                bytes[i] = (byte)(0xFF & in >> idx++ * 8);
            }
        }
        return bytes;
    }

    public static byte[] long2bytes(long in, boolean big) {
        byte[] bytes = new byte[8];
        int idx = 0;
        if (big) {
            for (int i = 7; i >= 0; --i) {
                bytes[i] = (byte)(0xFFL & in >> idx++ * 8);
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                bytes[i] = (byte)(0xFFL & in >> idx++ * 8);
            }
        }
        return bytes;
    }

    public static byte[] int2bytes(BigInteger n) {
        byte[] bytes = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            bytes = new byte[32];
            System.arraycopy(n.toByteArray(), 1, bytes, 0, 32);
        } else if (n.toByteArray().length == 32) {
            bytes = n.toByteArray();
        } else {
            bytes = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                bytes[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, bytes, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return bytes;
    }

    public static BigInteger byte2bigint(byte[] bytes) {
        if (bytes[0] < 0) {
            byte[] temp = new byte[bytes.length + 1];
            temp[0] = 0;
            System.arraycopy(bytes, 0, temp, 1, bytes.length);
            return new BigInteger(temp);
        }
        return new BigInteger(bytes);
    }

    public static int hex2dec(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static int hex2dec(String[] hex, int start, int len) {
        StringBuilder builder = new StringBuilder();
        int end = hex.length;
        for (int i = start; i < end && i < start + len; ++i) {
            builder.append(hex[i]);
        }
        return Integer.valueOf(builder.toString(), 16);
    }

    public static String byte2hex(byte[] bytes, String split) {
        return NumberUtil.byte2hex(bytes, bytes.length, split);
    }

    public static String byte2hex(byte[] bytes, int len) {
        return NumberUtil.byte2hex(bytes, len, null);
    }

    public static String byte2hex(byte[] bytes, int len, String split) {
        return NumberUtil.byte2hex(bytes, 0, len, split);
    }

    public static String byte2hex(byte[] bytes, int start, int len, String split) {
        StringBuffer builder = new StringBuffer();
        int size = 0;
        for (int i = start; i < start + len; ++i) {
            ++size;
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                builder.append(0);
            }
            builder.append(hex);
            if (size >= len || null == split) continue;
            builder.append(split);
        }
        return builder.toString();
    }

    public static String byte2hex(byte[] bytes) {
        return NumberUtil.byte2hex(bytes, null);
    }

    public static String[] byte2hexs(byte[] bytes) {
        String[] hexs = new String[bytes.length];
        for (int i = 0; i < hexs.length; ++i) {
            hexs[i] = NumberUtil.byte2hex(bytes[i]);
        }
        return hexs;
    }

    public static String byte2hex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String dec2hex(int number) {
        String hex = Integer.toHexString(number & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String[] dec2hex(int[] numbers) {
        String[] hex = new String[numbers.length];
        for (int i = 0; i < hex.length; ++i) {
            hex[i] = Integer.toHexString(numbers[i]);
        }
        return hex;
    }

    public static String byte2string(byte[] bytes, int start, int len, Charset charset) {
        byte[] bts = new byte[len];
        int max = bytes.length;
        int idx = 0;
        for (int i = start; i <= max && i < start + len; ++i) {
            bts[idx++] = bytes[i];
        }
        return new String(bts, charset);
    }

    public static String byte2string(byte[] bytes, int start, int len) {
        return NumberUtil.byte2string(bytes, start, len, StandardCharsets.UTF_8);
    }

    public static String byte2string(byte[] bytes) {
        return NumberUtil.byte2string(bytes, 0, bytes.length, StandardCharsets.UTF_8);
    }

    public static String byte2string(byte[] bytes, int start) {
        return NumberUtil.byte2string(bytes, start, bytes.length - start, StandardCharsets.UTF_8);
    }

    public static String byte2string(byte[] bytes, Charset charset) {
        return NumberUtil.byte2string(bytes, 0, bytes.length, charset);
    }

    public static byte[] hex2bytes(String hex) {
        byte[] result;
        int hexlen = hex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            hex = "0" + hex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = NumberUtil.hex2byte(hex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte hex2byte(String hex) {
        return (byte)Integer.parseInt(hex, 16);
    }

    public static byte[] dec2bcd(long num) {
        byte tmp;
        int i;
        int digits = 0;
        for (long temp = num; temp != 0L; temp /= 10L) {
            ++digits;
        }
        int len = digits % 2 == 0 ? digits / 2 : (digits + 1) / 2;
        byte[] bcd = new byte[len];
        for (i = 0; i < digits; ++i) {
            tmp = (byte)(num % 10L);
            if (i % 2 == 0) {
                bcd[i / 2] = tmp;
            } else {
                int n = i / 2;
                bcd[n] = (byte)(bcd[n] | (byte)(tmp << 4));
            }
            num /= 10L;
        }
        for (i = 0; i < len / 2; ++i) {
            tmp = bcd[i];
            bcd[i] = bcd[len - i - 1];
            bcd[len - i - 1] = tmp;
        }
        return bcd;
    }

    public static String byte2bin(byte b) {
        String value = Integer.toBinaryString((b & 0xFF) + 256).substring(1);
        return value;
    }

    public static int byte2decimal(byte res) {
        return res & 0xFF;
    }

    public static String byte2ascii(byte b) {
        StringBuilder sb = new StringBuilder();
        int value = NumberUtil.byte2decimal(b);
        sb.append((char)value);
        return sb.toString();
    }

    public static String byte2bcd(byte bit) {
        StringBuffer sb = new StringBuffer();
        byte high = (byte)(bit & 0xF0);
        high = (byte)(high >>> 4);
        high = (byte)(high & 0xF);
        byte low = (byte)(bit & 0xF);
        sb.append(high);
        sb.append(low);
        return sb.toString();
    }

    public static String bytes2bcd(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(NumberUtil.byte2bcd(bytes[i]));
        }
        return sb.toString();
    }

    public static String string2hex(String origin, String charset) {
        byte[] bytes = origin.getBytes(Charset.forName(charset));
        String hex = NumberUtil.byte2hex(bytes);
        return hex;
    }

    public static String string2hex(String origin) {
        return NumberUtil.string2hex(origin, "UTF-8");
    }

    public static String hex2string(String hex, String charset) {
        byte[] bytes = NumberUtil.hex2bytes(hex);
        return new String(bytes, Charset.forName(charset));
    }

    public static String hex2string(String hex) {
        return NumberUtil.hex2string(hex, "UTF-8");
    }

    public static String[] hex2array(String hex) {
        String[] array = new String[hex.length() / 2];
        int k = 2;
        for (int i = 0; i < array.length; ++i) {
            array[i] = hex.substring(i * 2, k);
            k += 2;
        }
        return array;
    }

    public static byte[] string2bytes(String src, String charset) {
        return src.getBytes(Charset.forName(charset));
    }

    public static byte[] string2bytes(String src) {
        return src.getBytes(StandardCharsets.UTF_8);
    }

    public static String string2ascii(String str) {
        String result = "";
        int max = str.length();
        for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            String b = Integer.toHexString(c);
            result = result + b;
        }
        return result;
    }

    public static String ascii2string(String content) {
        String result = "";
        int length = content.length() / 2;
        for (int i = 0; i < length; ++i) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = NumberUtil.hex2dec(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = result + d;
        }
        return result;
    }

    public static String compress(String src, boolean integer) {
        if (null != src) {
            int idx = src.indexOf(".");
            if (idx != -1) {
                src = src.replaceAll("^0+", "");
                src = src.replaceAll("0+$", "");
            }
            if (".".equals(src)) {
                src = integer ? "0" : "0.0";
            } else if (src.endsWith(".")) {
                src = integer ? src.substring(0, src.length() - 1) : src + "0";
            }
            if (src.startsWith(".")) {
                src = "0" + src;
            }
        }
        return src;
    }

    public static double compress(double src) {
        String str = NumberUtil.compress(src + "", false);
        src = BasicUtil.parseDouble(str, src);
        return src;
    }

    public static String compress(String src) {
        return NumberUtil.compress(src, false);
    }

    public static double[] byte2points(byte[] bytes) {
        int len = (bytes.length - 13) / 8;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = NumberUtil.byte2double(bytes, 13 + i * 8);
        }
        return result;
    }

    public static double byte2double(byte[] bytes, int start) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(bytes[start + i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(value);
    }

    public static byte[] double2bytes(double d) {
        long value = Double.doubleToRawLongBits(d);
        byte[] byteRet = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byteRet[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return byteRet;
    }

    public static Byte[] double2Bytes(double d) {
        long value = Double.doubleToRawLongBits(d);
        Byte[] byteRet = new Byte[8];
        for (int i = 0; i < 8; ++i) {
            byteRet[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return byteRet;
    }

    public static int byte2int(byte[] bytes, int start, int length, boolean big) {
        int value = 0;
        if (big) {
            for (int i = start; i < start + length; ++i) {
                value = value << 8 | bytes[i] & 0xFF;
            }
        } else {
            for (int i = start + length - 1; i >= start; --i) {
                value = value << 8 | bytes[i] & 0xFF;
            }
        }
        return value;
    }

    public static int byte2int(byte[] bytes, int start, int length) {
        return NumberUtil.byte2int(bytes, start, length, true);
    }

    public static int byte2int(byte[] bytes, int start) {
        return NumberUtil.byte2int(bytes, start, NumberUtil.min(4, bytes.length), true);
    }

    public static int byte2int(byte[] bytes, int start, boolean big) {
        return NumberUtil.byte2int(bytes, start, NumberUtil.min(4, bytes.length), big);
    }

    public static short byte2short(byte[] bytes, int start, int length) {
        return (short)NumberUtil.byte2int(bytes, start, length, true);
    }

    public static short byte2short(byte[] bytes, int start) {
        return (short)NumberUtil.byte2int(bytes, start, NumberUtil.min(2, bytes.length), true);
    }

    public static short byte2short(byte[] bytes, int start, boolean big) {
        return (short)NumberUtil.byte2int(bytes, start, NumberUtil.min(2, bytes.length), big);
    }

    public static BigDecimal avg(List<BigDecimal> list, int scale, int round) {
        int qty = 0;
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null != item) {
                sum = sum.add(item);
            }
            if (null == item) continue;
            ++qty;
        }
        if (qty > 0) {
            return sum.divide(new BigDecimal(qty), scale, round);
        }
        return null;
    }

    public static BigDecimal avga(List<BigDecimal> list, int scale, int round) {
        int qty = list.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null == item) continue;
            sum = sum.add(item);
        }
        if (qty > 0) {
            return sum.divide(new BigDecimal(qty), scale, round);
        }
        return null;
    }

    public static BigDecimal var(List<BigDecimal> list, int scale, int round) {
        int qty = 0;
        BigDecimal avg = NumberUtil.avg(list, scale, round);
        BigDecimal var = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null != item) {
                BigDecimal sub = item.subtract(avg);
                var = var.add(sub.multiply(sub));
            }
            if (null == item) continue;
            ++qty;
        }
        if (qty > 1) {
            return var.divide(new BigDecimal(qty - 1), scale, round);
        }
        return null;
    }

    public static BigDecimal vara(List<BigDecimal> list, int scale, int round) {
        int qty = list.size();
        BigDecimal avg = NumberUtil.avga(list, scale, round);
        BigDecimal var = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null == item) continue;
            BigDecimal sub = item.subtract(avg);
            var = var.add(sub.multiply(sub));
        }
        if (qty > 1) {
            return var.divide(new BigDecimal(qty - 1), scale, round);
        }
        return null;
    }

    public static BigDecimal varp(List<BigDecimal> list, int scale, int round) {
        int qty = 0;
        BigDecimal avg = NumberUtil.avg(list, scale, round);
        BigDecimal var = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null != item) {
                BigDecimal sub = item.subtract(avg);
                var = var.add(sub.multiply(sub));
            }
            if (null == item) continue;
            ++qty;
        }
        if (qty > 0) {
            return var.divide(new BigDecimal(qty), scale, round);
        }
        return null;
    }

    public static BigDecimal varpa(List<BigDecimal> list, int scale, int round) {
        int qty = list.size();
        BigDecimal avg = NumberUtil.avga(list, scale, round);
        BigDecimal var = BigDecimal.ZERO;
        for (BigDecimal item : list) {
            if (null == item) continue;
            BigDecimal sub = item.subtract(avg);
            var = var.add(sub.multiply(sub));
        }
        if (qty > 0) {
            return var.divide(new BigDecimal(qty), scale, round);
        }
        return null;
    }

    public static BigDecimal stdev(List<BigDecimal> list, int scale, int round) {
        BigDecimal var = NumberUtil.var(list, scale, round);
        if (null != var) {
            return new BigDecimal(Math.sqrt(var.doubleValue())).setScale(scale, round);
        }
        return null;
    }

    public static BigDecimal stdeva(List<BigDecimal> list, int scale, int round) {
        BigDecimal var = NumberUtil.vara(list, scale, round);
        if (null != var) {
            return new BigDecimal(Math.sqrt(var.doubleValue())).setScale(scale, round);
        }
        return null;
    }

    public static BigDecimal stdevp(List<BigDecimal> list, int scale, int round) {
        BigDecimal var = NumberUtil.varp(list, scale, round);
        if (null != var) {
            return new BigDecimal(Math.sqrt(var.doubleValue())).setScale(scale, round);
        }
        return null;
    }

    public static BigDecimal stdevpa(List<BigDecimal> list, int scale, int round) {
        BigDecimal var = NumberUtil.varpa(list, scale, round);
        if (null != var) {
            return new BigDecimal(Math.sqrt(var.doubleValue())).setScale(scale, round);
        }
        return null;
    }
}

