/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.util.BasicUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnylineConfig {
    protected static long lastLoadTime = 0L;
    protected static final Logger log = LoggerFactory.getLogger(AnylineConfig.class);
    protected Map<String, String> kvs = new HashMap<String, String>();
    protected static String[] compatibles = new String[0];
    public static final String DEFAULT_INSTANCE_KEY = "default";
    public String INSTANCE_KEY = "";
    private static boolean listener_running = false;
    protected static Map<String, Map<String, Object>> listener_files = new Hashtable<String, Map<String, Object>>();

    protected void afterParse(String key, String value) {
    }

    public static void parse(String content) {
    }

    protected static synchronized void load(Hashtable<String, AnylineConfig> instances, Class<? extends AnylineConfig> clazz, String fileName, String ... compatibles) {
        try {
            int configSize = 0;
            if ("jar".equals(ConfigTable.getProjectProtocol())) {
                InputStream in = null;
                log.info("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6][type:jar][file:{}]", (Object)fileName);
                if (FileUtil.getPathType(AnylineConfig.class) == 0) {
                    JarFile jar = new JarFile(System.getProperty("java.class.path"));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.endsWith(fileName)) continue;
                        in = jar.getInputStream(entry);
                        AnylineConfig.parse(clazz, in, instances, compatibles);
                        ++configSize;
                    }
                } else {
                    in = ConfigTable.class.getClassLoader().getResourceAsStream("/" + fileName);
                    String txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
                    AnylineConfig.parse(txt);
                }
                File dir = new File(FileUtil.merge(ConfigTable.getRoot(), "config"));
                if (null != dir && !dir.exists()) {
                    dir = new File(ConfigTable.getWebRoot());
                }
                List<File> files = FileUtil.getAllChildrenFile(dir, "xml");
                for (File file : files) {
                    if (!fileName.equals(file.getName())) continue;
                    AnylineConfig.parse(clazz, file, instances, compatibles);
                    ++configSize;
                }
            } else {
                File dir = new File(ConfigTable.getClassPath());
                if (!dir.exists()) {
                    dir = new File(ConfigTable.getWebRoot());
                }
                List<File> files = FileUtil.getAllChildrenFile(dir, "xml");
                for (File file : files) {
                    if (!fileName.equals(file.getName())) continue;
                    AnylineConfig.parse(clazz, file, instances, compatibles);
                    ++configSize;
                }
            }
            log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][\u6587\u4ef6:{}][\u6570\u91cf:{}/{}][\u8bf7\u53c2\u8003:http://doc.anyline.org\u6216\u6e90\u7801\u4e2dresources/{}]", new Object[]{fileName, configSize, instances.size(), fileName});
        }
        catch (Exception e) {
            log.error("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][file:{}][\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5f02\u5e38:{}]", (Object)fileName, (Object)e.getMessage());
        }
    }

    public static <T extends AnylineConfig> T parse(Class<? extends AnylineConfig> T, String instance, DataRow row, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        AnylineConfig config = null;
        try {
            config = T.newInstance();
            List<Field> fields = ClassUtil.getFields(T, false, false);
            HashMap<String, String> kvs = new HashMap<String, String>();
            config.kvs = kvs;
            for (Field field : fields) {
                String nm = field.getName();
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !"String".equals(field.getType().getSimpleName()) || !nm.equals(nm.toUpperCase())) continue;
                try {
                    String value = row.getString(nm);
                    config.setValue(nm, value);
                    log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][{}={}]", (Object)nm, (Object)value);
                    kvs.put(nm, value);
                    config.afterParse(nm, value);
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:", (Throwable)e);
                }
            }
            if (null != compatibles) {
                block5: for (String compatible : compatibles) {
                    String[] keys = compatible.split(":");
                    if (keys.length <= 1) continue;
                    String newKey = keys[0];
                    for (int i = 1; i < keys.length; ++i) {
                        String oldKey = keys[i];
                        if (BasicUtil.isNotEmpty(kvs.get(newKey))) continue block5;
                        if (!row.containsKey(oldKey)) continue;
                        String val = row.getString(oldKey);
                        kvs.put(newKey, val);
                        config.setValue(newKey, val);
                        config.afterParse(newKey, val);
                        log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][\u7248\u672c\u517c\u5bb9][last key:{}][old key:{}][value:{}]", new Object[]{newKey, oldKey, val});
                    }
                }
            }
            config.INSTANCE_KEY = instance;
            instances.put(instance, config);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:", (Throwable)e);
        }
        return (T)config;
    }

    public static Hashtable<String, AnylineConfig> parse(Class<? extends AnylineConfig> T, String column, DataSet set, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        for (DataRow row : set) {
            String key = row.getString(column);
            AnylineConfig.parse(T, key, row, instances, compatibles);
        }
        return instances;
    }

    private static Hashtable<String, AnylineConfig> parse(Class<?> T, Document document, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        try {
            Element root = document.getRootElement();
            Iterator itrConfig = root.elementIterator("config");
            while (itrConfig.hasNext()) {
                AnylineConfig config;
                Element configElement = (Element)itrConfig.next();
                String configKey = configElement.attributeValue("key");
                if (BasicUtil.isEmpty((Object)configKey)) {
                    configKey = DEFAULT_INSTANCE_KEY;
                }
                if (null == (config = instances.get(configKey))) {
                    config = (AnylineConfig)T.newInstance();
                }
                HashMap<String, String> kvs = new HashMap<String, String>();
                Iterator elements = configElement.elementIterator("property");
                while (elements.hasNext()) {
                    Element element = (Element)elements.next();
                    String key = element.attributeValue("key");
                    String value = element.getTextTrim();
                    log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][key:{}][{}={}]", new Object[]{configKey, key, value});
                    kvs.put(key, value);
                    config.setValue(key, value);
                }
                if (null != compatibles) {
                    block4: for (String compatible : compatibles) {
                        String[] keys = compatible.split(":");
                        if (keys.length <= 1) continue;
                        String newKey = keys[0];
                        for (int i = 1; i < keys.length; ++i) {
                            String oldKey = keys[i];
                            if (kvs.containsKey(newKey)) continue block4;
                            Element element = configElement.element(oldKey);
                            if (null == element) continue;
                            String val = element.getTextTrim();
                            kvs.put(newKey, val);
                            log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][\u7248\u672c\u517c\u5bb9][laster key:{}][old key:{}][value:{}]", new Object[]{newKey, oldKey, val});
                        }
                    }
                }
                config.kvs = kvs;
                config.INSTANCE_KEY = configKey;
                instances.put(configKey, config);
            }
        }
        catch (Exception e) {
            log.error("parse dom exception:", (Throwable)e);
        }
        return instances;
    }

    protected static Hashtable<String, AnylineConfig> parse(Class<?> T, String content, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        try {
            if (BasicUtil.isNotEmpty(content)) {
                Document document = DocumentHelper.parseText((String)content);
                instances = AnylineConfig.parse(T, document, instances, compatibles);
            }
        }
        catch (Exception e) {
            log.error("parse dom exception:", (Throwable)e);
        }
        return instances;
    }

    private static synchronized void listener() {
        if (listener_running) {
            return;
        }
        listener_running = true;
        log.info("[\u542f\u52a8\u672c\u5730\u914d\u7f6e\u76d1\u542c]");
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (Map.Entry<String, Map<String, Object>> item : listener_files.entrySet()) {
                        File file = new File(item.getKey());
                        Map<String, Object> params = item.getValue();
                        Class T = (Class)params.get("CLAZZ");
                        Hashtable instances = (Hashtable)params.get("INSTANCES");
                        String[] compatibles = (String[])params.get("COMPATIBLES");
                        Long lastLoad = (Long)params.get("LAST_LOAD");
                        Long lastModify = file.lastModified();
                        if (lastLoad != 0L && lastModify <= lastLoad) continue;
                        String txt = FileUtil.read(file).toString();
                        AnylineConfig.parse(T, txt, (Hashtable<String, AnylineConfig>)instances, compatibles);
                        params.put("LAST_LOAD", System.currentTimeMillis());
                        listener_files.put(file.getAbsolutePath(), params);
                    }
                    if (ConfigTable.getInt("RELOAD", 0) != 0) break;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                }
                listener_running = false;
            }
        }).start();
    }

    protected static Hashtable<String, AnylineConfig> parse(Class<?> T, File file, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][file:{}]", (Object)file);
        if (null == file || !file.exists()) {
            log.warn("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)file);
            return instances;
        }
        AnylineConfig.addListener(file, T, instances, compatibles);
        String txt = FileUtil.read(file).toString();
        AnylineConfig.parse(T, txt, instances, compatibles);
        if (ConfigTable.getInt("RELOAD", 0) == 0) {
            AnylineConfig.listener();
        }
        return instances;
    }

    public static Map<String, Map<String, Object>> getListeners() {
        return listener_files;
    }

    public static Map<String, Object> addListener(File file, Class clazz, Hashtable<String, AnylineConfig> instances, String[] compatibles) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CLAZZ", clazz);
        params.put("INSTANCES", instances);
        params.put("COMPATIBLES", compatibles);
        params.put("LAST_LOAD", System.currentTimeMillis());
        listener_files.put(file.getAbsolutePath(), params);
        return params;
    }

    protected static Hashtable<String, AnylineConfig> parse(Class<?> T, InputStream is, Hashtable<String, AnylineConfig> instances, String ... compatibles) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            instances = AnylineConfig.parse(T, document, instances, compatibles);
        }
        catch (Exception e) {
            log.error("parser stream exception:", (Throwable)e);
        }
        return instances;
    }

    protected void setValue(String key, String value) {
        Field field = null;
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(key);
                if (null == field) continue;
                this.setValue(field, value);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setValue(Field field, String value) {
        if (null != field) {
            try {
                Object val = value;
                Type type = field.getGenericType();
                String typeName = type.getTypeName();
                if (typeName.startsWith("int") || typeName.contains("Integer")) {
                    val = BasicUtil.parseInt(value, 0);
                } else if (typeName.contains("long") || typeName.contains("Long")) {
                    val = BasicUtil.parseLong(value, 0L);
                } else if (typeName.contains("double") || typeName.contains("Double")) {
                    val = BasicUtil.parseDouble(value, 0.0);
                } else if (typeName.contains("boolean") || typeName.contains("Boolean")) {
                    val = BasicUtil.parseBoolean(value);
                }
                if (field.isAccessible()) {
                    field.set(this, val);
                } else {
                    field.setAccessible(true);
                    field.set(this, val);
                    field.setAccessible(false);
                }
            }
            catch (Exception e) {
                log.error("set field value exception:", (Throwable)e);
            }
        }
    }
}

