/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.anyline.adapter.init.JavaTypeAdapter;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.ConvertException;
import org.anyline.metadata.type.DataType;
import org.anyline.metadata.type.init.AbstractConvert;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertProxy {
    private static final Logger log = LoggerFactory.getLogger(ConvertProxy.class);
    public static Map<Class, Map<Class, Convert>> converts = new Hashtable<Class, Map<Class, Convert>>();

    public static void reg(Convert convert) {
        Class origin = convert.getOrigin();
        Class target = convert.getTarget();
        Map map = converts.computeIfAbsent(origin, k -> new Hashtable());
        map.put(target, convert);
        DataType type = JavaTypeAdapter.types.get(origin);
        if (null != type) {
            type.convert(convert);
        }
    }

    public static Convert getConvert(Class origin, Class target) {
        Map<Class, Convert> map = converts.get(origin);
        if (null != map) {
            return map.get(target);
        }
        return null;
    }

    public static Object convert(Object value, Class target, boolean array) {
        return ConvertProxy.convert(value, target, array, null);
    }

    public static Object convert(Object value, Class target, boolean array, Object def) {
        return ConvertProxy.convert(value, target, array, def, true);
    }

    public static <T> Object convert(Object value, Class<T> target, boolean array, Object def, boolean warn) {
        Object result;
        if (null == value) {
            value = def;
        }
        if (null != (result = value) && null != target) {
            boolean success;
            Class<?> clazz;
            block40: {
                clazz = result.getClass();
                if (ClassUtil.isInSub(clazz, target)) {
                    return result;
                }
                if (result instanceof Map && ClassUtil.isWrapClass(target) && target != String.class) {
                    result = result instanceof DataRow ? ((DataRow)result).entity(target, new String[0]) : BeanUtil.map2object((Map)result, target, new String[0]);
                    return result;
                }
                if (array && (value instanceof Collection || value.getClass().isArray())) {
                    List list = BeanUtil.list(value);
                    int size = list.size();
                    Object[] arrays = (Object[])Array.newInstance(target, size);
                    int idx = 0;
                    for (Object item : list) {
                        arrays[idx++] = ConvertProxy.convert(item, target, false, def, warn);
                    }
                    return arrays;
                }
                if (target == String.class) {
                    if (value instanceof Collection) {
                        Collection col = (Collection)value;
                        Class component = ClassUtil.getComponentClass(value);
                        if (ClassUtil.isPrimitiveClass(component) || component == String.class) {
                            if ("concat".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                                return BeanUtil.concat(col);
                            }
                            if ("json".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                                return BeanUtil.object2json(col);
                            }
                        }
                    } else if (value.getClass().isArray()) {
                        Class component = ClassUtil.getComponentClass(value);
                        Object[] list = null;
                        if (component == String.class) {
                            list = (String[])value;
                        } else if (component == Integer.TYPE) {
                            list = BeanUtil.int2Integer((int[])value);
                        } else if (component == Double.TYPE) {
                            list = BeanUtil.double2Double((double[])value);
                        } else if (component == Long.TYPE) {
                            list = BeanUtil.long2Long((long[])value);
                        } else if (component == Float.TYPE) {
                            list = BeanUtil.float2Float((float[])value);
                        }
                        if (null != list) {
                            if ("concat".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                                return BeanUtil.concat(list);
                            }
                            if ("json".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                                return BeanUtil.object2json(list);
                            }
                        }
                    } else {
                        if (value instanceof Map) {
                            Map map = (Map)value;
                            return BeanUtil.map2object(map, target, new String[0]);
                        }
                        if (ClassUtil.isPrimitiveClass(value.getClass()) || value instanceof String) {
                            return value.toString();
                        }
                    }
                }
                success = false;
                Map<Class, Convert> map = converts.get(clazz);
                Convert convert = null;
                if (null != map) {
                    convert = map.get(target);
                    if (null != convert) {
                        try {
                            result = convert.exe(value, def);
                            success = true;
                        }
                        catch (ConvertException e) {
                            if (ConfigTable.IS_LOG_CONVERT_EXCEPTION) {
                                e.printStackTrace();
                            }
                        }
                    } else if (target == String.class) {
                        result = value.toString();
                        success = true;
                    }
                }
                if (!success) {
                    try {
                        result = target.cast(value);
                        success = true;
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_LOG_CONVERT_EXCEPTION) break block40;
                        e.printStackTrace();
                    }
                }
            }
            if (!success && warn) {
                log.warn("[{}][origin:{}][target:{}][value:{}]", new Object[]{LogUtil.format("convert\u5b9a\u4f4d\u5931\u8d25", 31), ClassUtil.type(clazz), ClassUtil.type(target), value});
                if (ConfigTable.IS_THROW_CONVERT_EXCEPTION) {
                    throw new RuntimeException("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                }
            }
        }
        return result;
    }

    static {
        ConvertProxy.reg(new AbstractConvert(String.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                try {
                    return BasicUtil.parseBoolean(value);
                }
                catch (Exception e) {
                    return value;
                }
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                try {
                    return (boolean)BasicUtil.parseBoolean(value);
                }
                catch (Exception e) {
                    return value;
                }
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                try {
                    return BasicUtil.parseDecimal(value, null);
                }
                catch (Exception e) {
                    return value;
                }
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(BasicUtil.parseLong(value, null));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseInt(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)BasicUtil.parseInt(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseLong(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)BasicUtil.parseLong(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseDouble(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)BasicUtil.parseDouble(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseFloat(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(BasicUtil.parseFloat(value, null).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseShort(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)BasicUtil.parseShort(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BasicUtil.parseByte(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (byte)BasicUtil.parseByte(value, null);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(value.toString().toCharArray()[0]);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(value.toString().toCharArray()[0]);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (boolean)((Boolean)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return BigInteger.ONE;
                }
                return BigInteger.ZERO;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Short.valueOf("1");
                }
                return Short.valueOf("0");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return (short)Short.valueOf("1");
                }
                return (short)Short.valueOf("0");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Byte.valueOf("1");
                }
                return Byte.valueOf("0");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return (byte)1;
                }
                return (byte)0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Character.valueOf('1');
                }
                return Character.valueOf('0');
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Character.valueOf('1');
                }
                return Character.valueOf('0');
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (boolean)((Boolean)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return BigInteger.ONE;
                }
                return BigInteger.ZERO;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Short.valueOf("1");
                }
                return Short.valueOf("0");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return (short)1;
                }
                return (short)0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Byte.valueOf("1");
                }
                return Byte.valueOf("0");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return (byte)1;
                }
                return (byte)0;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Character.valueOf('1');
                }
                return Character.valueOf('0');
            }
        });
        ConvertProxy.reg(new AbstractConvert(Boolean.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Boolean)value).booleanValue()) {
                    return Character.valueOf('1');
                }
                return Character.valueOf('0');
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (value.equals("0")) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (value.equals("0")) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).toBigInteger();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigDecimal)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((BigDecimal)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigDecimal.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((BigDecimal)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (value.equals("0")) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (value.equals("0")) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return new BigDecimal((BigInteger)value, 0);
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((BigInteger)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((BigInteger)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((BigInteger)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((BigInteger)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(BigInteger.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((BigInteger)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return new BigDecimal((Integer)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Integer)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Integer)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Integer)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Integer)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit((Integer)value, 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit((Integer)value, 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Integer)value).intValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Integer)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Integer)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Integer)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Integer)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Integer)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Integer)value).intValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Integer)value).intValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf((Integer)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf((Integer)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf((Integer)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf((Integer)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit((Integer)value, 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Integer.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit((Integer)value, 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Long)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Long)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Long)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Long)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Long)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ("0".equals(value)) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Long)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Long)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Long)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Long)value).longValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Long)value).longValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Long.valueOf((Long)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(Long.valueOf((Long)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(Long.valueOf((Long)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ((Double)value == 0.0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ((Double)value == 0.0) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf((Double)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Double)value).longValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Double)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(value.toString());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(value.toString()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Double)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Double)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Double)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ((Double)value == 0.0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ((Double)value == 0.0) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf((Double)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(Double.valueOf((Double)value).longValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf((Double)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf((Double)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf((Double)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf((Double)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Double)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(value.toString()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Double.valueOf(value.toString()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf(value.toString()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf((Double)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf(value.toString()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Double.valueOf(value.toString()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Double)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Double)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Float)value).floatValue() == 0.0f) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Float)value).floatValue() == 0.0f) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Float)value).longValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)Double.valueOf(value.toString());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)Double.valueOf(value.toString());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Float)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Float)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Float)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Float)value).floatValue() == 0.0f) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (((Float)value).floatValue() == 0.0f) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(Float.valueOf(((Float)value).floatValue()).longValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(value.toString()).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Float)value).floatValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(Float.valueOf(((Float)value).floatValue()).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Float.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(Float.valueOf(((Float)value).floatValue()).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(UUID.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Short)value) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Short)value) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Short)value).shortValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Short)value).shortValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Short)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Short)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)((Short)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Short)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Short)value).intValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Short)value) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Short)value) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Short)value).shortValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Short)value).shortValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Short)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Short)value).shortValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Short)value).shortValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)((Short)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Short)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Short)value).shortValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Short.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Short)value).shortValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Byte)value) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Byte)value) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Byte)value).intValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Byte)value).longValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Byte)value).doubleValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Byte)value).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((Byte)value).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (byte)((Byte)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Byte)value).byteValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Byte)value).byteValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Byte)value) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if (0 == (Byte)value) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Byte)value).byteValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Byte)value).byteValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (short)((Byte)value).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (byte)((Byte)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Byte)value).byteValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Byte.TYPE, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(Character.forDigit(((Byte)value).byteValue(), 10));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ('\u0000' == ((Character)value).charValue()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ('\u0000' == ((Character)value).charValue()) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigInteger.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Character)value).charValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.class, Character.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Boolean.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ('\u0000' == ((Character)value).charValue()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Boolean.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                if ('\u0000' == ((Character)value).charValue()) {
                    return false;
                }
                return true;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, BigDecimal.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, BigInteger.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BigDecimal.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Integer.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Integer.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (int)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Double.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Double.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (double)((Character)value).charValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Float.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Float.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Float.valueOf(Float.valueOf(((Character)value).charValue()).floatValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Short.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Short.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).shortValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Byte.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Byte.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Integer.valueOf(((Character)value).charValue()).byteValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Character.TYPE, Character.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Character.valueOf(((Character)value).charValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Year year = Year.of(DateUtil.year(date));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Year.of(DateUtil.year(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Year year = Year.of(DateUtil.year(date));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Long.TYPE, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((java.util.Date)value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((java.util.Date)value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Year year = Year.of(DateUtil.year((java.util.Date)value));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = (java.util.Date)value;
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = (java.util.Date)value;
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(java.util.Date.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime((java.util.Date)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value), "yyyy-MM-dd");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Year year = Year.of(DateUtil.year(date));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Date.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value), "HH:mm:ss");
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Year year = Year.of(DateUtil.year(date));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Time.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Year year = Year.of(DateUtil.year(date));
                return year;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                Month month = Month.of(DateUtil.month(date));
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Timestamp.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Year)value).getValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return (long)((Year)value).getValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return date;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.sqlDate(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.sqlTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.sqlTimestamp(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
                return yearMonth;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Month month = Month.of(1);
                return month;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.localDate(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.localTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Year.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(((Year)value).getValue() + "-01-01");
                return DateUtil.localDateTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                int m = month.getMonthValue();
                if (m < 10) {
                    return month.getYear() + "-0" + m;
                }
                return month.getYear() + "-" + m;
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return date.getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return date.getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return date;
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.sqlDate(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.sqlTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.sqlTimestamp(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                return Year.of(month.getYear());
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                return Month.of(month.getMonthValue());
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.localDate(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.localTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(YearMonth.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                YearMonth month = (YearMonth)value;
                java.util.Date date = DateUtil.parse(month.getYear() + "-" + month.getMonthValue() + "-01");
                return DateUtil.localDateTime(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Month.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Month month = (Month)value;
                if (month.getValue() < 10) {
                    return "0" + month.getValue();
                }
                return "" + month.getValue();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Month.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return YearMonth.of(DateUtil.year(), (Month)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Year.of(DateUtil.year(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                return YearMonth.of(DateUtil.year(date), DateUtil.month(date));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                return Month.of(DateUtil.month(date));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDate.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value), "HH:mm:ss");
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Year.of(DateUtil.year(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                return DateUtil.yearMonth(date);
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                java.util.Date date = DateUtil.parse(value);
                return Month.of(DateUtil.month(date));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalTime.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Year.of(DateUtil.year(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.yearMonth(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Month.of(DateUtil.month(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(LocalDateTime.class, ZonedDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.zonedDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.format(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Long.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Long.TYPE){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value).getTime();
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, java.util.Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.parse(value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Date.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Time.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Timestamp.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.sqlTimestamp(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Year.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Year.of(DateUtil.year(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, YearMonth.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.yearMonth(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, Month.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return Month.of(DateUtil.month(DateUtil.parse(value)));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, LocalDate.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDate(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, LocalTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(ZonedDateTime.class, LocalDateTime.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DateUtil.localDateTime(DateUtil.parse(value));
            }
        });
        ConvertProxy.reg(new AbstractConvert(Double[].class, Point.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Point point = new Point((Double[])value);
                return point;
            }
        });
        ConvertProxy.reg(new AbstractConvert(double[].class, Point.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Point point = new Point((double[])value);
                return point;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Point.class, int[].class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Point point = (Point)value;
                try {
                    int[] ints = new int[]{point.x().intValue(), point.y().intValue()};
                    value = ints;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return value;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Point.class, Double[].class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Point point = (Point)value;
                Double[] xy = new Double[]{point.x(), point.y()};
                value = xy;
                return value;
            }
        });
        ConvertProxy.reg(new AbstractConvert(Point.class, double[].class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                Point point = (Point)value;
                try {
                    value = point.doubles();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return value;
            }
        });
        ConvertProxy.reg(new AbstractConvert(byte[].class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return new String((byte[])value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(DataRow.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((DataRow)value).toJSON();
            }
        });
        ConvertProxy.reg(new AbstractConvert(DataSet.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return ((DataSet)value).toJSON();
            }
        });
        ConvertProxy.reg(new AbstractConvert(Map.class, String.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return BeanUtil.map2json((Map)value);
            }
        });
        ConvertProxy.reg(new AbstractConvert(Map.class, DataRow.class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return DataRow.parse((Map)value, new String[0]);
            }
        });
        ConvertProxy.reg(new AbstractConvert(String.class, byte[].class){

            @Override
            public Object exe(Object value, Object def) throws ConvertException {
                return value.toString().getBytes();
            }
        });
    }
}

