/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Td;
import org.anyline.entity.html.Tr;
import org.anyline.util.BeanUtil;
import org.dom4j.Element;

public class Table {
    private String clazz;
    private List<Tr> trs = new ArrayList<Tr>();
    private String header = null;
    private String footer = null;
    private boolean isOffset = false;
    private Map<String, String> styles = new LinkedHashMap<String, String>();
    private List<Integer> mergeRows = new ArrayList<Integer>();
    private Map<Integer, List<Integer>> refs = new LinkedHashMap<Integer, List<Integer>>();
    private List<Integer[]> mergeCols = new ArrayList<Integer[]>();
    private Element src;
    private String widthUnit = "px";

    public Table() {
    }

    public Table(int rows, int cols) {
        this.trs = new ArrayList<Tr>();
        for (int r = 0; r < rows; ++r) {
            Tr tr = new Tr();
            tr.setTable(this);
            for (int c = 0; c < cols; ++c) {
                Td td = new Td();
                tr.addTd(td);
            }
            this.trs.add(tr);
        }
    }

    public Td getTd(int row, int col) {
        return this.trs.get(row).getTd(col);
    }

    public List<Tr> getTrs() {
        return this.trs;
    }

    public void setTrs(List<Tr> trs) {
        this.trs = trs;
    }

    public Map<String, String> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<String, String> styles) {
        this.styles = styles;
    }

    public Tr getTr(int index) {
        return this.trs.get(index);
    }

    public Table setTd(int rows, int cols, Td td) {
        this.trs.get(rows).setTd(cols, td);
        return this;
    }

    public Table setWidth(String width) {
        if (null == this.styles) {
            this.styles = new HashMap<String, String>();
        }
        this.styles.put("width", width);
        return this;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Tr tr : this.trs) {
            tr.setWidthUnit(widthUnit);
        }
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public Table addTr(Tr tr) {
        this.trs.add(tr);
        tr.setTable(this);
        return this;
    }

    public Table addColumns(int qty) {
        this.insertColumns(-1, qty);
        return this;
    }

    public Table insertColumns(int col, int qty) {
        for (Tr tr : this.trs) {
            List<Td> tds = tr.getTds();
            int cols = tds.size();
            if (cols > 0 && col < cols) {
                Td template = null;
                template = col == 0 ? tds.get(0) : (col == -1 ? tds.get(cols - 1) : tds.get(col - 1));
                int index = col;
                for (int i = 0; i < qty; ++i) {
                    Td newTc = template.createCopy();
                    newTc.setTr(tr);
                    if (col == -1) {
                        tds.add(newTc);
                        continue;
                    }
                    tds.add(index++, newTc);
                }
                continue;
            }
            for (int i = 0; i < qty; ++i) {
                tr.addTd(new Td());
            }
        }
        return this;
    }

    public Table insertRows(int index, int qty) {
        if (this.trs.size() > 0) {
            Tr template = null;
            if (index > 0 && index < this.trs.size() - 1) {
                template = this.getTr(index - 1);
            } else if (index == -1) {
                template = this.getTr(this.trs.size() - 1);
            }
            this.insertRows(template, index, qty);
        }
        return this;
    }

    public Table insertRows(Tr template, int index, int qty) {
        if (this.trs.size() > 0) {
            if (null == template) {
                template = this.trs.get(this.trs.size() - 1);
            }
            for (int i = 0; i < qty; ++i) {
                Tr newTr = template.createCopy();
                newTr.setTable(this);
                if (index != -1) {
                    this.trs.add(index++, newTr);
                    continue;
                }
                this.trs.add(newTr);
            }
        }
        return this;
    }

    public Table addRows(int qty) {
        return this.insertRows(-1, qty);
    }

    public Table addRows(int index, int qty) {
        return this.insertRows(index, qty);
    }

    public String build(boolean box) {
        this.merge();
        StringBuilder builder = new StringBuilder();
        int rows = this.trs.size();
        int cols = 0;
        if (rows > 0) {
            cols = this.trs.get(0).getTds().size();
        }
        if (box) {
            builder.append("<table");
            if (null != this.clazz) {
                builder.append(" class='").append(this.clazz).append("'");
            }
            if (null != this.styles && !this.styles.isEmpty()) {
                builder.append(" style='");
                for (String key : this.styles.keySet()) {
                    builder.append(key).append(":").append(this.styles.get(key)).append(";");
                }
                builder.append("'");
            }
            builder.append(">\n");
        }
        if (null != this.header) {
            builder.append(this.header);
        }
        for (Tr tr : this.trs) {
            tr.build(builder);
            builder.append("\r\n");
        }
        if (null != this.footer) {
            builder.append(this.footer);
        }
        if (box) {
            builder.append("</table>");
        }
        return builder.toString();
    }

    public String build() {
        return this.build(true);
    }

    private int checkColspan(Td td, int qty) {
        int colspan = 1;
        int[] index = td.index();
        int end = index[1] + qty;
        String value = td.getText();
        if (null != value) {
            for (int i = index[1] + 1; i <= end; ++i) {
                Td cur = this.getTd(index[0], i);
                if (!value.equals(cur.getText())) continue;
                ++colspan;
            }
        }
        return colspan;
    }

    private void exeMergeCol() {
        int rows = this.trs.size();
        for (int r = 0; r < rows; ++r) {
            Tr tr = this.getTr(r);
            for (Integer[] mergeCol : this.mergeCols) {
                int mergeIndex = mergeCol[0];
                int mergeQty = mergeCol[1];
                for (int i = mergeIndex; i < mergeIndex + mergeQty; ++i) {
                    Td td = this.getTd(r, mergeIndex);
                    int colspan = this.checkColspan(td, mergeQty);
                    if (colspan <= 1) continue;
                    td.setColspan(colspan);
                    td.merge();
                }
            }
        }
        for (Tr tr : this.trs) {
            for (Td td : tr.getTds()) {
                td.merge();
            }
        }
    }

    private int checkRowspan(Td td) {
        int qty = 1;
        int r = td.getRowIndex();
        int c = td.getColIndex();
        String value = td.getText();
        if (null != value) {
            Td cur;
            String cvalue;
            int size = this.trs.size();
            for (int i = r + 1; i < size && value.equals(cvalue = (cur = this.getTd(i, c)).getText()); ++i) {
                List<Integer> curRefs = this.refs.get(c);
                boolean refMerge = true;
                if (null == curRefs) continue;
                for (Integer refIndex : curRefs) {
                    Td prev = this.getTd(i, refIndex);
                    if (prev.isRemove()) continue;
                    refMerge = false;
                    break;
                }
                if (!refMerge) continue;
                ++qty;
            }
        }
        return qty;
    }

    private void exeMergeRow() {
        int rows = this.trs.size();
        for (int r = 0; r < rows; ++r) {
            Tr tr = this.getTr(r);
            for (int col : this.mergeRows) {
                int rowspan;
                Td td = tr.getTd(col);
                if (td.isRemove() || (rowspan = this.checkRowspan(td)) <= 1) continue;
                td.setRowspan(rowspan);
                td.merge();
            }
        }
    }

    private void merge() {
        this.exeMergeRow();
        this.exeMergeCol();
        this.offset();
    }

    public Table offset() {
        if (this.isOffset) {
            return this;
        }
        this.isOffset = true;
        int rows = this.trs.size();
        int maxCols = this.getMaxColSize();
        for (int c = 0; c < maxCols; ++c) {
            for (int r = 0; r < rows; ++r) {
                Tr tr = this.trs.get(r);
                List<Td> tds = tr.getTds();
                int cols = tds.size();
                if (c >= cols) continue;
                Td td = tds.get(c);
                int colspan = td.getColspan();
                int rowspan = td.getRowspan();
                int offset = colspan - 1;
                if (offset > 0) {
                    for (int cc = c + 1; cc < cols; ++cc) {
                        Td after = tds.get(cc);
                        after.addOffset(offset);
                    }
                }
                if (rowspan <= 1) continue;
                ++offset;
                for (int rr = r + 1; rr < r + rowspan; ++rr) {
                    Tr afterTr = this.trs.get(rr);
                    int begin = td.getColIndex() + td.getOffset();
                    List<Td> afterTds = afterTr.getTdsByOffset(begin);
                    for (Td afterTd : afterTds) {
                        afterTd.addOffset(offset);
                    }
                }
            }
        }
        return this;
    }

    public int getMaxColSize() {
        int max = 0;
        for (Tr tr : this.trs) {
            int size = tr.getTds().size();
            if (size <= max) continue;
            max = size;
        }
        return max;
    }

    public Table setMergeRow(String ... cols) {
        for (String col : cols) {
            ArrayList<Integer> refs = new ArrayList<Integer>();
            int c = -1;
            if (col.contains("(")) {
                col = col.trim();
                String[] ref = col.substring(col.indexOf("(") + 1, col.length() - 1).split(",");
                for (int i = 0; i < ref.length; ++i) {
                    refs.add(Integer.parseInt(ref[i]));
                }
                col = col.substring(0, col.indexOf("("));
            }
            c = Integer.parseInt(col);
            this.mergeRows.add(c);
            this.refs.put(c, refs);
        }
        return this;
    }

    public Table setMergeRow(Integer ... cols) {
        this.mergeRows = BeanUtil.array2list(new Integer[][]{cols});
        return this;
    }

    public Table setMergeCol(int start, int qty) {
        Integer[] merge = new Integer[]{start, qty};
        this.mergeCols.add(merge);
        return this;
    }

    public String getText(int row, int col) {
        Td td = this.getTd(row, col);
        return td.getText();
    }

    public Table setText(int row, int col, String text) {
        Td td = this.getTd(row, col);
        if (null != text) {
            td.setText(text);
        }
        return this;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Td removeLeftBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeLeftBorder();
        return td;
    }

    public Td removeRightBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeRightBorder();
        return td;
    }

    public Td removeTopBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeTopBorder();
        return td;
    }

    public Td removeBottomBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeBottomBorder();
        return td;
    }

    public Td removeTl2brBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeTl2brBorder();
        return td;
    }

    public Td removeTr2blBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeTr2blBorder();
        return td;
    }

    public Td removeBorder(String side, int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeBorder(side);
        return td;
    }

    public Td removeBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.removeBorder();
        return td;
    }

    public Td setBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setBorder();
        return td;
    }

    public Td setBorder(int rows, int cols, String weight, String color, String style) {
        Td td = this.getTd(rows, cols);
        td.setBorder(weight, color, style);
        return td;
    }

    public Td setLeftBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setLeftBorder();
        return td;
    }

    public Td setRightBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setRightBorder();
        return td;
    }

    public Td setTopBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setTopBorder();
        return td;
    }

    public Td setBottomBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setBottomBorder();
        return td;
    }

    public Td setTl2brBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setTl2brBorder();
        return td;
    }

    public Td setTl2brBorder(int rows, int cols, String top, String bottom) {
        Td td = this.getTd(rows, cols);
        td.setTl2brBorder(top, bottom);
        return td;
    }

    public Td setTr2blBorder(int rows, int cols) {
        Td td = this.getTd(rows, cols);
        td.setTr2blBorder();
        return td;
    }

    public Td setTr2blBorder(int rows, int cols, String top, String bottom) {
        Td td = this.getTd(rows, cols);
        td.setTr2blBorder(top, bottom);
        return td;
    }

    public Td setLeftBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setLeftBorder(width, color, style);
    }

    public Td setLeftBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setLeftBorder(width, color, style);
    }

    public Td setLeftBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setLeftBorder(width + this.widthUnit, color, style);
    }

    public Td setRightBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setRightBorder(width, color, style);
    }

    public Td setRightBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setRightBorder(width, color, style);
    }

    public Td setRightBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setRightBorder(width, color, style);
    }

    public Td setTopBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setTopBorder(width, color, style);
    }

    public Td setTopBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setTopBorder(width, color, style);
    }

    public Td setTopBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setTopBorder(width, color, style);
    }

    public Td setBottomBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setBottomBorder(width, color, style);
    }

    public Td setBottomBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setBottomBorder(width, color, style);
    }

    public Td setBottomBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setBottomBorder(width, color, style);
    }

    public Td setTl2brBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setTl2brBorder(width, color, style);
    }

    public Td setTl2brBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setTl2brBorder(width, color, style);
    }

    public Td setTl2brBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setTl2brBorder(width, color, style);
    }

    public Td setTr2blBorder(int rows, int cols, String width, String color, String style) {
        return this.getTd(rows, cols).setTr2blBorder(width, color, style);
    }

    public Td setTr2blBorder(int rows, int cols, int width, String color, String style) {
        return this.getTd(rows, cols).setTr2blBorder(width, color, style);
    }

    public Td setTr2blBorder(int rows, int cols, double width, String color, String style) {
        return this.getTd(rows, cols).setTr2blBorder(width, color, style);
    }

    public Td setBorder(int rows, int cols, String side, String width, String color, String style) {
        return this.getTd(rows, cols).setBorder(side, width, color, style);
    }

    public Td setBorder(int rows, int cols, String side, int width, String color, String style) {
        return this.getTd(rows, cols).setBorder(side, width, color, style);
    }

    public Td setBorder(int rows, int cols, String side, double width, String color, String style) {
        return this.getTd(rows, cols).setBorder(side, width, color, style);
    }

    public Td setColor(int rows, int cols, String color) {
        return this.getTd(rows, cols).setColor(color);
    }

    public Td setFont(int rows, int cols, String weight, String eastAsia, String ascii, String hint) {
        return this.getTd(rows, cols).setFont(weight, eastAsia, ascii, hint);
    }

    public Td setFontSize(int rows, int cols, String weight) {
        return this.getTd(rows, cols).setFontSize(weight);
    }

    public Td setFontWeight(int rows, int cols, String weight) {
        return this.getTd(rows, cols).setFontSize(weight);
    }

    public Td setFontFamily(int rows, int cols, String font) {
        return this.getTd(rows, cols).setFontFamily(font);
    }

    public Td setAlign(int rows, int cols, String align) {
        return this.getTd(rows, cols).setAlign(align);
    }

    public Td setVerticalAlign(int rows, int cols, String align) {
        return this.getTd(rows, cols).setVerticalAlign(align);
    }

    public Td setBackgroundColor(int rows, int cols, String color) {
        return this.getTd(rows, cols).setBackgroundColor(color);
    }

    public Td removeStyle(int rows, int cols) {
        return this.getTd(rows, cols).removeStyle();
    }

    public Td removeBackgroundColor(int rows, int cols) {
        return this.getTd(rows, cols).removeBackgroundColor();
    }

    public Td removeColor(int rows, int cols) {
        return this.getTd(rows, cols).removeColor();
    }

    public Td setBold(int rows, int cols, boolean bold) {
        return this.getTd(rows, cols).setBold(bold);
    }

    public Td setBold(int rows, int cols) {
        return this.getTd(rows, cols).setBold();
    }

    public Td setUnderline(int rows, int cols, boolean underline) {
        return this.getTd(rows, cols).setUnderline(underline);
    }

    public Td setUnderline(int rows, int cols) {
        return this.getTd(rows, cols).setUnderline();
    }

    public Td setStrike(int rows, int cols, boolean strike) {
        return this.getTd(rows, cols).setStrike(strike);
    }

    public Td setStrike(int rows, int cols) {
        return this.getTd(rows, cols).setStrike();
    }

    public Td setDelete(int rows, int cols) {
        return this.getTd(rows, cols).setStrike();
    }

    public Td setDelete(int rows, int cols, boolean strike) {
        return this.getTd(rows, cols).setDelete();
    }

    public Td setItalic(int rows, int cols, boolean italic) {
        return this.getTd(rows, cols).setItalic(italic);
    }

    public Td setItalic(int rows, int cols) {
        return this.getTd(rows, cols).setItalic();
    }

    public Td setLineHeight(int rows, int cols, String height) {
        return this.getTd(rows, cols).setLineHeight(height);
    }

    public Td setLineHeight(int rows, int cols, int height) {
        return this.getTd(rows, cols).setLineHeight(height);
    }

    public Td setLineHeight(int rows, int cols, double height) {
        return this.getTd(rows, cols).setLineHeight(height);
    }

    public Td setColspan(int rows, int cols, int colspan) {
        return this.getTd(rows, cols).setColspan(colspan);
    }

    public Td setRowspan(int rows, int cols, int rowspan) {
        return this.getTd(rows, cols).setRowspan(rowspan);
    }

    public Td setPadding(int rows, int cols, String padding) {
        return this.getTd(rows, cols).setPadding(padding);
    }

    public Td setPadding(int rows, int cols, int padding) {
        return this.getTd(rows, cols).setPadding(padding);
    }

    public Td setPadding(int rows, int cols, double padding) {
        return this.getTd(rows, cols).setPadding(padding);
    }

    public Td setBottomPadding(int rows, int cols, String padding) {
        return this.getTd(rows, cols).setBottomPadding(padding);
    }

    public Td setBottomPadding(int rows, int cols, int padding) {
        return this.getTd(rows, cols).setBottomPadding(padding);
    }

    public Td setBottomPadding(int rows, int cols, double padding) {
        return this.getTd(rows, cols).setBottomPadding(padding);
    }

    public Td setTopPadding(int rows, int cols, String padding) {
        return this.getTd(rows, cols).setTopPadding(padding);
    }

    public Td setTopPadding(int rows, int cols, int padding) {
        return this.getTd(rows, cols).setTopPadding(padding);
    }

    public Td setTopPadding(int rows, int cols, double padding) {
        return this.getTd(rows, cols).setTopPadding(padding);
    }

    public Td setRightPadding(int rows, int cols, String padding) {
        return this.getTd(rows, cols).setRightPadding(padding);
    }

    public Td setRightPadding(int rows, int cols, int padding) {
        return this.getTd(rows, cols).setRightPadding(padding);
    }

    public Td setRightPadding(int rows, int cols, double padding) {
        return this.getTd(rows, cols).setRightPadding(padding);
    }

    public Td setLeftPadding(int rows, int cols, String padding) {
        return this.getTd(rows, cols).setLeftPadding(padding);
    }

    public Td setLeftPadding(int rows, int cols, int padding) {
        return this.getTd(rows, cols).setLeftPadding(padding);
    }

    public Td setLeftPadding(int rows, int cols, double padding) {
        return this.getTd(rows, cols).setLeftPadding(padding);
    }

    public Td setPadding(int rows, int cols, String side, String padding) {
        return this.getTd(rows, cols).setPadding(side, padding);
    }

    public Td setPadding(int rows, int cols, String side, int padding) {
        return this.getTd(rows, cols).setPadding(side, padding);
    }

    public Td setPadding(int rows, int cols, String side, double padding) {
        return this.getTd(rows, cols).setPadding(side, padding);
    }
}

