/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.Operation;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.TaskWithFieldExtensions;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.impl.ExternalInvocationTaskValidator;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskValidator
extends ExternalInvocationTaskValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List serviceTasks = process.findFlowElementsOfType(ServiceTask.class);
        for (ServiceTask serviceTask : serviceTasks) {
            this.verifyImplementation(process, serviceTask, errors);
            this.verifyType(process, serviceTask, errors);
            this.verifyResultVariableName(process, serviceTask, errors);
            this.verifyWebservice(bpmnModel, process, serviceTask, errors);
        }
    }

    protected void verifyImplementation(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (!ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(serviceTask.getImplementationType()) && !ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType()) && !ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType()) && !ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isEmpty((CharSequence)serviceTask.getType()) && StringUtils.isEmpty((CharSequence)serviceTask.getImplementation())) {
            this.addError(errors, "activiti-servicetask-missing-implementation", process, (BaseElement)serviceTask, "One of the attributes 'implementation', 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask.");
        }
    }

    protected void verifyType(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if (!(serviceTask.getType().equalsIgnoreCase("mail") || serviceTask.getType().equalsIgnoreCase("mule") || serviceTask.getType().equalsIgnoreCase("camel") || serviceTask.getType().equalsIgnoreCase("shell") || serviceTask.getType().equalsIgnoreCase("dmn"))) {
                this.addError(errors, "activiti-servicetask-invalid-type", process, (BaseElement)serviceTask, "Invalid or unsupported service task type");
            }
            if (serviceTask.getType().equalsIgnoreCase("mail")) {
                this.validateFieldDeclarationsForEmail(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            } else if (serviceTask.getType().equalsIgnoreCase("shell")) {
                this.validateFieldDeclarationsForShell(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            } else if (serviceTask.getType().equalsIgnoreCase("dmn")) {
                this.validateFieldDeclarationsForDmn(process, (TaskWithFieldExtensions)serviceTask, serviceTask.getFieldExtensions(), errors);
            }
        }
    }

    protected void verifyResultVariableName(Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName()) && (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType()))) {
            this.addError(errors, "activiti-servicetask-result-var-name-with-delegate", process, (BaseElement)serviceTask, "'resultVariableName' not supported for service tasks using 'class' or 'delegateExpression");
        }
    }

    protected void verifyWebservice(BpmnModel bpmnModel, Process process, ServiceTask serviceTask, List<ValidationError> errors) {
        if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            boolean operationFound = false;
            if (bpmnModel.getInterfaces() != null && !bpmnModel.getInterfaces().isEmpty()) {
                for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                    if (bpmnInterface.getOperations() == null || bpmnInterface.getOperations().isEmpty()) continue;
                    for (Operation operation : bpmnInterface.getOperations()) {
                        if (operation.getId() == null || !operation.getId().equals(serviceTask.getOperationRef())) continue;
                        operationFound = true;
                    }
                }
            }
            if (!operationFound) {
                this.addError(errors, "activiti-servicetask-webservice-invalid-operation-ref", process, (BaseElement)serviceTask, "Invalid operation reference");
            }
        }
    }
}

