/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class SubprocessValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List subProcesses = process.findFlowElementsOfType(SubProcess.class);
        for (SubProcess subProcess : subProcesses) {
            if (subProcess instanceof EventSubProcess) continue;
            List startEvents = process.findFlowElementsInSubProcessOfType(subProcess, StartEvent.class, false);
            if (startEvents.size() > 1) {
                this.addError(errors, "activiti-subprocess-multiple-start-event", process, (BaseElement)subProcess, "Multiple start events not supported for subprocess");
            }
            for (StartEvent startEvent : startEvents) {
                if (startEvent.getEventDefinitions().isEmpty()) continue;
                this.addError(errors, "activiti-subprocess-start-event-event-definition-not-allowed", process, (BaseElement)startEvent, "event definitions only allowed on start event if subprocess is an event subprocess");
            }
        }
    }
}

