/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process.simple.editor.table;

import com.vaadin.data.Item;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import java.util.Arrays;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.process.simple.editor.listener.AddPropertyClickListener;
import org.activiti.explorer.ui.process.simple.editor.listener.DeletePropertyClickListener;

public class PropertyTable
extends Table {
    private static final long serialVersionUID = 6521446909987945815L;
    public static final String ID_PROPERTY_NAME = "property";
    public static final String ID_PROPERTY_TYPE = "type";
    public static final String ID_PROPERTY_REQUIRED = "required";
    public static final String ID_PROPERTY_ACTIONS = "actions";
    private static final String DEFAULT_PROPERTY_NAME = "My property";
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();

    public PropertyTable() {
        this.setEditable(true);
        this.setColumnReorderingAllowed(true);
        this.setPageLength(this.size());
        this.addContainerProperty(ID_PROPERTY_NAME, String.class, null);
        this.addContainerProperty(ID_PROPERTY_TYPE, ComboBox.class, null);
        this.addContainerProperty(ID_PROPERTY_REQUIRED, CheckBox.class, null);
        this.addContainerProperty(ID_PROPERTY_ACTIONS, HorizontalLayout.class, null);
        this.setColumnHeader(ID_PROPERTY_NAME, this.i18nManager.getMessage("process.editor.property.name"));
        this.setColumnHeader(ID_PROPERTY_TYPE, this.i18nManager.getMessage("process.editor.property.type"));
        this.setColumnHeader(ID_PROPERTY_REQUIRED, this.i18nManager.getMessage("process.editor.property.required"));
        this.setColumnHeader(ID_PROPERTY_ACTIONS, this.i18nManager.getMessage("process.editor.actions"));
    }

    public void addPropertyRow() {
        this.addPropertyRow(null, null, null, null);
    }

    public void addPropertyRow(String propertyName, String propertyType, Boolean required) {
        this.addPropertyRow(null, propertyName, propertyType, required);
    }

    public void addPropertyRowAfter(Object itemId) {
        this.addPropertyRow(itemId, null, null, null);
    }

    protected void addPropertyRow(Object itemId, String propertyName, String propertyType, Boolean required) {
        Object newItemId = null;
        newItemId = itemId == null ? this.addItem() : this.addItemAfter(itemId);
        Item newItem = this.getItem(newItemId);
        newItem.getItemProperty((Object)ID_PROPERTY_NAME).setValue((Object)(propertyName == null ? DEFAULT_PROPERTY_NAME : propertyName));
        ComboBox typeComboBox = new ComboBox("", Arrays.asList("text", "number", "date"));
        typeComboBox.setNullSelectionAllowed(false);
        if (propertyType == null) {
            typeComboBox.setValue(typeComboBox.getItemIds().iterator().next());
        } else {
            typeComboBox.setValue((Object)propertyType);
        }
        newItem.getItemProperty((Object)ID_PROPERTY_TYPE).setValue((Object)typeComboBox);
        CheckBox requiredCheckBox = new CheckBox();
        requiredCheckBox.setValue((Object)(required == null ? false : required));
        newItem.getItemProperty((Object)ID_PROPERTY_REQUIRED).setValue((Object)requiredCheckBox);
        HorizontalLayout actionButtons = new HorizontalLayout();
        Button deleteRowButton = new Button("-");
        deleteRowButton.setData(newItemId);
        deleteRowButton.addListener((Button.ClickListener)new DeletePropertyClickListener(this));
        actionButtons.addComponent((Component)deleteRowButton);
        Button addRowButton = new Button("+");
        addRowButton.setData(newItemId);
        addRowButton.addListener((Button.ClickListener)new AddPropertyClickListener(this));
        actionButtons.addComponent((Component)addRowButton);
        newItem.getItemProperty((Object)ID_PROPERTY_ACTIONS).setValue((Object)actionButtons);
    }
}

