/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.processdefinition;

import com.vaadin.ui.Button;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.runtime.Job;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.AbstractPage;
import org.activiti.explorer.ui.management.processdefinition.ActiveProcessDefinitionPage;
import org.activiti.explorer.ui.management.processdefinition.ChangeProcessSuspensionStatePopupWindow;
import org.activiti.explorer.ui.process.AbstractProcessDefinitionDetailPanel;

public class ActiveProcessDefinitionDetailPanel
extends AbstractProcessDefinitionDetailPanel {
    private static final long serialVersionUID = 1L;

    public ActiveProcessDefinitionDetailPanel(String processDefinitionId, ActiveProcessDefinitionPage activeProcessDefinitionPage) {
        super(processDefinitionId, activeProcessDefinitionPage);
    }

    @Override
    protected void initActions(final AbstractPage parentPage) {
        ActiveProcessDefinitionPage processDefinitionPage = (ActiveProcessDefinitionPage)parentPage;
        Button suspendButton = new Button(this.i18nManager.getMessage("process.suspend"));
        suspendButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                ChangeProcessSuspensionStatePopupWindow popupWindow = new ChangeProcessSuspensionStatePopupWindow(ActiveProcessDefinitionDetailPanel.this.processDefinition.getId(), parentPage, true);
                ExplorerApp.get().getViewManager().showPopupWindow(popupWindow);
            }
        });
        boolean suspendJobPending = false;
        List jobs = ProcessEngines.getDefaultProcessEngine().getManagementService().createJobQuery().processDefinitionId(this.processDefinition.getId()).list();
        for (Job job : jobs) {
            if (!((JobEntity)job).getJobHandlerType().equals("suspend-processdefinition")) continue;
            suspendJobPending = true;
            break;
        }
        suspendButton.setEnabled(!suspendJobPending);
        processDefinitionPage.getToolBar().removeAllButtons();
        processDefinitionPage.getToolBar().addButton(suspendButton);
    }
}

