/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Validator;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import java.util.Arrays;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;

public class NewGroupPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Form form;

    public NewGroupPopupWindow() {
        this.setCaption(this.i18nManager.getMessage("group.create"));
        this.setModal(true);
        this.center();
        this.setResizable(false);
        this.setWidth(265.0f, 0);
        this.setHeight(240.0f, 0);
        this.addStyleName("light");
        this.initEnterKeyListener();
        this.initForm();
    }

    protected void initEnterKeyListener() {
        this.addActionHandler(new Action.Handler(){

            public void handleAction(Action action, Object sender, Object target) {
                NewGroupPopupWindow.this.handleFormSubmit();
            }

            public Action[] getActions(Object target, Object sender) {
                return new Action[]{new ShortcutAction("enter", 13, null)};
            }
        });
    }

    protected void initForm() {
        this.form = new Form();
        this.form.setValidationVisibleOnCommit(true);
        this.form.setImmediate(true);
        this.addComponent((Component)this.form);
        this.initInputFields();
        this.initCreateButton();
    }

    protected void initInputFields() {
        this.form.addField((Object)"id", (Field)new TextField(this.i18nManager.getMessage("group.id")));
        this.form.getField((Object)"id").setRequired(true);
        this.form.getField((Object)"id").setRequiredError(this.i18nManager.getMessage("group.id.required"));
        this.form.getField((Object)"id").focus();
        this.form.getField((Object)"id").addValidator(new Validator(){

            public void validate(Object value) throws Validator.InvalidValueException {
                if (!this.isValid(value)) {
                    throw new Validator.InvalidValueException(NewGroupPopupWindow.this.i18nManager.getMessage("group.id.unique"));
                }
            }

            public boolean isValid(Object value) {
                if (value != null) {
                    return NewGroupPopupWindow.this.identityService.createGroupQuery().groupId(value.toString()).singleResult() == null;
                }
                return false;
            }
        });
        this.form.addField((Object)"name", (Field)new TextField(this.i18nManager.getMessage("group.name")));
        ComboBox typeComboBox = new ComboBox(this.i18nManager.getMessage("group.type"), Arrays.asList("assignment", "security-role"));
        typeComboBox.select((Object)"assignment");
        this.form.addField((Object)"type", (Field)typeComboBox);
    }

    protected void initCreateButton() {
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidth(100.0f, 8);
        this.form.getFooter().setWidth(100.0f, 8);
        this.form.getFooter().addComponent((Component)buttonLayout);
        Button createButton = new Button(this.i18nManager.getMessage("group.create"));
        buttonLayout.addComponent((Component)createButton);
        buttonLayout.setComponentAlignment((Component)createButton, Alignment.BOTTOM_RIGHT);
        createButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                NewGroupPopupWindow.this.handleFormSubmit();
            }
        });
    }

    protected void handleFormSubmit() {
        try {
            this.form.commit();
            Group group = this.createGroup();
            this.close();
            ExplorerApp.get().getViewManager().showGroupPage(group.getId());
        }
        catch (Validator.InvalidValueException e) {
            this.setHeight(270.0f, 0);
        }
    }

    protected Group createGroup() {
        Group group = this.identityService.newGroup(this.form.getField((Object)"id").getValue().toString());
        group.setName(this.form.getField((Object)"name").getValue().toString());
        group.setType(this.form.getField((Object)"type").getValue().toString());
        this.identityService.saveGroup(group);
        return group;
    }
}

