/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.util.HashSet;
import java.util.Set;
import org.activiti.engine.IdentityService;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.ui.custom.PopupWindow;
import org.activiti.explorer.ui.event.SubmitEvent;
import org.activiti.explorer.ui.management.identity.GroupSelectionQuery;

public class GroupSelectionPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected I18nManager i18nManager;
    protected String userId;
    protected Table groupTable;

    public GroupSelectionPopupWindow(IdentityService identityService, String userId) {
        this.identityService = identityService;
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.userId = userId;
        this.setCaption(this.i18nManager.getMessage("user.select.groups.popup", userId));
        this.setModal(true);
        this.center();
        this.setWidth(500.0f, 0);
        this.setHeight(400.0f, 0);
        this.addStyleName("light");
        ((VerticalLayout)this.getContent()).setSpacing(true);
        this.initGroupTable();
        this.initSelectButton();
    }

    protected void initGroupTable() {
        this.groupTable = new Table();
        this.groupTable.setNullSelectionAllowed(false);
        this.groupTable.setSelectable(true);
        this.groupTable.setMultiSelect(true);
        this.groupTable.setSortDisabled(true);
        this.groupTable.setWidth(460.0f, 0);
        this.groupTable.setHeight(275.0f, 0);
        this.addComponent((Component)this.groupTable);
        GroupSelectionQuery query = new GroupSelectionQuery(this.identityService, this.userId);
        LazyLoadingContainer container = new LazyLoadingContainer(query, 30);
        this.groupTable.setContainerDataSource((Container)container);
        this.groupTable.addContainerProperty((Object)"id", String.class, null);
        this.groupTable.addContainerProperty((Object)"name", String.class, null);
        this.groupTable.addContainerProperty((Object)"type", String.class, null);
    }

    protected void initSelectButton() {
        final Button selectButton = new Button(this.i18nManager.getMessage("user.select.groups"));
        this.addComponent((Component)selectButton);
        ((VerticalLayout)this.getContent()).setComponentAlignment((Component)selectButton, Alignment.BOTTOM_RIGHT);
        selectButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GroupSelectionPopupWindow.this.fireEvent(new SubmitEvent((Component)selectButton, "submit"));
                GroupSelectionPopupWindow.this.close();
            }
        });
    }

    public Set<String> getSelectedGroupIds() {
        HashSet<String> groupIds = new HashSet<String>();
        for (Object itemId : (Set)this.groupTable.getValue()) {
            groupIds.add((String)this.groupTable.getItem(itemId).getItemProperty((Object)"id").getValue());
        }
        return groupIds;
    }
}

