/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.data.LazyLoadingQuery;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.identity.GroupDetailPanel;
import org.activiti.explorer.ui.management.identity.GroupListQuery;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class GroupPage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected String groupId;
    protected Table groupTable;
    protected LazyLoadingQuery groupListQuery;
    protected LazyLoadingContainer groupListContainer;

    public GroupPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("group"));
    }

    public GroupPage(String groupId) {
        this.groupId = groupId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.groupId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.groupListContainer.getIndexForObjectId(this.groupId));
        }
    }

    @Override
    protected Table createList() {
        this.groupTable = new Table();
        this.groupTable.setEditable(false);
        this.groupTable.setImmediate(true);
        this.groupTable.setSelectable(true);
        this.groupTable.setNullSelectionAllowed(false);
        this.groupTable.setSortDisabled(true);
        this.groupTable.setSizeFull();
        this.groupListQuery = new GroupListQuery();
        this.groupListContainer = new LazyLoadingContainer(this.groupListQuery, 30);
        this.groupTable.setContainerDataSource((Container)this.groupListContainer);
        this.groupTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.GROUP_22));
        this.groupTable.setColumnWidth((Object)"icon", 22);
        this.groupTable.addContainerProperty((Object)"name", String.class, null);
        this.groupTable.setColumnHeaderMode(-1);
        this.groupTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = GroupPage.this.groupTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    String groupId = (String)item.getItemProperty((Object)"id").getValue();
                    GroupPage.this.setDetailComponent((Component)new GroupDetailPanel(GroupPage.this, groupId));
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("group", groupId));
                } else {
                    GroupPage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("group", GroupPage.this.groupId));
                }
            }
        });
        return this.groupTable;
    }

    public void notifyGroupChanged(String groupId) {
        this.groupTable.removeAllItems();
        this.groupListContainer.removeAllItems();
        this.groupTable.select((Object)this.groupListContainer.getIndexForObjectId(groupId));
    }
}

