/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.admin;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;

public class AdminDatabaseSettingsPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected I18nManager i18nManager;
    protected ProcessEngineConfigurationImpl engineConfiguration;
    protected VerticalLayout panelLayout;
    protected HorizontalLayout detailLayout;
    protected GridLayout detailsGrid;

    public AdminDatabaseSettingsPanel() {
        ProcessEngineImpl processEngine = (ProcessEngineImpl)ProcessEngines.getDefaultProcessEngine();
        this.engineConfiguration = processEngine.getProcessEngineConfiguration();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.init();
    }

    protected void init() {
        this.setSizeFull();
        this.addStyleName("light");
        this.initPageTitle();
        this.initDatabaseSettingsDetails();
    }

    protected void initPageTitle() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth(100.0f, 8);
        layout.addStyleName("title-block");
        layout.setSpacing(true);
        layout.setMargin(false, false, true, false);
        this.addDetailComponent((Component)layout);
        Embedded databaseImage = new Embedded(null, Images.DATABASE_50);
        layout.addComponent((Component)databaseImage);
        Label groupName = new Label(this.i18nManager.getMessage("database.title"));
        groupName.setSizeUndefined();
        groupName.addStyleName("h2");
        layout.addComponent((Component)groupName);
        layout.setComponentAlignment((Component)groupName, Alignment.MIDDLE_LEFT);
        layout.setExpandRatio((Component)groupName, 1.0f);
    }

    protected void initDatabaseSettingsDetails() {
        Label settingsHeader = new Label(this.i18nManager.getMessage("management.menu.database"));
        settingsHeader.addStyleName("h3");
        settingsHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)settingsHeader);
        this.detailLayout = new HorizontalLayout();
        this.detailLayout.setSpacing(true);
        this.detailLayout.setMargin(true, false, true, false);
        this.addDetailComponent((Component)this.detailLayout);
        this.initSettingsProperties();
    }

    protected void initSettingsProperties() {
        this.detailsGrid = new GridLayout(2, 3);
        this.detailsGrid.setSpacing(true);
        this.detailLayout.setMargin(true, true, true, false);
        this.detailLayout.addComponent((Component)this.detailsGrid);
        Label typeLabel = new Label(this.i18nManager.getMessage("database.type") + ": ");
        typeLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)typeLabel);
        Label typeValueLabel = new Label(this.engineConfiguration.getDatabaseType());
        this.detailsGrid.addComponent((Component)typeValueLabel);
        Label schemaUpdateLabel = new Label(this.i18nManager.getMessage("database.update") + ": ");
        schemaUpdateLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)schemaUpdateLabel);
        Label schemaUpdateValueLabel = new Label(this.engineConfiguration.getDatabaseSchemaUpdate());
        this.detailsGrid.addComponent((Component)schemaUpdateValueLabel);
        Label configTypeLabel = new Label(this.i18nManager.getMessage("database.config.type") + ": ");
        configTypeLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)configTypeLabel);
        String databaseConfigType = this.getDatabaseType();
        Label configTypeValueLabel = new Label(databaseConfigType);
        this.detailsGrid.addComponent((Component)configTypeValueLabel);
        if ("JNDI".equals(databaseConfigType)) {
            Label jndiLabel = new Label(this.i18nManager.getMessage("database.jndi") + ": ");
            jndiLabel.addStyleName("bold");
            this.detailsGrid.addComponent((Component)jndiLabel);
            Label jndiValueLabel = new Label(this.engineConfiguration.getDataSourceJndiName());
            this.detailsGrid.addComponent((Component)jndiValueLabel);
        } else if ("Datasource".equals(databaseConfigType)) {
            Label datasourceLabel = new Label(this.i18nManager.getMessage("database.datasource.class") + ": ");
            datasourceLabel.addStyleName("bold");
            this.detailsGrid.addComponent((Component)datasourceLabel);
            Label datasourceValueLabel = new Label(this.engineConfiguration.getDataSource().getClass().getName());
            this.detailsGrid.addComponent((Component)datasourceValueLabel);
        } else {
            Label jdbcURLLabel = new Label(this.i18nManager.getMessage("database.jdbc.url") + ": ");
            jdbcURLLabel.addStyleName("bold");
            this.detailsGrid.addComponent((Component)jdbcURLLabel);
            Label jdbcURLValueLabel = new Label(this.engineConfiguration.getJdbcUrl());
            this.detailsGrid.addComponent((Component)jdbcURLValueLabel);
        }
    }

    protected String getDatabaseType() {
        String databaseType = null;
        databaseType = this.engineConfiguration.getDataSourceJndiName() != null ? "JNDI" : (this.engineConfiguration.getDataSource() != null ? "Datasource" : "JDBC config");
        return databaseType;
    }
}

