/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.alfresco;

import com.vaadin.data.Container;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.ui.alfresco.ProcessInstanceTableLazyQuery;
import org.activiti.explorer.ui.process.ProcessDefinitionDetailPanel;
import org.activiti.explorer.ui.process.ProcessDefinitionPage;

public class AlfrescoProcessDefinitionDetailPanel
extends ProcessDefinitionDetailPanel {
    private static final long serialVersionUID = 1L;

    public AlfrescoProcessDefinitionDetailPanel(String processDefinitionId, ProcessDefinitionPage processDefinitionPage) {
        super(processDefinitionId, processDefinitionPage);
    }

    protected void initActions() {
    }

    @Override
    protected void initUi() {
        super.initUi();
        this.initProcessInstancesTable();
    }

    protected void initProcessInstancesTable() {
        ProcessInstanceTableLazyQuery query = new ProcessInstanceTableLazyQuery(this.processDefinition.getId());
        Label instancesTitle = new Label(this.i18nManager.getMessage("process.instances") + " (" + query.size() + ")");
        instancesTitle.addStyleName("h3");
        instancesTitle.addStyleName("block-holder");
        instancesTitle.addStyleName("no-line");
        this.detailPanelLayout.addComponent((Component)instancesTitle);
        if (query.size() > 0) {
            Label emptySpace = new Label("&nbsp;", 3);
            this.detailPanelLayout.addComponent((Component)emptySpace);
            Table instancesTable = new Table();
            instancesTable.setWidth(400.0f, 0);
            if (query.size() > 6) {
                instancesTable.setPageLength(6);
            } else {
                instancesTable.setPageLength(query.size());
            }
            LazyLoadingContainer container = new LazyLoadingContainer(query);
            instancesTable.setContainerDataSource((Container)container);
            instancesTable.addContainerProperty((Object)"id", String.class, null);
            instancesTable.addContainerProperty((Object)"businessKey", String.class, null);
            instancesTable.addContainerProperty((Object)"actions", Component.class, null);
            instancesTable.setColumnAlignment((Object)"actions", "c");
            instancesTable.setColumnHeader((Object)"id", this.i18nManager.getMessage("process.instance.id"));
            instancesTable.setColumnHeader((Object)"businessKey", this.i18nManager.getMessage("process.instance.businesskey"));
            instancesTable.setColumnHeader((Object)"actions", this.i18nManager.getMessage("process.instance.actions"));
            instancesTable.setEditable(false);
            instancesTable.setSelectable(true);
            instancesTable.setNullSelectionAllowed(false);
            instancesTable.setSortDisabled(true);
            this.detailPanelLayout.addComponent((Component)instancesTable);
        } else {
            Label noInstances = new Label(this.i18nManager.getMessage("process.no.instances"));
            this.detailPanelLayout.addComponent((Component)noInstances);
        }
    }
}

