/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.navigation;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.navigation.Navigator;
import org.activiti.explorer.navigation.UriFragment;

public class TaskNavigator
implements Navigator {
    public static final String TASK_URI_PART = "tasks";
    public static final String CATEGORY_TASKS = "tasks";
    public static final String CATEGORY_INBOX = "inbox";
    public static final String CATEGORY_QUEUED = "queued";
    public static final String CATEGORY_INVOLVED = "involved";
    public static final String CATEGORY_ARCHIVED = "archived";
    public static final String PARAMETER_CATEGORY = "category";
    public static final String PARAMETER_GROUP = "group";
    protected transient TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected transient HistoryService historyService;
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();

    public TaskNavigator() {
        this.historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
    }

    @Override
    public String getTrigger() {
        return "tasks";
    }

    @Override
    public void handleNavigation(UriFragment uriFragment) {
        String category = uriFragment.getParameter(PARAMETER_CATEGORY);
        String taskId = uriFragment.getUriPart(1);
        if (taskId == null) {
            this.directToCategoryPage(category, uriFragment);
        } else {
            this.directToSpecificTaskPage(category, taskId, uriFragment);
        }
    }

    protected void directToCategoryPage(String category, UriFragment uriFragment) {
        ViewManager viewManager = ExplorerApp.get().getViewManager();
        if ("tasks".equals(category)) {
            viewManager.showTasksPage();
        } else if (CATEGORY_INBOX.equals(category)) {
            viewManager.showInboxPage();
        } else if (CATEGORY_QUEUED.equals(category)) {
            viewManager.showQueuedPage(uriFragment.getParameter(PARAMETER_GROUP));
        } else if (CATEGORY_INVOLVED.equals(category)) {
            viewManager.showInvolvedPage();
        } else if (CATEGORY_ARCHIVED.equals(category)) {
            viewManager.showArchivedPage();
        } else {
            throw new ActivitiException("Couldn't find a matching category");
        }
    }

    protected void directToSpecificTaskPage(String category, String taskId, UriFragment uriFragment) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ViewManager viewManager = ExplorerApp.get().getViewManager();
        String loggedInUserId = ExplorerApp.get().getLoggedInUser().getId();
        boolean pageFound = false;
        if ("tasks".equals(category)) {
            if (loggedInUserId.equals(task.getOwner())) {
                viewManager.showTasksPage(task.getId());
                pageFound = true;
            }
        } else if (CATEGORY_INBOX.equals(category)) {
            if (loggedInUserId.equals(task.getAssignee())) {
                viewManager.showInboxPage(task.getId());
                pageFound = true;
            }
        } else if (CATEGORY_QUEUED.equals(category)) {
            boolean isUserMemberOfGroup;
            String groupId = uriFragment.getParameter(PARAMETER_GROUP);
            boolean isTaskAssignedToGroup = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).taskCandidateGroup(groupId)).count() == 1L;
            boolean bl = isUserMemberOfGroup = this.identityService.createGroupQuery().groupMember(loggedInUserId).groupId(groupId).count() == 1L;
            if (isTaskAssignedToGroup && isUserMemberOfGroup) {
                viewManager.showQueuedPage(groupId, task.getId());
                pageFound = true;
            }
        } else if (CATEGORY_INVOLVED.equals(category)) {
            boolean isUserInvolved;
            boolean bl = isUserInvolved = ((TaskQuery)this.taskService.createTaskQuery().taskInvolvedUser(loggedInUserId)).count() == 1L;
            if (isUserInvolved) {
                viewManager.showInvolvedPage(task.getId());
                pageFound = true;
            }
        } else if (CATEGORY_ARCHIVED.equals(category)) {
            if (task == null) {
                boolean isOwner;
                boolean bl = isOwner = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskOwner(loggedInUserId)).finished().count() == 1L;
                if (isOwner) {
                    viewManager.showArchivedPage(taskId);
                    pageFound = true;
                }
            }
        } else {
            throw new ActivitiException("Couldn't find a matching category");
        }
        if (!pageFound) {
            viewManager.showTaskPage(taskId);
        }
    }

    protected void showNavigationError(String taskId) {
        String description = ExplorerApp.get().getI18nManager().getMessage("navigation.error.not.involved", taskId);
        ExplorerApp.get().getNotificationManager().showErrorNotification("navigation.error.not.involved.title", description);
    }

    protected List<String> getGroupIds(String userId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }
}

