/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer;

import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.activiti.editor.ui.EditorProcessDefinitionPage;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.AbstractPage;
import org.activiti.explorer.ui.MainWindow;
import org.activiti.explorer.ui.management.admin.AdministrationPage;
import org.activiti.explorer.ui.management.crystalball.CrystalBallPage;
import org.activiti.explorer.ui.management.db.DatabasePage;
import org.activiti.explorer.ui.management.deployment.DeploymentPage;
import org.activiti.explorer.ui.management.identity.GroupPage;
import org.activiti.explorer.ui.management.identity.UserPage;
import org.activiti.explorer.ui.management.job.JobPage;
import org.activiti.explorer.ui.management.processdefinition.ActiveProcessDefinitionPage;
import org.activiti.explorer.ui.management.processdefinition.SuspendedProcessDefinitionPage;
import org.activiti.explorer.ui.process.MyProcessInstancesPage;
import org.activiti.explorer.ui.process.ProcessDefinitionPage;
import org.activiti.explorer.ui.process.simple.editor.SimpleTableEditor;
import org.activiti.explorer.ui.profile.ProfilePopupWindow;
import org.activiti.explorer.ui.reports.RunReportsPage;
import org.activiti.explorer.ui.reports.SavedReportsPage;
import org.activiti.explorer.ui.task.ArchivedPage;
import org.activiti.explorer.ui.task.InboxPage;
import org.activiti.explorer.ui.task.InvolvedPage;
import org.activiti.explorer.ui.task.QueuedPage;
import org.activiti.explorer.ui.task.TasksPage;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultViewManager
implements ViewManager,
Serializable {
    private static final long serialVersionUID = -1712344958488358861L;
    protected AbstractPage currentPage;
    @Autowired
    protected MainWindow mainWindow;
    protected transient TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected transient HistoryService historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();

    @Override
    public void showLoginPage() {
        if (!this.mainWindow.isShowingLoginPage()) {
            this.mainWindow.showLoginPage();
        }
    }

    @Override
    public void showDefaultPage() {
        this.mainWindow.showDefaultContent();
        this.showInboxPage();
    }

    @Override
    public void showPopupWindow(Window window) {
        this.mainWindow.addWindow(window);
    }

    @Override
    public void showTaskPage(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String loggedInUserId = ExplorerApp.get().getLoggedInUser().getId();
        if (task == null) {
            boolean isOwner;
            boolean bl = isOwner = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).taskOwner(loggedInUserId)).count() == 1L;
            if (isOwner) {
                this.showArchivedPage(taskId);
            } else {
                this.showNavigationError(taskId);
            }
        } else if (loggedInUserId.equals(task.getOwner())) {
            this.showTasksPage(taskId);
        } else if (loggedInUserId.equals(task.getAssignee())) {
            this.showInboxPage(taskId);
        } else if (((TaskQuery)this.taskService.createTaskQuery().taskInvolvedUser(loggedInUserId)).count() == 1L) {
            this.showInvolvedPage(taskId);
        } else {
            List<String> groupIds = this.getGroupIds(loggedInUserId);
            List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
            Iterator identityLinkIterator = identityLinks.iterator();
            boolean pageFound = false;
            while (!pageFound && identityLinkIterator.hasNext()) {
                IdentityLink identityLink = (IdentityLink)identityLinkIterator.next();
                if (identityLink.getGroupId() == null || !groupIds.contains(identityLink.getGroupId())) continue;
                this.showQueuedPage(identityLink.getGroupId(), task.getId());
                pageFound = true;
            }
            if (!pageFound) {
                this.showNavigationError(taskId);
            }
        }
    }

    protected List<String> getGroupIds(String userId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        List groups = this.identityService.createGroupQuery().groupMember(userId).list();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected void showNavigationError(String taskId) {
        ExplorerApp.get().getNotificationManager().showErrorNotification("navigation.error.not.involved.title", ExplorerApp.get().getI18nManager().getMessage("navigation.error.not.involved", taskId));
    }

    @Override
    public void showTasksPage() {
        this.switchView(new TasksPage(), "task", "tasks");
    }

    @Override
    public void showTasksPage(String taskId) {
        this.switchView(new TasksPage(taskId), "task", "tasks");
    }

    @Override
    public void showInboxPage() {
        this.switchView(new InboxPage(), "task", "inbox");
    }

    @Override
    public void showInboxPage(String taskId) {
        this.switchView(new InboxPage(taskId), "task", "inbox");
    }

    @Override
    public void showQueuedPage(String groupId) {
        this.switchView(new QueuedPage(groupId), "task", "queued");
    }

    @Override
    public void showQueuedPage(String groupId, String taskId) {
        this.switchView(new QueuedPage(groupId, taskId), "task", "queued");
    }

    @Override
    public void showInvolvedPage() {
        this.switchView(new InvolvedPage(), "task", "involved");
    }

    @Override
    public void showInvolvedPage(String taskId) {
        this.switchView(new InvolvedPage(taskId), "task", "involved");
    }

    @Override
    public void showArchivedPage() {
        this.switchView(new ArchivedPage(), "task", "archived");
    }

    @Override
    public void showArchivedPage(String taskId) {
        this.switchView(new ArchivedPage(taskId), "task", "archived");
    }

    @Override
    public void showDeployedProcessDefinitionPage() {
        this.switchView(new ProcessDefinitionPage(), "process", "deployedProcessDefinitions");
    }

    @Override
    public void showDeployedProcessDefinitionPage(String processDefinitionId) {
        this.switchView(new ProcessDefinitionPage(processDefinitionId), "process", "deployedProcessDefinitions");
    }

    @Override
    public void showEditorProcessDefinitionPage() {
        this.switchView(new EditorProcessDefinitionPage(), "process", "editorProcessDefinitions");
    }

    @Override
    public void showEditorProcessDefinitionPage(String modelId) {
        this.switchView(new EditorProcessDefinitionPage(modelId), "process", "editorProcessDefinitions");
    }

    @Override
    public void showMyProcessInstancesPage() {
        this.switchView(new MyProcessInstancesPage(), "process", "myProcessInstances");
    }

    @Override
    public void showMyProcessInstancesPage(String processInstanceId) {
        this.switchView(new MyProcessInstancesPage(processInstanceId), "process", "myProcessInstances");
    }

    @Override
    public void showSimpleTableProcessEditor(String processName, String processDescription) {
        this.switchView(new SimpleTableEditor(processName, processDescription), "process", null);
    }

    @Override
    public void showSimpleTableProcessEditor(String modelId, WorkflowDefinition workflowDefinition) {
        this.switchView(new SimpleTableEditor(modelId, workflowDefinition), "process", null);
    }

    @Override
    public void showRunReportPage() {
        this.switchView(new RunReportsPage(), "report", "runReports");
    }

    @Override
    public void showRunReportPage(String reportId) {
        this.switchView(new RunReportsPage(reportId), "report", "runReports");
    }

    @Override
    public void showSavedReportPage() {
        this.switchView(new SavedReportsPage(), "report", "savedResults");
    }

    @Override
    public void showSavedReportPage(String reportId) {
        this.switchView(new SavedReportsPage(reportId), "report", "savedResults");
    }

    @Override
    public void showDatabasePage() {
        this.switchView(new DatabasePage(), "manage", "database");
    }

    @Override
    public void showDatabasePage(String tableName) {
        this.switchView(new DatabasePage(tableName), "manage", "database");
    }

    @Override
    public void showDeploymentPage() {
        this.switchView(new DeploymentPage(), "manage", "deployments");
    }

    @Override
    public void showDeploymentPage(String deploymentId) {
        this.switchView(new DeploymentPage(deploymentId), "manage", "deployments");
    }

    @Override
    public void showActiveProcessDefinitionsPage() {
        this.switchView(new ActiveProcessDefinitionPage(), "manage", "activeProcessDefinitions");
    }

    @Override
    public void showActiveProcessDefinitionsPage(String processDefinitionId) {
        this.switchView(new ActiveProcessDefinitionPage(processDefinitionId), "manage", "activeProcessDefinitions");
    }

    @Override
    public void showSuspendedProcessDefinitionsPage() {
        this.switchView(new SuspendedProcessDefinitionPage(), "manage", "suspendedProcessDefinitions");
    }

    @Override
    public void showSuspendedProcessDefinitionsPage(String processDefinitionId) {
        this.switchView(new SuspendedProcessDefinitionPage(processDefinitionId), "manage", "suspendedProcessDefinitions");
    }

    @Override
    public void showJobPage() {
        this.switchView(new JobPage(), "manage", "jobs");
    }

    @Override
    public void showJobPage(String jobId) {
        this.switchView(new JobPage(jobId), "manage", "jobs");
    }

    @Override
    public void showUserPage() {
        this.switchView(new UserPage(), "manage", "users");
    }

    @Override
    public void showUserPage(String userId) {
        this.switchView(new UserPage(userId), "manage", "users");
    }

    @Override
    public void showGroupPage() {
        this.switchView(new GroupPage(), "manage", "groups");
    }

    @Override
    public void showGroupPage(String groupId) {
        this.switchView(new GroupPage(groupId), "manage", "groups");
    }

    @Override
    public void showProcessInstancePage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void showProcessInstancePage(String processInstanceId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void showAdministrationPage() {
        this.switchView(new AdministrationPage(), "manage", "administration");
    }

    @Override
    public void showAdministrationPage(String managementId) {
        this.switchView(new AdministrationPage(managementId), "manage", "administration");
    }

    @Override
    public void showCrystalBallPage() {
        this.switchView(new CrystalBallPage(), "manage", "crystalball");
    }

    @Override
    public void showProfilePopup(String userId) {
        this.showPopupWindow(new ProfilePopupWindow(userId));
    }

    protected void switchView(AbstractPage page, String mainMenuActive, String subMenuActive) {
        this.currentPage = page;
        this.mainWindow.setMainNavigation(mainMenuActive);
        this.mainWindow.switchView((Component)page);
        if (subMenuActive != null && page.getToolBar() != null) {
            page.getToolBar().setActiveEntry(subMenuActive);
        }
    }

    public AbstractPage getCurrentPage() {
        return this.currentPage;
    }

    public void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }
}

