/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.UserEntityManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.UserDataManager;

public class UserEntityManagerImpl
extends AbstractEntityManager<UserEntity>
implements UserEntityManager {
    protected UserDataManager userDataManager;

    public UserEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, UserDataManager userDataManager) {
        super(processEngineConfiguration);
        this.userDataManager = userDataManager;
    }

    @Override
    protected DataManager<UserEntity> getDataManager() {
        return this.userDataManager;
    }

    @Override
    public UserEntity findById(String entityId) {
        return (UserEntity)this.userDataManager.findById(entityId);
    }

    @Override
    public User createNewUser(String userId) {
        UserEntity userEntity = (UserEntity)this.create();
        userEntity.setId(userId);
        userEntity.setRevision(0);
        return userEntity;
    }

    @Override
    public void updateUser(User updatedUser) {
        super.update((UserEntity)updatedUser);
    }

    @Override
    public void delete(UserEntity userEntity) {
        super.delete(userEntity);
        this.deletePicture(userEntity);
    }

    @Override
    public void deletePicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        if (userEntity.getPictureByteArrayRef() != null) {
            userEntity.getPictureByteArrayRef().delete();
        }
    }

    @Override
    public void delete(String userId) {
        UserEntity user = this.findById(userId);
        if (user != null) {
            List<IdentityInfoEntity> identityInfos = this.getIdentityInfoEntityManager().findIdentityInfoByUserId(userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoEntityManager().delete(identityInfo);
            }
            this.getMembershipEntityManager().deleteMembershipByUserId(userId);
            this.delete(user);
        }
    }

    @Override
    public List<User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        return this.userDataManager.findUserByQueryCriteria(query, page);
    }

    @Override
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return this.userDataManager.findUserCountByQueryCriteria(query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.userDataManager.findGroupsByUser(userId);
    }

    @Override
    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(this.getCommandExecutor());
    }

    @Override
    public Boolean checkPassword(String userId, String password) {
        UserEntity user = null;
        if (userId != null) {
            user = this.findById(userId);
        }
        if (user != null && password != null && password.equals(user.getPassword())) {
            return true;
        }
        return false;
    }

    @Override
    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.userDataManager.findUsersByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.userDataManager.findUserCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewUser(User user) {
        return ((UserEntity)user).getRevision() == 0;
    }

    @Override
    public Picture getUserPicture(String userId) {
        UserEntity user = this.findById(userId);
        return user.getPicture();
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        UserEntity user = this.findById(userId);
        if (user == null) {
            throw new ActivitiObjectNotFoundException("user " + userId + " doesn't exist", User.class);
        }
        user.setPicture(picture);
    }

    public UserDataManager getUserDataManager() {
        return this.userDataManager;
    }

    public void setUserDataManager(UserDataManager userDataManager) {
        this.userDataManager = userDataManager;
    }
}

