/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntityManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.IdentityInfoDataManager;

public class IdentityInfoEntityManagerImpl
extends AbstractEntityManager<IdentityInfoEntity>
implements IdentityInfoEntityManager {
    protected IdentityInfoDataManager identityInfoDataManager;

    public IdentityInfoEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, IdentityInfoDataManager identityInfoDataManager) {
        super(processEngineConfiguration);
        this.identityInfoDataManager = identityInfoDataManager;
    }

    @Override
    protected DataManager<IdentityInfoEntity> getDataManager() {
        return this.identityInfoDataManager;
    }

    @Override
    public void deleteUserInfoByUserIdAndKey(String userId, String key) {
        IdentityInfoEntity identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key);
        if (identityInfoEntity != null) {
            this.delete(identityInfoEntity);
        }
    }

    @Override
    public void updateUserInfo(String userId, String userPassword, String type, String key, String value, String accountPassword, Map<String, String> accountDetails) {
        IdentityInfoEntity identityInfoEntity;
        byte[] storedPassword = null;
        if (accountPassword != null) {
            storedPassword = this.encryptPassword(accountPassword, userPassword);
        }
        if ((identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key)) != null) {
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            if (accountDetails == null) {
                accountDetails = new HashMap<String, String>();
            }
            HashSet<String> newKeys = new HashSet<String>(accountDetails.keySet());
            List<IdentityInfoEntity> identityInfoDetails = this.identityInfoDataManager.findIdentityInfoDetails(identityInfoEntity.getId());
            for (IdentityInfoEntity identityInfoDetail : identityInfoDetails) {
                String detailKey = identityInfoDetail.getKey();
                newKeys.remove(detailKey);
                String newDetailValue = accountDetails.get(detailKey);
                if (newDetailValue == null) {
                    this.delete(identityInfoDetail);
                    continue;
                }
                identityInfoDetail.setValue(newDetailValue);
            }
            this.insertAccountDetails(identityInfoEntity, accountDetails, newKeys);
        } else {
            identityInfoEntity = (IdentityInfoEntity)this.identityInfoDataManager.create();
            identityInfoEntity.setUserId(userId);
            identityInfoEntity.setType(type);
            identityInfoEntity.setKey(key);
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            this.insert(identityInfoEntity, false);
            if (accountDetails != null) {
                this.insertAccountDetails(identityInfoEntity, accountDetails, accountDetails.keySet());
            }
        }
    }

    protected void insertAccountDetails(IdentityInfoEntity identityInfoEntity, Map<String, String> accountDetails, Set<String> keys) {
        for (String newKey : keys) {
            IdentityInfoEntity identityInfoDetail = (IdentityInfoEntity)this.identityInfoDataManager.create();
            identityInfoDetail.setParentId(identityInfoEntity.getId());
            identityInfoDetail.setKey(newKey);
            identityInfoDetail.setValue(accountDetails.get(newKey));
            this.insert(identityInfoDetail, false);
        }
    }

    protected byte[] encryptPassword(String accountPassword, String userPassword) {
        return accountPassword.getBytes();
    }

    protected String decryptPassword(byte[] storedPassword, String userPassword) {
        return new String(storedPassword);
    }

    @Override
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        return this.identityInfoDataManager.findUserInfoByUserIdAndKey(userId, key);
    }

    @Override
    public List<IdentityInfoEntity> findIdentityInfoByUserId(String userId) {
        return this.identityInfoDataManager.findIdentityInfoByUserId(userId);
    }

    @Override
    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        return this.identityInfoDataManager.findUserInfoKeysByUserIdAndType(userId, type);
    }

    public IdentityInfoDataManager getIdentityInfoDataManager() {
        return this.identityInfoDataManager;
    }

    public void setIdentityInfoDataManager(IdentityInfoDataManager identityInfoDataManager) {
        this.identityInfoDataManager = identityInfoDataManager;
    }
}

