/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryProperty;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;

public class UserQueryImpl
extends AbstractQuery<UserQuery, User>
implements UserQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String firstName;
    protected String firstNameLike;
    protected String lastName;
    protected String lastNameLike;
    protected String fullNameLike;
    protected String email;
    protected String emailLike;
    protected String groupId;
    protected String procDefId;

    public UserQueryImpl() {
    }

    public UserQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public UserQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public UserQuery userId(String id) {
        if (id == null) {
            throw new ActivitiIllegalArgumentException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public UserQuery userFirstName(String firstName) {
        if (firstName == null) {
            throw new ActivitiIllegalArgumentException("Provided firstName is null");
        }
        this.firstName = firstName;
        return this;
    }

    @Override
    public UserQuery userFirstNameLike(String firstNameLike) {
        if (firstNameLike == null) {
            throw new ActivitiIllegalArgumentException("Provided firstNameLike is null");
        }
        this.firstNameLike = firstNameLike;
        return this;
    }

    @Override
    public UserQuery userLastName(String lastName) {
        if (lastName == null) {
            throw new ActivitiIllegalArgumentException("Provided lastName is null");
        }
        this.lastName = lastName;
        return this;
    }

    @Override
    public UserQuery userLastNameLike(String lastNameLike) {
        if (lastNameLike == null) {
            throw new ActivitiIllegalArgumentException("Provided lastNameLike is null");
        }
        this.lastNameLike = lastNameLike;
        return this;
    }

    @Override
    public UserQuery userFullNameLike(String fullNameLike) {
        if (fullNameLike == null) {
            throw new ActivitiIllegalArgumentException("Provided full name is null");
        }
        this.fullNameLike = fullNameLike;
        return this;
    }

    @Override
    public UserQuery userEmail(String email) {
        if (email == null) {
            throw new ActivitiIllegalArgumentException("Provided email is null");
        }
        this.email = email;
        return this;
    }

    @Override
    public UserQuery userEmailLike(String emailLike) {
        if (emailLike == null) {
            throw new ActivitiIllegalArgumentException("Provided emailLike is null");
        }
        this.emailLike = emailLike;
        return this;
    }

    @Override
    public UserQuery memberOfGroup(String groupId) {
        if (groupId == null) {
            throw new ActivitiIllegalArgumentException("Provided groupIds is null or empty");
        }
        this.groupId = groupId;
        return this;
    }

    @Override
    public UserQuery potentialStarter(String procDefId) {
        if (procDefId == null) {
            throw new ActivitiIllegalArgumentException("Provided processDefinitionId is null or empty");
        }
        this.procDefId = procDefId;
        return this;
    }

    @Override
    public UserQuery orderByUserId() {
        return (UserQuery)this.orderBy(UserQueryProperty.USER_ID);
    }

    @Override
    public UserQuery orderByUserEmail() {
        return (UserQuery)this.orderBy(UserQueryProperty.EMAIL);
    }

    @Override
    public UserQuery orderByUserFirstName() {
        return (UserQuery)this.orderBy(UserQueryProperty.FIRST_NAME);
    }

    @Override
    public UserQuery orderByUserLastName() {
        return (UserQuery)this.orderBy(UserQueryProperty.LAST_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getUserEntityManager().findUserCountByQueryCriteria(this);
    }

    @Override
    public List<User> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getUserEntityManager().findUserByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFirstNameLike() {
        return this.firstNameLike;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastNameLike() {
        return this.lastNameLike;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailLike() {
        return this.emailLike;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFullNameLike() {
        return this.fullNameLike;
    }

    public String getProcDefId() {
        return this.procDefId;
    }
}

