/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;

public class GetHistoricIdentityLinksForTaskCmd
implements Command<List<HistoricIdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;

    public GetHistoricIdentityLinksForTaskCmd(String taskId, String processInstanceId) {
        if (taskId == null && processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("taskId or processInstanceId is required");
        }
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<HistoricIdentityLink> execute(CommandContext commandContext) {
        if (this.taskId != null) {
            return this.getLinksForTask(commandContext);
        }
        return this.getLinksForProcessInstance(commandContext);
    }

    protected List<HistoricIdentityLink> getLinksForTask(CommandContext commandContext) {
        HistoricIdentityLinkEntity identityLink;
        HistoricTaskInstanceEntity task = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("No historic task exists with the given id: " + this.taskId, HistoricTaskInstance.class);
        }
        List<HistoricIdentityLink> identityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskId(this.taskId);
        if (task.getAssignee() != null) {
            identityLink = new HistoricIdentityLinkEntity();
            identityLink.setUserId(task.getAssignee());
            identityLink.setTaskId(task.getId());
            identityLink.setType("assignee");
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = new HistoricIdentityLinkEntity();
            identityLink.setTaskId(task.getId());
            identityLink.setUserId(task.getOwner());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }

    protected List<HistoricIdentityLink> getLinksForProcessInstance(CommandContext commandContext) {
        return commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByProcessInstanceId(this.processInstanceId);
    }
}

