/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.List;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.api.task.model.payloads.ClaimTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.DeleteTaskPayload;
import org.activiti.api.task.model.payloads.GetTasksPayload;
import org.activiti.api.task.model.payloads.ReleaseTaskPayload;
import org.activiti.api.task.model.payloads.SetTaskVariablesPayload;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.model.impl.APITaskConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="hasRole('ACTIVITI_ADMIN')")
public class TaskAdminRuntimeImpl
implements TaskAdminRuntime {
    private final TaskService taskService;
    private final APITaskConverter taskConverter;

    public TaskAdminRuntimeImpl(TaskService taskService, APITaskConverter taskConverter) {
        this.taskService = taskService;
        this.taskConverter = taskConverter;
    }

    public org.activiti.api.task.model.Task task(String taskId) {
        Task internalTask = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (internalTask == null) {
            throw new NotFoundException("Unable to find task for the given id: " + taskId);
        }
        return this.taskConverter.from(internalTask);
    }

    public Page<org.activiti.api.task.model.Task> tasks(Pageable pageable) {
        return this.tasks(pageable, TaskPayloadBuilder.tasks().build());
    }

    public Page<org.activiti.api.task.model.Task> tasks(Pageable pageable, GetTasksPayload getTasksPayload) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (getTasksPayload.getProcessInstanceId() != null) {
            taskQuery = (TaskQuery)taskQuery.processInstanceId(getTasksPayload.getProcessInstanceId());
        }
        if (getTasksPayload.getParentTaskId() != null) {
            taskQuery = (TaskQuery)taskQuery.taskParentTaskId(getTasksPayload.getParentTaskId());
        }
        List tasks = this.taskConverter.from(taskQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems()));
        return new PageImpl(tasks, Math.toIntExact(taskQuery.count()));
    }

    public org.activiti.api.task.model.Task delete(DeleteTaskPayload deleteTaskPayload) {
        org.activiti.api.task.model.Task task = this.task(deleteTaskPayload.getTaskId());
        TaskImpl deletedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.DELETED);
        this.taskService.deleteTask(deleteTaskPayload.getTaskId(), deleteTaskPayload.getReason(), true);
        return deletedTaskData;
    }

    public void setVariables(SetTaskVariablesPayload setTaskVariablesPayload) {
        this.taskService.setVariablesLocal(setTaskVariablesPayload.getTaskId(), setTaskVariablesPayload.getVariables());
    }

    public org.activiti.api.task.model.Task complete(CompleteTaskPayload completeTaskPayload) {
        org.activiti.api.task.model.Task task = this.task(completeTaskPayload.getTaskId());
        if (task == null) {
            throw new IllegalStateException("Task with id: " + completeTaskPayload.getTaskId() + " cannot be completed because it cannot be found.");
        }
        TaskImpl competedTaskData = new TaskImpl(task.getId(), task.getName(), Task.TaskStatus.COMPLETED);
        this.taskService.complete(completeTaskPayload.getTaskId(), completeTaskPayload.getVariables(), true);
        return competedTaskData;
    }

    public org.activiti.api.task.model.Task claim(ClaimTaskPayload claimTaskPayload) {
        this.taskService.claim(claimTaskPayload.getTaskId(), claimTaskPayload.getAssignee());
        return this.task(claimTaskPayload.getTaskId());
    }

    public org.activiti.api.task.model.Task release(ReleaseTaskPayload releaseTaskPayload) {
        this.taskService.unclaim(releaseTaskPayload.getTaskId());
        return this.task(releaseTaskPayload.getTaskId());
    }
}

