/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanShellFunctionProvider
implements FunctionProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$util$beanshell$BeanShellFunctionProvider == null ? (class$com$opensymphony$workflow$util$beanshell$BeanShellFunctionProvider = BeanShellFunctionProvider.class$("com.opensymphony.workflow.util.beanshell.BeanShellFunctionProvider")) : class$com$opensymphony$workflow$util$beanshell$BeanShellFunctionProvider));
    static /* synthetic */ Class class$com$opensymphony$workflow$util$beanshell$BeanShellFunctionProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String script = (String)args.get("script");
        Interpreter i = null;
        ClassLoader loader = null;
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        loader = Thread.currentThread().getContextClassLoader();
        try {
            i = new Interpreter();
            if (loader != null) {
                i.setClassLoader(loader);
            }
            i.set("entry", (Object)entry);
            i.set("context", (Object)context);
            i.set("transientVars", (Object)transientVars);
            i.set("propertySet", (Object)ps);
        }
        catch (EvalError evalError) {
            String message = "Could not set values for BSH script";
            log.error((Object)message, (Throwable)evalError);
            throw new WorkflowException(message, evalError);
        }
        try {
            try {
                i.eval(script);
            }
            catch (TargetError targetError) {
                if (targetError.getTarget() instanceof WorkflowException) {
                    throw (WorkflowException)targetError.getTarget();
                }
                String message = "Evaluation error while running BSH function script";
                throw new WorkflowException(message, targetError.getTarget());
            }
            catch (EvalError evalError) {
                String message = "Evaluation error while running BSH function script";
                log.error((Object)message, (Throwable)evalError);
                throw new WorkflowException(message, evalError);
            }
            Object var12_15 = null;
            if (loader == null) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (loader == null) throw throwable;
            i.setClassLoader(null);
            throw throwable;
        }
        i.setClassLoader(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

