/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import no.api.freemarker.java8.time.AbstractAdapter;
import no.api.freemarker.java8.time.AbstractFormatter;
import no.api.freemarker.java8.time.DateTimeTools;
import no.api.freemarker.java8.zone.ZonedDateTimeStrategy;

public class ZonedDateTimeAdapter
extends AbstractAdapter<ZonedDateTime>
implements AdapterTemplateModel,
TemplateScalarModel,
TemplateHashModel {
    private final ZonedDateTimeStrategy strategy;

    public ZonedDateTimeAdapter(ZonedDateTime obj, BeansWrapper wrapper, ZonedDateTimeStrategy strategy) {
        super(obj, wrapper);
        this.strategy = strategy;
    }

    @Override
    public TemplateModel getForType(String s) throws TemplateModelException {
        if ("format".equals(s)) {
            return new ZonedDateTimeFormatter((ZonedDateTime)this.getObject());
        }
        throw new TemplateModelException("Unknown method call: " + s);
    }

    public class ZonedDateTimeFormatter
    extends AbstractFormatter<ZonedDateTime>
    implements TemplateMethodModelEx {
        public ZonedDateTimeFormatter(ZonedDateTime obj) {
            super(obj);
        }

        public Object exec(List list) throws TemplateModelException {
            ZoneId targetZoneId = this.getTargetZoneId(list);
            if (this.isDifferentTimeZoneRequested(targetZoneId)) {
                return ((ZonedDateTime)this.getObject()).withZoneSameInstant(targetZoneId).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            return ((ZonedDateTime)this.getObject()).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }

        private ZoneId getTargetZoneId(List argumentList) throws TemplateModelException {
            return DateTimeTools.zoneIdLookup(argumentList, 1).orElse(ZonedDateTimeAdapter.this.strategy.getZoneId(((ZonedDateTime)this.getObject()).getZone()));
        }

        private boolean isDifferentTimeZoneRequested(ZoneId zoneId) {
            return !((ZonedDateTime)this.getObject()).getZone().equals(zoneId);
        }
    }
}

