/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public final class YamlUtils {
    private YamlUtils() {
    }

    public static void fail(Node node, String filename, String error) {
        throw new InvalidParserConfigurationException(YamlUtils.createErrorString(node, filename, error));
    }

    private static String createErrorString(Node node, String filename, String error) {
        return "Yaml config problem.(" + filename + ":" + node.getStartMark().getLine() + "): " + error;
    }

    public static NodeTuple getExactlyOneNodeTuple(MappingNode mappingNode, String filename) {
        List nodeTupleList = mappingNode.getValue();
        if (nodeTupleList.size() != 1) {
            YamlUtils.fail((Node)mappingNode, filename, "There must be exactly 1 value in the list");
        }
        return (NodeTuple)nodeTupleList.get(0);
    }

    public static String getKeyAsString(NodeTuple tuple, String filename) {
        Node keyNode = tuple.getKeyNode();
        if (!(keyNode instanceof ScalarNode)) {
            YamlUtils.fail(tuple.getKeyNode(), filename, "The key should be a string but it is a " + keyNode.getNodeId().name());
        }
        return ((ScalarNode)keyNode).getValue();
    }

    public static String getValueAsString(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        if (!(valueNode instanceof ScalarNode)) {
            YamlUtils.fail(tuple.getValueNode(), filename, "The value should be a string but it is a " + valueNode.getNodeId().name());
        }
        return ((ScalarNode)valueNode).getValue();
    }

    public static MappingNode getValueAsMappingNode(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        if (!(valueNode instanceof MappingNode)) {
            YamlUtils.fail(tuple.getValueNode(), filename, "The value should be a map but it is a " + valueNode.getNodeId().name());
        }
        return (MappingNode)valueNode;
    }

    public static SequenceNode getValueAsSequenceNode(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        if (!(valueNode instanceof SequenceNode)) {
            YamlUtils.fail(tuple.getValueNode(), filename, "The value should be a sequence but it is a " + valueNode.getNodeId().name());
        }
        return (SequenceNode)valueNode;
    }

    public static List<String> getStringValues(Node sequenceNode, String filename) {
        if (!(sequenceNode instanceof SequenceNode)) {
            YamlUtils.fail(sequenceNode, filename, "The provided node must be a sequence but it is a " + sequenceNode.getNodeId().name());
        }
        List valueNodes = ((SequenceNode)sequenceNode).getValue();
        ArrayList<String> values = new ArrayList<String>(valueNodes.size());
        for (Node node : valueNodes) {
            if (!(node instanceof ScalarNode)) {
                YamlUtils.fail(node, filename, "The value should be a string but it is a " + node.getNodeId().name());
            }
            values.add(((ScalarNode)node).getValue());
        }
        return values;
    }
}

