/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;

public class WordRangeVisitor
extends UserAgentTreeWalkerBaseVisitor<Range> {
    public static final int MAX_RANGE_IN_HASHMAP = 3;
    private static final WordRangeVisitor WORD_RANGE_VISITOR = new WordRangeVisitor();

    public static Range getRange(UserAgentTreeWalkerParser.WordRangeContext ctx) {
        return (Range)WORD_RANGE_VISITOR.visit(ctx);
    }

    @Override
    public Range visitWordRangeStartToEnd(UserAgentTreeWalkerParser.WordRangeStartToEndContext ctx) {
        return new Range(Integer.parseInt(ctx.firstWord.getText()), Integer.parseInt(ctx.lastWord.getText()));
    }

    @Override
    public Range visitWordRangeFirstWords(UserAgentTreeWalkerParser.WordRangeFirstWordsContext ctx) {
        return new Range(1, Integer.parseInt(ctx.lastWord.getText()));
    }

    @Override
    public Range visitWordRangeLastWords(UserAgentTreeWalkerParser.WordRangeLastWordsContext ctx) {
        return new Range(Integer.parseInt(ctx.firstWord.getText()), -1);
    }

    @Override
    public Range visitWordRangeSingleWord(UserAgentTreeWalkerParser.WordRangeSingleWordContext ctx) {
        Integer wordNumber = Integer.parseInt(ctx.singleWord.getText());
        return new Range(wordNumber, wordNumber);
    }

    public static class Range {
        final int first;
        final int last;

        public Range(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public boolean isRangeInHashMap() {
            if (this.last > 3) {
                return false;
            }
            return this.first == 1 && this.last != -1 || this.first == this.last;
        }
    }
}

