/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.DefaultAllMethodAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllMethodAnnotationsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAllAnnotationsHandler
implements AllAnnotationsHandler {
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public DefaultAllAnnotationsHandler(ReflectionProvider provider, Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz cannot be null.");
        }
        this.provider = provider;
        this.clazz = clazz;
    }

    @Override
    public List<Annotation> atClass() {
        return this.provider.getAnnotatedElementReflectionProvider(this.clazz).getAnnotations();
    }

    @Override
    public List<Annotation> atField(String fieldName) {
        Field field = new Mirror(this.provider).on(this.clazz).reflect().field(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("could not find field " + fieldName + " at class " + this.clazz);
        }
        return this.provider.getAnnotatedElementReflectionProvider(field).getAnnotations();
    }

    @Override
    public AllMethodAnnotationsHandler atMethod(String methodName) {
        return new DefaultAllMethodAnnotationsHandler(this.provider, this.clazz, methodName);
    }
}

