/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.vidageek.mirror.bean.Bean;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.invoke.ConstructorHandlerByArgs;
import net.vidageek.mirror.invoke.ConstructorHandlerByConstructor;
import net.vidageek.mirror.invoke.DefaultSetterMethodHandler;
import net.vidageek.mirror.invoke.MethodHandlerByMethod;
import net.vidageek.mirror.invoke.MethodHandlerByName;
import net.vidageek.mirror.invoke.dsl.ConstructorHandler;
import net.vidageek.mirror.invoke.dsl.InvocationHandler;
import net.vidageek.mirror.invoke.dsl.MethodHandler;
import net.vidageek.mirror.invoke.dsl.SetterMethodHandler;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultInvocationHandler<T>
implements InvocationHandler<T> {
    private final Object target;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public DefaultInvocationHandler(ReflectionProvider provider, Object target) {
        if (target == null) {
            throw new IllegalArgumentException("target can't be null");
        }
        this.provider = provider;
        this.target = target;
        this.clazz = target.getClass();
    }

    public DefaultInvocationHandler(ReflectionProvider provider, Class<T> target) {
        if (target == null) {
            throw new IllegalArgumentException("target can't be null");
        }
        this.provider = provider;
        this.clazz = target;
        this.target = null;
    }

    @Override
    public MethodHandler method(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("methodName can't be null");
        }
        return new MethodHandlerByName(this.provider, this.target, this.clazz, methodName);
    }

    @Override
    public ConstructorHandler<T> constructor() {
        if (this.target != null) {
            throw new IllegalStateException("must use constructor InvocationHandler(Class<T>) instead of InvocationHandler(Object).");
        }
        return new ConstructorHandlerByArgs(this.provider, this.clazz);
    }

    @Override
    public MethodHandler method(Method method) {
        return new MethodHandlerByMethod(this.provider, this.target, this.clazz, method);
    }

    @Override
    public <C> ConstructorHandler<C> constructor(Constructor<C> con) {
        return new ConstructorHandlerByConstructor(this.provider, this.clazz, con);
    }

    @Override
    public Object getterFor(String fieldName) {
        Method method = null;
        for (String string : new Bean().getter(fieldName)) {
            method = new Mirror(this.provider).on(this.target.getClass()).reflect().method(string).withoutArgs();
            if (method == null) continue;
            break;
        }
        if (method == null) {
            throw new MirrorException("Could not find getter for field " + fieldName);
        }
        return new Mirror(this.provider).on(this.target).invoke().method(method).withoutArgs();
    }

    @Override
    public Object getterFor(Field field) {
        return this.getterFor(field.getName());
    }

    @Override
    public SetterMethodHandler setterFor(String fieldName) {
        return new DefaultSetterMethodHandler(this.provider, this.target, fieldName);
    }

    @Override
    public SetterMethodHandler setterFor(Field field) {
        return this.setterFor(field.getName());
    }
}

