/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.get;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.get.dsl.GetterHandler;
import net.vidageek.mirror.provider.FieldReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultGetterHandler
implements GetterHandler {
    private final Object target;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public DefaultGetterHandler(ReflectionProvider provider, Object target) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        this.provider = provider;
        this.clazz = target.getClass();
        this.target = target;
    }

    public DefaultGetterHandler(ReflectionProvider provider, Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
        this.target = null;
    }

    @Override
    public Object field(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("fieldName cannot be null or empty.");
        }
        return this.field(this.getField(fieldName));
    }

    @Override
    public Object field(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (!field.getDeclaringClass().isAssignableFrom(this.clazz)) {
            throw new IllegalArgumentException("field declaring class (" + field.getDeclaringClass().getName() + ") doesn't match clazz " + this.clazz.getName());
        }
        if (this.target == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException("attempt to get instance field " + field.getName() + " on class " + this.clazz.getName());
        }
        FieldReflectionProvider fieldReflectionProvider = this.provider.getFieldReflectionProvider(this.target, this.clazz, field);
        fieldReflectionProvider.setAccessible();
        return fieldReflectionProvider.getValue();
    }

    private Field getField(String fieldName) {
        Field field = new Mirror(this.provider).on(this.clazz).reflect().field(fieldName);
        if (field == null) {
            throw new MirrorException("could not find field " + fieldName + " for class " + this.clazz.getName());
        }
        return field;
    }
}

