/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.dsl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import net.vidageek.mirror.DefaultAccessorsController;
import net.vidageek.mirror.DefaultClassController;
import net.vidageek.mirror.DefaultFieldController;
import net.vidageek.mirror.DefaultMemberController;
import net.vidageek.mirror.config.MirrorProviderBuilder;
import net.vidageek.mirror.dsl.AccessorsController;
import net.vidageek.mirror.dsl.ClassController;
import net.vidageek.mirror.dsl.FieldController;
import net.vidageek.mirror.dsl.MemberController;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mirror {
    private static final String MIRROR_CFG = "/mirror.properties";
    private static final ReflectionProvider cachedProvider = new MirrorProviderBuilder(Mirror.class.getResource("/mirror.properties")).createProvider();
    private final ReflectionProvider provider;

    public Mirror(ReflectionProvider provider) {
        this.provider = provider;
    }

    public Mirror() {
        this.provider = cachedProvider;
    }

    public Class<?> reflectClass(String className) {
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException("className cannot be null or empty");
        }
        return this.provider.getClassReflectionProvider(className).reflectClass();
    }

    public <T> ClassController<T> on(Class<T> clazz) {
        return new DefaultClassController<T>(this.provider, clazz);
    }

    public AccessorsController on(Object object) {
        return new DefaultAccessorsController(this.provider, object);
    }

    public ClassController<?> on(String className) {
        return this.on(this.reflectClass(className));
    }

    public MemberController on(AnnotatedElement member) {
        return new DefaultMemberController(this.provider, member);
    }

    public FieldController on(Field field) {
        return new DefaultFieldController(this.provider, field);
    }
}

